//      credits.cpp

#include <malloc.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "mode13.h"
#include "phongpal.h"
#include "stuff.h"
#include "credits.h"

#include "credit1.h"
#include "credit2.h"
#include "credit3.h"
#include "credit4.h"


#define c_radius 15

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


double c_dist[100][160];
int c_sx0, c_sy0, c_sx1, c_sy1, c_sx2, c_sy2, c_sx3, c_sy3;
float c_sint[256], c_cost[256];
unsigned char c_WobBackPos;
int c_WobBackTrans[256];
unsigned int c_WobBackTransOff = (unsigned int)c_WobBackTrans;


void WobbleImage(unsigned int source, unsigned int where);
#pragma aux WobbleImage =       \
"add esi, 3210" \
"add edi, 3210" \
"mov dh, 180"   \
"loopy: mov ecx, 300"   \
"       movzx eax, byte ptr [c_WobBackPos]"     \
"       shl eax, 2"     \
"       add eax, [c_WobBackTransOff]"      \
"       mov ebx, [eax]" \
"loopx: mov dl, [esi + ebx]"    \
"       inc esi"        \
"       mov [edi], dl"  \
"       inc edi"        \
"       dec ecx"        \
"       jnz loopx"      \
"       add esi, 20"    \
"       add edi, 20"    \
"       inc byte ptr [c_WobBackPos]"    \
"       dec dh" \
"       jnz loopy"      \
parm [esi] [edi]        \
modify [eax ebx ecx edx];



void CREDITS_Setup() {
        double d;
        int i, x, y;

        for (y = 0; y < 100; y++)
                for (x = 0; x < 160; x++) {
                        d = sqrt(x * x + y * y);
                        if (d > 0.0) c_dist[y][x] = c_radius / d;
                        else c_dist[y][x] = 1e38;
                 }
        for (i = 0; i < 256; i++) {
                d = i * 3.14159265 / 128.0;
                c_sint[i] = sin(d);
                c_cost[i] = cos(d);
                x = 10 * cos(d);
                y = 10 * sin(d);
                c_WobBackTrans[i] = y * 320 + x;
	}
        c_WobBackPos = 0;
}


void CalcBlobs(unsigned int source, unsigned int dest) {
        int x, y, color;
        unsigned int src = source;
        unsigned int dst = dest;
        double blob;

        for (y = 0; y < 100; y++) {
                for (x = 0; x < 160; x++) {
                        blob =  c_dist[abs(c_sy0 - y)][abs(c_sx0 - x)] +
                                c_dist[abs(c_sy1 - y)][abs(c_sx1 - x)] +
                                c_dist[abs(c_sy2 - y)][abs(c_sx2 - x)] +
                                c_dist[abs(c_sy3 - y)][abs(c_sx3 - x)];
                        if (blob > 1.0) {
                                color = 255 - dtoi(255.0 / blob);
                                _asm {
                                        mov esi, [src]
                                        mov edi, [dst]
                                        mov dx, [esi]
                                        mov [edi], dx
                                        mov dx, [esi + 320]
                                        mov [edi + 320], dx
                                        mov eax, [color]                                
                                        mov edx, 0FFh
                                        add byte ptr [edi], al
                                        jnc @cont1
                                        mov [edi], dl
                                @cont1: add byte ptr [edi + 1], al
                                        jnc @cont2
                                        mov [edi + 1], dl
                                @cont2: add byte ptr [edi + 320], al
                                        jnc @cont3
                                        mov [edi + 320], dl
                                @cont3: add byte ptr [edi + 321], al
                                        jnc @cont4
                                        mov [edi + 321], dl
                                @cont4: nop
                                }
                        }
                        dst += 2;
                        src += 2;
                }
                dst += 320;
                src += 320;
        }
}



void CREDITS_Run() {
        PTVirtual vscr, wobbackpic;
        unsigned int voff, wobbackoff;
        TPalette pal;
        unsigned char a = 0;
        unsigned char l = 0;
        double ambient;

        SetupVirtual(&vscr, &voff);
        SetupVirtual(&wobbackpic, &wobbackoff);
        ClearScreen(0, voff);
        ClearScreen(0, wobbackoff);
        
        //      first credit
        c_sx2 = 80;
        c_sy3 = 50;
        ambient = 256.0;
        GetMusicInfo();
        while (position < 9) {
                Fast256PhongPal(0, 128.0, 255.0, ambient / 2, 20.0, 128.0,
                                ambient, 0.0, 128.0, pal);

                c_sx0 = dtoi(c_cost[a] * 65.0) + 80;
                c_sy0 = -dtoi(c_sint[(unsigned char)(a << 1)] * 30.0) + 50;
                c_sx1 = dtoi(c_sint[a] * 40.0) + 80;
                c_sy1 = dtoi(c_cost[a] * 35.0) + 50;
                c_sy2 = dtoi(c_sint[a] * 20.0) + 50;
                c_sx3 = -dtoi(c_sint[(unsigned char)((a++) << 1)] * 60.0) + 80;

                ClearScreen(0, wobbackoff);
                CalcBlobs((unsigned int)CREDIT1, wobbackoff);
                WobbleImage(wobbackoff, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                c_WobBackPos -= 175;
                if (ambient > 64.0) ambient -= 8.0;
                else ambient = 32.0 + 32.0 * c_cost[(l += 4)];
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }


        //      second credit
        c_sx2 = 120;
        c_sy3 = 20;
        ambient = 256.0;
        GetMusicInfo();
        while (position < 10) {
                Fast256PhongPal(ambient / 2, 20.0, 128.0, 0, 128.0, 255.0,
                                ambient / 2, 20.0, 128.0, pal);

                c_sx0 = -dtoi(c_cost[a] * 65.0) + 80;
                c_sy0 = dtoi(c_sint[(unsigned char)(a << 1)] * 35.0) + 50;
                c_sx1 = dtoi(c_sint[a] * 50.0) + 80;
                c_sy1 = -dtoi(c_cost[a] * 25.0) + 60;
                c_sy2 = dtoi(c_sint[(unsigned char)(a << 1)] * 40.0) + 50;
                c_sx3 = -dtoi(c_sint[a++] * 40.0) + 80;

                ClearScreen(0, wobbackoff);
                CalcBlobs((unsigned int)CREDIT2, wobbackoff);
                WobbleImage(wobbackoff, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                c_WobBackPos -= 175;
                if (ambient > 64.0) ambient -= 8.0;
                else ambient = 32.0 + 32.0 * c_cost[(l += 4)];
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }


        //      third credit
        c_sx2 = 80;
        c_sy3 = 50;
        ambient = 256.0;
        GetMusicInfo();
        while (position < 11) {
                Fast256PhongPal(0, 128.0, 255.0, ambient, 0.0, 128.0,
                                0, 128.0, 255.0, pal);

                c_sx0 = dtoi(c_cost[a] * 45.0) + 60;
                c_sy0 = dtoi(c_sint[a] * 40.0) + 50;
                c_sx1 = -dtoi(c_sint[(unsigned char)(a << 1)] * 40.0) + 80;
                c_sy1 = dtoi(c_cost[a] * 40.0) + 50;
                c_sy2 = -dtoi(c_cost[a] * 30.0) + 30;
                c_sx3 = dtoi(c_sint[(unsigned char)((a++) << 1)] * 40.0) + 90;

                ClearScreen(0, wobbackoff);
                CalcBlobs((unsigned int)CREDIT3, wobbackoff);
                WobbleImage(wobbackoff, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                c_WobBackPos -= 175;
                if (ambient > 64.0) ambient -= 8.0;
                else ambient = 32.0 + 32.0 * c_cost[(l += 4)];
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        //      fourth credit
        c_sx2 = 40;
        c_sy3 = 80;
        ambient = 256.0;
        GetMusicInfo();
        while (row < 62) {
                Fast256PhongPal(0, 128.0, 255.0, 0, 128.0, 255.0,
                                ambient, 0.0, 128.0, pal);

                c_sx0 = -dtoi(c_sint[a] * 50.0) + 80;
                c_sy0 = -dtoi(c_cost[(unsigned char)(a << 1)] * 30.0) + 40;
                c_sx1 = -dtoi(c_cost[a] * 40.0) + 80;
                c_sy1 = dtoi(c_cost[a] * 30.0) + 60;
                c_sy2 = dtoi(c_sint[(unsigned char)(a << 1)] * 30.0) + 50;
                c_sx3 = dtoi(c_sint[(unsigned char)((a++) << 1)] * 40.0) + 80;

                ClearScreen(0, wobbackoff);
                ClearScreen(0, voff);
                CalcBlobs((unsigned int)CREDIT4, wobbackoff);
                WobbleImage(wobbackoff, voff);
                Blur(voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                c_WobBackPos -= 175;
                if (ambient > 64.0) ambient -= 8.0;
                else ambient = 32.0 + 32.0 * c_cost[(l += 4)];
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        ShutDownVirtual(&vscr);
        ShutDownVirtual(&wobbackpic);
}
