
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "bitmaps.h"
#include "blitter.h"
#include "tunnel.h"
#include "obj3d.h"
#include "triangle.h"
#include "cameras.h"
#include "primitiv.h"
#include "globals.h"
#include "midas.h"
#include "part5.h"

#include "tex6.h"
#include "tex7.h"
#include "tex8.h"
#include "tex9.h"
#include "us4.h"
#include "mono3.h"
#include "publico2.h"
#include "mono5.h"
#include "tex3.h"

#define P5_CamZ -1.6
#define P5_CamY -0.5

void P5_MoveCamera(int ax, int ay, TVector displace) {
        TVector *p = new TVector(0, 0, P5_CamZ);
        p->Rotate(ax, ay, 0);
        *p += displace;
        camera->location.SetP(p->x, P5_CamY + p->y, p->z);
	camera->ax = ax;
	camera->ay = ay;
        delete p;
}


void luchador_Part5() {
        TBitmap8bpp *tex1 = new TBitmap8bpp(TEX6_ANCHO, TEX6_ALTO, TEX6, TEX6_PAL);
        TBitmap8bpp *tex2 = new TBitmap8bpp(TEX7_ANCHO, TEX7_ALTO, TEX7, TEX7_PAL);
        TBitmap8bpp *tex3 = new TBitmap8bpp(TEX8_ANCHO, TEX8_ALTO, TEX8, TEX8_PAL);
        TBitmap8bpp *tex4 = new TBitmap8bpp(TEX9_ANCHO, TEX9_ALTO, TEX9, TEX9_PAL);
        TBitmap8bpp *mono1 = new TBitmap8bpp(US4_ANCHO, US4_ALTO, US4, US4_PAL);
        TBitmap8bpp *mono2 = new TBitmap8bpp(MONO3_ANCHO, MONO3_ALTO, MONO3, MONO3_PAL);
        TBitmap8bpp *mono3 = new TBitmap8bpp(PUBLICO2_ANCHO, PUBLICO2_ALTO, PUBLICO2, PUBLICO2_PAL);
        TBitmap8bpp *mono4 = new TBitmap8bpp(MONO5_ANCHO, MONO5_ALTO, MONO5, MONO5_PAL);
        TBitmap8bpp *mono5 = new TBitmap8bpp(TEX3_ANCHO, TEX3_ALTO, TEX3, TEX3_PAL);

        TObject3D *santo = new TObject3D();
        MakeQuadPatch(santo, 1, 1);
        santo->SetStyle(ca_texturemapped);
        santo->SetTexture(mono5);
        santo->Centre();
        santo->FitSphere(sqrt(2.0));
        TransparentColor = 127;

	int centers[6];
	TFX_centers = centers;
	TFX_count = 3;
        byte a, d;
        double theta = 0.0;
        double c1, c2;
        TVector *disp = new TVector(0, 0, 0);

        int lastpos = m_position;
        m_timer = 0;
        while (m_position < 16) {
                c1 = m_timer / 100.0;
                c2 = m_timer / 80.0;
                disp->SetP(1.5 * sin(c2), 0.5 * cos(c2 * 2.0), 0.5 * sin(c1 + c2));
                P5_MoveCamera(120 * sin(c1 * 2.0), 120 * cos(c1), *disp);
                
                switch (m_position) {
                        case 12:
                                theta = m_timer / 100.0;
                                centers[0] = 160 + 120 * sin(theta);
                                centers[1] = 120 + 80 * cos(theta);
                                centers[2] = 160 - 120 * cos(theta);
                                centers[3] = 120 - 80 * sin(theta * 2.0);
                                centers[4] = 160 - 120 * sin(theta * 2.0);
                                centers[5] = 120 - 80 * cos(theta);
                                TFX_DrawTunnel(a, d, tex1, vscr);
                                a += 3; d -= 6; //theta += 0.05;

                                santo->Draw(vscr);

                                if (m_timer < 192)
                                        mono3->TransBlitTo(vscr, 0, 240 - (m_timer >> 1), 229);
                                        else mono3->TransBlitTo(vscr, 0, 144, 229);

                                break;

                        case 13:
                                theta = m_timer / 150.0;
                                centers[0] = 160 + 120 * sin(theta);
                                centers[1] = 120 + 80 * cos(theta * 3.0);
                                centers[2] = 160 - 120 * cos(theta * 1.5);
                                centers[3] = 120 - 80 * sin(theta * 2.0);
                                centers[4] = 160 - 120 * sin(theta * 3.0);
                                centers[5] = 120 - 80 * cos(theta);
                                TFX_DrawWobbler(a, d, tex2, vscr);
                                a -= 2; d += 2; //theta += 0.03;

                                santo->Draw(vscr);

                                if (m_timer < 246)
                                        mono4->TransBlitTo(vscr, 320 - m_timer, 24, 128);
                                        else mono4->TransBlitTo(vscr, 74, 24, 128);

                                if (m_timer < 192)
                                        mono3->TransBlitTo(vscr, 0, 144 + (m_timer >> 1), 229);

                                break;

                        case 14:
                                theta = m_timer / 120.0;
                                centers[0] = 160 + 120 * sin(theta * 1.4);
                                centers[1] = 120 + 80 * cos(theta * 2.0);
                                centers[2] = 160 - 120 * cos(theta * 0.5);
                                centers[3] = 120 - 80 * sin(theta * 1.7);
                                centers[4] = 160 - 120 * cos(theta * 2.0);
                                centers[5] = 120 - 80 * cos(theta * 0.7);
                                TFX_DrawTunnel(a, d, tex3, vscr);
                                a -= 4; d += 8; //theta += 0.03;

                                santo->Draw(vscr);

                                if (m_timer < 212)
                                        mono2->TransBlitTo(vscr, m_timer - 212, 8, 255);
                                        else mono2->TransBlitTo(vscr, 0, 8, 255);

                                if (m_timer < 246)
                                        mono4->TransBlitTo(vscr, 74 + m_timer, 24, 128);

                                break;

                        case 15:
                                theta = m_timer / 140.0;
                                centers[0] = 160 + 120 * sin(theta * 2.5);
                                centers[1] = 120 + 80 * cos(theta * 0.8);
                                centers[2] = 160 - 120 * sin(theta * 1.3);
                                centers[3] = 120 - 80 * sin(theta * 2.7);
                                centers[4] = 160 - 120 * sin(theta);
                                centers[5] = 120 - 80 * cos(theta * 1.8);
                                TFX_DrawRipples(a, d, tex4, vscr);
                                a += 3; d -= 1; //theta += 0.04;

                                santo->Draw(vscr);

                                if (m_timer < 240)
                                        mono1->TransBlitTo(vscr, 36, 240 - m_timer, 255);
                                        else mono1->TransBlitTo(vscr, 36, 0, 255);

                                if (m_timer < 212)
                                        mono2->TransBlitTo(vscr, -m_timer, 8, 255);

                                break;
                }

                if (blurflag) santo->Rotate(0, 0, 20);
                else santo->Rotate(0, 0, 15);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
                if (lastpos != m_position) {
                        m_timer = 0;
                        lastpos = m_position;
                        vscr->Borra(0);
                }
        }

        delete tex1;
        delete tex2;
        delete tex3;
        delete tex4;
        delete mono1;
        delete mono2;
        delete mono3;
        delete mono4;
        delete mono5;
        delete santo;
        delete disp;
}
