
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include "bitmaps.h"
#include "blitter.h"
#include "circles.h"
#include "plasmafx.h"
#include "obj3d.h"
#include "cameras.h"
#include "triangle.h"
#include "primitiv.h"
#include "globals.h"
#include "midas.h"
#include "part15.h"

#include "mono4.h"
#include "p11.h"
#include "p19.h"
#include "tex9.h"

byte p15_table1[256], p15_table2[256];
double p15_ainc1, p15_ainc2;

void Part15_Setup() {
        GeneratePlasmaTable(p15_table1, 0, 0, 0);
        GeneratePlasmaTable(p15_table1, 5, 32, 4);
        GeneratePlasmaTable(p15_table1, 7, 64, 2);
        GeneratePlasmaTable(p15_table2, 0, 0, 0);
        GeneratePlasmaTable(p15_table2, 3, 64, 2);
        GeneratePlasmaTable(p15_table2, 6, 32, 4);
}

#define FX15sides 16
#define FX15sections 50
#define FX15freq1 3
#define FX15freq2 4

void EFX15_1(TObject3D *o, double t, double p) {
	int v = 0;
	double dist;
        for (int j = 0; j < FX15sections; j++) {
		dist = sin(t) * p;
                for (int i = 0; i < FX15sides; i++) {
			o->Vertex[v]->x += dist * o->Vertex[v]->normal.x;
			o->Vertex[v]->y += dist * o->Vertex[v]->normal.y;
			o->Vertex[v]->z += dist * o->Vertex[v]->normal.z;
			v++;
		}
                t += p15_ainc1;
	}
}

void EFX15_2(TObject3D *o, double t, double p) {
	int v = 0;
	double dist;
        for (int j = 0; j < FX15sections; j++) {
		dist = cos(t) * p;
                for (int i = 0; i < FX15sides; i++) {
			o->Vertex[v]->x += dist * o->Vertex[v]->normal.x;
			o->Vertex[v]->y += dist * o->Vertex[v]->normal.y;
			o->Vertex[v]->z += dist * o->Vertex[v]->normal.z;
			v++;
		}
                t += p15_ainc2;
	}
	for (int i = 0; i < o->NumPolygons; i++) o->Poly[i]->CalcNormal();
}


void luchador_Part15() {
        TBitmap8bpp *mono = new TBitmap8bpp(MONO4_ANCHO, MONO4_ALTO, MONO4, MONO4_PAL);
        TBitmap8bpp *logo = new TBitmap8bpp(P11_ANCHO, P11_ALTO, P11, P11_PAL);
        TBitmap8bpp *fondo = new TBitmap8bpp(P19_ANCHO, P19_ALTO, P19, P19_PAL);
        TBitmap8bpp *textura = new TBitmap8bpp(TEX9_ANCHO, TEX9_ALTO, TEX9, TEX9_PAL);
        TBitmap8bpp *plasma = new TBitmap8bpp(40, 30);
	byte t1, t2, t3, t4;

        p15_ainc1 = FX15freq1 * 2.0 * 3.14159265 / FX15sections;
        p15_ainc2 = FX15freq2 * 2.0 * 3.14159265 / FX15sections;

	TObject3D *obj = new TObject3D();
        MakeTorus(obj, 1.2, 0.5, FX15sides, FX15sections, 0);
	obj->SetStyle(c_texturemapped);
        obj->SetTexture(textura);
	obj->Rotate(360, 0, 0);
	for (int i = 0; i < obj->NumVertex; i++) obj->Vertex[i]->u *= 2.0;

        m_timer = 0;
        while (m_position < 41) {
                vscr->Borra(RGB(102, 032, 255));

                t1 = m_timer >> 4;
                t2 = dtoi(128.0 + 127.0 * sin(m_timer * 0.004));
                t3 = 255 - dtoi(m_timer * 0.6);
                t4 = dtoi(160.0 * cos(m_timer * 0.007) - 128);

                GeneratePlasma(plasma, p15_table1, p15_table2, t1, t2, t3, t4);
                plasma->Blur();
                plasma->Blur();
                DrawCircleFX(plasma, vscr, RGB(255, 102, 032), 8);

                GeneratePlasma(plasma, p15_table2, p15_table1, t3, t1, t4, t2);
                plasma->Blur();
                plasma->Blur();
                DrawCircleFX(plasma, vscr, RGB(102, 255, 032), 6);

                logo->TransBlitTo(vscr, (rand() % 5) - 2, (rand() % 5) - 2, 255);

                if (m_timer < 124) ;
                else if (m_timer < 300) mono->TransBlitTo(vscr, m_timer - 300, 52, 255);
                else if (m_timer < 474) mono->TransBlitTo(vscr, 0, 52, 255);
                else if (m_timer < 650) mono->TransBlitTo(vscr, 474 - m_timer, 52, 255);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        camera->location.SetP(0, 0, -2.2);
        camera->ax = camera->ay = camera->az = 0;
        double a, b;

        m_timer = 0;
        while (m_position < 43) {
                vscr->Borra(RGB(102, 032, 255));

                t1 = m_timer >> 4;
                t2 = dtoi(128.0 + 127.0 * sin(m_timer * 0.004));
                t3 = 255 - dtoi(m_timer * 0.6);
                t4 = dtoi(160.0 * cos(m_timer * 0.007) - 128);

                GeneratePlasma(plasma, p15_table1, p15_table2, t1, t2, t3, t4);
                plasma->Blur();
                plasma->Blur();
                DrawCircleFX(plasma, vscr, RGB(255, 102, 032), 8);

                GeneratePlasma(plasma, p15_table2, p15_table1, t3, t1, t4, t2);
                plasma->Blur();
                plasma->Blur();
                DrawCircleFX(plasma, vscr, RGB(102, 255, 032), 6);

                logo->TransBlitTo(vscr, (rand() % 5) - 2, (rand() % 5) - 2, 255);

                if (m_timer > 640) fondo->BlitTo(vscr, 0, 0);
                else if (m_timer > 400) fondo->BlitTo(vscr, 0, m_timer - 640);

                a = m_timer / 250.0;
                b = -m_timer / 31.0;

                EFX15_1(obj, a * 15.0, 0.024);
                EFX15_2(obj, b, 0.015);

                if (m_timer < 400) obj->origin.SetP(0, (m_timer / 100.0) - 4.0, 0);
		obj->Draw(vscr);

                obj->Rotate(    dtoi(8.0 * sin(a * 1.2)),
                                dtoi(8.0 * cos(a * 0.9)),
                                dtoi(10.0 * sin(a * 2.3)));

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        while (m_position < 45) {
                fondo->BlitTo(vscr, 0, 0);

                a = m_timer / 250.0;
                b = -m_timer / 31.0;

                EFX15_1(obj, a * 15.0, 0.024);
                EFX15_2(obj, b, 0.015);

                if (m_timer < 300) obj->origin.SetP(0, (m_timer / 100.0) - 3.0, 0);
		obj->Draw(vscr);

                obj->Rotate(    dtoi(8.0 * sin(a * 1.2)),
                                dtoi(8.0 * cos(a * 0.9)),
                                dtoi(10.0 * sin(a * 2.3)));

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        free(plasma->datos); delete plasma;
        delete mono;
        delete logo;
        delete fondo;
        delete textura;
        delete obj;
}

