#include <dos.h>
#include <stdio.h>
#include "memavail.h"

typedef struct {
    unsigned	data[25];
} pharlap_mem_status;

/* names suggested by PharLap on page DOSX-20 of the 2.2d release notes */
#define NCONVPG	1
#define NBIMPG	2
#define EXTLIM	4

unsigned long memavail()
{
    pharlap_mem_status status;
    union REGS regs;
    unsigned long amount;

    regs.h.ah = 0x25;
    regs.h.al = 0x20;
    regs.h.bl = 0;
    regs.x.edx = (unsigned int) &status;
    intdos( &regs, &regs );
    /* equation is on page DOSX-22 */
    amount = status.data[ NCONVPG ];
    amount += status.data[ NBIMPG ];
    amount += status.data[ EXTLIM ];
    return( amount * 4096 );
}

