
#include "vectors.h"
#include "globals.h"
#include "cameras.h"



TCamera::TCamera() {
	location.SetP(0, 0, 0);
	direction.SetP(0, 0, 1.0);
	ax = ay = az = 0;
}


void TCamera::Rotate(int x, int y, int z) {
	ax = (ax + x) % NumDegrees;
	ay = (ay + y) % NumDegrees;
	az = (az + z) % NumDegrees;
	direction.x = -SinT[ay];
	direction.y = -SinT[ax];
	direction.z = CosT[ax] * CosT[ay];
	direction.Normalize();
}


void TCamera::Advance(double dist) {
	location.x += dist * direction.x;
	location.y += dist * direction.y;
	location.z += dist * direction.z;
}


TCameraPath::TCameraPath() {
	numpoints = 0;
	divisions_per_point = 1;
	total_frames = 0;
}

TCameraPath::~TCameraPath() {
	for (int i = 0; i < numpoints; i++) delete(Point[i]);
	numpoints = 0;
}


void TCameraPath::AddCurrentPosition() {
	if (numpoints == MaxPathPoints) return;
	Point[numpoints] = new(TCamera);
	Point[numpoints]->location = CopyVector(camera->location);
	Point[numpoints]->ax = camera->ax;
	Point[numpoints]->ay = camera->ay;
	Point[numpoints]->az = camera->az;
	numpoints++;
}


void TCameraPath::SetDivisionsPerPoint(int divisions) {
	divisions_per_point = divisions;
	total_frames = (long)(numpoints - 1) * (long)divisions;
}

void TCameraPath::SetTotalFrames(long frames) {
	total_frames = frames;
	divisions_per_point = frames / (numpoints - 1);
}


int TCameraPath::InterpolateFrame(long frame, TCamera *c) {
	if (frame >= total_frames) return 0;
	int a = frame / divisions_per_point;
	int b = a + 1;
	double p = ((double)frame / (double)divisions_per_point) - a;
	
	c->location = CopyVector(Point[b]->location);
	c->location -= Point[a]->location;
	c->location = c->location * p;
	c->location += Point[a]->location;
	
	c->ax = dtoi((Point[b]->ax - Point[a]->ax) * p) + Point[a]->ax;
	c->ay = dtoi((Point[b]->ay - Point[a]->ay) * p) + Point[a]->ay;
	c->az = dtoi((Point[b]->az - Point[a]->az) * p) + Point[a]->az;
	return 1;
}

TCamera *camera;

