--      SCROLLIE.PAS    --      old little thing by FAC
--
--      this of course draws the scrollie of stupikeffyloopy
--      the scroller text is taken from the TEXT.TXT file
--      the characters size must be 32 * 32
--      the scrollie is transformed with a sinus table
--      and then blitted transparently to the screen


unit Scrollie;

interface

uses PCharSet;

{ LoadText:  what'd you expect?  it loads the text }
procedure LoadText;

{ DoScrollie: draws the wobbled scroller with the given charset }
procedure DoScrollie(where : dword; cs : PTCharSet);

{ KillScrollie: releases all memory used bu the scroller }
procedure KillScrollie;


implementation

uses Mode13PM;

var StupidText : PTVirtual; { the text can be as large as 64000 chars! }

{ the scroller is 320 * 64 pixels big, so we define the next types }
type TScrollie = array[0..20479] of byte;
     PTScrollie = ^TScrollie;

var TextLength, CurrentChar, CurrentPos : longint; { some needed stuff }
    ScrollieTransTable : array[0..255] of longint; { transformation table }
    ScrollieTransTableOff : dword;                 { and it's offset }
    ScrollieTransPos : byte;                       { transformation position }
    ScrollieScr, ScrollieTransScr : PTScrollie;    { two buffers are needed }
    ScrollieOff, ScrollieTransOff : dword;         { with their offsets     }


{ The next procedure releases all memory used by the scroller }
procedure KillScrollie;
begin
     if ScrollieScr <> nil then dispose(ScrollieScr);
     if ScrollieTransScr <> nil then dispose(ScrollieTransScr);
     ScrollieScr := nil;
     ScrollieTransScr := nil;
     dispose(StupidText);
end;


{ this one calculates the sinus table for the wobbling stuff    }
procedure CalcTransTable;
var a : integer;
begin
     for a := 0 to 255 do
         ScrollieTransTable[a] := round(sin(a * Pi / 128) * 15) * 320;

     ScrollieTransTableOff := ofs(ScrollieTransTable);
end;


{ this function returns the number of chars in TEXT.TXT }
function CalcTextLength : longint;
var i : longint;
begin
     for i := 0 to 9999 do
         if StupidText^[i] = 0 then
         begin
              CalcTextLength := i;
              exit;
         end;
end;

{ and this one loads the file TEXT.TXT into the StupidText array  }
procedure LoadText;
var i : longint;
    f : file of byte;	
begin
	assign(f, 'text.txt');
	reset(f);
	for i := 0 to (filesize(f) - 1) do read(f, StupidText^[i]);
	StupidText^[filesize(f)] := 0;
	close(f);
        TextLength := CalcTextLength - 1;
end;

{ the wobbling procedure                                                  }
{ you'll have to figure it out yourself cause I'm too lazy to describe it }
procedure WobbleScrollie; assembler;
asm
   mov esi, [ScrollieOff]
   mov edi, [ScrollieTransOff]
   add esi, 4800
   add edi, 4800
   mov dh, 33
   @loopy: mov dl, [ScrollieTransPos]
           mov ch, 160
   @loopx: movzx ebx, dl
           mov cl, [esi]
           shl ebx, 2
           inc dl
           add ebx, [ScrollieTransTableOff]
           inc esi
           mov eax, [ebx]
           add eax, edi
           mov [eax], cl
           inc edi
           movzx ebx, dl
           mov cl, [esi]
           shl ebx, 2
           add ebx, [ScrollieTransTableOff]
           inc dl
           mov eax, [ebx]
           inc esi
           add eax, edi
           mov [eax], cl
           inc edi
           dec ch
           jnz @loopx
           dec dh
           jnz @loopy
end;


{ and the transparent blitter procedure                 }
procedure BlitScrollie(dest : dword); assembler;
asm
   mov esi, [ScrollieTransOff]
   mov edi, [dest]
   mov ecx, 20480
   @loop:   mov al, [esi]
            or al, al
            jz @noplot
            mov [edi], al
   @noplot: inc esi
            inc edi
            dec ecx
            jnz @loop
end;

{ the next procedure does the scrolling stuff }
procedure DrawScrollie(cs : PTCharSet);
var x, y : longint;
    scroff, mapoff : dword;
begin
     { first, we scroll the buffers four pixels from right to left }
     asm
        mov edi, [ScrollieOff]
        add edi, 5120
        mov ecx, 10240
        @loop:   mov al, [edi + 4]
                 mov [edi], al
                 inc edi
                 dec ecx
                 jnz @loop
     end;

     { then we calculate the next row position in the character map }
     x := cs^.Info.Chars[chr(StupidText^[CurrentChar])].x + CurrentPos;
     y := cs^.Info.Chars[chr(StupidText^[CurrentChar])].y + 1;
     scroff := ScrollieOff + 5120 + 316;
     mapoff := cs^.MapOff + y * 320 + x;

     { and copy it to the scroller's right side }
     asm
        mov edi, [scroff]
        mov esi, [mapoff]
        mov ecx, 30      { the chars height is 32 but we only copy 30 pixels }
        @loopy:  mov eax, [esi]
                 add esi, 320
                 mov [edi], eax
                 add edi, 320
                 dec ecx
                 jnz @loopy
     end;
end;

{ and finally, the procedure that puts all the stuff together }
procedure DoScrollie(where : dword; cs : PTCharSet);
begin
     DrawScrollie(cs);          { draw the scroller                     }
     WobbleScrollie;            { deform it                             }
     BlitScrollie(where);       { and copy it to the destination screen }

     { now we increment the scrollie position, BUT we have to give      }
     { more space to wide chars, like w, m, ~, %, &, # and spacebar     }
     case chr(StupidText^[CurrentChar])
      of
          'w', 'm', '~', '%', '&', '#', ' ' :
          begin
               if CurrentPos < 30 then inc(CurrentPos, 4)
               else
               begin
                    CurrentPos := 2;
                    if CurrentChar < TextLength then inc(CurrentChar)
                    else CurrentChar := 0;
               end;
          end;

          else
          begin
               if CurrentPos < 26 then inc(CurrentPos, 4)
               else
               begin
                    CurrentPos := 6;
                    if CurrentChar < TextLength then inc(CurrentChar)
                    else CurrentChar := 0;
               end;
          end;
     end;
     dec(ScrollieTransPos); { this makes it look even better }
end;

{ scroller initialization }
begin
     { allocate all memory needed }
     StupidText := new(PTVirtual);
     ScrollieScr := new(PTScrollie);
     ScrollieTransScr := new(PTScrollie);
     ScrollieOff := ofs(ScrollieScr^);
     ScrollieTransOff := ofs(ScrollieTransScr^);

     { clear the two drawing buffers }
     asm
        mov edi, [ScrollieOff]
        mov ecx, 5120
        xor eax, eax
        rep stosd
        mov edi, [ScrollieTransOff]
        mov ecx, 5120
        rep stosd
     end;

     { and set the initial position values }
     CurrentChar := 0;
     CurrentPos := 2;
     CalcTransTable;
     ScrollieTransPos := 0;
end.

