
#include <malloc.h>
#include "obj3d.h"
#include "cameras.h"
#include "lightsrc.h"
#include "hires256.h"
#include "vectors.h"
#include "triangle.h"
#include "polygons.h"
#include "scenes.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif




TScene::TScene() {
	numobjects = 0;
}

TScene::~TScene() {
	for (int i = 0; i < numobjects; i++) delete(obj[i]);
	numobjects = 0;
}


void TScene::AddObject(TObject3D *o) {
	if (numobjects < MaxSceneObjects) obj[numobjects++] = o;
}

void TScene::Setup(int change_pal) {
	camera->location = CopyVector(own_camera.location);
	camera->direction = CopyVector(own_camera.direction);
	camera->ax = own_camera.ax;
	camera->ay = own_camera.ay;
	camera->az = own_camera.az;
	SetLightPosition(own_light.x, own_light.y, own_light.z);
	if (change_pal) SetPalette(own_palette);
}


void TScene::Draw(unsigned int where) {
	TPolygon **visiblepoly;
	int n = 0;
	visiblepoly = (TPolygon **)malloc(sizeof(TPolygon *) * MaxScenePoly);
	
	for (int o = 0; o < numobjects; o++)
	if (obj[o]->NumPolygons > 0) {

		obj[o]->TransformView();
		if ((obj[o]->Poly[0]->style % 10) == nc_gouraudshaded)
			for (int v = 0; v < obj[o]->NumVertex; v++)
				obj[o]->Vertex[v]->c = dtoi((DotProduct(obj[o]->Vertex[v]->normal, Light) + 1.0)
					* obj[o]->Poly[0]->crange) + obj[o]->Poly[0]->cstart;
			
		for (int p = 0; p < obj[o]->NumPolygons; p++) 
			if (obj[o]->Poly[p]->Visible()) {
				obj[o]->Poly[p]->CalcZOrder();
				visiblepoly[n++] = obj[o]->Poly[p];
			}
	}
	if (n > 0) radixsort(visiblepoly, n);
//        for (int p = 0; p < n; p++) visiblepoly[p]->Draw(where);
        for (int p = 0; p < n; p++) DrawPolygon(visiblepoly[p], where);
	free(visiblepoly);
}
