#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "obj3d.h"
#include "triangle.h"
#include "polygons.h"
#include "vectors.h"
#include "scenes.h"
#include "cameras.h"
#include "credits.h"

// picture files
#include "textcred.h"
#include "credgfx.h"
#include "credmusx.h"
#include "credcode.h"
#include "antalla2.h"

// 3d files
#include "globe.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


double CreditsTable1[256][3], CreditsTable2[256][3];
TObject3D *Credits_obj;

void Credits_Setup() {
	double ang;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
                CreditsTable1[i][0] = 1.0 + cos(ang) * 0.3;
                CreditsTable1[i][1] = 1.0 + sin(ang) * 0.3;
                CreditsTable1[i][2] = 1.0 - cos(ang * 2) * 0.3;
                CreditsTable2[i][0] = 1.0 / CreditsTable1[i][0];
                CreditsTable2[i][1] = 1.0 / CreditsTable1[i][1];
                CreditsTable2[i][2] = 1.0 / CreditsTable1[i][2];
	}
        
        for (i = 0; i < 40320; i++) {
                TEXTCRED[i] = 192 + TEXTCRED[i] / 4;
                CREDGFX[i] = 192 + CREDGFX[i] / 4;
                CREDMUSX[i] = 192 + CREDMUSX[i] / 4;
                CREDCODE[i] = 192 + CREDCODE[i] / 4;
        }

        Credits_obj = new TObject3D();
        Read3DObject(GLOBE_VKX, Credits_obj);
        Credits_obj->Centre();
        Credits_obj->FitSphere(8);
        Credits_obj->SetStyle(c_flatshaded);
        Credits_obj->SetColor(0, 47);
}


void Credits_Free() {
        delete Credits_obj;
}


void CTransform(TObject3D *o, unsigned char t) {
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= CreditsTable1[t][0];
                o->Vertex[i]->y *= CreditsTable1[t][1];
                o->Vertex[i]->z *= CreditsTable1[t][2];
		t--;
	}
        for (i = 0; i < o->NumPolygons; i++) o->Poly[i]->CalcNormal();
}

void CUnTransform(TObject3D *o, unsigned char t) {
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= CreditsTable2[t][0];
                o->Vertex[i]->y *= CreditsTable2[t][1];
                o->Vertex[i]->z *= CreditsTable2[t][2];
		t--;
	}
}

void CRotate(TObject3D *o, int ax, int ay, int az) {
        for (int i = 0; i < o->NumVertex; i++) o->Vertex[i]->Rotate(ax, ay, az);
}


void DrawCredit(int x, int y, unsigned int source, unsigned int dest);
#pragma aux DrawCredit =        \
"       imul ebx, 640"  \
"       add edi, eax"   \
"       mov edx, 112"   \
"       add edi, ebx"   \
"       lp:     mov ecx, 90"    \
"               rep movsd"      \
"               add edi, 280"   \
"               dec edx"        \
"               jnz lp" \
parm [eax] [ebx] [esi] [edi]    \
modify [ecx edx];


void Credits() {
        TVirtual *vs = new TVirtual;
        unsigned char t = 0;
        double a = 0.0;
        int i;
        TPalette pal;

        CopyPalette(ANTALLA2_PAL, pal, 0, 191);
        PhongPal(0.0, 0.6, 1.0, 0.2, 0.6, 1.0, 0.4, 0.6, 1.0, 10, pal, 192, 64);
        HClearScreen(0, SCREEN_OFF);
        HCopyScreen((unsigned int)ANTALLA2, (unsigned int)vs);
        SetPalette(pal);

        camera->location.SetP(-8, 4, -20);
        SetLightPosition(0, 0, -1);

        GetMusicInfo();
        while (row < 32) {
                DrawCredit(60, 60, (unsigned int)TEXTCRED, (unsigned int)vs);
                for (i = 0; i < 4; i++) {
                        HDDALine(52 + rand() % 10, 52 + rand() % 10, 418 + rand() % 10, 52 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(52 + rand() % 10, 170 + rand() % 10, 418 + rand() % 10, 170 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(52 + rand() % 10, 52 + rand() % 10, 52 + rand() % 10, 170 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(418 + rand() % 10, 52 + rand() % 10, 418 + rand() % 10, 170 + rand() % 10, 191, (unsigned int)vs);
                }

                a = ((position) * 64 + row) * 0.02;
                CTransform(Credits_obj, t);
                Credits_obj->Draw((unsigned int)vs);
                CUnTransform(Credits_obj, t);

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA2);

                CRotate(Credits_obj, dtoi(8.0 * sin(a)), dtoi(8.0 * cos(a)), dtoi(8.0 * sin(a / 2.0)));
                t += 2;
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 15) {
                DrawCredit(60, 60, (unsigned int)CREDGFX, (unsigned int)vs);
                for (i = 0; i < 4; i++) {
                        HDDALine(52 + rand() % 10, 52 + rand() % 10, 418 + rand() % 10, 52 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(52 + rand() % 10, 170 + rand() % 10, 418 + rand() % 10, 170 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(52 + rand() % 10, 52 + rand() % 10, 52 + rand() % 10, 170 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(418 + rand() % 10, 52 + rand() % 10, 418 + rand() % 10, 170 + rand() % 10, 191, (unsigned int)vs);
                }

                a = ((position) * 64 + row) * 0.02;
                CTransform(Credits_obj, t);
                Credits_obj->Draw((unsigned int)vs);
                CUnTransform(Credits_obj, t);

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA2);

                CRotate(Credits_obj, dtoi(8.0 * sin(a)), dtoi(8.0 * cos(a)), dtoi(8.0 * sin(a / 2.0)));
                t += 2;
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(8, -6, -20);

        while (row < 32) {
                DrawCredit(220, 240, (unsigned int)CREDMUSX, (unsigned int)vs);
                for (i = 0; i < 4; i++) {
                        HDDALine(212 + rand() % 10, 232 + rand() % 10, 578 + rand() % 10, 232 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(212 + rand() % 10, 350 + rand() % 10, 578 + rand() % 10, 350 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(212 + rand() % 10, 232 + rand() % 10, 212 + rand() % 10, 350 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(578 + rand() % 10, 232 + rand() % 10, 578 + rand() % 10, 350 + rand() % 10, 191, (unsigned int)vs);
                }

                a = ((position) * 64 + row) * 0.02;
                CTransform(Credits_obj, t);
                Credits_obj->Draw((unsigned int)vs);
                CUnTransform(Credits_obj, t);

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA2);

                CRotate(Credits_obj, dtoi(8.0 * sin(a)), dtoi(8.0 * cos(a)), dtoi(8.0 * sin(a / 2.0)));
                t += 2;
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 16) {
                DrawCredit(220, 240, (unsigned int)CREDCODE, (unsigned int)vs);
                for (i = 0; i < 4; i++) {
                        HDDALine(212 + rand() % 10, 232 + rand() % 10, 578 + rand() % 10, 232 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(212 + rand() % 10, 350 + rand() % 10, 578 + rand() % 10, 350 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(212 + rand() % 10, 232 + rand() % 10, 212 + rand() % 10, 350 + rand() % 10, 191, (unsigned int)vs);
                        HDDALine(578 + rand() % 10, 232 + rand() % 10, 578 + rand() % 10, 350 + rand() % 10, 191, (unsigned int)vs);
                }

                a = ((position) * 64 + row) * 0.02;
                CTransform(Credits_obj, t);
                Credits_obj->Draw((unsigned int)vs);
                CUnTransform(Credits_obj, t);

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA2);

                CRotate(Credits_obj, dtoi(8.0 * sin(a)), dtoi(8.0 * cos(a)), dtoi(8.0 * sin(a / 2.0)));
                t += 2;
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
}
