#pragma pack(1)
/* One-Byte Opcode Map */
char	*OpMap1[256]={
/* 0 */
	"add %Eb,%Gb",  "add %Ev,%Gv",  "add %Gb,%Eb",  "add %Gv,%Ev",
	"add al,%Ib",   "add %eax,%Iv", "push es",      "pop es",
	"or %Eb,%Gb",   "or %Ev,%Gv",   "or %Gb,%Eb",   "or %Gv,%Ev",
	"or al,%Ib",    "or %eax,%Iv",  "push cs",      "%2 ",
/* 1 */
	"adc %Eb,%Gb",  "adc %Ev,%Gv",  "adc %Gb,%Eb",  "adc %Gv,%Ev",
	"adc al,%Ib",   "adc %eax,%Iv", "push ss",      "pop ss",
	"sbb %Eb,%Gb",  "sbb %Ev,%Gv",  "sbb %Gb,%Eb",  "sbb %Gv,%Ev",
	"sbb al,%Ib",   "sbb %eax,%Iv", "push ds",      "pop ds",
/* 2 */
	"and %Eb,%Gb",  "and %Ev,%Gv",  "and %Gb,%Eb",  "and %Gv,%Ev",
	"and al,%Ib",   "and %eax,%Iv", "%pe",          "daa",
	"sub %Eb,%Gb",  "sub %Ev,%Gv",  "sub %Gb,%Eb",  "sub %Gv,%Ev",
	"sub al,%Ib",   "sub %eax,%Iv", "%pc",          "das",
/* 3 */
	"xor %Eb,%Gb",  "xor %Ev,%Gv",  "xor %Gb,%Eb",  "xor %Gv,%Ev",
	"xor al,%Ib",   "xor %eax,%Iv", "%ps",          "aaa",
	"cmp %Eb,%Gb",  "cmp %Ev,%Gv",  "cmp %Gb,%Eb",  "cmp %Gv,%Ev",
	"cmp al,%Ib",   "cmp %eax,%Iv", "%pd",          "aas",
/* 4 */
	"inc %eax",     "inc %ecx",     "inc %edx",     "inc %ebx",
	"inc %esp",     "inc %ebp",     "inc %esi",     "inc %edi",
	"dec %eax",     "dec %ecx",     "dec %edx",     "dec %ebx",
	"dec %esp",     "dec %ebp",     "dec %esi",     "dec %edi",
/* 5 */
	"push %eax",    "push %ecx",    "push %edx",    "push %ebx",
	"push %esp",    "push %ebp",    "push %esi",    "push %edi",
	"pop %eax",     "pop %ecx",     "pop %edx",     "pop %ebx",
	"pop %esp",     "pop %ebp",     "pop %esi",     "pop %edi",
/* 6 */
	"pusha%d ",     "popa%d ",      "bound %Gv,%Ma","arpl %Ew,%Gw",
	"%pf",          "%pg",          "%so",          "%sa",
	"push %Iv",     "imul %Gv,%Ev,%Iv","push %3v%Ib",  "imul %Gv,%Ev,%Ib",
	"insb %Yb,dx",  "ins%wd %Yv,dx","outsb dx,%Xb", "outs%wd dx,%Xv",
/* 7 */
	"jo %Jb",       "jno %Jb",      "jb %Jb",       "jnb %Jb",
	"jz %Jb",       "jnz %Jb",      "jbe %Jb",      "jnbe %Jb",
	"js %Jb",       "jns %Jb",      "jp %Jb",       "jnp %Jb",
	"jl %Jb",       "jnl %Jb",      "jng %Jb",      "jg %Jb",
/* 8 */
	"%g0 %Eb,%Ib",  "%g0 %Ev,%Iv",  "%g0 %Eb,%Ib","%g0 %3v%Ev,%Ib",
	"test %Eb,%Gb", "test %Ev,%Gv", "xchg %Eb,%Gb", "xchg %Ev,%Gv",
	"mov %Eb,%Gb",  "mov %Ev,%Gv",  "mov %Gb,%Eb",  "mov %Gv,%Ev",
	"mov %Ev,%Sw",  "lea %Gv,%M ",  "mov %Sw,%Ew",  "pop %Ev",
/* 9 */
	"nop",        "xchg %eax,%ecx","xchg %eax,%edx","xchg %eax,%ebx",
     "xchg %eax,%esp","xchg %eax,%ebp","xchg %eax,%esi","xchg %eax,%edi",
	"c%bw%wd%qe",   "c%w d%qq",     "call %Ap",     "wait",
	"pushf%d ",     "popf%d ",      "sahf",         "lahf",
/* A */
	"mov al,%Ob",   "mov %eax,%Ov", "mov %Ob,al",   "mov %Ov,%eax",
     "movs byte ptr %Yb,%Xb","movs %d word ptr %Yv,%Xv","cmps byte ptr %Yb,%Xb","cmps %d word ptr %Yv,%Xv",
"test al,%Ib",  "test %eax,%Iv","stos byte ptr %Yb,al", "stos %d word ptr %Yv,%eax",
     "lods byte ptr al,%Xb","lods %d word ptr %eax,%Xv","scas byte ptr %Yb,al", "scas %d word ptr %Yv,%eax",
/* B */
	"mov al,%Ib",   "mov cl,%Ib",   "mov dl,%Ib",   "mov bl,%Ib",
	"mov ah,%Ib",   "mov ch,%Ib",   "mov dh,%Ib",   "mov bh,%Ib",
	"mov %eax,%Iv", "mov %ecx,%Iv", "mov %edx,%Iv", "mov %ebx,%Iv",
	"mov %esp,%Iv", "mov %ebp,%Iv", "mov %esi,%Iv", "mov %edi,%Iv",
/* C */
	"%g1 %Eb,%Ib",  "%g1 %Ev,%Ib",  "ret %Iw",      "ret",
	"les %Gv,%Mp",  "lds %Gv,%Mp",  "mov %Eb,%Ib",  "mov %Ev,%Iv",
	"enter %Iw,%Ib","leave",        "retf %Iw",     "retf",
	"int 3",        "int %Ib",      "into",         "iret%d ",
/* D */
	"%g1 %Eb,1",    "%g1 %Ev,1",    "%g1 %Eb,cl",   "%g1 %Ev,cl",
//	  "aam%11",       "aad%11",       "salc",         "xlat",
	"aam %Ib",      "aad %Ib",      "salc",         "xlat",
	"%f0",          "%f1",          "%f2",          "%f3",
	"%f4",          "%f5",          "%f6",          "%f7",
/* E */
	"loopne %Jb",   "loope %Jb",    "loop %Jb",     "j%aecxz %Jb",
	"in al,%Ib",    "in %eax,%Ib",  "out %Ib,al",   "out %Ib,%eax",
	"call %Jv",     "jmp %Jv",      "jmp %Ap",      "jmp %Jb",
	"in al,dx",     "in %eax,dx",   "out dx,al",    "out dx,%eax",
/* F */
	"lock %p ",     0,              "repne %p ",    "repe %p ",
	"hlt",          "cmc",          "%rb%g2",       "%rv%g2",
	"clc",          "stc",          "cli",          "sti",
	"cld",          "std",          "%g3",          "%g4" };

/* Two-Byte Opcode Map (first byte is 0Fh) */
char	*Second[256]={
/* 0 */
	"%g5",          "%g6",          "lar %Gv,%Ew",  "lsl %Gv,%Ew",
	0,		"loadall",      "clts",         "loadalld",
	"invd",         "wbinvd",       0,              "ud2",
	0,		0,		0,		0,

/* 1 */
	"mov %Eb,%Gb",  "mov %Gv,%Ev",  "mov %Gb,%Eb",  "mov %Ev,%Gv",
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 2 */
	"mov %Rd,%Cd",  "mov %Rd,%Dd",  "mov %Cd,%Rd",  "mov %Dd,%Rd",
	"mov %Rd,%Td",  0,              "mov %Td,%Rd",  0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 3 */
	"wrmsr",        "rdtsc",        "rdmsr",        "rdpmc",
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 4 */
       "cmovo %Gv,%Ev","cmovno %Gv,%Ev","cmovb %Gv,%Ev","cmovnb %Gv,%Ev",
       "cmovz %Gv,%Ev","cmovnz %Gv,%Ev","cmovbe %Gv,%Ev","cmovnbe %Gv,%Ev",
       "cmovs %Gv,%Ev","cmovns %Gv,%Ev","cmovp %Gv,%Ev","cmovnp %Gv,%Ev",
       "cmovl %Gv,%Ev","cmovnl %Gv,%Ev","cmovng %Gv,%Ev","cmovg %Gv,%Ev",

/* 5 */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 6 */
 "punpcklbw %Pq,%Qd","punpcklwd %Pq,%Qd","punockldq %Pq,%Qd","packusdw %Pq,%Qd",
     "pcmpgtb %Pq,%Qd","pcmpgtw %Pq,%Qd","pcmpgtd %Pq,%Qd","packsswb %Pq,%Qd",
 "punpckhbw %Pq,%Qd","punpckhwd %Pq,%Qd","punpckhdq %Pq,%Qd","packssdw %Pq,%Qd",
	0,		0,		"movd %Pd,%Ed", "movq %Pq,%Qq",

/* 7 */
	0,		"%g9w %Pq,%Ib", "%g9d %Pq,%Ib", "%g9q %Pq,%Ib",
    "pcmpeqb %Pq,%Qd","pcmpeqw %Pq,%Qd","pcmpeqd %Pq,%Qd","emms",
	0,		0,		0,		0,
	0,		0,		"movd %Ed,%Pd", "movq %Qq,%Pq",

/* 8 */
	"jo %Jv",       "jno %Jv",      "jb %Jv",       "jnb %Jv",
	"jz %Jv",       "jnz %Jv",      "jna %Jv",      "ja %Jv",
	"js %Jv",       "jns %Jv",      "jp %Jv",       "jnp %Jv",
	"jl %Jv",       "jnl %Jv",      "jng %Jv",      "jg %Jv",

/* 9 */
	"seto %Eb",     "setno %Eb",    "setb %Eb",     "setnb %Eb",
	"setz %Eb",     "setnz %Eb",    "setna %Eb",    "seta %Eb",
	"sets %Eb",     "setns %Eb",    "setp %Eb",     "setnp %Eb",
	"setl %Eb",     "setnl %Eb",    "setng %Eb",    "setg %Eb",

/* A */
	"push fs",      "pop fs",       "cpuid",        "bt %Ev,%Gv",
   "shld %Ev,%Gv,%Ib","shld %Ev,%Gv,cl",0,              0,
	"push gs",      "pop gs",       "rsm",          "bts %Ev,%Gv",
   "shrd %Ev,%Gv,%Ib","shrd %Ev,%Gv,cl",0,              "imul %Gv,%Ev",

/* B */
    "cmpxchg %Eb,%Gb","cmpxchg %Ev,%Gv","lss %Gv,%Mp",  "btr %Ev,%Gv",
    "lfs %Gv,%Mp",  "lgs %Gv,%Mp",  "movzx %Gv,%Eb","movzx %Gv,%Ew",
	0,		"ud",           "%g7 %Ev,%Ib",  "btc %Ev,%Gv",
	"bsf %Gv,%Ev",  "bsr %Gv,%Ev",  "movsx %Gv,%Eb","movsx %Gv,%Ew",

/* C */
	"xadd %Eb,%Gb", "xadd %Ev,%Gv", 0,              0,
	0,		0,		0,		"cmpxchg8B %Mq",
	"bswap eax",    "bswap ecx",    "bswap edx",    "bswap ebx",
	"bswap esp",    "bswap ebp",    "bswap esi",    "bswap edi",

/* D */
	0,		"psrlw %Pq,%Qd","psrld %Pq,%Qd","psrlq %Pq,%Qd",
	0,	       "pmullw %Pq,%Qd",0,              0,
    "psubusb %Pq,%Qq","psubusw %Pq,%Qq",0,              "pand %Pq,%Qq",
    "paddusb %Pq,%Qq","paddusw %Pq,%Qq",0,              "pandn %Pq,%Qq",
/* E */
	0,		"psraw %Pq,%Qd","psrad %Pq,%Qd",0,
	0,	       "pmulhw %Pq,%Qd",0,              0,
      "psubsb %Pq,%Qq","psubsw %Pq,%Qq",0,              "por %Pq,%Qq",
      "paddsb %Pq,%Qq","paddsw %Pq,%Qq",0,              "pxor %Pq,%Qq",
/* F */
	0,		"psllw %Pq,%Qd","pslld %Pq,%Qd","psllq %Pq,%Qd",
	0,	      "pmaddwd %Pq,%Qd",0,              0,
	"psubb %Pq,%Qq","psubw %Pq,%Qq","psubd %Pq,%Qq",0,
	"paddb %Pq,%Qq","paddw %Pq,%Qq","paddd %Pq,%Qq",0 };

char	*Groups[][8]={
/* 0 */ {
	"add",          "or",           "adc",          "sbb",
	"and",          "sub",          "xor",          "cmp"       },

/* 1 */ {
	"rol",          "ror",          "rcl",          "rcr",
	"shl",          "shr",          "shl",          "sar"       },

/* 2 */ {
	"test %Er,%Ir", "test %Er,%Ir", "not %Er",      "neg %Er",
	"mul %Er",      "imul %Er",     "div %Er",      "idiv %Er"  },

/* 3 */ {
	"inc %Eb",      "dec %Eb",      0,              0,
	0,		0,		0,		0	    },

/* 4 */ {
	"inc %Ev",      "dec %Ev",      "call %Ev",     "call %Ep",
	"jmp %Ev",      "jmp %Ep",      "push %Ev",     0           },

/* 5 */ {
	"sldt %Ew",     "str %Ew",      "lldt %Ew",     "ltr %Ew",
	"verr %Ew",     "verw %Ew",     0,              0           },

/* 6 */ {
	"sgdt %Ms",     "sidt %Ms",     "lgdt %Ms",     "lidt %Ms",
	"smsw %Ew",     0,              "lmsw %Ew",     "invlpg"    },

/* 7 */ {
	0,		0,		0,		0,
	"bt",           "bts",          "btr",          "btc"       },

/* 8 */ {
	0,		"cmpxch8B %Mq", 0,              0,
	0,		0,		0,		0	    },

/* 9 */ {
	0,		0,		"psrl",         0,
	"psra",         0,              "psll",         0
	},
	};

	/* These maps are directly copied from table.c (2asm) */
char	*f0[]	  = { 0, 0, 0, 0, 0, 0, 0, 0};
char	*fop_9[]  = { "*fxch st,%GF" };
char	*fop_10[] = { "fnop", 0, 0, 0, 0, 0, 0, 0 };
char	*fop_12[] = { "fchs", "fabs", 0, 0, "ftst", "fxam", 0, 0 };
char	*fop_13[] = { "fld1", "fldl2t", "fldl2e", "fldpi",
		      "fldlg2", "fldln2", "fldz", 0 };
char	*fop_14[] = { "f2xm1", "fyl2x", "fptan", "fpatan",
		      "fxtract", "fprem1", "fdecstp", "fincstp" };
char	*fop_15[] = { "fprem", "fyl2xp1", "fsqrt", "fsincos",
		      "frndint", "fscale", "fsin", "fcos" };
char	*fop_16[] = { "*fcmovb st,%GF" };
char	*fop_17[] = { "*fcmove st,%GF" };
char	*fop_18[] = { "*fcmovbe st,%GF" };
char	*fop_19[] = { "*fcmovu st,%GF" };
char	*fop_21[] = { 0, "fucompp", 0, 0, 0, 0, 0, 0 };
char	*fop_24[] = { "*fcmovnb st,%GF" };
char	*fop_25[] = { "*fcmovne st,%GF" };
char	*fop_26[] = { "*fcmovnbe st,%GF" };
char	*fop_27[] = { "*fcmovnu st,%GF" };
char	*fop_28[] = { 0, 0, "fclex", "finit", 0, 0, 0, 0 };
char	*fop_29[] = { "*fucomi st,%GF" };
char	*fop_30[] = { "*fcomi st,%GF" };
char	*fop_32[] = { "*fadd %GF,st" };
char	*fop_33[] = { "*fmul %GF,st" };
char	*fop_36[] = { "*fsubr %GF,st" };
char	*fop_37[] = { "*fsub %GF,st" };
char	*fop_38[] = { "*fdivr %GF,st" };
char	*fop_39[] = { "*fdiv %GF,st" };
char	*fop_40[] = { "*ffree %GF" };
char	*fop_42[] = { "*fst %GF" };
char	*fop_43[] = { "*fstp %GF" };
char	*fop_44[] = { "*fucom %GF" };
char	*fop_45[] = { "*fucomp %GF" };
char	*fop_48[] = { "*faddp %GF,st" };
char	*fop_49[] = { "*fmulp %GF,st" };
char	*fop_51[] = { 0, "fcompp", 0, 0, 0, 0, 0, 0 };
char	*fop_52[] = { "*fsubrp %GF,st" };
char	*fop_53[] = { "*fsubp %GF,st" };
char	*fop_54[] = { "*fdivrp %GF,st" };
char	*fop_55[] = { "*fdivp %GF,st" };
char	*fop_60[] = { "fstsw ax", 0, 0, 0, 0, 0, 0, 0 };
char	*fop_61[] = { "*fucmpip st,%GF" };
char	*fop_62[] = { "*fcomip st,%GF" };

char	**fspecial[] = { /* 0=use st(i), 0 in fop_* means undefined */
/* D8 */0, 0, 0, 0, 0, 0, 0, 0,
/* D9 */0, fop_9, fop_10, 0, fop_12, fop_13, fop_14, fop_15,
/* DA */fop_16,fop_17,fop_18,fop_19,f0,fop_21, f0, f0,
/* DB */fop_24,fop_25,fop_26,fop_27,fop_28,fop_29,fop_30,f0,
/* DC */fop_32, fop_33, f0, f0, fop_36, fop_37, fop_38, fop_39,
/* DD */fop_40, f0, fop_42, fop_43, fop_44, fop_45, f0, f0,
/* DE */fop_48, fop_49, f0, fop_51, fop_52, fop_53, fop_54, fop_55,
/* DF */f0, f0, f0, f0, fop_60, fop_61, fop_62, f0
};

char	*floatops[] = { /* assumed " %EF" at end of each.  mod != 3 only */
/*00*/	"fadd",         "fmul",         "fcom",         "fcomp",
	"fsub",         "fsubr",        "fdiv",         "fdivr",
/*08*/	"fld",          0,              "fst",          "fstp",
	"fldenv",       "fldcw",        "fstenv",       "fstcw",
/*16*/	"fiadd",        "fimul",        "ficomw",       "ficompw",
	"fisub",        "fisubr",       "fidiv",        "fidivr",
/*24*/	"fild",         0,              "fist",         "fistp",
	"frstor",       "fldt",         0,              "fstpt",
/*32*/	"faddq",        "fmulq",        "fcomq",        "fcompq",
	"fsubq",        "fsubrq",       "fdivq",        "fdivrq",
/*40*/	"fldq",         0,              "fstq",         "fstpq",
	0,	0,	"fsave",        "fstsw",
/*48*/	"fiaddw",       "fimulw",       "ficomw",       "ficompw",
	"fisubw",       "fisubrw",      "fidivw",       "fidivr",
/*56*/	"fildw",        0,              "fistw",        "fistpw",
	"fbldt",        "fildq",        "fbstpt",       "fistpq"
};
