//
//                       __      __      _  __ 
//                   .: (__ (__ (--) >-< ( (-_ :.
//
//
// (c) Copyright 1997 Mikko E. Mononen <memon@inside.org>
//

#include <dos.h>
#include <string.h>

struct meminfo {
    unsigned int LargestBlockAvail;
    unsigned int MaxUnlockedPage;
    unsigned int LargestLockablePage;
    unsigned int LinAddrSpace;
    unsigned int NumFreePagesAvail;
    unsigned int NumPhysicalPagesFree;
    unsigned int TotalPhysicalPages;
    unsigned int FreeLinAddrSpace;
    unsigned int SizeOfPageFile;
    unsigned int Reserved[3];
} MemInfo;


int memFree()
{
  union REGS regs;
  struct SREGS sregs;

  regs.x.eax = 0x00000500;
  memset( &sregs, 0, sizeof(sregs) );
  sregs.es = FP_SEG( &MemInfo );
  regs.x.edi = FP_OFF( &MemInfo );
  int386x( 0x31, &regs, &regs, &sregs );

  return MemInfo.LargestBlockAvail;
}
