//
//  8bit Targa24 loader
//  (c) Copyright 1997 memon/inside
//

#include <stdio.h>
#include <stdlib.h>

#include "file_tga.hh"
#include "clax.h"


int
loadTGA( char* file, char* buffer, char* palette )
{

  char       id[257];
  int        i;
  TGAheader  h;
  FILE       *fp;
  
  
  if ((fp = fopen( file, "rb" )) == 0 )
    return clax_err_badfile;
  
  if ( fread( &h, sizeof( TGAheader ), 1, fp ) == 0 )
    return clax_err_badfile;

/*
  printf( " sizeof( TGAheader ) = %d\n", sizeof( TGAheader ) );
  printf( "idSize..........%d\n", h.idSize );
  printf( "colorMapType....%d\n", h.colorMapType );
  printf( "imageTypeCode...%d\n", h.imageTypeCode );
  printf( "colorMapOrigin..%d\n", h.colorMapOrigin );
  printf( "colorMapLenght..%d\n", h.colorMapLenght );
  printf( "colorMapESize...%d\n", h.colorMapESize );
  printf( "xOrigin.........%d\n", h.xOrigin );
  printf( "yOrigin.........%d\n", h.yOrigin );
  printf( "width...........%d\n", h.width );
  printf( "height..........%d\n", h.height );
  printf( "depth...........%d\n", h.depth );
  printf( "imageDescrip....%d\n", h.imageDescrip );
  fflush( stdout );
*/

  if ( (h.colorMapType != 1) || (h.depth != 8) ||
       (h.width != 256) || (h.height != 256) ||
       (h.colorMapESize != 24) ) {
    fclose( fp );
    return clax_err_badformat;
  }
  
  // skip over image identification field
  for ( i = 0; i < h.idSize; i++ )
    id[i] = (char)fgetc( fp );
  id[i] = 0;

//  printf("id: %s\n", id );

  fseek( fp, (18 + h.idSize), SEEK_SET );
  if ( palette ) {
    for ( i = h.colorMapOrigin; i < (h.colorMapOrigin + h.colorMapLenght); i++ ) {
      palette[i * 3 + 2] = (char)(fgetc( fp ) >> 2);
      palette[i * 3 + 1] = (char)(fgetc( fp ) >> 2);
      palette[i * 3 + 0] = (char)(fgetc( fp ) >> 2);
    }
  }

  fseek( fp, (18 + h.idSize + (h.colorMapLenght) * 3), SEEK_SET );
  if ( buffer ) {
    if ( fread( buffer, (h.width * h.height), 1, fp ) == 0 ) {
      fclose( fp );
      return clax_err_badfile;
    }
    // swap picture
    for ( i = 0; i < (h.width * h.height); i++ ) {
      char tmp = buffer[i];
      buffer[i] = buffer[(h.width * h.height - 1) - i];
      buffer[(h.width * h.height - 1) - i] = tmp;
    }
  }

  fclose( fp );

  return clax_err_ok;
}

