#include <math.h>
#include <stdio.h>


long  sqrttab[0x100];


void
buildSqrtTable( void )
{
  unsigned short i;
  float f;
  unsigned int *fi = (unsigned*)&f;   // To access the bits of a float in
                                      // C quickly we must misuse pointers
  for (i = 0; i <= 0x7f; i++) {
    *fi = 0;

    // Build a float with the bit pattern i as mantissa
    // and an exponent of 0, stored as 127
    *fi = (i << 16) | (127 << 23);
    f = sqrt(f);

    // Take the square root then strip the first 7 bits of
    // the mantissa into the table
    sqrttab[i] = (*fi & 0x7fffff);

    // Repeat the process, this time with an exponent of 1,
    // stored as 128
    *fi = 0;
    *fi = (i << 16) | (128 << 23);
    f = sqrt(f);
    sqrttab[i+0x80] = (*fi & 0x7fffff);
  }

}


void
main()
{
  buildSqrtTable();

  int last = 6;
  for ( int i = 0; i < 256; i++ ) {
    printf( "0x%x, ", sqrttab[i] );
    if ( i > last ) {
      printf( "\n" );
      last += 8;
    }
  }
  printf( "\n" );

}