*****************************************************************************
* CCS-MON 								    *
* by Per Hkan Sundell							    *
*****************************************************************************
	INCDIR	CCSInclude/
Prefs=$f0000
Preferences=Prefs+$400
Prend=Preferences+$400

	Section	Code,Code

	bra.s	Start2				;This line only on the
						;testversions!
Start1:	
	movem.l	a0-a1,Preferences+$1c		;ENTRY FR. RESET
	move.l	$0080.w,a0
	lea	Start1a(pc),a1
	movem.l	a1/a1,$0080.w
	trap	#0
Start1a:move.w	#$2700,SR
	move.l	a0,$0080.w
	movem.l	Preferences+$1c,a0-a1
	move.w	(a7)+,Preferences+$8e		;SR
	move.l	a5,Preferences+$90		;PC
	addq.l	#4,a7
	move.w	#1000,Preferences+$70		;Startcode 1000
	bra	Start5

Start2:
	movem.l	a0-a1,Preferences+$1c		;ENTRY FR. JSR
	move.l	$0080.w,a0
	lea	Start2a(pc),a1
	movem.l	a1/a1,$0080.w
	trap	#0
Start2a:move.w	#$2700,SR
	move.l	a0,$0080.w
	movem.l	Preferences+$1c,a0-a1
	move.w	(a7)+,Preferences+$8e		;SR
	addq.l	#4,a7
	move.l	a7,Preferences+$8a		;SSP
	move.l	USP,a7
	movem.l	a0-a7/d0-d7,Preferences+$1c
	move.w	#1001,Preferences+$70		;Startcode 1001
	move.w	Preferences+$8e,d0
	and.w	#$2000,d0			;SUPERVISOR
	bne.s	Start2b				;OR USER-MODE ?
	move.l	(a7)+,Preferences+$90		;PC
	move.l	a7,Preferences+$58		;USP
	bra	Start6
Start2b:
	move.l	Preferences+$8a,a7
	move.l	(a7)+,Preferences+$90		;PC
	move.l	a7,Preferences+$8a		;SSP
	bra	Start6

Start3:
	movem.l	a0-a1,Preferences+$1c		;ENTRY FR. RTS
	move.l	$0080.w,a0
	lea	Start3a(pc),a1
	movem.l	a1/a1,$0080.w
	trap	#0
Start3a:move.w	#$2700,SR
	move.l	a0,$0080.w
	movem.l	Preferences+$1c,a0-a1
	move.w	(a7)+,Preferences+$8e		;SR
	addq.l	#4,a7
	move.l	a7,Preferences+$8a		;SSP
	move.l	USP,a7
	movem.l	a0-a7/d0-d7,Preferences+$1c
	move.w	#1002,Preferences+$70		;Startcode 1002
	move.w	Preferences+$8e,d0
	and.w	#$2000,d0			;SUPERVISOR
	bne.s	Start3b				;OR USER-MODE ?
	move.l	(a7)+,Preferences+$90		;PC
	move.l	a7,Preferences+$58		;USP
	bra.s	Start6
Start3b:
	move.l	Preferences+$8a,a7
	move.l	(a7)+,Preferences+$90		;PC
	move.l	a7,Preferences+$8a		;SSP
	bra.s	Start6

Start4:	move.w	#$2700,SR			;ENTRY FR. NMI-IRQ
	move.w	(a7)+,Preferences+$8e		;SR
	move.l	(a7)+,Preferences+$90		;PC
	move.w	#1003,Preferences+$70		;Startcode 1003
Start5:	move.l	a7,Preferences+$8a		;SSP
	move.l	USP,a7
	movem.l	a0-a7/d0-d7,Preferences+$1c
Start6:	lea	Preferences,a6
	lea	Prefs,a7
	add.l	#$010000,a7
	move.l	a7,$94(a6)
	bsr	MakePrefs
	bsr	ReadAgnus	;Read The Agnus Hardware regs.
	bsr	ReadCIA		;Read The CIA regs.
	move.w	#$7fff,$dff09a	;INTENA
	move.w	#$07ff,$dff096	;DMACON
	bsr	MakeLibrary
	jsr	_ExchangeRam(a6)
	bsr	FindROMFont
	bsr	FindROMKeymap
	bsr	FindAgnusChip
	bsr	FindScreenLastLine
	bsr	SaveExitPar
	bsr	MakePointer
	bsr	MakeCursor
	lea	AdressErrorIRQ(pc),a0
	move.l	a0,$000c.W		;ADRESS ERROR EXCEPTION
	lea	LevelOneIRQ(pc),a0
	move.l	a0,$0064.W		;LEVEL 1 IRQ
	lea	LevelTwoIRQ(pc),a0
	move.l	a0,$0068.W		;LEVEL 2 IRQ
	lea	LevelThreeIRQ(pc),a0
	move.l	a0,$006c.W		;LEVEL 3 IRQ
	lea	LevelFourIRQ(pc),a0
	move.l	a0,$0070.W		;LEVEL 4 IRQ
	lea	LevelFiveIRQ(pc),a0
	move.l	a0,$0074.W		;LEVEL 5 IRQ
	lea	LevelSixIRQ(pc),a0
	move.l	a0,$0078.W		;LEVEL 6 IRQ
	lea	LevelSevenIRQ(pc),a0
	move.l	a0,$007c.W		;LEVEL 7 IRQ
	move.b	#$00,$bfe301
	move.b	#$03,$bfe201
	move.b	#$fc,$bfe001
	move.b	#$7f,$bfed01		;CIAA ICR
	move.b	#$88,$bfed01

	move.b	#$00,$bfee01		;CIAA CRA
	move.b	#$08,$bfef01
	move.b	#$ff,$bfd300
	move.b	#$ff,$bfd100
	move.b	#$c0,$bfd200
	move.b	#$00,$1bc(a6)
	move.b	#$04,$1bd(a6)		;Enable ALRM
	move.b	#$00,$1be(a6)
	move.b	#$08,$1bf(a6)		;Enable SP
	move.b	#$7f,$bfdd00
	move.b	#$84,$bfdd00		;ALRM
	tst.b	$bfdd00
	move.b	#$00,$bfde00
	move.b	#$80,$bfdf00
	move.w	#$7fff,$dff09c
	move.l	$18e(a6),a0
	move.b	$2c(a0),d0	;Keyboard Irq request
	or.b	$bfed01,d0
	and.b	#$08,d0
	beq.s	Start7
	move.w	#$8008,$dff09c
	or.b	#$08,$1be(a6)
Start7:	move.w	#$e028,$dff09a	;INTENA
	move.w	#$2000,SR
	tst.l	$5c(a6)
	bne.s	Start8
	moveq	#$0c,d0
	jsr	_WriteChar(a6)
Start8:	moveq	#'*',d0
	jsr	_WriteChar(a6)
	moveq	#'B',d0
	cmp.w	#1003,$70(a6)
	beq.s	Start9
	moveq	#'R',d0
	cmp.w	#1002,$70(a6)
	beq.s	Start9
	lea	StartText(pc),a0
	jsr	_WriteString(a6)
	moveq	#'*',d0
	jsr	_WriteChar(a6)
	moveq	#'S',d0
	cmp.w	#1001,$70(a6)
	beq.s	Start9
	moveq	#'C',d0
	cmp.w	#1000,$70(a6)
	bne.s	Loop
Start9:
	jsr	_WriteChar(a6)
	bsr	RegisterCom
Loop:	lea	Preferences,a6
	bsr	ShowCursor
Loop1:	bsr	SetCursor		;Pointer
	jsr	_ReadKeyboard(a6)
	tst.b	d0
	beq.s	Loop1
	bsr	RemCursor
Loop2:
	cmp.b	#$7f,d0		;DEL
	beq	Delkey
	cmp.b	#$1b,d0		;Esc
	beq.s	EscSeq
	cmp.b	#$9b,d0		;CSI
	beq.s	ANSI
	cmp.b	#$0d,d0		;Return
	beq	ExecuteCom
	jsr	_WriteChar(a6)
	bra.s	Loop
EscSeq:
	jsr	_ReadKeyboard(a6)
	tst.b	d0
	beq.s	EscSeq
	cmp.b	#$5b,d0		;[
	beq.s	ANSI
	bra.s	Loop2
ANSI:
	move.l	$1c4(a6),a0
	bsr	ReadCSIPar
	move.l	4(a0),d6
	lea	ErrorHandler0,a0
	move.l	a0,$142(a6)
	cmp.b	#$01,d0		;KEYPAD & CURSOR SPECIAL
	beq.s	ANSI10
	cmp.b	#$5A,d0		;CURSOR BACKWARD TAB
	beq.s	ANSI1
	cmp.b	#$3f,d0		;HELP KEY
	beq.s	ANSI2
	cmp.b	#$7e,d0		;FUNCTION KEY
	beq.s	ANSI3
	bra	Loop

ANSI1:					;Backward TAB
	subq.w	#1,$5e(a6)
	and.w	#$0078,$5e(a6)
	cmp.w	#$0078,$5e(a6)
	bne	Loop
	move.w	#$0048,$5e(a6)
	moveq	#1,d6			;CuUp
	bra	ANSI10

ANSI2:					;HELP
	jsr	_ReadKeyboard(a6)
	tst.b	d0
	beq.s	ANSI2
	cmp.b	#$7e,d0
	bne	Loop
	bra	HelpScreen

ANSI3:					;FUNCTION KEY
	cmp.b	#0,d6			;F1
	beq	Editor
	bra	Loop
ANSI10:					;KEYPAD SPECIAL
	cmp.b	#0,d6
	beq.s	ANSI10_0
	cmp.b	#1,d6
	beq.s	ANSI10_1
	cmp.b	#2,d6
	beq.s	ANSI10_2
	cmp.b	#3,d6
	beq.s	ANSI10_3
	cmp.b	#4,d6
	beq.s	ANSI10_4
	cmp.b	#5,d6
	beq	ANSI10_5
	cmp.b	#6,d6
	beq	ANSI10_6
	cmp.b	#7,d6
	beq	ANSI10_7
	cmp.b	#9,d6
	beq	ANSI10_9
	cmp.b	#10,d6
	beq	ANSI10_10
	cmp.b	#15,d6
	beq	ANSI10_15
	bra	Loop

ANSI10_0:				;Home
	clr.w	$5e(a6)
	bra	Loop

ANSI10_1:				;CRSR UP
	tst.w	$5c(a6)
	bne.s	ANSI10_1a
	jsr	_ScrollDown(a6)
	bsr	TestForComUp
	bra	Loop
ANSI10_1a:
	subq.w	#1,$5c(a6)
	bra	Loop

ANSI10_2:				;PAGE UP
	bra	TestForComUpII

ANSI10_3:				;CRSR LEFT
	tst.w	$5e(a6)
	bne.s	ANSI10_3a
	move.w	#$004f,$5e(a6)
	moveq	#$01,d6			;CuUp
	bra	ANSI10
ANSI10_3a:
	subq.w	#1,$5e(a6)
	bra	Loop

ANSI10_4:				;CRSR RIGHT
	cmp.w	#$004f,$5e(a6)
	bne.s	ANSI10_4a
	clr.w	$5e(a6)
	moveq	#$06,d6			;CuDo
	bra	ANSI10
ANSI10_4a:
	addq.w	#1,$5e(a6)
	bra	Loop

ANSI10_5:				;END
	move.w	#$004f,$5e(a6)
	bra	Loop

ANSI10_6:				;CRSR DOWN
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0		;CRSR DOWN
	bne.s	ANSI10_6a
	bsr	TestForComDown
	move.w	$14c(a6),d0
	subq.w	#3,d0
	cmp.w	$5c(a6),d0
	beq.s	ANSI10_6a
	jsr	_ScrollUp(a6)
	bra	Loop
ANSI10_6a:
	addq.w	#1,$5c(a6)
	bra	Loop

ANSI10_7:				;PAGE DOWN
	bra	TestForComDownII

ANSI10_9:				;DEL
	bra	Delkey

ANSI10_10:				;SHFT HOME
	clr.w	$5c(a6)
	clr.w	$5e(a6)
	bra	Loop

ANSI10_15:				;SHFT END
	move.w	$14c(a6),d0		;TOTAL NR OF LINES
	subq.w	#2,d0
	move.w	d0,$5c(a6)
	move.w	#$004f,$5e(a6)
	bra	Loop

Delkey:
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	Delkey1
	bsr	CalcYAddr
Delkey1:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a0
	add.w	d1,a0
Delkey2:
	cmp.w	#$004f,d1
	beq.s	Delkey3
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	bra.s	Delkey2
Delkey3:
	move.b	#$20,(a0)
	move.w	$5e(a6),d1
	move.l	$178(a6),a0
	add.w	d1,a0
Delkey4:
	cmp.w	#$004f,d1
	beq.s	Delkey5
	move.b	$0051(a0),$0050(a0)
	move.b	$00a1(a0),$00a0(a0)
	move.b	$00f1(a0),$00f0(a0)
	move.b	$0141(a0),$0140(a0)
	move.b	$0191(a0),$0190(a0)
	move.b	$01e1(a0),$01e0(a0)
	move.b	$0231(a0),$0230(a0)
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	bra.s	Delkey4
Delkey5:
	clr.b	(a0)
	clr.b	$0050(a0)
	clr.b	$00a0(a0)
	clr.b	$00f0(a0)
	clr.b	$0140(a0)
	clr.b	$0190(a0)
	clr.b	$01e0(a0)
	clr.b	$0230(a0)
	bra	Loop

StartText:
	dc.b	12
	dc.b	"                           CCS-MON  V0.53",10
	dc.b	"                        BY PER HKAN SUNDELL",10
	dc.b	"                  (C) 1990 Future Computer Systems AB"
	dc.b	10,0
	even

*****************************************************************************
	INCLUDE	HelpScreen
*****************************************************************************

TestForComUp:
	moveq	#$00,d7
	move.w	$14c(a6),d1		;ScreenLastLine
	subq.w	#2,d1
TestForComUp1:
	move.w	$14c(a6),d2
	subq.w	#2,d2
	sub.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComUp1a
	sub.w	$14c(a6),d2
TestForComUp1a:
	lsl.w	#4,d2
	move.w	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComUp2
	cmp.b	#":",d0
	beq.s	TestForComUp3
	cmp.b	#",",d0
	beq.s	TestForComUp4
	dbf	d1,TestForComUp1
	rts
TestForComUp2:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	lea	-$40(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	InterpretCom1
	clr.w	$5c(a6)		;Cursor Y position
	rts
TestForComUp3:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	lea	-$10(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	MemoryCom2
	clr.w	$5c(a6)		;Cursor Y position
	rts
TestForComUp4:
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	lea	-$28(a1),a0
TestForComUp5:
	move.l	a1,-(a7)
	bsr	DisassembleComFindInstr
	move.l	(a7)+,a1
	cmpa.l	a0,a1
	bhi.s	TestForComUp5
	move.l	a0,d0
	move.l	a1,d1
	btst	#31,d1
	bne.s	TestForComUp5a
	eor.l	d1,d0
	bmi.s	TestForComUp5
TestForComUp5a:
	lea	Preferences,a6
	move.l	$98(a6),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	DisassembleCom1
	clr.w	$5c(a6)		;Cursor Y position
	tst.w	$68(a6)
	beq.s	TestForComUp6
	move.w	#$0004,$68(a6)
TestForComUp6:
	rts

TestForComDown:
	moveq	#$00,d7
	move.w	$14c(a6),d1	;ScreenLastLine
	subq.w	#3,d1
TestForComDown1:
	move.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComDown1a
	sub.w	$14c(a6),d2
TestForComDown1a:
	lsl.w	#4,d2
	move.l	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComDown2
	cmp.b	#":",d0
	beq.s	TestForComDown3
	cmp.b	#",",d0
	beq.s	TestForComDown4
	dbf	d1,TestForComDown1
	rts
TestForComDown2:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	lea	$40(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	InterpretCom1
	subq.w	#1,$5c(a6)		;Cursor Y position
	rts
TestForComDown3:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	lea	$10(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)			;Cursor X position
	bsr	MemoryCom2
	subq.w	#1,$5c(a6)		;Cursor Y position
	rts
TestForComDown4:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	bsr	DisassembleComFindInstr
	sub.l	a1,a1
	clr.w	$5e(a6)			;Cursor X position
	bsr	DisassembleCom1
	subq.w	#1,$5c(a6)		;Cursor Y position
	rts

TestForComUpII:
	moveq	#$00,d7
	move.w	$14c(a6),d1		;ScreenLastLine
	subq.w	#2,d1
TestForComUpII1:
	move.w	$14c(a6),d2
	subq.w	#2,d2
	sub.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComUpII1a
	sub.w	$14c(a6),d2
TestForComUpII1a:
	lsl.w	#4,d2
	move.w	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComUpII2
	cmp.b	#":",d0
	beq.s	TestForComUpII3
	cmp.b	#",",d0
	beq	TestForComUpII4
	dbf	d1,TestForComUpII1
	bra	Loop
TestForComUpII2:
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
TestForComUpII2a:
	subq.w	#2,$5c(a6)
	sub.l	a1,a1
	lea	-$40(a0),a0
	move.l	a0,-(a7)
	bsr	InterpretCom1
	move.l	(a7)+,a0
	cmp.w	#$0001,$5c(a6)
	bne.s	TestForComUpII2a
	clr.w	$5c(a6)
	bra	Loop
TestForComUpII3:
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
TestForComUpII3a:
	subq.w	#2,$5c(a6)
	sub.l	a1,a1
	lea	-$10(a0),a0
	move.l	a0,-(a7)
	bsr	MemoryCom2
	move.l	(a7)+,a0
	cmp.w	#$0001,$5c(a6)
	bne.s	TestForComUpII3a
	clr.w	$5c(a6)
	bra	Loop
TestForComUpII4:
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_ReadNumber(a6)
	move.l	d0,a1
TestForComUpII4a:
	move.l	$76(a6),a2
	lea	-$168(a1),a0
TestForComUpII5:
	movem.l	a1/a2,-(a7)
	bsr	DisassembleComFindInstr
	movem.l	(a7)+,a1/a2
	move.l	a0,d0
	sub.l	$98(a6),d0
	move.b	d0,(a2)+
	cmpa.l	a0,a1
	bhi.s	TestForComUpII5
	move.l	a0,d0
	move.l	a1,d1
	btst	#31,d1
	bne.s	TestForComUpII5a
	eor.l	d1,d0
	bmi.s	TestForComUpII5
TestForComUpII5a:
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
TestForComUpII5b:
	subq.w	#2,$5c(a6)
	move.b	-(a2),d0
	ext.w	d0
	sub.w	d0,a0
	sub.l	a1,a1
	movem.l	a0/a2,-(a7)
	bsr	DisassembleCom1
	movem.l	(a7)+,a0/a2
	cmp.w	#$0001,$5c(a6)
	bne.s	TestForComUpII5b
	clr.w	$5c(a6)
	bra	Loop

TestForComDownII:
	moveq	#$00,d7
	move.w	$14c(a6),d1		;ScreenLastLine
	subq.w	#3,d1
TestForComDownII1:
	move.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComDownII1a
	sub.w	$14c(a6),d2
TestForComDownII1a:
	lsl.w	#4,d2
	move.l	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComDownII2
	cmp.b	#":",d0
	beq.s	TestForComDownII3
	cmp.b	#",",d0
	beq.s	TestForComDownII4
	dbf	d1,TestForComDownII1
	bra	Loop
TestForComDownII2:
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	clr.w	$5c(a6)
	clr.w	$5e(a6)
TestForComDownII2a:
	lea	$40(a0),a0
	sub.l	a1,a1
	move.l	a0,-(a7)
	bsr	InterpretCom1
	move.l	(a7)+,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	TestForComDownII2a
	bra	Loop
TestForComDownII3:
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	clr.w	$5c(a6)
	clr.w	$5e(a6)
TestForComDownII3a:
	lea	$10(a0),a0
	sub.l	a1,a1
	move.l	a0,-(a7)
	bsr	MemoryCom2
	move.l	(a7)+,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	TestForComDownII3a
	bra	Loop
TestForComDownII4:
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	bsr	DisassembleComFindInstr
	clr.w	$5c(a6)
	clr.w	$5e(a6)
TestForComDownII4a:
	sub.l	a1,a1
	bsr	DisassembleCom1
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	TestForComDownII4a
	bra	Loop

Editor:					;Source text editor
	move.l	$5c(a6),-(a7)
	move.w	$14a(a6),-(a7)
	addq.b	#1,$1a8(a6)
	move.l	a7,$1e0(a6)
	move.b	#$01,$1e5(a6)
	bsr	MakeScreenBackup
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)
	clr.w	$166(a6)
	clr.w	$16e(a6)
	move.l	$150(a6),d0
	cmp.l	$154(a6),d0
	bne.s	Editor1
	move.b	#$01,$1e4(a6)
Editor1:
	bsr	UpdateText
	bsr	UpdateLine
Editor2:
	bsr	ShowCursor
Editor3:
	jsr	_ReadKeyboard(a6)
	tst.b	d0
	beq.s	Editor3
	bsr	RemCursor
Editor3a:
	cmp.b	#$9b,d0
	beq	Editor4			;CSI
	cmp.b	#$1b,d0
	beq	EditorEscSeq
	cmp.b	#$7f,d0
	beq	Editor15		;Delete
	cmp.b	#$08,d0
	beq	Editor14		;Backspace
	cmp.b	#$0c,d0
	beq	Editor1			;Clear Screen
	cmp.b	#$0d,d0
	beq.s	Editor3b		;Return
	move.l	d0,d1
	bsr	GetFreeWorkBuf
	tst.l	d0
	beq.s	Editor2
	move.l	d1,d0
	bsr	InsCharBuffer
	bra	Editor14a		;Memory Save Label
Editor3b:				;New Line ,Line Feed
	bsr	GetFreeWorkBuf
	tst.l	d0
	beq	Editor2
	moveq	#$0a,d0
	bsr	InsCharBuffer
	bsr	InsCurrentLine
	bsr	UpdateText
	clr.w	$166(a6)
	bra	Editor6
EditorEscSeq:
	jsr	_ReadKeyboard(a6)
	tst.b	d0
	beq.s	EditorEscSeq
	cmp.b	#$5b,d0			;"["
	beq.s	Editor4
	bra	Editor3a
Editor4:
	move.l	$1c4(a6),a0
	bsr	ReadCSIPar
Editor4a:
	move.l	4(a0),d6
	cmp.b	#$01,d0		;KEYPAD & CURSOR SPECIAL
	beq	EditorNum3
	cmp.b	#$5a,d0		;CBT
	beq	Editor11
	cmp.b	#$7e,d0		;FUNCTION KEYS
	beq	Editor16
	bra	Editor2
EditorNum3:
	cmp.b	#30,d6		;NUM LOCK
	beq	Editor20
	cmp.b	#41,d6		;RIGHT MOBUT pressed
	beq	EditorMenu
	cmp.b	#44,d6		;RIGHT ALT KEY pressed
	beq	EditorKeyMenu
	cmp.b	#48,d6		;CAPS LOCK pressed
	beq	Editor20
	cmp.b	#49,d6		;CAPS LOCK released
	beq	Editor20
	cmp.b	#39,d6
	bhi.s	EditorNum5
	cmp.b	#17,d6		;SHIFT KEYPAD
	bhi.s	EditorNum4
	cmp.b	#9,d6
	bls.s	EditorNum4
	bsr	StartMarking
	sub.b	#10,d6
	bra.s	EditorNum5
EditorNum4:
	bsr	EndMarking
EditorNum5:
	cmp.b	#1,d6		;UP
	beq.s	Editor5
	cmp.b	#6,d6		;DOWN
	beq	Editor6
	cmp.b	#3,d6		;LEFT
	beq	Editor8
	cmp.b	#4,d6		;RIGHT
	beq	Editor7
	cmp.b	#2,d6		;PG UP
	beq	Editor9
	cmp.b	#7,d6		;PG DOWN
	beq	Editor10
	cmp.b	#0,d6		;HOME
	beq	Editor13
	cmp.b	#5,d6		;END
	beq	Editor12
	cmp.b	#9,d6		;DEL
	beq	Editor15
	cmp.b	#22,d6		;CTRL PG UP
	beq	Editor17
	cmp.b	#27,d6		;CTRL PG DOWN
	beq	Editor18
	bra	Editor2
Editor5:			;CRSR UP
	bsr	RememberMark
	bsr	InsCurrentLine
	tst.w	$5c(a6)
	bne.s	Editor5a
	tst.l	$158(a6)
	beq	Editor2
	jsr	_ScrollDown(a6)
	addq.w	#1,$1ba(a6)		;Rem Line Y
	bsr	GotoPrecCurLine
	move.l	$15c(a6),$170(a6)
	bsr	ContMarkingII
	tst.l	d0
	bne	Editor1
	bra.s	Editor6a
Editor5a:
	subq.w	#1,$5c(a6)
	bsr	GotoPrecCurLine
	bra	Editor13b		;Memory Save Label

Editor6:				;CRSR DOWN
	bsr	RememberMark
	bsr	InsCurrentLine
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#3,d0
	cmp.w	$5c(a6),d0
	bne.s	Editor6c
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor2
	move.l	d0,d2
	bsr	GotoNextTopLine
	jsr	_ScrollUp(a6)
	subq.w	#1,$1ba(a6)		;Rem Line Y
	bsr	ContMarkingII
	move.l	d2,d0
	bne	Editor1
Editor6a:				;Memory Save Label
	addq.b	#1,$75(a6)
Editor6b:
	tst.b	$75(a6)
	bne.s	Editor6b
	bsr	UpdateLine
	bsr	ContMarkingIII
	bsr	WriteCursorInfo
	bra	Editor2
Editor6c:
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor2
	addq.w	#1,$5c(a6)
	bra	Editor13b		;Memory Save Label

Editor7:				;CRSR RIGHT
	bsr	RememberMark
	move.w	$16c(a6),d1		;Index
	cmp.w	$164(a6),d1		;Line Length
	beq	Editor2
	move.l	$160(a6),a0		;Buffert address
	cmp.b	#$0a,0(a0,d1.w)
	beq	Editor2
	addq.w	#1,$16c(a6)		;Next Index
	bra	Editor13a

Editor8:				;CRSR LEFT
	bsr	RememberMark
	tst.w	$16c(a6)		;Index
	beq	Editor2
	subq.w	#1,$16c(a6)		;Prec Index
	bra	Editor13a

Editor9:				;Page Up
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
	move.w	$14c(a6),d2		;ScreenLastLine
	subq.w	#3,d2
Editor9a:
	move.l	$150(a6),a0		;Text Start Addr
	cmp.l	$170(a6),a0		;Top TextLine Addr
	beq	Editor1
	bsr	GotoPrecTopLine
	bsr	GotoPrecCurLine
	bsr	ContMarkingII
	dbf	d2,Editor9a
	bra	Editor1

Editor10:				;Page Down
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
	move.w	$14c(a6),d2		;ScreenLastLine
	subq.w	#3,d2
Editor10a:
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor1
	bsr	GotoNextTopLine
	bsr	ContMarkingII
	dbf	d2,Editor10a
	bra	Editor1

Editor11:				;Backward Tab
	bsr	EndMarking
	move.w	$166(a6),d0
	beq	Editor2
	subq.w	#1,d0
	and.w	#$fff8,d0
	move.w	d0,d1
Editor11a:
	subq.w	#1,$16c(a6)
	bsr	CalColumnNr
	cmp.w	$166(a6),d1
	bne.s	Editor11a
	bra.s	Editor13a		;Memory Save Label

Editor12:				;END
	bsr	RememberMark
	move.w	$164(a6),d0
	beq	Editor2
	move.l	$160(a6),a0		;Line Buffer Addr
	cmp.b	#$0a,-1(a0,d0.w)
	bne.s	Editor12a
	subq.w	#1,d0
Editor12a:
	move.w	d0,$16c(a6)
	bra.s	Editor13a

Editor13:				;HOME
	bsr	RememberMark
	clr.w	$16c(a6)
Editor13a:				;Memory Save Label
	bsr	CalColumnNr
	bsr	CalCursorX
Editor13b:				;Memory Save Label
	bsr	ContMarking
	tst.l	d0
	bne	Editor1
	bsr	WriteCursorInfo
	bra	Editor2

Editor14:				;Backspace
	bsr	EndMarking
	tst.w	$16c(a6)		;Index
	beq.s	Editor14b		;First Column
	subq.w	#1,$16c(a6)		;Prec Index
	bsr	RemCharBuffer
Editor14a:				;Memory Save Label
	bsr	CalColumnNr
	bsr	CalCursorX
	tst.l	d0
	bne	Editor1
	bsr	UpdateLine
	bsr	WriteCursorInfo
	bra	Editor2
Editor14b:
	tst.l	$158(a6)
	beq	Editor2
	tst.w	$5c(a6)
	bne.s	Editor14c
	bsr	GotoPrecTopLine
Editor14c:
	subq.l	#1,$15c(a6)	;Textbuffer adress
	addq.w	#1,$168(a6)	;Old linelength
	move.w	#$1234,$16a(a6)	;Buffer changes
	move.l	$15c(a6),d2
	bsr	InsCurrentLine
	bsr	GotoPrecCurLineII
	sub.l	$15c(a6),d2
	move.w	d2,$16c(a6)
	bsr	CalColumnNr
	bsr	CalCursorX
	bra	Editor1

Editor15:				;Delete
	bsr	EndMarking
	move.w	$16c(a6),d1		;Index
	cmp.w	$164(a6),d1		;Line Length
	beq	Editor2			;EOL not deleted
	move.l	$160(a6),a0		;Buffert address
	cmp.b	#$0a,0(a0,d1.w)
	beq	Editor2			;EOL not deleted
	bsr	RemCharBuffer
	bsr	UpdateLine
	bsr	WriteCursorInfo
	bra	Editor2

Editor16:				;Function Keys
	cmp.b	#0,d6			;F1
	beq	EditorQuit
	cmp.b	#1,d6			;F2
	beq.s	Editor19
	bra	Editor2

Editor17:				;CTRL Page Up
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
Editor17a:
	move.l	$150(a6),a0		;Text Start Addr
	cmp.l	$170(a6),a0		;Top TextLine Addr
	beq	Editor1
	bsr	GotoPrecTopLine
	bsr	GotoPrecCurLine
	bra.s	Editor17a

Editor18:				;CTRL Page Down
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
Editor18a:
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor1
	bsr	GotoNextTopLine
	bra.s	Editor18a

Editor19:				;F2 (Copy to buffert)
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
	cmp.w	#$0001,$1b2(a6)
	bne.s	Editor19a
	bsr	CopyToCutBuffer
	bsr	EndMarking
Editor19a:
	bra	Editor1	

Editor20:				;Num Lock
	bsr	WriteCursorInfo
	bra	Editor2

EditorQuit:
	bsr	InsCurrentLine
	bsr	MakeScreenBackup
	move.l	$1e0(a6),a7
	clr.b	$1e5(a6)
	move.w	(a7)+,$14a(a6)
	bsr	RestoreScreen
	move.l	(a7)+,$5c(a6)
	bsr	CalcYAddr
	clr.b	$1a8(a6)		;No infoline
	bra	Loop

ReadCSIPar:				;Reads parameter to the Command
					;sequence.
					;A0=Parlist , D0out=End Char
	movem.l	d1-d4,-(a7)
	moveq	#$00,d2			;String index
ReadCSIPar1:
	moveq	#$00,d1			;Parameter
	moveq	#$00,d3
	moveq	#$00,d4			;Nr of pars
ReadCSIPar2:
	jsr	_ReadKeyboard(a6)
	tst.b	d0
	beq.s	ReadCSIPar2
	cmp.b	#$39,d0
	bhi.s	ReadCSIPar3
	cmp.b	#$2f,d0
	bls.s	ReadCSIPar3
	moveq	#$01,d3
	and.w	#$000f,d0
	mulu	#10,d1
	add.w	d0,d1
	bra.s	ReadCSIPar2
ReadCSIPar3:
	add.w	d3,d4
	move.l	d1,4(a0,d2.w)
	addq.w	#4,d2
	cmp.b	#';',d0
	beq.s	ReadCSIPar1
	move.l	d4,(a0)			;Nr of Parameters
	movem.l	(a7)+,d1-d4
	rts

EditorKeyMenu:
	bsr	ReadMousePosition
	move.l	d0,-(a7)
	move.l	#$00010000,d0
	bsr	WriteMousePosition
	bra	EditorMenu1
EditorMenu:
	bsr	ReadMousePosition
	move.l	d0,-(a7)
EditorMenu1:
	lea	EditorMenuHeadInfo(pc),a0
	bsr	MenuSystem
	tst.l	d0
	beq	EditorMenu2
EdMe1:	lea	EdMe1(pc),a0
	add.l	d0,a0
	bsr	InsCurrentLine
	bsr	RememberMarked
	jsr	(a0)
	bsr	RestoreScreen
	bsr	RestoreAllMarked
EditorMenu2:
	move.l	(a7)+,d0
	bsr	WriteMousePosition
	bra	Editor2

EditorMenuHeadInfo:
	dc.l	EditorMenuHeadText1		;0
	dc.l	EditorMenuHead1			;4
	dc.l	EditorMenuHead2			;8
	dc.l	EditorMenuHeadKeys		;C
EditorMenuHeadText1:
	dc.b	"FILE       EDIT       SEARCH     RUN    "
	dc.b	"     DEBUG      UTILITY             HELP",0
	even
EditorMenuHead1:
	dc.b	0,11,22,33,45,56,68,80
	even
EditorMenuHeadKeys:
	dc.b	'F',02,00,'E',13,00,'S',24,00,'R',35,00
	dc.b	'D',47,00,'U',58,00,'H',76,00,00
	even
EditorMenuHead2:
	dc.l	EditorMenuInfo1
	dc.l	EditorMenuText1
	dc.l	EditorMenuKeys1
	dc.l	EditorMenuInfo2
	dc.l	EditorMenuText2
	dc.l	EditorMenuKeys2
	dc.l	EditorMenuInfo3
	dc.l	EditorMenuText3
	dc.l	EditorMenuKeys3
	dc.l	EditorMenuInfo4
	dc.l	EditorMenuText4
	dc.l	EditorMenuKeys4
	dc.l	EditorMenuInfo5
	dc.l	EditorMenuText5
	dc.l	EditorMenuKeys5
	dc.l	EditorMenuInfo6
	dc.l	EditorMenuText6
	dc.l	EditorMenuKeys6
	dc.l	EditorMenuInfo7
	dc.l	EditorMenuText7
	dc.l	EditorMenuKeys7
*************************************************************************
*	dc.b	x1,y1,x2,y2		;box coords			*
*	dc.b	"text",0		;text				*
* or	dc.b	255			;for line +---+			*
*	dc.b	0			;end				*
*************************************************************************
EditorMenuText1:
	dc.b	0,1,12,12
	dc.b	"New",0
	dc.b	"Open file",0
	dc.b	"Merge file",0
	dc.b	"Save",0
	dc.b	"Save as",0
	dc.b	"Delete",0
	dc.b	255
	dc.b	"Print",0
	dc.b	255
	dc.b	"Exit",0
	dc.b	0

EditorMenuKeys1:
	dc.b	'N',01,02,'O',01,03,'M',01,04,'S',01,05
	dc.b	'A',01,06,'D',01,07,'P',01,09,'E',01,11,00

EditorMenuText2:
	dc.b	11,1,25,11
	dc.b	"Undo",0
	dc.b	"Redo",0
	dc.b	255
	dc.b	"Cut",0
	dc.b	"Copy",0
	dc.b	"Paste",0
	dc.b	"Clear",0
	dc.b	255
	dc.b	"Clear Buffer",0
	dc.b	0

EditorMenuKeys2:
	dc.b	'U',12,02,'R',12,03,'C',12,05,'O',12,06
	dc.b	'P',12,07,'L',12,08,'B',12,10,00

EditorMenuText3:
	dc.b	22,1,40,5
	dc.b	"Find",0
	dc.b	"Repeat last find",0
	dc.b	"Change",0
	dc.b	0

EditorMenuKeys3:
	dc.b	'F',23,02,'R',23,03,'C',23,03,00

EditorMenuText4:
	dc.b	33,1,48,9
	dc.b	"Start",0
	dc.b	"Restart",0
	dc.b	"Continue",0
	dc.b	255
	dc.b	"Compile only",0
	dc.b	255
	dc.b	"Make exe-file",0
	dc.b	0

EditorMenuKeys4:
	dc.b	'S',34,02,'R',34,03,'C',34,04,'O',34,06
	dc.b	'M',34,08,00

EditorMenuText5:
	dc.b	45,1,68,7
	dc.b	"Add breakpoint",0
	dc.b	"Delete breakpoint",0
	dc.b	"Show breakpoint",0
	dc.b	255
	dc.b	"Clear all breakpoints",0
	dc.b	0

EditorMenuKeys5:
	dc.b	'A',46,02,'D',46,03,'S',46,04,'C',46,06,00

EditorMenuText6:
	dc.b	56,1,72,6
	dc.b	"Calculator",0
	dc.b	"Date & Time",0
	dc.b	255
	dc.b	"Print Errors",0
	dc.b	0

EditorMenuKeys6:
	dc.b	'C',57,02,'D',57,03,'P',57,05,00

EditorMenuText7:
	dc.b	68,1,79,2
	dc.b	0

EditorMenuKeys7:
	dc.b	00
	even

EditorMenuInfo1:
	dc.l	EditorNew-EdMe1		;New
	dc.l	EditorOpen-EdMe1	;Open file
	dc.l	EditorMerge-EdMe1	;Merge file
	dc.l	EditorSave-EdMe1	;Save
	dc.l	EditorSaveAs-EdMe1	;Save as
	dc.l	EditorDelete-EdMe1	;Delete
	dc.l	-1			;--------
	dc.l	EditorPrint-EdMe1	;Print
	dc.l	-1			;--------
	dc.l	EditorExit-EdMe1	;Exit

EditorMenuInfo2:
	dc.l	0			;Undo
	dc.l	0			;Redo
	dc.l	-1			;--------
	dc.l	EditorCut-EdMe1		;Cut
	dc.l	EditorCopy-EdMe1	;Copy
	dc.l	EditorPaste-EdMe1	;Paste
	dc.l	EditorClear-EdMe1	;Clear
	dc.l	-1			;--------
	dc.l	EditorClearBuf-EdMe1	;Clear Buffer

EditorMenuInfo3:
	dc.l	EditorFind-EdMe1	;Find
	dc.l	EditorRepeat-EdMe1	;Repeat last find
	dc.l	EditorChange-EdMe1	;Change

EditorMenuInfo4:
	dc.l	0			;Start
	dc.l	0			;Restart
	dc.l	0			;Continue
	dc.l	-1			;--------
	dc.l	EditorCompile-EdMe1	;Compile only
	dc.l	-1			;--------
	dc.l	EditorMake-EdMe1	;Make exe-file

EditorMenuInfo5:
	dc.l	0			;Add breakpoint
	dc.l	0			;Delete breakpoint
	dc.l	0			;Show breakpoints
	dc.l	-1			;--------
	dc.l	0			;Clear all breakpoints

EditorMenuInfo6:
	dc.l	EditorCalculator-EdMe1	;Calculator
	dc.l	EditorDate-EdMe1	;Date & Time
	dc.l	-1			;--------
	dc.l	0			;Print Errors

EditorMenuInfo7:
	dc.l	0			;Help

WindowSaveAs:
	dc.b	43,9
	dc.l	WindowSaveAs1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowSaveAs1:
	dc.b	1			;Input Line
	dc.b	15,1,40,3		;Box
	dc.b	4,2,"Save file :",0
WindowSaveAs2:
	dc.b	2			;Yes Gadget (Return)
	dc.b	2,4,8,6			;Box
	dc.b	4,5,"Yes",0
WindowSaveAs3:
	dc.b	3			;Gadget (Space)
	dc.b	16,4,21,6		;Box
	dc.b	18,5,"No",0
WindowSaveAs4:
	dc.b	4			;Cancel Gadget (Esc)
	dc.b	28,4,37,6		;Box
	dc.b	30,5,"Cancel",0
	even

WindowOpen:
	dc.b	43,9
	dc.l	WindowOpen1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowOpen1:
	dc.b	1			;Input Line
	dc.b	15,1,40,3
	dc.b	4,2,"Open file :",0
	even

WindowMerge:
	dc.b	43,9
	dc.l	WindowMerge1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowMerge1:
	dc.b	1			;Input Line
	dc.b	15,1,40,3
	dc.b	3,2,"Merge file :",0
	even

WindowDelete:
	dc.b	43,9
	dc.l	WindowDelete1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowDelete1:
	dc.b	1			;Input Line
	dc.b	15,1,40,3
	dc.b	2,2,"Delete file :",0
	even

WindowPrint:
	dc.b	29,12
	dc.l	WindowPrint1
	dc.l	WindowPrint2
	dc.l	WindowPrint3
	dc.l	WindowPrint4
	dc.l	WindowPrint5
	dc.l	0
	dc.b	0
WindowPrint1:
	dc.b	5			;Choice gadget (X) (Space)
	dc.b	4,2			;Coords of X
	dc.b	2,3,0			;Unchoosed gadgets
	dc.b	3,2,"( )  Print document",0
WindowPrint2:
	dc.b	5			;Choice gadget
	dc.b	4,4			;Coords
	dc.b	1,3,0			;Unchoosed
	dc.b	3,4,"( )  Print marked text",0
WindowPrint3:
	dc.b	5			;Choice gadget
	dc.b	4,6			;Coords
	dc.b	1,2,0			;Unchoosed
	dc.b	3,6,"( )  Print directory",0
WindowPrint4:
	dc.b	2			;Yes Gadget
	dc.b	3,8,8,10		;Box
	dc.b	5,9,"Ok",0
WindowPrint5:
	dc.b	4			;Cancel Gadget
	dc.b	14,8,23,10		;Box
	dc.b	16,9,"Cancel",0
	even

WindowFind:
	dc.b	46,13
	dc.l	WindowFind1
	dc.l	WindowFind2
	dc.l	WindowFind3
	dc.l	WindowFind4
	dc.l	WindowFind5
	dc.l	0
	dc.b	0
WindowFind1:
	dc.b	1
	dc.b	14,1,43,3
	dc.b	2,2,"Find What :",0
WindowFind2:
	dc.b	5
	dc.b	3,5
	dc.b	0
	dc.b	2,5,"( ) Whole word",0
WindowFind3:
	dc.b	5
	dc.b	3,7
	dc.b	0
	dc.b	2,7,"( ) Match upper/lower case",0
WindowFind4:
	dc.b	2
	dc.b	2,9,7,11
	dc.b	4,10,"Ok",0
WindowFind5:
	dc.b	4
	dc.b	27,9,36,11
	dc.b	29,10,"Cancel",0
	even

WindowChange:
	dc.b	46,17
	dc.l	WindowFind1
	dc.l	WindowChange2
	dc.l	WindowChange3
	dc.l	WindowChange4
	dc.l	WindowChange5
	dc.l	WindowChange6
	dc.l	WindowChange7
	dc.l	0
	dc.b	0
WindowChange2:
	dc.b	1
	dc.b	14,4,43,6
	dc.b	2,5,"Change to :",0
WindowChange3:
	dc.b	5
	dc.b	3,9
	dc.b	0
	dc.b	2,9,"( ) Whole word",0
WindowChange4:
	dc.b	5
	dc.b	3,11
	dc.b	0
	dc.b	2,11,"( ) Match upper/lower case",0
WindowChange5:
	dc.b	2
	dc.b	2,13,20,15
	dc.b	4,14,"Find and verify",0
WindowChange6:
	dc.b	3
	dc.b	21,13,34,15
	dc.b	23,14,"Change all",0
WindowChange7:
	dc.b	4
	dc.b	35,13,44,15
	dc.b	37,14,"Cancel",0
	even

WindowCompile:
	dc.b	53,18
	dc.l	WindowCompile1
	dc.l	WindowCompile2
	dc.l	WindowCompile3
	dc.l	WindowCompile4
	dc.l	WindowCompile5
	dc.l	WindowCompile6
	dc.l	WindowCompile7
	dc.l	WindowCompile8
	dc.l	0
	dc.b	4,5,"Compiling options",0
	dc.b	34,5,"Output options",0
	dc.b	8,10,"compiling",0
	dc.b	0
WindowCompile1:
	dc.b	1
	dc.b	25,1,50,3
	dc.b	4,2,"Compiling document :",0
WindowCompile2:
	dc.b	5
	dc.b	5,7
	dc.b	0
	dc.b	4,7,"( ) Check error",0
WindowCompile3:
	dc.b	5
	dc.b	5,8
	dc.b	0
	dc.b	4,8,"( ) Mark errors",0
WindowCompile4:
	dc.b	5
	dc.b	5,9
	dc.b	0
	dc.b	4,9,"( ) Save document before",0
WindowCompile5:
	dc.b	5
	dc.b	35,7
	dc.b	6,0
	dc.b	34,7,"( ) Memory",0
WindowCompile6:
	dc.b	5
	dc.b	35,8
	dc.b	5,0
	dc.b	34,8,"( ) Exefile",0
WindowCompile7:
	dc.b	2
	dc.b	2,13,22,15
	dc.b	4,14,"Start compilation",0
WindowCompile8:
	dc.b	4
	dc.b	30,13,39,15
	dc.b	32,14,"Cancel",0
	even

WindowMake:
	dc.b	43,9
	dc.l	WindowMake1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowMake1:
	dc.b	1			;Input Line
	dc.b	17,1,40,3
	dc.b	2,2,"Make exe-file :",0
	even

WindowCalculator:
	dc.b	47,11
	dc.l	WindowCalculator1
	dc.l	WindowCalculator2
	dc.l	WindowCalculator3
	dc.l	WindowCalculator4
	dc.l	WindowCalculator5
	dc.l	WindowCalculator6
	dc.l	WindowCalculator7
	dc.l	0
	dc.b	0
WindowCalculator1:
	dc.b	1
	dc.b	2,4,44,6
	dc.b	2,2,"Calculator",0
WindowCalculator2:
	dc.b	5
	dc.b	16,1
	dc.b	3,4,0
	dc.b	15,1,"( ) Decimal",0
WindowCalculator3:
	dc.b	5
	dc.b	16,2
	dc.b	2,4,0
	dc.b	15,2,"( ) Hexadecimal",0
WindowCalculator4:
	dc.b	5
	dc.b	16,3
	dc.b	2,3,0
	dc.b	15,3,"( ) Binary",0
WindowCalculator5:
	dc.b	2
	dc.b	35,1,40,3
	dc.b	37,2,"Ok",0
WindowCalculator6:
	dc.b	3
	dc.b	3,7,22,9
	dc.b	5,8,"Send to document",0
WindowCalculator7:
	dc.b	4
	dc.b	28,7,35,9
	dc.b	30,8,"Exit",0
	even

WindowDate:
	dc.b	31,14
	dc.l	WindowDate1
	dc.l	WindowDate2
	dc.l	WindowDate3
	dc.l	WindowDate4
	dc.l	WindowDate5
	dc.l	0
	dc.b	4,11,"time",0
	dc.b	15,11,"date",0
	dc.b	0
WindowDate1:
	dc.b	1
	dc.b	16,1,27,3
	dc.b	2,2,"Current time",0
WindowDate2:
	dc.b	1
	dc.b	16,5,27,7
	dc.b	2,6,"Current date",0
WindowDate3:
	dc.b	3
	dc.b	2,9,9,12
	dc.b	4,10,"Send",0
WindowDate4:
	dc.b	3
	dc.b	13,9,20,12
	dc.b	15,10,"Send",0
WindowDate5:
	dc.b	2
	dc.b	22,9,27,12
	dc.b	24,10,"Ok",0
	even

EditorNew:
	tst.b	$1e4(a6)
	bne	EditorNew3
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_CopyString(a6)
EditorNew1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorNew4
	beq	EditorNew2
	cmp.b	#$02,d0
	beq	EditorNew2
	cmp.b	#$03,d0
	beq	EditorNew3
	cmp.b	#$04,d0
	beq	EditorNew4
	bra	EditorNew4
EditorNew2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorNew1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorNew3:				;No
	move.l	$19c(a6),a0
	clr.b	(a0)
	move.l	$150(a6),a0
	move.l	a0,$154(a6)
	move.l	a0,$186(a6)
	clr.l	$158(a6)
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)
	clr.w	$166(a6)
	clr.w	$16e(a6)
	bsr	UpdateText
	bsr	UpdateLine
	bsr	EndMarking
	move.b	#$01,$1e4(a6)		;Text is unchanged
EditorNew4:				;Cancel
	rts

EditorOpen:
	tst.b	$1e4(a6)
	bne	EditorOpen3
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_CopyString(a6)
EditorOpen1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorOpen7
	beq	EditorOpen2
	cmp.b	#$02,d0
	beq	EditorOpen2
	cmp.b	#$03,d0
	beq	EditorOpen3
	cmp.b	#$04,d0
	beq	EditorOpen7
	bra	EditorOpen7
EditorOpen2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorOpen1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorOpen3:
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_CopyString(a6)
	lea	WindowOpen(pc),a0
	bsr	OpenWindow
EditorOpen4:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorOpen7
	beq	EditorOpen5
	cmp.b	#$02,d0
	beq	EditorOpen5
	cmp.b	#$03,d0
	beq	EditorOpen6
	cmp.b	#$04,d0
	beq	EditorOpen7
	bra	EditorOpen7
EditorOpen5:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorOpen4
	move.l	$150(a6),a1
	move.l	$182(a6),a2
	bsr	LoadFile
	move.l	d0,$154(a6)		;Text End
	move.l	d0,$186(a6)		;Cut End
	clr.l	$158(a6)		;Textline nr
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)
	clr.w	$166(a6)
	clr.w	$16e(a6)
	bsr	UpdateText
	bsr	UpdateLine
	bsr	EndMarking
	move.b	#$01,$1e4(a6)		;Text is unchanged
EditorOpen6:				;No
	move.l	$076(a6),a0
	move.l	$19c(a6),a1
	jsr	_CopyString(a6)
EditorOpen7:				;Cancel
	rts

EditorMerge:
	lea	WindowMerge(pc),a0
	bsr	OpenWindow
	move.l	$076(a6),a0
	clr.b	(a0)
EditorMerge1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorMerge3
	beq	EditorMerge2
	cmp.b	#$02,d0
	beq	EditorMerge2
	cmp.b	#$03,d0
	beq	EditorMerge3
	cmp.b	#$04,d0
	beq	EditorMerge3
	bra	EditorMerge3
EditorMerge2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorMerge1
	move.l	$154(a6),a1
	move.l	$182(a6),a2
	bsr	LoadFile
	move.l	d0,$154(a6)		;Text End
	move.l	d0,$186(a6)		;Cut End
	bsr	LoadCurrentBuffer
	bsr	UpdateText
	bsr	UpdateLine
	clr.b	$1e4(a6)		;Text not saved
EditorMerge3:				;Cancel
	rts

EditorSave:
	move.l	$19c(a6),a0
	tst.b	(a0)
	beq	EditorSaveAs
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
	rts

EditorSaveAs:
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_CopyString(a6)
EditorSaveAs1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorSaveAs4
	beq	EditorSaveAs2
	cmp.b	#$02,d0
	beq	EditorSaveAs2
	cmp.b	#$03,d0
	beq	EditorSaveAs3
	cmp.b	#$04,d0
	beq	EditorSaveAs4
	bra	EditorSaveAs4
EditorSaveAs2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorSaveAs1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorSaveAs3:				;No
	move.l	$076(a6),a0
	move.l	$19c(a6),a1
	jsr	_CopyString(a6)
EditorSaveAs4:				;Cancel
	rts

EditorDelete:
	move.l	$076(a6),a0
	clr.b	(a0)
	lea	WindowDelete(pc),a0
	bsr	OpenWindow
EditorDelete1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorDelete3
	beq	EditorDelete2
	cmp.b	#$02,d0
	beq	EditorDelete2
	cmp.b	#$03,d0
	beq	EditorDelete3
	cmp.b	#$04,d0
	beq	EditorDelete3
	bra	EditorDelete3
EditorDelete2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorDelete1
	bsr	DeleteFile
EditorDelete3:				;Cancel
	rts

EditorPrint:
	lea	WindowPrint(pc),a0
	bsr	OpenWindow
	link	a5,#-20
	move.l	a7,a0
	clr.l	(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	bsr	UpdateWindow
	moveq	#$04,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorExit:
	tst.b	$1e4(a6)
	bne	EditorExit3
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_CopyString(a6)
EditorExit1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorExit4
	beq	EditorExit2
	cmp.b	#$02,d0
	beq	EditorExit2
	cmp.b	#$03,d0
	beq	EditorExit3
	cmp.b	#$04,d0
	beq	EditorExit4
	bra	EditorExit4
EditorExit2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorExit1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorExit3:				;No
	bsr	MakeScreenBackup
	move.l	$1e0(a6),a7
	clr.b	$1e5(a6)		;Editor non-active
	move.w	(a7)+,$14a(a6)
	bsr	RestoreScreen
	move.l	(a7)+,$5c(a6)
	bsr	CalcYAddr
	clr.b	$1a8(a6)		;No infoline
	bra	Loop
EditorExit4:				;Cancel
	rts

EditorCut:
	bsr	GetMarkedAddr
	tst.l	d0
	bmi	EditorCut1
	bsr	GotoAbsolute
	bsr	CopyToCutBuffer
	bsr	DeleteMarked
	bsr	LoadCurrentBuffer
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorCut1:
	rts

EditorCopy:
	bsr	GetMarkedAddr
	tst.l	d0
	bmi	EditorCopy1
	bsr	CopyToCutBuffer
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorCopy1:
	rts

EditorPaste:
	move.l	$186(a6),a0
	cmp.l	$154(a6),a0
	beq	EditorPaste1		;Nothing in buffer
	bsr	PasteBuffer
	move.l	$15c(a6),a0
	add.w	$16c(a6),a0
	add.l	$186(a6),a0
	sub.l	$154(a6),a0
	bsr	GotoAbsolute
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorPaste1:
	rts

EditorClear:
	bsr	GetMarkedAddr
	tst.l	d0
	bmi	EditorClear1
	bsr	GotoAbsolute
	bsr	DeleteMarked
	bsr	LoadCurrentBuffer
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorClear1:
	rts

EditorClearBuf:
	move.l	$154(a6),$186(a6)
	bsr	WriteCursorInfo
	rts

EditorFind:
	move.l	$1ea(a6),a0
	move.l	$076(a6),a1
	jsr	_CopyString(a6)
	lea	WindowFind(pc),a0
	bsr	OpenWindow
EditorFind1:
	link	a5,#-20
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	bsr	UpdateWindow
	moveq	#$01,d0
	bsr	EditWindow
	move.l	4(a0),d1
	move.l	8(a0),d2
	and.l	#$1,d1
	and.l	#$2,d2
	or.l	d2,d1
	unlk	a5
	tst.l	d0
	bmi	EditorFind4
	beq	EditorFind2
	cmp.b	#$04,d0
	beq	EditorFind2
	cmp.b	#$05,d0
	beq	EditorFind4
	bra	EditorFind4
EditorFind2:
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorFind1
	move.l	$076(a6),a0
	move.l	$1ea(a6),a1
	jsr	_CopyString(a6)
	move.l	$150(a6),$1e6(a6)
	move.l	$1ea(a6),a0
	move.l	d1,d0
	move.w	d0,$1ee(a6)
	bsr	SearchText
	cmp.l	#$ffffffff,d0
	beq	EditorFind4
	move.l	d0,$1aa(a6)
	addq.l	#1,a0
EditorFind3:
	addq.l	#1,d0
	tst.b	(a0)+
	bne	EditorFind3
	move.l	d0,$1ae(a6)
	move.w	#$0001,$1b2(a6)
	move.l	$1aa(a6),a0
	bsr	GotoAbsolute
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorFind4:
	rts

EditorRepeat:
	move.l	$1ea(a6),a0
	moveq	#$00,d0
	move.w	$1ee(a6),d0
	bsr	SearchText
	cmp.l	#$ffffffff,d0
	beq	EditorRepeat2
	move.l	d0,$1aa(a6)
	addq.l	#1,a0
EditorRepeat1:
	addq.l	#1,d0
	tst.b	(a0)+
	bne	EditorRepeat1
	move.l	d0,$1ae(a6)
	move.w	#$0001,$1b2(a6)
	move.l	$1aa(a6),a0
	bsr	GotoAbsolute
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorRepeat2:
	rts

EditorChange:
	lea	WindowChange(pc),a0
	bsr	OpenWindow
	link	a5,#-28
	move.l	a7,a0
	move.l	$076(a6),(a0)
	move.l	$076(a6),4(a0)
	add.l	#80,4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	clr.l	20(a0)
	clr.l	24(a0)
	bsr	UpdateWindow
	moveq	#$05,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorCompile:
	lea	WindowCompile(pc),a0
	bsr	OpenWindow
	link	a5,#-32
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	clr.l	20(a0)
	clr.l	24(a0)
	clr.l	28(a0)
	bsr	UpdateWindow
	moveq	#$07,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorMake:
	lea	WindowMake(pc),a0
	bsr	OpenWindow
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorCalculator:
	lea	WindowCalculator(pc),a0
	bsr	OpenWindow
	link	a5,#-28
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	clr.l	20(a0)
	clr.l	24(a0)
	bsr	UpdateWindow
	moveq	#$01,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorDate:
	lea	WindowDate(pc),a0
	bsr	OpenWindow
	link	a5,#-20
	move.l	a7,a0
	move.l	$076(a6),(a0)
	move.l	$076(a6),4(a0)
	add.l	#80,4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	bsr	UpdateWindow
	moveq	#$05,d0
	bsr	EditWindow
	unlk	a5
	rts

*****************************************************************************
	INCLUDE MenuSystem
*****************************************************************************

*****************************************************************************
	INCLUDE WindowSystem
*****************************************************************************

GotoAbsolute:				;Goes to specific adress in text
					;A0=Address
	movem.l	d0-d1/a0-a1,-(a7)
	bsr	LoadCurrentBuffer
GotoAbsolute1:
	cmp.l	$15c(a6),a0
	bhi	GotoAbsolute2
	beq	GotoAbsolute2
	bsr	GotoPrecCurLine
	subq.w	#1,$5c(a6)
	bpl	GotoAbsolute1
	clr.w	$5c(a6)
	move.l	$15c(a6),$170(a6)
	bra	GotoAbsolute1
GotoAbsolute2:
	move.l	$15c(a6),a1
	add.w	$164(a6),a1
	cmp.l	a0,a1
	bhi	GotoAbsolute3
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	GotoAbsolute3
	addq.w	#1,$5c(a6)
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bhi	GotoAbsolute2
	subq.w	#1,$5c(a6)
	bsr	GotoNextTopLine
	bra	GotoAbsolute2
GotoAbsolute3:
	move.l	a0,d1
	sub.l	$15c(a6),d1
	move.w	d1,$16c(a6)
	bsr	CalColumnNr
	bsr	CalCursorX
	movem.l	(a7)+,d0-d1/a0-a1
	rts

InsCharBuffer:
	movem.l	d1-d2/a0,-(a7)
	move.l	$160(a6),a0		;Line Buffer Addr
	move.w	$164(a6),d1		;Line Length
	move.w	$16c(a6),d2		;Line Index
InsCharBuffer1:
	cmp.w	d1,d2
	beq.s	InsCharBuffer2
	subq.w	#1,d1
	move.b	0(a0,d1.w),1(a0,d1.w)
	bra.s	InsCharBuffer1
InsCharBuffer2:
	move.b	d0,0(a0,d2.w)
	addq.w	#1,d2
	move.w	d2,$16c(a6)
	addq.w	#1,$164(a6)
	addq.w	#1,$166(a6)		;Column
	move.w	#$1234,$16a(a6)		;Buffer Changed
	clr.b	$1e4(a6)		;Text not saved
	movem.l	(a7)+,d1-d2/a0
	rts

RemCharBuffer:
	movem.l	d1-d2/a0,-(a7)
	move.l	$160(a6),a0		;Line Buffer Addr
	move.w	$164(a6),d2		;Line Length
	move.w	$16c(a6),d1		;Line Index
RemCharBuffer1:
	cmp.w	d1,d2
	beq.s	RemCharBuffer2
	move.b	1(a0,d1.w),0(a0,d1.w)
	addq.w	#1,d1
	bra.s	RemCharBuffer1
RemCharBuffer2:
	subq.w	#1,$164(a6)
	move.w	#$1234,$16a(a6)		;Buffer Changed
	clr.b	$1e4(a6)		;Text not saved
	movem.l	(a7)+,d1-d2/a0
	rts

PasteBuffer:
	movem.l	d1/a0-a2,-(a7)
	bsr	InsCurrentLine
	move.l	$15c(a6),a0
	add.w	$16c(a6),a0
	move.l	$186(a6),a1
	move.l	a1,d1
	sub.l	$154(a6),d1
	move.l	a0,a2
	add.l	d1,a2
	add.l	d1,$154(a6)
	add.l	d1,$186(a6)
	bsr	CopyMemory
	move.l	$154(a6),a0
	move.l	$186(a6),a1
	move.l	$15c(a6),a2
	add.w	$16c(a6),a2
	bsr	CopyMemory
	movem.l	(a7)+,d1/a0-a2
	rts

GetMarkedAddr:
					;Out-A0=Begin,A1=End,D0=Active
	moveq	#$ffffffff,d0
	cmp.w	#$0001,$1b2(a6)
	bne	GetMarkedAddr2
	move.l	$1aa(a6),a0
	move.l	$1ae(a6),a1
	cmp.l	a0,a1
	beq	GetMarkedAddr2
	bhi	GetMarkedAddr1
	exg	a0,a1
GetMarkedAddr1:
	moveq	#$00,d0
GetMarkedAddr2:
	rts

DeleteMarked:
	movem.l	d1/a0-a2,-(a7)
	bsr	InsCurrentLine
	move.l	$1aa(a6),a0
	move.l	$1ae(a6),a1
	cmp.l	a0,a1
	bhi	DeleteMarked1
	exg	a0,a1
DeleteMarked1:
	move.l	a1,d1
	sub.l	a0,d1
	move.l	a0,a2
	move.l	a1,a0
	move.l	$186(a6),a1
	sub.l	d1,$186(a6)
	sub.l	d1,$154(a6)
	bsr	CopyMemory
	movem.l	(a7)+,d1/a0-a2
	rts

CopyToCutBuffer:			;Copies marked to buffer
	movem.l	d1-d3/a0-a2,-(a7)
	bsr	InsCurrentLine
	move.l	$1aa(a6),a0
	move.l	$1ae(a6),a1
	cmp.l	a0,a1
	bhi	CopyToCutBuffer1
	exg	a0,a1
CopyToCutBuffer1:
	move.l	$154(a6),a2		;Text End
	move.l	a1,d1
	sub.l	a0,d1
	add.l	a2,d1
	move.l	d1,$186(a6)		;New Cut End
	tst.l	d1
	beq	CopyToCutBuffer2
	bsr	CopyMemory
CopyToCutBuffer2:
	movem.l	(a7)+,d1-d3/a0-a2
	rts

InsCurrentLine:				;Inserts buffer into text
	movem.l	d1-d3/a0-a2,-(a7)
	cmp.w	#$1234,$16a(a6)
	bne	InsCurrentLine3
	move.w	$168(a6),d1		;Buffer old length
	move.w	$164(a6),d2		;Buffer length
	cmp.w	d1,d2
	beq	InsCurrentLine1		;No Transfer
	move.l	$15c(a6),a0		;TextLine Addr
	move.l	$186(a6),a1		;Cut End
	move.l	a0,a2
	add.w	d1,a0
	add.w	d2,a2	
	move.w	d2,d3
	sub.w	d1,d3
	ext.l	d3
	add.l	d3,$154(a6)		;New Text End
	add.l	d3,$186(a6)		;New Cut End
	bsr	CopyMemory
InsCurrentLine1:
	move.l	$15c(a6),a0
	move.l	$160(a6),a1
	move.w	$164(a6),d2		;Buffer length
InsCurrentLine2:
	tst.w	d2
	beq.s	InsCurrentLine3
	move.b	(a1)+,d0
	jsr	_WriteMemByte(a6)
	subq.w	#1,d2
	bra.s	InsCurrentLine2
InsCurrentLine3:
	clr.w	$16a(a6)
	move.w	$164(a6),$168(a6)
	movem.l	(a7)+,d1-d3/a0-a2
	rts

SearchText:				;Searches Text for String
					;A0=String,D0=Options
					;Bit 0=Whole Word
					;Bit 1=Match upper/lower case
	movem.l	d1-d7/a0-a5,-(a7)
	move.l	d0,d1
	link	a5,#-160
	move.l	a7,a2
	lea	$0053ff,a3		;MemshiftBase
	move.l	$0086(a6),a4		;MemshiftBuffer
	moveq	#$ffffffff,d6
	moveq	#$4f,d2
SearchText1:
	move.b	0(a0,d2.w),0(a2,d2.w)
	dbf	d2,SearchText1
	moveq	#$4f,d2
SearchText2:
	move.b	0(a2,d2.w),80(a2,d2.w)
	dbf	d2,SearchText2
	btst	#1,d1
	bne	SearchText3
	lea	(a2),a0
	moveq	#$ffffffff,d3
	moveq	#$20,d4
	bsr	SearchTextChar
	lea	80(a2),a0
	moveq	#$ffffffdf,d3
	moveq	#$00,d4
	bsr	SearchTextChar
SearchText3:
	move.b	(a2),d3
	move.b	80(a2),d4
	beq	SearchText
	move.l	$1e6(a6),a0		;Start
	move.l	$154(a6),a1		;End
SearchText4:
	cmp.l	a0,a1
	bls	SearchText12
	cmpa.l	a3,a0
	bhi	SearchText5
	adda.l	a4,a0
	move.b	(a0)+,d0
	suba.l	a4,a0
	bra	SearchText6
SearchText5:
	move.b	(a0)+,d0
SearchText6:
	cmp.b	d0,d3
	beq	SearchText7
	cmp.b	d0,d4
	bne	SearchText4
SearchText7:
	move.l	a0,d5
	btst	#0,d1
	beq	SearchText8
	subq.l	#1,a0
	cmp.l	$150(a6),a0
	beq	SearchText8
	subq.l	#1,a0
	jsr	_ReadMemByte(a6)
	cmp.b	#$0a,d0
	beq	SearchText8
	cmp.b	#$20,d0
	beq	SearchText8
	cmp.b	#$09,d0
	beq	SearchText8
	move.l	d5,a0
	bra	SearchText4
SearchText8:
	move.l	d5,a0
	moveq	#$00,d2
SearchText9:
	addq.w	#1,d2
	tst.b	0(a2,d2.w)
	beq	SearchText10
	cmp.l	a0,a1
	bls	SearchText12
	jsr	_ReadMemByte(a6)
	cmp.b	0(a2,d2.w),d0
	beq	SearchText9
	cmp.b	80(a2,d2.w),d0
	beq	SearchText9
	move.l	d5,a0
	bra	SearchText4
SearchText10:
	btst	#0,d1
	beq	SearchText11
	cmp.l	a0,a1
	bls	SearchText11
	jsr	_ReadMemByte(a6)
	cmp.b	#$0a,d0
	beq	SearchText11
	cmp.b	#$20,d0
	beq	SearchText11
	cmp.b	#$09,d0
	beq	SearchText11
	move.l	d5,a0
	bra	SearchText4
SearchText11:
	move.l	d5,$1e6(a6)
	move.l	d5,d6
	subq.l	#1,d6
SearchText12:
	move.l	d6,d0
	unlk	a5
	movem.l	(a7)+,d1-d7/a0-a5
	rts
SearchTextChar:
	moveq	#$4f,d2
SearchTextChar1:
	move.b	0(a0,d2.w),d0
	cmp.b	#$ff,d0
	beq	SearchTextChar3
	cmp.b	#$f7,d0
	beq	SearchTextChar3
	cmp.b	#$df,d0
	beq	SearchTextChar3
	cmp.b	#$d7,d0
	beq	SearchTextChar3
	cmp.b	#$bf,d0
	bhi	SearchTextChar2
	cmp.b	#$7a,d0
	bhi	SearchTextChar3
	cmp.b	#$60,d0
	bhi	SearchTextChar2
	cmp.b	#$5a,d0
	bhi	SearchTextChar3
	cmp.b	#$40,d0
	bls	SearchTextChar3
SearchTextChar2:
	and.b	d3,d0
	or.b	d4,d0
	move.b	d0,0(a0,d2.w)
SearchTextChar3:
	dbf	d2,SearchTextChar1
	rts

CopyMemory:				;Copies RAM Memory
					;A0=Begin,A1=End,A2=Dest.
	movem.l	d0-d2/a0-a5,-(a7)
	lea	$0053ff,a3		;MemshiftBase
	cmp.l	a2,a0
	bls.s	CopyMemory2		;Backwards
CopyMemory1:
	cmp.l	a0,a1
	beq	CopyMemory4
	sub.l	a4,a4
	sub.l	a5,a5
	move.l	a1,d0
	sub.l	a0,d0
	move.l	d0,d1
	cmp.l	a3,a2
	bhi.s	CopyMemory1a
	move.l	$0086(a6),a5
	move.l	a3,d0
	addq.l	#1,d0
	sub.l	a2,d0
	cmp.l	a3,a0
	bhi.s	CopyMemory1a
	move.l	a5,a4
	move.l	a3,d0
	addq.l	#1,d0
	sub.l	a0,d0
CopyMemory1a:
	cmp.l	d1,d0
	bls.s	CopyMemory1b
	move.l	d1,d0
CopyMemory1b:
	add.l	a4,a0
	add.l	a5,a2
	subq.l	#1,d0
	move.l	d0,d1
	swap	d1
CopyMemory1c:
	move	d0,d2
	and.w	#$0007,d0
	lsr.w	#3,d2
	beq.s	CopyMemory1e
	subq.w	#1,d2
CopyMemory1d:
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	dbf	d2,CopyMemory1d
CopyMemory1e:
	move.b	(a0)+,(a2)+
	dbf	d0,CopyMemory1e
	dbf	d1,CopyMemory1c
	sub.l	a4,a0
	sub.l	a5,a2
	bra.s	CopyMemory1

CopyMemory2:
	add.l	a1,a2
	sub.l	a0,a2
	exg	a0,a1
	addq.l	#1,a3
CopyMemory3:
	cmp.l	a0,a1
	beq.s	CopyMemory4
	move.l	$0086(a6),a4
	move.l	a4,a5
	move.l	a0,d0
	sub.l	a1,d0
	move.l	d0,d1
	cmp.l	a3,a2
	bls.s	CopyMemory3a
	sub.l	a5,a5
	move.l	a2,d0
	sub.l	a3,d0
	cmp.l	a3,a0
	bls.s	CopyMemory3a
	sub.l	a4,a4
	move.l	a0,d0
	sub.l	a3,d0
CopyMemory3a:
	cmp.l	d1,d0
	bls.s	CopyMemory3b
	move.l	d1,d0
CopyMemory3b:
	add.l	a4,a0
	add.l	a5,a2
	subq.l	#1,d0
	move.l	d0,d1
	swap	d1
CopyMemory3c:
	move	d0,d2
	and.w	#$0007,d0
	lsr.w	#3,d2
	beq.s	CopyMemory3e
	subq.w	#1,d2
CopyMemory3d:
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	dbf	d2,CopyMemory3d
CopyMemory3e:
	move.b	-(a0),-(a2)
	dbf	d0,CopyMemory3e
	dbf	d1,CopyMemory3c
	sub.l	a4,a0
	sub.l	a5,a2
	bra.s	CopyMemory3
CopyMemory4:
	movem.l	(a7)+,d0-d2/a0-a5
	rts

UpdateText:				;Place First Line on Top
	movem.l	d1-d2/a0-a5,-(a7)	;of Screen
	move.l	$5c(a6),-(a7)
	clr.l	$5c(a6)			;CRSR TOP LEFT
	move.l	$170(a6),a0		;First Line Addr
	move.l	$154(a6),a1
	lea	$0053ff,a2		;MemshiftBase
	move.l	$0086(a6),a3		;MemshiftBuffer
	clr.b	$74(a6)			;No Inverse
	move.l	$01aa(a6),a4		;Mark Begin
	move.l	$01ae(a6),a5		;Mark End
	cmp.l	a4,a5
	bhi.s	UpdateTextMark
	exg	a4,a5
UpdateTextMark:
	cmp.l	a0,a4
	bhi.s	UpdateText1
	exg	a5,a4
	cmp.l	a4,a0
	bhi.s	UpdateText1
	move.b	#$ff,$74(a6)		;Inverse
UpdateText1:
	cmp.l	$15c(a6),a0		;Current Line Addr
	bne.s	UpdateText1a
	move.w	$5c(a6),(a7)
UpdateText1a:
	clr.w	$5e(a6)
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	beq	UpdateText3
	move.w	$16e(a6),d1		;Screen X base
	moveq	#$00,d2
UpdateText2:
	cmp.l	a0,a4
	bne.s	UpdateText2Mark
	exg	a5,a4
	cmp.l	a0,a4
	beq.s	UpdateText2Mark
	eor.b	#$ff,$74(a6)
UpdateText2Mark:
	cmp.l	a0,a1
	beq.s	UpdateText3
	cmpa.l	a2,a0
	bhi.s	UpdateText2a
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	UpdateText2b
UpdateText2a:
	move.b	(a0)+,d0
UpdateText2b:
	cmp.b	#$0a,d0			;LF
	beq.s	UpdateText2e
	cmp.w	d1,d2
	bge.s	UpdateText2c
	addq.w	#1,d2
	cmp.b	#$09,d0			;TAB
	bne.s	UpdateText2	
	addq.w	#7,d2
	and.w	#$7ff8,d2
	bra.s	UpdateText2
UpdateText2c:
	cmp.b	#$09,d0
	bne.s	UpdateText2ca
	jsr	_ClearToTAB(a6)
UpdateText2ca:
	jsr	_WriteChar(a6)
	tst.w	$5e(a6)
	bne.s	UpdateText2
UpdateText2d:
	cmp.l	a0,a4
	bne.s	UpdateText2dMark
	exg	a5,a4
	cmp.l	a0,a4
	beq.s	UpdateText2dMark
	eor.b	#$ff,$74(a6)
UpdateText2dMark:
	cmp.l	a0,a1
	beq.s	UpdateText3
	jsr	_ReadMemByte(a6)
	cmp.b	#$0a,d0
	bne.s	UpdateText2d
	bra	UpdateText1
UpdateText2e:
	move.b	$74(a6),-(a7)
	clr.b	$74(a6)
	jsr	_ClearToEOL(a6)
	move.b	(a7)+,$74(a6)
	jsr	_WriteChar(a6)
	bra	UpdateText1
UpdateText3:
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	beq.s	UpdateText4
	tst.w	$5e(a6)
	bne.s	UpdateText3a
	jsr	_ClearLine(a6)
	addq.w	#1,$5c(a6)
	bra.s	UpdateText3
UpdateText3a:
	jsr	_ClearToEOL(a6)
	clr.w	$5e(a6)
	addq.w	#1,$5c(a6)
	bra.s	UpdateText3
UpdateText4:
	clr.b	$74(a6)			;No Inverse
	bsr	WriteCursorInfo
	move.l	(a7)+,$5c(a6)
	movem.l	(a7)+,d1-d2/a0-a5
	rts

UpdateLine:
	movem.l	d1-d3/a0-a4,-(a7)
	move.l	$5c(a6),-(a7)
	clr.w	$5e(a6)
	move.l	$160(a6),a0		;Line Buffer
	move.l	$1aa(a6),a1		;Mark Begin
	move.l	$1ae(a6),a2		;Mark End
	lea	$0053ff,a3		;MemshiftBase
	move.l	$0086(a6),a4		;MemshiftBuffer
	cmp.l	a1,a2
	bhi.s	UpdateLineMark
	exg	a1,a2
UpdateLineMark:
	sub.l	$15c(a6),a1		;Real Line Addr
	sub.l	$15c(a6),a2
	add.l	a0,a1
	add.l	a0,a2
	move.w	$164(a6),d1
	addq.w	#1,d1
	moveq	#$00,d2
	move.w	$16e(a6),d3		;Screen X Base
	clr.b	$74(a6)			;No Inverse
	cmp.l	a0,a1
	bhi.s	UpdateLine1
	exg	a2,a1
	cmp.l	a1,a0
	bhi.s	UpdateLine1
	move.b	#$ff,$74(a6)		;Inverse
UpdateLine1:
	cmp.l	a0,a1
	bne.s	UpdateLine1Mark
	exg	a2,a1
	cmp.l	a0,a1
	beq.s	UpdateLine1Mark
	eor.b	#$ff,$74(a6)
UpdateLine1Mark:
	subq.w	#1,d1
	beq.s	UpdateLine4
	cmpa.l	a3,a0
	bhi.s	UpdateLine1a
	adda.l	a4,a0
	move.b	(a0)+,d0
	suba.l	a4,a0
	bra.s	UpdateLine1b
UpdateLine1a:
	move.b	(a0)+,d0
UpdateLine1b:
	cmp.b	#$0a,d0
	beq.s	UpdateLine4
	cmp.w	d3,d2
	bge.s	UpdateLine2
	addq.w	#1,d2
	cmp.b	#$09,d0			;TAB
	bne.s	UpdateLine1	
	addq.w	#7,d2
	and.w	#$7ff8,d2
	bra.s	UpdateLine1
UpdateLine2:
	cmp.b	#$09,d0
	bne.s	UpdateLine3
	jsr	_ClearToTAB(a6)
UpdateLine3:
	jsr	_WriteChar(a6)
	tst.w	$5e(a6)
	bne.s	UpdateLine1
	bra.s	UpdateLine5
UpdateLine4:
	move.b	$74(a6),-(a7)
	clr.b	$74(a6)
	jsr	_ClearToEOL(a6)
	move.b	(a7)+,$74(a6)
UpdateLine5:
	clr.b	$74(a6)			;No Inverse
	move.l	(a7)+,$5c(a6)
	movem.l	(a7)+,d1-d3/a0-a4
	rts

StartMarking:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,d0
	beq.s	StartMarking2
	move.l	#$ffffffff,$1aa(a6)
	move.l	#$ffffffff,$1ae(a6)
	bsr	UpdateText
	bsr	UpdateLine
StartMarking1:
	bsr	SetCursorMarkBegin
	move.w	#$0001,$01b2(a6)
StartMarking2:
	move.l	(a7)+,d0
	rts

ContMarking:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,$01b2(a6)
	bne.s	ContMarking1
	bsr	SetCursorMarkEnd
	bsr	UpdateLine
	move.w	$1ba(a6),d0
	cmp.w	$05c(a6),d0
	beq.s	ContMarking1
	move.l	$15c(a6),-(a7)
	move.l	$160(a6),-(a7)
	move.w	$164(a6),-(a7)
	move.w	$05c(a6),-(a7)
	move.l	$1b4(a6),$15c(a6)
	move.l	$1b4(a6),$160(a6)
	move.w	$1b8(a6),$164(a6)
	move.w	$1ba(a6),$05c(a6)
	bsr	UpdateLine
	move.w	(a7)+,$05c(a6)
	move.w	(a7)+,$164(a6)
	move.l	(a7)+,$160(a6)
	move.l	(a7)+,$15c(a6)
ContMarking1:
	move.l	(a7)+,d0
	rts

ContMarkingII:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,$01b2(a6)
	bne.s	ContMarkingII1
	bsr	SetCursorMarkEnd
ContMarkingII1:
	move.l	(a7)+,d0
	rts

ContMarkingIII:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,$01b2(a6)
	bne.s	ContMarkingIII1
	move.w	$1ba(a6),d0
	cmp.w	$05c(a6),d0
	beq.s	ContMarkingIII1
	move.l	$15c(a6),-(a7)
	move.l	$160(a6),-(a7)
	move.w	$164(a6),-(a7)
	move.w	$05c(a6),-(a7)
	move.l	$1b4(a6),$160(a6)
	move.l	$1b4(a6),$15c(a6)
	move.w	$1b8(a6),$164(a6)
	move.w	$1ba(a6),$05c(a6)
	bsr	UpdateLine
	move.w	(a7)+,$05c(a6)
	move.w	(a7)+,$164(a6)
	move.l	(a7)+,$160(a6)
	move.l	(a7)+,$15c(a6)
ContMarkingIII1:
	move.l	(a7)+,d0
	rts

EndMarking:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,d0
	bne.s	EndMarking1
	move.l	#$ffffffff,$1aa(a6)
	move.l	#$ffffffff,$1ae(a6)
	bsr	UpdateText
	bsr	UpdateLine
	move.w	#$0000,$01b2(a6)
EndMarking1:
	move.l	(a7)+,d0
	rts

RememberMark:
	move.l	d0,-(a7)
	move.w	$1b2(a6),d0
	cmp.w	#$0001,d0
	bne.s	RememberMark1
	move.l	$15c(a6),$1b4(a6)
	move.w	$164(a6),$1b8(a6)
	move.w	$05c(a6),$1ba(a6)
RememberMark1:
	move.l	(a7)+,d0
	rts

SetCursorMarkBegin:
	move.l	a0,-(a7)
	move.l	$15c(a6),a0		;Real Line Addr
	adda.w	$16c(a6),a0		;Line Index
	move.l	a0,$1aa(a6)		;Mark begin
	move.l	(a7)+,a0
	rts

SetCursorMarkEnd:
	move.l	a0,-(a7)
	move.l	$15c(a6),a0		;Real Line Addr
	adda.w	$16c(a6),a0		;Line Index
	move.l	a0,$1ae(a6)		;Mark begin
	move.l	(a7)+,a0
	rts

GotoPrecCurLineII:			;Searches for previous textline
	movem.l	d1-d2/a0-a3,-(a7)
	tst.l	$158(a6)
	beq.s	GotoPrecCurLineII1
	subq.l	#1,$158(a6)
GotoPrecCurLineII1:
	move.l	$15c(a6),a0		;Text Current Line
	move.l	$150(a6),a1		;Text Start
	lea	$0053ff,a2
	addq.l	#1,a2
	move.l	$086(a6),a3
GotoPrecCurLineII2:
	cmpa.l	a0,a1
	beq.s	GotoPrecCurLineII5
	cmpa.l	a2,a0
	bhi.s	GotoPrecCurLineII3
	adda.l	a3,a0
	move.b	-(a0),d0
	suba.l	a3,a0
	bra.s	GotoPrecCurLineII4
GotoPrecCurLineII3:
	move.b	-(a0),d0
GotoPrecCurLineII4:
	cmp.b	#$0a,d0
	bne.s	GotoPrecCurLineII2
	addq.l	#1,a0
GotoPrecCurLineII5:
	move.l	a0,$15c(a6)		;Current Line Addr
	bsr	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoPrecCurLine:			;Searches for previous textline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$158(a6),d2
	move.l	$15c(a6),a0		;Text Current Line
	move.l	$150(a6),a1		;Text Start
	lea	$0053ff,a2
	addq.l	#1,a2
	move.l	$086(a6),a3
	move.l	d2,d1
	subq.l	#1,d2
	addq.l	#1,d1
	bra.s	GotoPrecCurLine2
GotoPrecCurLine1:
	subq.l	#1,d1
	move.l	a0,$15c(a6)		;Current Line Addr
	addq.l	#1,$15c(a6)
	cmp.l	d1,d2
	beq	GotoPrecCurLine5
GotoPrecCurLine2:
	cmp.l	a0,a1
	beq.s	GotoPrecCurLine4a
	cmpa.l	a2,a0
	bhi.s	GotoPrecCurLine3
	adda.l	a3,a0
	move.b	-(a0),d0
	suba.l	a3,a0
	bra.s	GotoPrecCurLine4
GotoPrecCurLine3:
	move.b	-(a0),d0
GotoPrecCurLine4:
	cmp.b	#$0a,d0
	beq.s	GotoPrecCurLine1
	bra.s	GotoPrecCurLine2
GotoPrecCurLine4a:
	subq.l	#1,d1
	move.l	a0,$15c(a6)
GotoPrecCurLine5:
	move.l	d1,$158(a6)		;Current Line nr
	bsr	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoPrecTopLine:			;Searches for previous toptextline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$170(a6),a0		;Text Current Line
	move.l	$150(a6),a1		;Text Start
	lea	$0053ff,a2
	addq.l	#1,a2
	move.l	$086(a6),a3
	moveq	#$00,d2
	move.l	d2,d1
	subq.l	#1,d2
	addq.l	#1,d1
	bra.s	GotoPrecTopLine2
GotoPrecTopLine1:
	subq.l	#1,d1
	move.l	a0,$170(a6)		;First Line Addr
	addq.l	#1,$170(a6)
	cmp.l	d1,d2
	beq.s	GotoPrecTopLine5
GotoPrecTopLine2:
	cmp.l	a0,a1
	beq.s	GotoPrecTopLine4a
	cmpa.l	a2,a0
	bhi.s	GotoPrecTopLine3
	adda.l	a3,a0
	move.b	-(a0),d0
	suba.l	a3,a0
	bra.s	GotoPrecTopLine4
GotoPrecTopLine3:
	move.b	-(a0),d0
GotoPrecTopLine4:
	cmp.b	#$0a,d0
	beq.s	GotoPrecTopLine1
	bra.s	GotoPrecTopLine2
GotoPrecTopLine4a:
	move.l	a0,$170(a6)
GotoPrecTopLine5:
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoNextCurLine:			;Searches for next textline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$158(a6),d2
	move.l	$15c(a6),a0		;Text Current Line
	move.l	$154(a6),a1		;Text End
	lea	$0053ff,a2
	move.l	$086(a6),a3
	move.l	d2,d1
	addq.l	#1,d2
	subq.l	#1,d1
GotoNextCurLine1:
	addq.l	#1,d1
	move.l	a0,$15c(a6)		;Current Line Addr
	cmp.l	d1,d2
	beq.s	GotoNextCurLine5
GotoNextCurLine2:
	cmp.l	a0,a1
	beq.s	GotoNextCurLine5
	cmpa.l	a2,a0
	bhi.s	GotoNextCurLine3
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	GotoNextCurLine4
GotoNextCurLine3:
	move.b	(a0)+,d0
GotoNextCurLine4:
	cmp.b	#$0a,d0
	beq.s	GotoNextCurLine1
	bra.s	GotoNextCurLine2
GotoNextCurLine5:
	move.l	d1,$158(a6)		;Current Line nr
	bsr	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoNextTopLine:			;Searches for next toptextline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$170(a6),a0		;Text Current Line
	move.l	$154(a6),a1		;Text End
	lea	$0053ff,a2
	move.l	$086(a6),a3
	moveq	#$00,d2
	move.l	d2,d1
	addq.l	#1,d2
	subq.l	#1,d1
GotoNextTopLine1:
	addq.l	#1,d1
	move.l	a0,$170(a6)		;First Line Addr
	cmp.l	d1,d2
	beq.s	GotoNextTopLine5
GotoNextTopLine2:
	cmp.l	a0,a1
	beq.s	GotoNextTopLine5
	cmpa.l	a2,a0
	bhi.s	GotoNextTopLine3
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	GotoNextTopLine4
GotoNextTopLine3:
	move.b	(a0)+,d0
GotoNextTopLine4:
	cmp.b	#$0a,d0
	beq.s	GotoNextTopLine1
	bra.s	GotoNextTopLine2
GotoNextTopLine5:
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoCurrentLine:			;Searches for current Textline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$150(a6),a0		;Text Start
	move.l	$154(a6),a1		;Text End
	lea	$0053ff,a2		;MemshiftBase
	move.l	$086(a6),a3		;MemshiftBuffer
	move.l	$158(a6),d2		;Current Line nr
	moveq	#$ffffffff,d1
GotoCurrentLine1:
	move.l	a0,$15c(a6)		;Current Line Addr
	addq.l	#1,d1
	cmp.l	d1,d2
	beq.s	GotoCurrentLine3
GotoCurrentLine2:
	cmp.l	a0,a1
	beq.s	GotoCurrentLine3
	cmpa.l	a2,a0
	bhi.s	GotoCurrentLine2a
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	GotoCurrentLine2b
GotoCurrentLine2a:
	move.b	(a0)+,d0
GotoCurrentLine2b:
	cmp.b	#$0a,d0
	beq.s	GotoCurrentLine1
	bra.s	GotoCurrentLine2
GotoCurrentLine3:
	move.l	d1,$158(a6)		;Current Line nr
	bsr.s	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

LoadCurrentBuffer:			;Loads the current line into buffer
	movem.l	d1-d6/a0-a4,-(a7)
	moveq	#$00,d1			;Index count
	moveq	#$00,d2			;Column count
	moveq	#$ffffffff,d4		;Cursor - Index
	moveq	#$ffffffff,d5		;New Column nr
	moveq	#$00,d6
	move.l	$15c(a6),a0
	move.l	$154(a6),a1
	move.l	$160(a6),a2		;Buffer Addr
	lea	$0053ff,a3		;MemshiftBase
	move.l	$086(a6),a4		;MemshiftBuffer
	move.w	$166(a6),d3		;Column nr
LoadCurrentBuffer1:
	tst.w	d6
	bne.s	LoadCurrentBuffer1a
	move.w	d1,d4			;Index
	move.w	d2,d5			;New Column
	cmp.w	d3,d2
	blt.s	LoadCurrentBuffer1a
	moveq	#$01,d6
LoadCurrentBuffer1a:
	cmp.w	#$0200,d2
	beq.s	LoadCurrentBuffer4
	cmp.l	a0,a1
	beq.s	LoadCurrentBuffer4
	cmpa.l	a3,a0
	bhi.s	LoadCurrentBuffer2
	adda.l	a4,a0
	move.b	(a0)+,d0
	suba.l	a4,a0
	bra.s	LoadCurrentBuffer3
LoadCurrentBuffer2:
	move.b	(a0)+,d0
LoadCurrentBuffer3:
	move.b	d0,(a2)+
	addq.w	#1,d2
	cmp.b	#$09,d0
	bne.s	LoadCurrentBuffer3a
	addq.w	#7,d2
	and.w	#$7ff8,d2
LoadCurrentBuffer3a:
	addq.l	#1,d1
	cmp.b	#$0a,d0
	bne.s	LoadCurrentBuffer1
LoadCurrentBuffer4:
	move.w	d1,$164(a6)		;Buffer Length
	move.w	d1,$168(a6)		;Buffer Oldlength
	move.w	d4,$16c(a6)		;Buffer Index
	move.w	d5,$166(a6)		;Column nr
	bsr.s	CalCursorX
	clr.w	$16a(a6)		;Buffer Changed = No
	movem.l	(a7)+,d1-d6/a0-a4
	rts

CalColumnNr:				;Calculates the column nr
	movem.l	d0-d2/a0,-(a7)
	moveq	#$00,d0
	moveq	#$ffffffff,d1
	move.w	$16c(a6),d2		;Buffert index
	move.l	$160(a6),a0		;Buffert address
CalColumnNr1:
	addq.w	#1,d1
	cmp.w	d1,d2
	beq.s	CalColumnNr2
	addq.w	#1,d0
	cmp.b	#$09,(a0)+		;TAB
	bne.s	CalColumnNr1
	addq.w	#7,d0
	and.w	#$7ff8,d0
	bra.s	CalColumnNr1
CalColumnNr2:
	move.w	d0,$166(a6)
	movem.l	(a7)+,d0-d2/a0
	rts

CalCursorX:				;Calculates the X position
					;D0out: 0=Noscreenmove, 1=Screenmove
	movem.l	d1-d2,-(a7)
	move.w	$166(a6),d1
	move.w	$16e(a6),d2
CalCursorX1:
	cmp.w	d1,d2
	bhi.s	CalCursorX4
	beq.s	CalCursorX4
	add.w	#$004f,d2
	cmp.w	d1,d2
	bls.s	CalCursorX5
	sub.w	#$004f,d2
CalCursorX2:
	moveq	#$00,d0
	cmp.w	$16e(a6),d2
	beq.s	CalCursorX3
	moveq	#$01,d0
CalCursorX3:
	move.w	d2,$16e(a6)		;Column start
	sub.w	d2,d1
	move.w	d1,$5e(a6)		;Screen Cursor X
	movem.l	(a7)+,d1-d2
	rts
CalCursorX4:
	subq.w	#8,d2
	bcc.s	CalCursorX1
	moveq	#$00,d2
	bra.s	CalCursorX2
CalCursorX5:
	sub.w	#$0047,d2
	bra.s	CalCursorX1

WriteCursorInfo:			;Writes the Infoline
	movem.l	d1/a0,-(a7)
	move.l	$5c(a6),-(a7)		;Save Cursor X,Y
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
	btst	#0,$6c(a6)
	beq.s	WriteCursorInfoCaps
	lea	WriteCursorInfoText5(pc),a0
	jsr	_WriteString(a6)
WriteCursorInfoCaps:
	btst	#1,$6c(a6)
	beq.s	WriteCursorInfoNum
	lea	WriteCursorInfoText6(pc),a0
	jsr	_WriteString(a6)
WriteCursorInfoNum:
	lea	WriteCursorInfoText1(pc),a0
	jsr	_WriteString(a6)
	move.l	#1000000000,d1
	move.l	$158(a6),d0
	addq.l	#1,d0			;Start with Line 1
	jsr	_WriteDecNumberII(a6)
	lea	WriteCursorInfoText2(pc),a0
	jsr	_WriteString(a6)
	move.l	#10000,d1
	moveq	#$00,d0
	move.w	$166(a6),d0
	addq.l	#1,d0			;Start with Col 1
	jsr	_WriteDecNumberII(a6)
	lea	WriteCursorInfoText3(pc),a0
	jsr	_WriteString(a6)
	move.l	#1000000000,d1
	bsr	GetFreeWorkBuf
	jsr	_WriteDecNumberII(a6)
	lea	WriteCursorInfoText4(pc),a0
	jsr	_WriteString(a6)
	moveq	#$4f,d1
	move.l	$19c(a6),a0
WriteCursorInfo1:
	move.b	(a0)+,d0
	beq.s	WriteCursorInfo2
	jsr	_WriteASCIIChar(a6)
	dbf	d1,WriteCursorInfo1
WriteCursorInfo2:
	jsr	_ClearToEOL(a6)
	move.l	(a7)+,$5c(a6)
	movem.l	(a7)+,d1/a0
	rts
WriteCursorInfoText1:
	dc.b	"LINE:",0
WriteCursorInfoText2:
	dc.b	" COLUMN:",0
WriteCursorInfoText3:
	dc.b	" FREE:",0
WriteCursorInfoText4:
	dc.b	" NAME:",0
WriteCursorInfoText5:
	dc.b	"CAPS ",0
WriteCursorInfoText6:
	dc.b	"NUM ",0
	even

GetFreeWorkBuf:				;Get length of free workmem
	move.w	$168(a6),d0
	sub.w	$164(a6),d0
	ext.l	d0
	add.l	$182(a6),d0
	sub.l	$186(a6),d0
	rts

MakeScreenBackup:			;Copies the Charmap to buffert
	movem.l	d1-d3/a0-a1,-(a7)
	move.l	$4(a6),a0
	move.l	$174(a6),a1
	move.w	#$0293,d3
MakeScreenBackup1:
	move.l	(a0),d2
	move.l	(a1),d1
	move.l	d1,(a0)+
	move.l	d2,(a1)+
	dbf	d3,MakeScreenBackup1
	movem.l	(a7)+,d1-d3/a0-a1
	rts

RestoreScreen:				;Redraws the Screen
	movem.l	d1-d4/a0-a2,-(a7)
	move.l	(a6),a1
	move.l	$4(a6),a2
	moveq	#$20,d3
RestoreScreen1:
	moveq	#$4f,d4
RestoreScreen2:
	move.b	(a2)+,d0
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	d0,d1
	bpl.s	RestoreScreen3
	sub.b	#$0020,d1
	bmi.s	RestoreScreen4
	moveq	#-1,d2
	add.b	#$0040,d1
	bra.s	RestoreScreen4
RestoreScreen3:
	sub.b	#$0020,d1
	bpl.s	RestoreScreen4
	moveq	#-1,d2
	add.b	#$0040,d1
RestoreScreen4:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	tst.b	d2
	beq.s	RestoreScreen5
	move.b	$00c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d2,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d2,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d2,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d2,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d2,d0
	move.b	d0,$0230(a1)
	move.b	(a0),d0
	eor.b	d2,d0
	move.b	d0,(a1)+
	bra.s	RestoreScreen6
RestoreScreen5:
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
	move.b	(a0),(a1)+
RestoreScreen6:
	dbf	d4,RestoreScreen2
	lea	$0230(a1),a1
	dbf	d3,RestoreScreen1
	movem.l	(a7)+,d1-d4/a0-a2
	rts

RememberMarked:				;Remembers the markings
	movem.l	d1-d6/a0-a3,-(a7)
	move.l	(a6),a1
	move.l	$4(a6),a2
	move.l	$1f6(a6),a3
	moveq	#$20,d3
RememberMarked1:
	moveq	#$09,d4
RememberMarked2:
	moveq	#$07,d5
	moveq	#$00,d6
RememberMarked3:
	move.b	(a2)+,d0
	moveq	#$00,d1
	moveq	#-1,d2
	move.b	d0,d1
	bpl.s	RememberMarked4
	sub.b	#$0020,d1
	bmi.s	RememberMarked5
	moveq	#$00,d2
	add.b	#$0040,d1
	bra.s	RememberMarked5
RememberMarked4:
	sub.b	#$0020,d1
	bpl.s	RememberMarked5
	moveq	#$00,d2
	add.b	#$0040,d1
RememberMarked5:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	lsr.b	#1,d6
	move.b	(a1)+,d0
	eor.b	d2,d0
	cmp.b	(a0),d0
	bne.s	RememberMarked6
	or.b	#$80,d6
RememberMarked6:
	dbf	d5,RememberMarked3
	move.b	d6,(a3)+
	dbf	d4,RememberMarked2
	lea	$0230(a1),a1
	dbf	d3,RememberMarked1
	movem.l	(a7)+,d1-d6/a0-a3
	rts

RestoreMarked:				;Restores the markings
					;D0/D1=X1/Y1 , D2/D3=X2/Y2
	movem.l	d0-d5/a0-a2,-(a7)
	move.l	$05c(a6),-(a7)
	move.w	d0,d4
	move.w	d1,d5
RestoreMarked1:
	move.w	d5,$05c(a6)
	bsr	CalcYAddr
	move.l	$178(a6),a1		;Bitmap
	move.l	a1,d0
	sub.l	(a6),d0
	lsr.l	#6,d0
	move.l	$1f6(a6),a0
	add.l	d0,a0
	move.w	d4,d1
RestoreMarked2:
	move.w	d1,d0
	lsr.w	#3,d0
	btst	d1,0(a0,d0.w)
	beq	RestoreMarked3
	lea	0(a1,d1.w),a2
	moveq	#-1,d0
	eor.b	d0,(a2)
	eor.b	d0,$050(a2)
	eor.b	d0,$0a0(a2)
	eor.b	d0,$0f0(a2)
	eor.b	d0,$140(a2)
	eor.b	d0,$190(a2)
	eor.b	d0,$1e0(a2)
	eor.b	d0,$230(a2)
RestoreMarked3:
	addq.w	#1,d1
	cmp.w	d2,d1
	bls	RestoreMarked2
	addq.w	#1,d5
	cmp.w	d3,d5
	bls	RestoreMarked1
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d5/a0-a2
	rts

RestoreAllMarked:
	movem.l	d0-d3,-(a7)
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$4f,d2
	moveq	#$00,d3
	move.w	$14c(a6),d3
	subq.w	#2,d3
	bsr	RestoreMarked
	movem.l	(a7)+,d0-d3
	rts

WriteBitmapChar:
	movem.l	d1/a0-a1,-(a7)
	moveq	#$00,d1
	move.b	d0,d1
	bpl.s	WriteBitmapChar1
	sub.b	#$20,d1
	bpl	WriteBitmapCharSpec
	bra.s	WriteBitmapChar2
WriteBitmapChar1:
	sub.b	#$20,d1
	bmi	WriteBitmapCharSpec
WriteBitmapChar2:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteBitmapChar3
	bsr	CalcYAddr
WriteBitmapChar3:
	move.w	$5e(a6),d1
	move.l	$178(a6),a1
	add.w	d1,a1
	move.b	$74(a6),d1
	move.b	(a0),d0
	eor.b	d1,d0
	move.b	d0,(a1)
	move.b	$00c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d1,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d1,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d1,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d1,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d1,d0
	move.b	d0,$0230(a1)
	addq.w	#1,$5e(a6)
WriteBitmapCharSpec:
	movem.l	(a7)+,d1/a0-a1
	rts

WriteBitmapString:				;Writes a Textstring
						;A0=Text
	move.l	a0,-(a7)
WriteBitmapString1:
	move.b	(a0)+,d0
	beq.s	WriteBitmapStringEnd
	bsr	WriteBitmapChar
	bra.s	WriteBitmapString1
WriteBitmapStringEnd:
	move.l	a0,d0
	move.l	(a7)+,a0
	rts

MakeLibrary:
	movem.l	d0/a0-a2,-(a7)
	lea	(a6),a1
	lea	Library(pc),a0
	move.l	a0,a2
MakeLibrary1:
	move.l	(a0)+,d0
	beq	MakeLibrary2
	add.l	a2,d0
	subq.l	#6,a1
	move.w	#$4ef9,(a1)
	move.l	d0,2(a1)
	bra	MakeLibrary1
MakeLibrary2:
	movem.l	(a7)+,d0/a0-a2
	rts

Library:
	dc.l	WriteChar-Library		;-6
	dc.l	WriteString-Library		;-12
	dc.l	ReadKeyboard-Library		;-18
	dc.l	ScrollUp-Library		;-24
	dc.l	ScrollDown-Library		;-30
	dc.l	ReadNumber-Library		;-36
	dc.l	ReadDecNumber-Library		;-42
	dc.l	ReadNibble-Library		;-48
	dc.l	ReadByte-Library		;-54
	dc.l	ReadStringII-Library		;-60
	dc.l	ReadString-Library		;-66
	dc.l	CopyString-Library		;-72
	dc.l	WriteASCIIChar-Library		;-78
	dc.l	WriteNumber-Library		;-84
	dc.l	WriteDecNumber-Library		;-90
	dc.l	WriteDecNumberII-Library	;-96
	dc.l	WriteByte-Library		;-102
	dc.l	WriteWord-Library		;-108
	dc.l	WriteLong-Library		;-114
	dc.l	ReadMemByte-Library		;-120
	dc.l	ReadMemWord-Library		;-126
	dc.l	ReadMemLong-Library		;-132
	dc.l	WriteMemByte-Library		;-138
	dc.l	WriteMemWord-Library		;-144
	dc.l	WriteMemLong-Library		;-150
	dc.l	ExchangeRam-Library		;-156
	dc.l	ClearLine-Library		;-162
	dc.l	ClearLineII-Library		;-168
	dc.l	ClearToEOL-Library		;-174
	dc.l	ClearToTAB-Library		;-180
	dc.l	ClearScreen-Library		;-186
	dc.l	0
LVO_WriteChar		equ	-6	;(Char)(D0)
LVO_WriteString		equ	-12	;(String)(A0)=End
LVO_ReadKeyboard	equ	-18	;=Key
LVO_ScrollUp		equ	-24	;
LVO_ScrollDown		equ	-30	;
LVO_ReadNumber		equ	-36	;=HexNumber
LVO_ReadDecNumber	equ	-42	;=DecNumber
LVO_ReadNibble		equ	-48	;=Nibble
LVO_ReadByte		equ	-54	;=Byte
LVO_ReadStringII	equ	-60	;(String)(A0)=Length
LVO_ReadString		equ	-66	;(String)(A0)=Length
LVO_CopyString		equ	-72	;(Source,Dest)(A0,A1)
LVO_WriteASCIIChar	equ	-78	;(Char)(D0)
LVO_WriteNumber		equ	-84	;(Nibble)(D0)
LVO_WriteDecNumber	equ	-90	;(Number,Divisor)(D0,D1)
LVO_WriteDecNumberII	equ	-96	;(Number,Divisor)(D0,D1)
LVO_WriteByte		equ	-102	;(Byte)(D0)
LVO_WriteWord		equ	-108	;(Word)(D0)
LVO_WriteLong		equ	-114	;(Long)(D0)
LVO_ReadMemByte		equ	-120	;(Adress)(A0)=Byte
LVO_ReadMemWord		equ	-126	;(Adress)(A0)=Word
LVO_ReadMemLong		equ	-132	;(Adress)(A0)=Long
LVO_WriteMemByte	equ	-138	;(Byte,Adress)(D0,A0)
LVO_WriteMemWord	equ	-144	;(Word,Adress)(D0,A0)
LVO_WriteMemLong	equ	-150	;(Long,Adress)(D0,A0)
LVO_ExchangeRam		equ	-156	;
LVO_ClearLine		equ	-162	;
LVO_ClearLineII		equ	-168	;(Length)(D0)
LVO_ClearToEOL		equ	-174	;
LVO_ClearToTAB		equ	-180	;
LVO_ClearScreen		equ	-186	;

SaveExitPar:				;Saves the Exit Parameters
	movem.l	d0/a0-a1,-(a7)
	cmp.w	#1000,$70(a6)
	beq.s	SaveExitPar1
	cmp.w	#1001,$70(a6)
	beq.s	SaveExitPar1
	cmp.w	#1003,$70(a6)
	beq.s	SaveExitPar1
	bra.s	SaveExitPar5
SaveExitPar1:
	move.l	$196(a6),a1
	move.l	$18a(a6),a0
	moveq	#$7f,d0
SaveExitPar2:
	move.l	(a0)+,(a1)+
	dbf	d0,SaveExitPar2
	move.l	$18e(a6),a0
	moveq	#$0b,d0
SaveExitPar3:
	move.l	(a0)+,(a1)+
	dbf	d0,SaveExitPar3
	lea	$1c(a6),a0
	moveq	#$0f,d0
SaveExitPar4:
	move.l	(a0)+,(a1)+
	dbf	d0,SaveExitPar4
	move.l	$8a(a6),(a1)+
	move.w	$8e(a6),(a1)+
	move.l	$90(a6),(a1)+
SaveExitPar5:
	movem.l	(a7)+,d0/a0-a1
	rts

LoadExitPar:				;Restores the Exit Parameters
	movem.l	d0/a0-a1,-(a7)
	cmp.w	#1000,$70(a6)
	beq.s	LoadExitPar1
	cmp.w	#1001,$70(a6)
	beq.s	LoadExitPar1
	cmp.w	#1003,$70(a6)
	beq.s	LoadExitPar1
	bra.s	LoadExitPar5
LoadExitPar1:
	move.l	$196(a6),a1
	move.l	$18a(a6),a0
	moveq	#$7f,d0
LoadExitPar2:
	move.l	(a1)+,(a0)+
	dbf	d0,LoadExitPar2
	move.l	$18e(a6),a0
	moveq	#$0b,d0
LoadExitPar3:
	move.l	(a1)+,(a0)+
	dbf	d0,LoadExitPar3
	lea	$1c(a6),a0
	moveq	#$0f,d0
LoadExitPar4:
	move.l	(a1)+,(a0)+
	dbf	d0,LoadExitPar4
	move.l	(a1)+,$8a(a6)
	move.w	(a1)+,$8e(a6)
	move.l	(a1)+,$90(a6)
LoadExitPar5:
	movem.l	(a7)+,d0/a0-a1
	rts

ReadAgnus:				;Reads the Custom registers
	movem.l	d0/a0-a2,-(a7)
	move.l	$18a(a6),a0		;DFF000
	lea	-$200(a6),a1		;DFF000 Write Only HARDWARE
	lea	$dff000,a2		;DFF000 Read Only
	move.w	(a2),(a0)		;BLTDDAT
	move.w	$2(a2),d0
	move.w	d0,$002(a0)		;DMACONR
	move.w	d0,$096(a0)		;DMACON
	move.l	$4(a2),d0
	move.l	d0,$004(a0)		;VPOSR
	move.l	d0,$02a(a0)		;VPOSW
	move.w	$8(a2),$008(a0)		;DSKDATR
	move.w	$a(a2),$00a(a0)		;JOY0DAT
	move.w	$c(a2),$00c(a0)		;JOY1DAT
	move.w	$e(a2),$00e(a0)		;CLXDAT
	move.w	$10(a2),d0
	move.w	d0,$010(a0)		;ADKCONR
	move.w	d0,$09e(a0)		;ADKCON
	move.w	$12(a2),$012(a0)	;POT0DAT
	move.w	$14(a2),$014(a0)	;POT1DAT
	move.w	$16(a2),d0
	move.w	d0,$016(a0)		;POTGOR
	move.w	d0,$034(a0)		;POTGO
	move.w	$18(a2),$018(a0)	;SERDATR
	move.w	$1a(a2),$01a(a0)	;DSKBYTR
	move.w	$1c(a2),d0
	move.w	d0,$01c(a0)		;INTENAR
	move.w	d0,$09a(a0)		;INTENA
	move.w	$1e(a2),d0
	move.w	d0,$01e(a0)		;INTREQR
	move.w	d0,$09c(a0)		;INTREQ
	move.l	$20(a1),$020(a0)	;DSKPT
	move.w	$24(a1),$024(a0)	;DSKLEN
	move.w	$26(a1),$026(a0)	;DSKDAT
	move.w	$28(a1),$028(a0)	;REFPTR
	move.w	$2e(a1),$02e(a0)	;COPCON
	move.w	$30(a1),$030(a0)	;SERDAT
	move.w	$32(a1),$032(a0)	;SERPER
	move.w	$36(a1),$036(a0)	;JOYTEST
	move.w	$38(a1),$038(a0)	;STREQU
	move.w	$3a(a1),$03a(a0)	;STRVBL
	move.w	$3c(a1),$03c(a0)	;STRHOR
	move.w	$3e(a1),$03e(a0)	;STRLONG
	move.w	$40(a1),$040(a0)	;BLTCON0
	move.w	$42(a1),$042(a0)	;BLTCON1
	move.w	$44(a1),$044(a0)	;BLTAFWM
	move.w	$46(a1),$046(a0)	;BLTALWM
	move.l	$48(a1),$048(a0)	;BLTCPT
	move.l	$4c(a1),$04c(a0)	;BLTBPT
	move.l	$50(a1),$050(a0)	;BLTAPT
	move.l	$54(a1),$054(a0)	;BLTDPT
	move.w	$58(a1),$058(a0)	;BLTSIZE
	move.w	$60(a1),$060(a0)	;BLTCMOD
	move.w	$62(a1),$062(a0)	;BLTBMOD
	move.w	$64(a1),$064(a0)	;BLTAMOD
	move.w	$66(a1),$066(a0)	;BLTDMOD
	move.w	$70(a1),$070(a0)	;BLTCDAT
	move.w	$72(a1),$072(a0)	;BLTBDAT
	move.w	$74(a1),$074(a0)	;BLTADAT
	move.w	$7e(a1),$07e(a0)	;DSKSYNC
	move.l	$80(a1),$080(a0)	;COP1LC
	move.l	$84(a1),$084(a0)	;COP2LC
	move.w	$88(a1),$088(a0)	;COPJMP1
	move.w	$8a(a1),$08a(a0)	;COPJMP2
	move.w	$8c(a1),$08c(a0)	;COPINS
	move.w	$8e(a1),$08e(a0)	;DIWSTRT
	move.w	$90(a1),$090(a0)	;DIWSTOP
	move.w	$92(a1),$092(a0)	;DDFSTRT
	move.w	$94(a1),$094(a0)	;DDFSTOP
	move.w	$98(a1),$098(a0)	;CLXCON
	move.w	#$00a0,d0		;AUDxLC,-LEN,-PER,-VOL,-DAT
ReadAgnus1:
	move.l	$00(a1,d0.w),$00(a0,d0.w)
	move.l	$10(a1,d0.w),$10(a0,d0.w)
	move.l	$20(a1,d0.w),$20(a0,d0.w)
	move.l	$30(a1,d0.w),$30(a0,d0.w)
	addq.l	#4,d0
	cmp.w	#$00ac,d0
	bne.s	ReadAgnus1
	move.w	#$00e0,d0		;BPLxPT
ReadAgnus2:
	move.l	0(a1,d0.w),0(a0,d0.w)
	addq.w	#4,d0
	cmp.w	#$00f8,d0
	bne.s	ReadAgnus2
	move.w	$100(a1),$100(a0)	;BPLCON0
	move.w	$102(a1),$102(a0)	;BPLCON1
	move.w	$104(a1),$104(a0)	;BPLCON2
	move.w	$108(a1),$108(a0)	;BPL1MOD
	move.w	$10a(a1),$10a(a0)	;BPL2MOD
	move.w	$110(a1),$110(a0)	;BPL1DAT
	move.w	$112(a1),$112(a0)	;BPL2DAT
	move.w	$114(a1),$114(a0)	;BPL3DAT
	move.w	$116(a1),$116(a0)	;BPL4DAT
	move.w	$118(a1),$118(a0)	;BPL5DAT
	move.w	$11a(a1),$11a(a0)	;BPL6DAT
	move.w	#$0120,d0
ReadAgnus3:
	move.l	0(a1,d0.w),0(a0,d0.w)
	addq.w	#4,d0
	cmp.w	#$01c0,d0
	bne.s	ReadAgnus3
	movem.l	(a7)+,d0/a0-a2
	rts

WriteAgnus:				;Writes back the Custom registers
	movem.l	d0/a0-a1,-(a7)
	move.l	$18a(a6),a0
	lea	$dff000,a1
	move.l	$20(a0),$20(a1)		;DSKPT
	move.l	$2a(a0),$2a(a1)		;VPOSW
	move.w	$2e(a0),$2e(a1)		;COPCON
	move.l	$30(a0),$30(a1)		;SERDAT,SERPER
	move.l	$34(a0),$34(a1)		;POTGO,JOYTEST
	move.l	$40(a0),$40(a1)		;BLTCON0,BLTCON1
	move.l	$44(a0),$44(a1)		;BLTAFWM,BLTALWM
	move.l	$48(a0),$48(a1)		;BLTCPT
	move.l	$4c(a0),$4c(a1)		;BLTBPT
	move.l	$50(a0),$50(a1)		;BLTAPT
	move.l	$54(a0),$54(a1)		;BLTDPT
	move.l	$60(a0),$60(a1)		;BLTCMOD,BLTBMOD
	move.l	$64(a0),$64(a1)		;BLTAMOD,BLTDMOD
	move.l	$70(a0),$70(a1)		;BLTCDAT,BLTBDAT
	move.w	$74(a0),$74(a1)		;BLTADAT
	move.w	$7e(a0),$7e(a1)		;DSKSYNC
*	move.l	$80(a0),$80(a1)		;COP1LC
*	move.l	$84(a0),$84(a1)		;COP2LC
	move.l	$8e(a0),$8e(a1)		;DIWSTRT,DIWSTOP
	move.l	$92(a0),$92(a1)		;DDFSTRT,DDFSTOP
	move.w	$96(a0),d0
	or.w	#$8000,d0
	move.w	#$07ff,$96(a1)
	move.w	d0,$96(a1)		;DMACON
	move.w	$98(a0),$98(a1)		;CLXCON
	move.w	$9a(a0),d0
	or.w	#$8000,d0
	move.w	#$7fff,$9a(a1)
	move.w	d0,$9a(a1)		;INTENA
	move.w	$9c(a0),d0
	or.w	#$8000,d0
	move.w	#$7fff,$9c(a1)
	move.w	d0,$9c(a1)		;INTREQ
	move.w	$9e(a0),d0
	or.w	#$8000,d0
	move.w	#$7fff,$9e(a1)
	move.w	d0,$9e(a1)		;ADKCON
	move.w	#$00a0,d0		;AUDxLC,-LEN,-PER,-VOL,-DAT
WriteAgnus1:
	move.l	$00(a0,d0.w),$00(a1,d0.w)
	move.l	$10(a0,d0.w),$10(a1,d0.w)
	move.l	$20(a0,d0.w),$20(a1,d0.w)
	move.l	$30(a0,d0.w),$30(a1,d0.w)
	addq.l	#4,d0
	cmp.w	#$00ac,d0
	bne.s	WriteAgnus1
	move.w	#$00e0,d0		;BPLxPT
WriteAgnus2:
	move.l	0(a0,d0.w),0(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#$00f8,d0
	bne.s	WriteAgnus2
	move.w	$100(a0),$100(a1)	;BPLCON0
	move.w	$102(a0),$102(a1)	;BPLCON1
	move.w	$104(a0),$104(a1)	;BPLCON2
	move.w	$108(a0),$108(a1)	;BPL1MOD
	move.w	$10a(a0),$10a(a1)	;BPL2MOD
	move.w	$110(a0),$110(a1)	;BPL1DAT
	move.w	$112(a0),$112(a1)	;BPL2DAT
	move.w	$114(a0),$114(a1)	;BPL3DAT
	move.w	$116(a0),$116(a1)	;BPL4DAT
	move.w	$118(a0),$118(a1)	;BPL5DAT
	move.w	$11a(a0),$11a(a1)	;BPL6DAT
	move.w	#$0120,d0
WriteAgnus3:
	move.l	0(a0,d0.w),0(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#$01c0,d0
	bne.s	WriteAgnus3
	movem.l	(a7)+,d0/a0-a1
	rts

ReadCIA:				;Reads the CIA registers
	movem.l	d0-d4/a0-a2,-(a7)
	move.l	$18e(a6),a0		;CIA
	lea	$bfd000,a1		;CIAB Hardware address
	lea	$dff000,a2
	move.w	#$2000,d2		;EXTER
	bsr.s	ReadCIA1
	lea	$18(a0),a0
	lea	$bfe001,a1		;CIAA Hardware address
	move.w	#$0008,d2		;PORTS
	bsr.s	ReadCIA1
	movem.l	(a7)+,d0-d4/a0-a2
	rts

ReadCIA1:
	move.b	$000(a1),$0(a0)		;PRA
	move.b	$100(a1),$1(a0)		;PRB
	move.b	$200(a1),$2(a0)		;DDRA
	move.b	$300(a1),$3(a0)		;DDRB
	move.b	$e00(a1),$e(a0)		;CRA
	move.b	$f00(a1),$f(a0)		;CRB
	moveq	#$00,d4
	move.b	d4,$e00(a1)	;turn off timer a
	move.b	d4,$f00(a1)	;turn off timer b
	move.b	$400(a1),$4(a0)		;TALO
	move.b	$500(a1),$5(a0)		;TAHI
	move.b	$600(a1),$6(a0)		;TBLO
	move.b	$700(a1),$7(a0)		;TBHI
	move.b	$a00(a1),$a(a0)		;Event MSB
	move.b	$900(a1),$9(a0)		;Event 8-15
	move.b	$800(a1),$8(a0)		;Event LSB
	move.b	$c00(a1),$c(a0)		;SDR
	move.b	$d00(a1),$14(a0)	;ICR request
	move.b	#$10,$e00(a1)	;force load timer a
	move.b	#$10,$f00(a1)	;force load timer a
	move.b	$400(a1),$10(a0)	;TALO latch
	move.b	$500(a1),$11(a0)	;TAHI latch
	move.b	$600(a1),$12(a0)	;TBLO latch
	move.b	$700(a1),$13(a0)	;TBHI latch
	moveq	#$00,d1
	move.b	#$10,$d00(a1)
	move.b	d4,$a00(a1)		;Stop TOD
	or.b	#$40,$e00(a1)		;Set Serial to output
	tst.b	$d00(a1)
	move.w	d2,$9c(a2)
	move.b	#$01,$400(a1)
	move.b	d4,$500(a1)
	move.b	#$59,$e00(a1)
	moveq	#$01,d3			;TA
	bsr.s	ReadCIA2
	move.b	#$01,$600(a1)
	move.b	d4,$700(a1)
	move.b	#$19,$f00(a1)
	moveq	#$02,d3			;TB
	bsr.s	ReadCIA2
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	#$01,$800(a1)
	move.b	#$80,$f00(a1)
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	d4,$800(a1)
	move.b	d4,$f00(a1)
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	d4,$800(a1)
	moveq	#$04,d3			;ALRM
	bsr.s	ReadCIA2
	move.b	#$51,$e00(a1)
	move.b	$c00(a1),$c00(a1)
	moveq	#$08,d3			;SP
	bsr.s	ReadCIA2
	move.b	d1,$d(a0)		;ICR
	move.b	d4,$e00(a1)
	rts

ReadCIA2:
	move.b	$d00(a1),d0
	and.b	d3,d0
	beq.s	ReadCIA2
	and.w	d2,$1e(a2)
	beq.s	ReadCIA3
	or.b	d3,d1
ReadCIA3:
	move.b	d3,$d00(a1)
	move.w	d2,$9c(a2)
	rts

WriteCIA:				;Writes back the CIA registers
	movem.l	d0/a0-a1,-(a7)
	move.l	$18e(a6),a0
	lea	$bfd000,a1
	bsr.s	WriteCIA1
	lea	$18(a0),a0
	lea	$bfe001,a1
	bsr.s	WriteCIA1
	movem.l	(a7)+,d0/a0-a1
	rts
WriteCIA1:
	moveq	#$00,d0
	move.b	d0,$e00(a1)
	move.b	d0,$f00(a1)
	move.b	#$0f,$d00(a1)
	tst.b	$d00(a1)
	move.b	$2(a0),$200(a1)
	move.b	$0(a0),$000(a1)
	move.b	$3(a0),$300(a1)
	move.b	$1(a0),$100(a1)
	move.b	$4(a0),$400(a1)
	move.b	$5(a0),$500(a1)
	move.b	$6(a0),$600(a1)
	move.b	$7(a0),$700(a1)
	move.b	$a(a0),$a00(a1)
	move.b	$9(a0),$900(a1)
	move.b	$8(a0),$800(a1)
	move.b	$e(a0),d0
	or.b	#$10,d0
	move.b	d0,$e00(a1)
	move.b	$f(a0),d0
	or.b	#$10,d0
	move.b	d0,$f00(a1)
	move.b	$10(a0),$400(a1)
	move.b	$11(a0),$500(a1)
	move.b	$12(a0),$600(a1)
	move.b	$13(a0),$700(a1)
	move.b	$d(a0),d0
	or.b	#$80,d0
	move.b	d0,$d00(a1)
	rts

FindROMKeymap:				;Find the Rom UsaKeymap
	movem.l	d0/a0-a1,-(a7)
	move.l	$60(a6),a0
	move.l	-(a0),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a1
	cmp.l	#$75736100,(a1)
	beq.s	FindROMKeymap3
FindROMKeymap1:
	lea	$f80000,a0
FindROMKeymap2:
	addq.l	#2,a0
	move.l	(a0),d0
	and.l	#$00fffffe,d0
	cmp.l	#$00f00000,d0
	bls.s	FindROMKeymap2
	move.l	d0,a1
	cmp.l	#$75736100,(a1)		;usa
	bne.s	FindROMKeymap2
FindROMKeymap3:
	addq.l	#4,a0
	move.l	a0,$60(a6)
	movem.l	(a7)+,d0/a0-a1
	rts

FindROMFont:				;Searches for the ROM Topazfont
	movem.l	d0/a0-a1,-(a7)
	move.l	$18(a6),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a0
	cmp.l	#$94140008,4(a0)	;topaz 8
	bne.s	FindROMFont1
	move.l	(a0),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a1
	cmp.l	#"topa",(a1)		;topaz.font
	beq.s	FindROMFont3
FindROMFont1:
	lea	$f80000,a0
FindROMFont2:
	addq.l	#2,a0
	cmp.l	#$94140008,(a0)		;topaz 8
	bne.s	FindROMFont2
	move.l	-(a0),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a1
	cmp.l	#"topa",(a1)		;topaz.font
	bne.s	FindROMFont2
FindROMFont3:
	move.l	$14(a0),$c(a6)
	move.l	$1a(a0),$10(a6)
	move.l	a0,$18(a6)
	movem.l	(a7)+,d0/a0-a1
	rts

FindAgnusChip:				;Searches for the Custom Chips
	movem.l	d0/a0,-(a7)
	lea	$c00000,a0
FindAgnusChip1:
	move.w	$6(a0),d0
	cmp.w	$6(a0),d0
	bne.s	FindAgnusChip2
	add.l	#$040000,a0
	cmp.l	#$dc0000,a0
	bne.s	FindAgnusChip1
FindAgnusChip2:
	move.l	a0,d0
	subq.l	#1,d0
	move.l	d0,$14(a6)
	movem.l	(a7)+,d0/a0
	rts

MakePrefs:				;Makes the Preferences
	movem.l	d0/a0,-(a7)
	lea	Prend,a0
	move.l	#$0000c0,(a6)
	move.l	a0,$4(a6)
	move.w	$72(a6),d0		;Checksum
	add.w	$8(a6),d0
	add.w	$a(a6),d0
	add.w	$1a2(a6),d0
	not.w	d0
	beq.s	MakePrefs1
	move.w	#$0888,$8(a6)
	move.w	#$0ccc,$a(a6)
	move.w	#$0fff,$1a2(a6)
	move.w	#$0444,$1f4(a6)
MakePrefs1:
	move.w	$192(a6),d0		;Checksum
	add.w	$5c(a6),d0
	add.w	$5e(a6),d0
	add.w	$14a(a6),d0
	add.w	$14c(a6),d0
	not.w	d0
	beq.s	MakePrefs2
	clr.w	$5c(a6)
	clr.w	$5e(a6)
	clr.w	$14a(a6)
MakePrefs2:
	move.l	a0,$64(a6)
	add.l	#$000a50,$64(a6)
	clr.l	$68(a6)
	move.w	#$00ff,$6c(a6)
	clr.w	$6e(a6)
	clr.b	$74(a6)
	move.l	a0,$76(a6)
	add.l	#$000b50,$76(a6)
	move.l	a0,$7a(a6)
	add.l	#$000c50,$7a(a6)
	move.l	a0,$7e(a6)
	add.l	#$000e50,$7e(a6)
	move.l	#$005400,$82(a6)
	move.l	a0,$86(a6)
	add.l	#$002650,$86(a6)
	clr.l	$118(a6)
	move.w	$194(a6),d0		;Checksum
	add.b	$11d(a6),d0
	add.w	$11e(a6),d0
	not.w	d0
	beq.s	MakePrefs3
	move.w	#$ffff,$11e(a6)
MakePrefs3:
	move.l	a0,$120(a6)
	add.l	#$001050,$120(a6)
	move.b	#$ff,$125(a6)
	move.w	#$0001,$126(a6)
	move.l	#$005340,$128(a6)
	move.w	#$0d22,$132(a6)
	move.w	#$0000,$134(a6)
	move.w	#$0fca,$136(a6)
	clr.w	$138(a6)
	move.l	a0,$13e(a6)
	add.l	#$00ad90,$13e(a6)
	move.w	#$0021,$14c(a6)		;Nr of Lines
	move.l	a0,$160(a6)
	add.l	#$00af90,$160(a6)
	move.l	a0,$174(a6)
	add.l	#$00b190,$174(a6)
	move.w	#$ffff,$180(a6)
	move.l	a0,$18a(a6)
	add.l	#$00bbe0,$18a(a6)
	move.l	a0,$18e(a6)
	add.l	#$00bde0,$18e(a6)
	move.l	a0,$196(a6)
	add.l	#$00be10,$196(a6)
	move.l	a0,$19c(a6)
	add.l	#$00c090,$19c(a6)
	clr.w	$1a8(a6)
	move.l	a0,$1c4(a6)
	add.l	#$00c0e0,$1c4(a6)
	move.l	a0,$1ea(a6)
	add.l	#$00c100,$1ea(a6)
	move.l	#$005380,$1f0(a6)
	move.l	a0,$1f6(a6)
	add.l	#$00c150,$1f6(a6)
	movem.l	(a7)+,d0/a0
	rts

MakePrefsCheck:				;Checksum the Preferences
	move.l	d0,-(a7)
	moveq	#$ffffffff,d0
	sub.w	$8(a6),d0
	sub.w	$a(a6),d0
	sub.w	$1a2(a6),d0
	sub.w	$1f4(a6),d0
	move.w	d0,$72(a6)
	moveq	#$ffffffff,d0
	sub.w	$5c(a6),d0
	sub.w	$5e(a6),d0
	sub.w	$14a(a6),d0
	sub.w	$14c(a6),d0
	move.w	d0,$192(a6)
	moveq	#$ffffffff,d0
	sub.w	$11e(a6),d0
	sub.b	$11d(a6),d0
	move.w	d0,$194(a6)
	move.l	(a7)+,d0
	rts

FindScreenLastLine:			;Checks the TV-System PAL/NTSC
	movem.l	d0-d2/a0,-(a7)
	lea	$dff004,a0
	move.l	#$0001ff00,d2
	move.l	(a0),d1
	and.l	d2,d1
FindScreenLastLine1:
	move.l	d1,d0
	move.l	(a0),d1
	and.l	d2,d1
	cmp.l	d1,d0
	bls.s	FindScreenLastLine1
	cmp.l	#$00010000,d0
	bls.s	FindScreenLastLine1
	lsr.l	#8,d0
	sub.w	#$0038,d0
	lsr.w	#3,d0
	move.w	d0,$14c(a6)	;ScreenLastLine
	addq.w	#1,$14c(a6)
	lsl.w	#3,d0
	add.w	#$002c,d0
	move.w	d0,$1a0(a6)	;LastRasterLine
	movem.l	(a7)+,d0-d2/a0
	rts

AdressErrorIRQ:
	moveq	#$0d,d7		;Adress Error
	bra	ErrorHandler

LevelSevenIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelSevenIRQExit
	and.w	$001e(a5),d0		;INTREQR
LevelSevenIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

LevelSixIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelSixIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#13,d0
	bne.s	CIABIRQ
	btst	#14,d0
	bne.s	MasterIRQ
LevelSixIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

MasterIRQ:
	move.w	#$4000,$009c(a5)	;INTREQ
	bra.s	LevelSixIRQExit

CIABIRQ:
	move.l	a4,-(a7)
	lea	$00c00000,a4
	move.b	$ffffdd00(a4),d0
	or.b	$01bc(a6),d0		;CIAB_IRQ_REQ
	move.b	d0,$01bc(a6)
CIABIRQ1:
	move.b	$1bc(a6),d0
	and.b	$1bd(a6),d0		;CIAB_IRQ_ENA
	beq.s	CIABIRQ2
	bclr	#0,$1bc(a6)
	lsr.b	#1,d0			;TA
	bcs.s	CIABTimerA
	bclr	#1,$1bc(a6)
	lsr.b	#1,d0			;TB
	bcs.s	CIABTimerB
	bclr	#2,$1bc(a6)
	lsr.b	#1,d0			;ALRM
	bcs.s	RasterIRQ
	bclr	#3,$1bc(a6)
	lsr.b	#1,d0			;SP
	bcs	CIABSerialPort
	bclr	#4,$1bc(a6)
	lsr.b	#1,d0			;FLAG
	bcs	CIABFlag
CIABIRQ2:
	move.w	#$2000,$009c(a5)	;INTREQ
	move.l	(a7)+,a4
	bra.s	LevelSixIRQExit

CIABTimerA:
	or.w	#$0001,$19a(a6)		;Timer A
	and.b	#$fe,$ffffde00(a4)	;Timer A OFF
	move.b	#$01,$ffffdd00(a4)	;Timer A IRQ Disable
	bclr	#0,$1bd(a6)
	bra.s	CIABIRQ1

CIABTimerB:
	or.w	#$0002,$19a(a6)		;Timer B
	and.b	#$fe,$ffffdf00(a4)	;Timer B OFF
	move.b	#$02,$ffffdd00(a4)	;Timer B IRQ Disable
	bclr	#1,$1bd(a6)
	bra.s	CIABIRQ1

* Raster Type Definition: *
* Bit 0 - Screen Start Line *
* Bit 1 - Screen Wrap Line *
* Bit 2 - Screen Info Line *
* Bit 3 - Screen Wrap+Info Line *
* Bit 4 - Screen End Line *
RasterIRQ:
	move.w	$14e(a6),d1		;RasterLine
	move.b	$1a9(a6),d2
	lsr.b	#1,d2
	bcs.s	RasterIRQ1
	lsr.b	#1,d2
	bcs.s	RasterIRQ2
	lsr.b	#1,d2
	bcs.s	RasterIRQ3
	lsr.b	#1,d2
	bcs.s	RasterIRQ4
	lsr.b	#1,d2
	bcs.s	RasterIRQ5
	bra	CIABIRQ1
RasterIRQ1:				;Start Screen
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ1
	addq.b	#1,$75(a6)		;Screen Blank over
	bra.s	RasterIRQ6
RasterIRQ2:				;Wrap Screen
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ2
	move.l	$00(a6),$e0(a5)
	bra.s	RasterIRQ6
RasterIRQ3:				;Info
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ3
	move.w	$1a2(a6),$182(a5)
	bra.s	RasterIRQ6
RasterIRQ4:				;Swap Screen + Info
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ4
	move.l	$00(a6),$e0(a5)
	move.w	$1a2(a6),$182(a5)
	bra.s	RasterIRQ6
RasterIRQ5:
	clr.b	$75(a6)			;Blank Screen
	bsr	MakeMoButEvents
	tst.b	$6d(a6)
	bmi.s	RasterIRQ6
	addq.w	#1,$6e(a6)
	cmp.w	#$0019,$6e(a6)
	bne.s	RasterIRQ6
	movem.l	d6/d7/a1/a2,-(a7)
	bsr	Keyboardrepeat
	movem.l	(a7)+,d6/d7/a1/a2
	subq.w	#$1,$6e(a6)
RasterIRQ6:
	moveq	#$02,d2
	move.w	$1a6(a6),d1		;Wrap Screen Line
	cmp.w	$14e(a6),d1
	bls.s	RasterIRQ7
	cmp.w	$1a0(a6),d1		;End Line
	beq.s	RasterIRQ7
	cmp.w	$1a4(a6),d1		;RasterLine
	bne.s	RasterIRQ9
	moveq	#$08,d2
	bra.s	RasterIRQ9
RasterIRQ7:
	moveq	#$04,d2
	move.w	$1a4(a6),d1		;Info Line
	cmp.w	$14e(a6),d1
	bls.s	RasterIRQ8
	cmp.w	$1a0(a6),d1
	bne.s	RasterIRQ9
RasterIRQ8:
	moveq	#$10,d2
	move.w	$1a0(a6),d1
RasterIRQ9:
	move.b	d2,$1a9(a6)
	move.w	d1,$14e(a6)
	subq.w	#2,d1
	move.b	d1,$ffffd800(a4)
	move.w	d1,$ffffd900(a4)
	bra	CIABIRQ1

CIABSerialPort:
	bra	CIABIRQ1

CIABFlag:
	bra	CIABIRQ1

LevelFiveIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelFiveIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#11,d0
	bne.s	SerialPortFullIRQ
	btst	#12,d0
	bne.s	DiskSyncIRQ
LevelFiveIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

SerialPortFullIRQ:
	move.w	#$0800,$009c(a5)	;INTREQ
	bra.s	LevelFiveIRQExit

DiskSyncIRQ:
	move.w	#$1000,$009c(a5)	;INTREQ
	bra.s	LevelFiveIRQExit

LevelFourIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelFourIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#7,d0
	bne.s	Audio0IRQ
	btst	#8,d0
	bne.s	Audio1IRQ
	btst	#9,d0
	bne.s	Audio2IRQ
	btst	#10,d0
	bne.s	Audio3IRQ
LevelFourIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

Audio0IRQ:
	move.w	#$0080,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

Audio1IRQ:
	move.w	#$0100,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

Audio2IRQ:
	move.w	#$0200,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

Audio3IRQ:
	move.w	#$0400,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

LevelThreeIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelThreeIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#4,d0
	bne.s	CopperIRQ
	btst	#5,d0
	bne.s	VertBlankIRQ
	btst	#6,d0
	bne	BlitterFinIRQ
LevelThreeIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

CopperIRQ:
	move.w	#$0010,$009c(a5)	;INTREQ
	bra.s	LevelThreeIRQExit

VertBlankIRQ:
	move.w	$08(a6),$180(a5)	;COLOR TABLE 00
	move.w	$0a(a6),$182(a5)	;COLOR TABLE 01
	move.w	#$2c81,$8e(a5)		;DIWSTRT
	move.w	$1a0(a6),d0		;LastRasterLine
	lsl.w	#8,d0
	or.w	#$00c1,d0
	move.w	d0,$90(a5)		;DIWSTOP
	move.w	#$003c,$92(a5)		;DDFSTRT
	move.w	#$00d0,$94(a5)		;DDFSTOP
	move.w	#$9200,$100(a5)		;BPLCON0
	clr.w	$102(a5)		;BPLCON1
	move.w	#$0009,$104(a5)		;BPLCON2
	clr.l	$108(a5)		;BPL1MOD
	move.w	#$8300,$96(a5)		;DMACON
	bsr	ShowPointer
	bsr	ShowScreen
	bsr	ReadMouseButtons
	cmp.w	#$1234,$138(a6)
	beq.s	VertBlankIRQ1
	bsr	DiskCheck
VertBlankIRQ1:
	btst	#7,$bfe001
	beq	ProgramDebug
	move.w	#$0020,$009c(a5)	;INTREQ
	bra.s	LevelThreeIRQExit

BlitterFinIRQ:
	move.w	#$0040,$009c(a5)	;INTREQ
	bra	LevelThreeIRQExit

LevelTwoIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelTwoIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#3,d0
	bne.s	CIAAIRQ
LevelTwoIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

CIAAIRQ:
	move.l	a4,-(a7)
	lea	$00c00000,a4
	move.b	$ffffed01(a4),d0
	or.b	$01be(a6),d0		;CIAB_IRQ_REQ
	move.b	d0,$01be(a6)
CIAAIRQ1:
	move.b	$1be(a6),d0
	and.b	$1bf(a6),d0		;CIAB_IRQ_ENA
	beq.s	CIAAIRQ2
	bclr	#0,$1be(a6)
	lsr.b	#1,d0			;TA
	bcs.s	CIAATimerA
	bclr	#1,$1be(a6)
	lsr.b	#1,d0			;TB
	bcs.s	CIAATimerB
	bclr	#2,$1be(a6)
	lsr.b	#1,d0			;ALRM
	bcs.s	CIAAAlarm
	bclr	#3,$1be(a6)
	lsr.b	#1,d0			;SP
	bcs.s	CIAASerialPort
	bclr	#4,$1be(a6)
	lsr.b	#1,d0			;FLAG
	bcs	CIAAFlag
CIAAIRQ2:
	move.w	#$0008,$009c(a5)	;INTREQ
	move.l	(a7)+,a4
	bra.s	LevelTwoIRQExit

CIAATimerA:
	or.w	#$0100,$19a(a6)		;Timer A
	and.b	#$fe,$ffffee01(a4)	;Timer A OFF
	move.b	#$01,$ffffed01(a4)	;Timer A IRQ Disable
	bclr	#0,$1bf(a6)
	bra.s	CIAAIRQ1

CIAATimerB:
	or.w	#$0200,$19a(a6)		;Timer B
	and.b	#$fe,$ffffef01(a4)	;Timer B OFF
	move.b	#$02,$ffffed01(a4)	;Timer B IRQ Disable
	bclr	#1,$1bf(a6)
	bra.s	CIAAIRQ1

CIAAAlarm:
	bra.s	CIAAIRQ1

CIAASerialPort:
	move.l	d0,d1
	move.b	$ffffec01(a4),d0

	and.w	#$fffd,$19a(a6)		;Wait for 85 microsec.
	move.b	#$3c,$ffffd600(a4)	;Timer B Low
	move.b	#$00,$ffffd700(a4)	;Timer B High
	and.b	#$fd,$1bc(a6)
	or.b	#$02,$1bd(a6)
	move.b	#$82,$ffffdd00(a4)	;Timer B IRQ Enable
	and.b	#$80,$ffffdf00(a4)
	or.b	#$40,$ffffee01(a4)	;Set Serial to output
	or.b	#$11,$ffffdf00(a4)	;Timer B Load & Start

	not.b	d0
	ror.b	#1,d0
	move.b	d0,$6d(a6)		;Last Key
	move.w	#$0000,$6e(a6)		;Repeat Counter
	bsr	Keyboard
CIAASerialPort1:
	move.w	$19a(a6),d0
	and.w	#$0002,d0
	beq.s	CIAASerialPort1
	and.b	#$bf,$ffffee01(a4)	;Set Serial to input
	move.l	d1,d0
	bra	CIAAIRQ1

CIAAFlag:
	bra	CIAAIRQ1

LevelOneIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	Preferences,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelOneIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#0,d0
	bne.s	SerialPortEmptyIRQ
	btst	#1,d0
	bne.s	DiskBlockIRQ
	btst	#2,d0
	bne.s	SoftwareIRQ
LevelOneIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

SerialPortEmptyIRQ:
	move.w	#$0001,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

DiskBlockIRQ:
	move.w	#$0002,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

SoftwareIRQ:
	move.w	#$0004,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

ShowScreen:				;Shows the Screen
	movem.l	d0/d1/a0,-(a7)
	and.b	#$7f,$bfdf00
	move.b	#$00,$bfda00
	move.b	$0005(a5),d0		;VPOSR - V8
	and.b	#$01,d0
	move.b	d0,$bfd900
	move.b	$0006(a5),d0
ShowScreen1:
	cmp.b	$0006(a5),d0
	beq.s	ShowScreen1
	move.b	$0006(a5),$bfd800	;VHPOSR - V7-V0
	or.b	#$80,$bfdf00
	move.w	$1a0(a6),d0
	tst.b	$1a8(a6)		;InfoLine Enable
	beq.s	ShowScreen2
	subq.w	#8,d0
ShowScreen2:
	move.w	d0,$1a4(a6)
	move.w	$14c(a6),d0
	move.w	$14a(a6),d1
	sub.w	d1,d0
	lsl.w	#3,d0
	add.w	#$002c,d0
	cmp.w	$1a0(a6),d0		;LastRasterLine
	blt.s	ShowScreen3
	move.w	$1a0(a6),d0
ShowScreen3:
	move.w	d0,$1a6(a6)		;SwapscreenRasterLine
	move.w	#$002c,d0
	move.w	d0,$14e(a6)
	move.b	#$01,$1a9(a6)
	subq.w	#2,d0
	move.b	d0,$bfd800
	move.w	d0,$bfd900
	clr.b	$bfda00
	lsl.w	#7,d1
	move.w	d1,d0
	lsl.w	#2,d1
	add.w	d1,d0
	ext.l	d0
	add.l	$00(a6),d0
	move.l	d0,$00e0(a5)
	movem.l	(a7)+,d0/d1/a0
	rts

ProgramDebug:
	move.l	#$40000,d0
ProgramDebug1:
	subq.l	#1,d0
	bne.s	ProgramDebug1
	movem.l	(a7)+,d0-d2/a5/a6
	bra	Start4

Keyboard:				;Makes Keyboard events
					;D0=Rawkey
	movem.l	d0-d7/a0-a4,-(a7)
	move.l	$60(a6),a0
	move.l	$64(a6),a2		;Keyboardbuffer
	move.w	$68(a6),d7		;Keyboardbuffer index
	move.w	d0,d1
	and.w	#$007f,d1
	cmp.w	#$0060,d1
	bcc	KeyboardVanilla
	tst.b	d0
	bmi	KeyboardExit
	cmp.w	#$000f,d1
	beq	KeyboardKeypad1
	cmp.w	#$001f,d1
	bhi.s	KeyboardNum1
	cmp.w	#$001d,d1
	bge	KeyboardKeypad2
KeyboardNum1:
	cmp.w	#$002f,d1
	bhi.s	KeyboardNum2
	cmp.w	#$002d,d1
	bge	KeyboardKeypad3
KeyboardNum2:
	cmp.w	#$003f,d1
	bhi.s	KeyboardNum3
	cmp.w	#$003c,d1
	bge	KeyboardKeypad4
KeyboardNum3:
	cmp.w	#$0043,d1
	beq	KeyboardKeypad5
	cmp.w	#$004a,d1
	beq	KeyboardKeypad6
	cmp.w	#$005e,d1
	bhi.s	KeyboardNum4
	cmp.w	#$005a,d1
	bge	KeyboardKeypad7
KeyboardNum4:
	cmp.w	#$004f,d1
	bhi.s	KeyboardCur1
	cmp.w	#$004c,d1
	bge	KeyboardCursor1
KeyboardCur1:
	cmp.w	#$0040,d1		;Lo or Hi
	bcs.s	Keyboard1
	lea	$10(a0),a0
	sub.w	#$0040,d1
Keyboard1:
	move.l	$8(a0),a1		;Caps Lock
	move.w	d1,d2
	move.w	d2,d3
	and.w	#$0007,d2
	lsr.w	#3,d3
	lea	0(a1,d3.w),a1
	move.b	$6b(a6),d0
	btst	d2,(a1)
	beq.s	Keyboard2
	move.b	$6c(a6),d0
	and.b	#$01,d0
	or.b	$6b(a6),d0		;d0 = vanillakeys
Keyboard2:
	move.l	$c(a0),a1		;Repeatable
	lea	0(a1,d3.w),a1
	btst	d2,(a1)
	bne.s	Keyboard3
	or.b	#$80,$6d(a6)		;No repeat
Keyboard3:
	move.l	(a0)+,a1		;Keymaptypes
	move.b	0(a1,d1.w),d2
	and.b	d2,d0			;Get valid vanillakeys
	move.l	(a0)+,a1		;Keymap
	lsl.w	#2,d1
	lea	0(a1,d1.w),a1
	btst	#5,d2
	bne.s	KeyboardDead
	btst	#6,d2
	bne.s	KeyboardString
	move.b	d0,d1
	eor.w	#$03,d1
	and.w	#$03,d1
	move.b	0(a1,d1.w),d1
	btst	#2,d0
	beq.s	Keyboard4
	and.b	#$9f,d1
Keyboard4:
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	clr.b	$6a(a6)
	bra	KeyboardExit
KeyboardDead:
	move.l	(a1),a1
	and.w	#$0007,d0
	add.w	d0,d0
	move.b	1(a1,d0.w),d1
	move.b	0(a1,d0.w),d0
	cmp.b	#$01,d0
	beq.s	KeyboardDead1		;MOD
	cmp.b	#$08,d0
	beq.s	KeyboardDead2		;DEAD
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	clr.b	$6a(a6)
	bra	KeyboardExit

KeyboardDead1:
	ext.w	d1
	lea	0(a1,d1.w),a1
	move.b	$6a(a6),d1
	ext.w	d1
	clr.b	$6a(a6)
	move.b	0(a1,d1.w),d1
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	bra	KeyboardExit
KeyboardDead2:
	move.b	d1,$6a(a6)
	bra	KeyboardExit
KeyboardString:
	move.l	(a1),a1
	and.w	#$0007,d0
	add.w	d0,d0
	move.b	1(a1,d0.w),d1
	move.b	0(a1,d0.w),d0
	ext.w	d1
	lea	0(a1,d1.w),a1
KeyboardString2:
	move.b	(a1)+,0(a2,d7.w)
	addq.w	#1,d7
	subq.b	#1,d0
	bne.s	KeyboardString2
	bra	KeyboardExit

KeyboardCursor1:		;CRSR UP/DOWN/RIGHT/LEFT
	moveq	#$01,d0
	cmp.w	#$004c,d1
	beq	KeyboardKeypad8
	moveq	#$06,d0
	cmp.w	#$004d,d1
	beq	KeyboardKeypad8
	moveq	#$04,d0
	cmp.w	#$004e,d1
	beq	KeyboardKeypad8
	moveq	#$03,d0
	bra	KeyboardKeypad8

KeyboardKeypad1:		;$0F		,"0"
	moveq	#$30,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne	KeyboardKeypad10
	moveq	#$08,d0
	bra	KeyboardKeypad8

KeyboardKeypad2:		;$1D-$1F	;"123"
	move.b	d1,d0
	sub.w	#$001c,d0
	or.w	#$0030,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne	KeyboardKeypad10
	addq.b	#4,d0
	bra	KeyboardKeypad8

KeyboardKeypad3:		;$2D-$2F	;"456"
	move.b	d1,d0
	sub.w	#$0029,d0
	or.w	#$0030,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne	KeyboardKeypad10
	cmp.w	#$002e,d1
	beq	KeyboardExit
	moveq	#$03,d0
	cmp.w	#$002d,d1
	beq	KeyboardKeypad8
	moveq	#$04,d0
	bra	KeyboardKeypad8

KeyboardKeypad4:		;$3C-$3F	;".789"
	move.b	d1,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne.s	KeyboardKeypad4a
	sub.w	#$003d,d0
	cmp.w	#$003c,d1
	bne.s	KeyboardKeypad8
	moveq	#$09,d0
	bra.s	KeyboardKeypad8
KeyboardKeypad4a:
	sub.w	#$0036,d0
	or.w	#$0030,d0
	cmp.w	#$003c,d1
	bne	KeyboardKeypad10
	moveq	#$2e,d0
	bra	KeyboardKeypad10

KeyboardKeypad5:		;$43		;"Enter"
	moveq	#$0d,d0
	bra	KeyboardKeypad10

KeyboardKeypad6:		;$4A		;"-"
	moveq	#$2d,d0
	bra	KeyboardKeypad10

KeyboardKeypad7:		;$5A-5E		;"()/*+"
	move.b	d1,d0
	btst	#1,$6b(a6)			;ALT
	beq.s	KeyboardKeypad7a
	moveq	#$02,d0
	cmp.w	#$005d,d1
	beq.s	KeyboardKeypad9
	moveq	#$01,d0
	cmp.w	#$005b,d1
	beq.s	KeyboardKeypad9
	cmp.w	#$005a,d1
	bne.s	KeyboardKeypad7a
	bchg	#1,$6c(a6)
	moveq	#$00,d0
	bra.s	KeyboardKeypad9
KeyboardKeypad7a:
	moveq	#$28,d0				;"("
	cmp.w	#$005a,d1
	beq.s	KeyboardKeypad10
	moveq	#$29,d0				;")"
	cmp.w	#$005b,d1
	beq.s	KeyboardKeypad10
	moveq	#$2f,d0				;"/"
	cmp.w	#$005c,d1
	beq.s	KeyboardKeypad10
	moveq	#$2a,d0				;"*"
	cmp.w	#$005d,d1
	beq.s	KeyboardKeypad10
	moveq	#$2b,d0				;"+"
	bra.s	KeyboardKeypad10

KeyboardKeypad8:
	move.b	#$9b,0(a2,d7.w)
	addq.w	#1,d7
	moveq	#$30,d1
	btst	#0,$6b(a6)			;SHFT
	beq.s	KeyboardKeypad8a
	moveq	#$31,d1
KeyboardKeypad8a:
	btst	#2,$6b(a6)			;CTRL
	beq.s	KeyboardKeypad8b
	moveq	#$32,d1
KeyboardKeypad8b:
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	and.b	#$0f,d0
	or.b	#$30,d0
	move.b	d0,0(a2,d7.w)
	addq.w	#1,d7
	move.b	#$01,0(a2,d7.w)
	addq.w	#1,d7
	bra	KeyboardExit

KeyboardKeypad9:
	move.b	#$9b,0(a2,d7.w)
	addq.w	#1,d7
	moveq	#$33,d1
	bra.s	KeyboardKeypad8b

KeyboardKeypad10:
	move.b	d0,0(a2,d7.w)
	addq.w	#1,d7
	bra	KeyboardExit

KeyboardVanilla:
	move.b	$6b(a6),d1
	cmp.b	#$60,d0
	bne.s	KeybVan1
	bset	#0,d1
KeybVan1:
	cmp.b	#$e0,d0
	bne.s	KeybVan2
	bclr	#0,d1
KeybVan2:
	cmp.b	#$61,d0
	bne.s	KeybVan3
	bset	#0,d1
KeybVan3:
	cmp.b	#$e1,d0
	bne.s	KeybVan4
	bclr	#0,d1
KeybVan4:
	cmp.b	#$62,d0
	bne.s	KeybVan5
	or.b	#$01,$6c(a6)
KeybVan5:
	cmp.b	#$e2,d0
	bne.s	KeybVan6
	and.b	#$fe,$6c(a6)
KeybVan6:
	cmp.b	#$63,d0
	bne.s	KeybVan7
	bset	#2,d1
KeybVan7:
	cmp.b	#$e3,d0
	bne.s	KeybVan8
	bclr	#2,d1
KeybVan8:
	cmp.b	#$64,d0
	bne.s	KeybVan9
	bset	#1,d1
KeybVan9:
	cmp.b	#$e4,d0
	bne.s	KeybVan10
	bclr	#1,d1
KeybVan10:
	cmp.b	#$65,d0
	bne.s	KeybVan11
	bset	#1,d1
KeybVan11:
	cmp.b	#$e5,d0
	bne.s	KeybVan12
	bclr	#1,d1
KeybVan12:
	move.b	d1,$6b(a6)
	or.b	#$80,$6d(a6)		;No repeat

KeybSpecKeys:
	lea	KeybSpecKeysData(pc),a1
KeybSpecKeys1:
	move.b	(a1)+,d1
	move.b	(a1)+,d2
	cmp.b	#$ff,d1
	beq.s	KeyboardExit
	cmp.b	d1,d0
	bne.s	KeybSpecKeys1
	move.b	#$9b,0(a2,d7.w)
	move.b	d2,d1
	lsr.b	#4,d1
	or.b	#$30,d1
	move.b	d1,1(a2,d7.w)
	and.b	#$0f,d2
	or.b	#$30,d2
	move.b	d2,2(a2,d7.w)
	move.b	#$01,3(a2,d7.w)
	addq.w	#4,d7
	bra.s	KeyboardExit
KeybSpecKeysData:
	dc.b	$62,$48,$e2,$49
	dc.b	$67,$44,$e7,$45,$66,$46,$e6,$47,$ff,$ff
*****************************************************************************
*	44	Right Alt Key Pressed
*	45	Right Alt Key Released
*	46	Left Alt Key Pressed
*	47	Left Alt Key Released
*	48	Caps Lock Pressed
*	49	Caps Lock Released
*****************************************************************************
KeyboardExit:
	move.w	$68(a6),d6
	move.l	a2,$64(a6)
	move.w	d7,$68(a6)
	lea	$f0(a2),a1
	sub.w	d6,d7
	move.b	d7,(a1)+
	tst.b	d7
	beq.s	KeyboardExit2
KeyboardExit1:
	move.b	0(a2,d6.w),(a1)+
	addq.w	#1,d6
	subq.w	#1,d7
	bne.s	KeyboardExit1
KeyboardExit2:
	movem.l	(a7)+,d0-d7/a0-a4
	rts

Keyboardrepeat:				;Repeats the last Keyboard event
	move.l	$64(a6),a2
	move.w	$68(a6),d7
	lea	$f0(a2),a1
	move.b	(a1)+,d6
	tst.b	d6
	beq.s	Keyboardrepeat2
Keyboardrepeat1:
	move.b	(a1)+,0(a2,d7.w)
	addq.w	#1,d7
	cmp.w	#$00f0,d7
	beq.s	Keyboardrepeat3
	subq.b	#1,d6
	bne.s	Keyboardrepeat1
Keyboardrepeat2:
	move.w	d7,$68(a6)
Keyboardrepeat3:
	rts

MakeMoButEvents:			;Makes Keyboardchars of Mousebuttons
	movem.l	d0/d7/a2,-(a7)
	move.l	$64(a6),a2
	move.w	$68(a6),d7	
	move.w	$1c0(a6),d0
	and.w	#$000f,d0
	cmp.w	#$0003,d0
	bne.s	MakeMoButEvents1
	move.w	#$3430,d0		;Mouse L Pressed
	bsr.s	MakeMoButEvents5
	bra.s	MakeMoButEvents2
MakeMoButEvents1:
	cmp.w	#$000c,d0
	bne.s	MakeMoButEvents2
	move.w	#$3432,d0		;Mouse L Released
	bsr.s	MakeMoButEvents5
MakeMoButEvents2:
	move.w	$1c2(a6),d0
	and.w	#$000f,d0
	cmp.w	#$0003,d0
	bne.s	MakeMoButEvents3
	move.w	#$3431,d0		;Mouse R Pressed
	bsr.s	MakeMoButEvents5
	bra.s	MakeMoButEvents4
MakeMoButEvents3:
	cmp.w	#$000c,d0
	bne.s	MakeMoButEvents4
	move.w	#$3433,d0		;Mouse R Released
	bsr.s	MakeMoButEvents5
MakeMoButEvents4:
	move.w	d7,$68(a6)
	movem.l	(a7)+,d0/d7/a2
	rts
MakeMoButEvents5:
	cmp.w	#$00ec,d7
	bhi.s	MakeMoButEvents6
	move.b	#$9b,0(a2,d7.w)
	move.b	d0,2(a2,d7.w)
	lsr.w	#8,d0
	move.b	d0,1(a2,d7.w)
	move.b	#$01,3(a2,d7.w)
	addq.w	#4,d7
MakeMoButEvents6:
	rts

ReadMouseButtons:			;Checks the mouse buttons
	movem.l	d0-d1,-(a7)
	move.w	#$0c00,$0034(a5)	;Enable Right Mouse Button
	move.w	$1c0(a6),d1
	move.b	$bfe001,d0
	and.b	#$40,d0
	sub.b	#$40,d0
	roxl.w	#1,d1
	move.w	d1,$1c0(a6)		;Mouse L Button
	move.w	$1c2(a6),d1
	move.w	$0016(a5),d0
	and.w	#$0400,d0
	sub.w	#$0400,d0
	roxl.w	#1,d1
	move.w	d1,$1c2(a6)		;Mouse R Button
	movem.l	(a7)+,d0-d1
	rts

RevCursor:				;Reverses the Cursor position
	movem.l	d1/a0,-(a7)
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	RevCursor1
	bsr	CalcYAddr
RevCursor1:
	move.l	$178(a6),a0
	add.w	$5e(a6),a0
	moveq	#$ffffffff,d1
	eor.b	d1,(a0)
	eor.b	d1,$050(a0)
	eor.b	d1,$0a0(a0)
	eor.b	d1,$0f0(a0)
	eor.b	d1,$140(a0)
	eor.b	d1,$190(a0)
	eor.b	d1,$1e0(a0)
	eor.b	d1,$230(a0)
	movem.l	(a7)+,d1/a0
	rts

ShowCursor:				;Shows the Cursor
	movem.l	d0-d2/a0,-(a7)
	bsr	RevCursor
	move.l	$1f0(a6),a0
	move.w	$5e(a6),d2
	lsl.w	#2,d2
	move.w	$5c(a6),d1
	lsl.w	#3,d1
	add.w	#$002c,d1
	add.w	#$0080,d2
	move.b	d1,(a0)
	move.b	d2,3(a0)
	and.b	#$01,3(a0)
	ror.w	#1,d2
	move.b	d2,1(a0)
	btst	#8,d1
	beq.s	ShowCursor1
	bset	#2,3(a0)
ShowCursor1:
	addq.w	#8,d1
	move.b	d1,2(a0)
	btst	#8,d1
	beq.s	ShowCursor2
	bset	#1,3(a0)
ShowCursor2:
	move.l	(a0),$dff150		;SPR2POS & SPR2CTL
	move.l	#$f000f000,d0
	move.l	d0,4(a0)
	move.l	d0,8(a0)
	move.l	d0,12(a0)
	move.l	d0,16(a0)
	move.l	d0,20(a0)
	move.l	d0,24(a0)
	move.l	d0,28(a0)
	move.l	d0,32(a0)
	movem.l	(a7)+,d0-d2/a0
	rts

RemCursor:				;Removes the Cursor
	movem.l	d0/a0,-(a7)
	bsr	RevCursor
	move.l	$1f0(a6),a0
	moveq	#$00,d0
	move.l	d0,4(a0)
	move.l	d0,8(a0)
	move.l	d0,12(a0)
	move.l	d0,16(a0)
	move.l	d0,20(a0)
	move.l	d0,24(a0)
	move.l	d0,28(a0)
	move.l	d0,32(a0)
	movem.l	(a7)+,d0/a0
	rts

MakeCursor:				;Makes the Cursor image
	movem.l	d1/a0,-(a7)
	move.l	$1f0(a6),a0
	clr.l	(a0)+
	moveq	#$07,d1
MakeCursor1:
	move.l	#$f000f000,(a0)+
	dbf	d1,MakeCursor1
	clr.l	(a0)
	movem.l	(a7)+,d1/a0
	rts

MakePointer:				;Makes the Mousepointer image
	movem.l	a0/a1,-(a7)
	lea	PointerData(pc),a0
	move.l	$128(a6),a1
	lea	PointerDataEnd(pc),a2
MakePointer1:
	move.l	(a0)+,(a1)+
	cmp.l	a2,a0
	bne.s	MakePointer1
	move.w	$dff00a,$130(a6)
	movem.l	(a7)+,a0/a1
	rts

PointerData:
	dc.w	$0000,$0000

	dc.w	$0000,$fc00
	dc.w	$7c00,$fe00
	dc.w	$7c00,$8600
	dc.w	$7800,$8c00

	dc.w	$7c00,$8600
	dc.w	$6e00,$9300
	dc.w	$0700,$6980
	dc.w	$0380,$04c0

	dc.w	$01c0,$0260
	dc.w	$0080,$0140
	dc.w	$0000,$0080
PointerDataFinish:
	dc.w	$0000,$0000
PointerDataEnd:

ShowPointer:				;Shows the Mousepointer
	movem.l	d0-d2/a0/a1/a5,-(a7)
	lea	$dff000,a5
	move.l	$128(a6),a0
	lea	PointerDataFinish-PointerData(a0),a1
	move.w	$0a(a5),d1
	move.w	$130(a6),d0
	move.w	d1,$130(a6)
	move.b	d1,d2
	sub.b	d0,d2
	ext.w	d2
	lsr.w	#8,d1
	lsr.w	#8,d0
	sub.b	d0,d1
	ext.w	d1
	add.w	d1,$12c(a6)
	bpl.s	ShowPointer1
	clr.w	$12c(a6)
ShowPointer1:
	move.w	$1a0(a6),d0		;LastRasterLine
	sub.w	#$002d,d0
	cmp.w	$12c(a6),d0
	bhi.s	ShowPointer2
	move.w	d0,$12c(a6)
ShowPointer2:
	add.w	d2,$12e(a6)
	bpl.s	ShowPointer3
	clr.w	$12e(a6)
ShowPointer3:
	cmp.w	#$013f,$12e(a6)
	ble.s	ShowPointer4
	move.w	#$013f,$12e(a6)
ShowPointer4:
	move.w	$12e(a6),d2
	move.w	$12c(a6),d1
	add.w	#$002b,d1
	add.w	#$007f,d2
	move.b	d1,(a0)
	move.b	d2,3(a0)
	and.b	#$01,3(a0)
	ror.w	#1,d2
	move.b	d2,1(a0)
	btst	#8,d1
	beq.s	ShowPointer5
	bset	#2,3(a0)
ShowPointer5:
	add.w	#$000b,d1
	move.b	d1,2(a0)
	btst	#8,d1
	beq.s	ShowPointer6
	bset	#1,3(a0)
ShowPointer6:
	move.l	a0,$120(a5)
	move.l	a1,$124(a5)
	move.l	$1f0(a6),$128(a5)
	move.l	a1,$12c(a5)
	move.l	a1,$130(a5)
	move.l	a1,$134(a5)
	move.l	a1,$138(a5)
	move.l	a1,$13c(a5)
	move.w	#$8020,$96(a5)
	move.w	$132(a6),$1a2(a5)
	move.w	$134(a6),$1a4(a5)
	move.w	$136(a6),$1a6(a5)
	move.w	$1f4(a6),$1ae(a5)
	movem.l	(a7)+,d0-d2/a0/a1/a5
	rts

SetCursor:				;Moves the cursor to Mousepointer
	move.l	d1,-(a7)
	btst	#6,$bfe001
	bne.s	SetCursor2
	addq.b	#1,$75(a6)
SetCursor1:
	tst.b	$75(a6)
	bne.s	SetCursor1
	bsr	ShowCursor
	move.w	$12c(a6),d1
	lsr.w	#3,d1
	move.w	d1,$5c(a6)
	move.w	$12e(a6),d1
	lsr.w	#2,d1
	move.w	d1,$5e(a6)
	bsr	RemCursor
SetCursor2:
	move.l	(a7)+,d1
	rts
	
ReadMousePosition:			;Reads the Mousepointer position
					;D0h=y, D0l=x
	move.w	$12c(a6),d0
	lsr.w	#3,d0
	swap	d0
	move.w	$12e(a6),d0
	lsr.w	#2,d0
	rts

WriteMousePosition:			;Sets the Mousepointer position
					;D0h=y, D0l=x
	lsl.w	#2,d0
	or.w	#$0002,d0
	move.w	d0,$12e(a6)
	swap	d0
	lsl.w	#3,d0
	or.w	#$0004,d0
	move.w	d0,$12c(a6)
	rts

ReadKeyboard:				;Reads next Keyboard char
	movem.l	d1/a0,-(a7)
	moveq	#$00,d0
	move.l	$64(a6),a0
	move.w	$68(a6),d1
	beq.s	ReadKeyboardExit
	move.b	(a0),d0
	move.w	#$2300,SR
	subq.w	#1,$68(a6)
ReadKeyboard2:
	move.b	1(a0),(a0)+
	subq.w	#1,d1
	bne.s	ReadKeyboard2
	move.w	#$2000,SR
ReadKeyboardExit:
	movem.l	(a7)+,d1/a0
	rts

CalcYAddr:				;Calculates the LineAdresses
	movem.l	d1/a0,-(a7)
	move.w	$5c(a6),d1
	move.w	d1,$180(a6)
	add.w	$14a(a6),d1
	cmp.w	$14c(a6),d1
	blt.s	CalcYAddr1
	sub.w	$14c(a6),d1
CalcYAddr1:
	move.l	$04(a6),a0
	lsl.w	#4,d1
	add.w	d1,a0
	add.w	d1,d1
	add.w	d1,d1
	add.w	d1,a0
	move.l	a0,$17c(a6)
	move.l	$00(a6),a0
	add.w	d1,d1
	add.w	d1,a0
	add.w	d1,d1
	add.w	d1,d1
	add.w	d1,a0
	move.l	a0,$178(a6)
	movem.l	(a7)+,d1/a0
	rts

WriteChar:				;Writes a AscII character
	movem.l	d1/a0-a1,-(a7)
	moveq	#$00,d1
	move.b	d0,d1
	bpl.s	WriteChar1
	sub.b	#$20,d1
	bpl	WriteCharSpec
	bra.s	WriteChar2
WriteChar1:
	sub.b	#$20,d1
	bmi	WriteCharSpec
WriteChar2:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteChar3
	bsr	CalcYAddr
WriteChar3:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a1
	move.b	d0,0(a1,d1.w)
	move.l	$178(a6),a1
	add.w	d1,a1
	move.b	$74(a6),d1
	beq.s	WriteChar4
	move.b	(a0),d0
	eor.b	d1,d0
	move.b	d0,(a1)
	move.b	$00c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d1,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d1,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d1,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d1,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d1,d0
	move.b	d0,$0230(a1)
	bra.s	WriteChar5
WriteChar4:
	move.b	(a0),(a1)
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
WriteChar5:
	cmp.w	#$004f,$5e(a6)
	bne.s	WriteChar6
	moveq	#$0a,d0
	bra.s	WriteCharSpec
WriteChar6:
	addq.w	#1,$5e(a6)
	movem.l	(a7)+,d1/a0-a1
	rts

WriteCharSpec:
	move.l	d2,-(a7)
	and.w	#$00ff,d0
	cmp.w	#$0008,d0		;Backspace
	bne	WriteCharSpec3
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteCharSpec1
	bsr	CalcYAddr
WriteCharSpec1:
	move.w	$5e(a6),d1
	beq	WriteCharSpecExit
	subq.w	#1,d1
	move.w	d1,$5e(a6)
	move.w	d1,d2
	move.l	$17c(a6),a0
	add.w	d1,a0
WriteCharSpec2:
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	cmp.w	#$004f,d1
	bne.s	WriteCharSpec2
	move.b	#$20,(a0)
	move.l	$178(a6),a0
	move.w	d2,d1
	add.w	d1,a0
WriteCharSpec2a:
	move.b	$0051(a0),$0050(a0)
	move.b	$00a1(a0),$00a0(a0)
	move.b	$00f1(a0),$00f0(a0)
	move.b	$0141(a0),$0140(a0)
	move.b	$0191(a0),$0190(a0)
	move.b	$01e1(a0),$01e0(a0)
	move.b	$0231(a0),$0230(a0)
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	cmp.w	#$004f,d1
	bne.s	WriteCharSpec2a
	clr.b	(a0)
	clr.b	$0050(a0)
	clr.b	$00a0(a0)
	clr.b	$00f0(a0)
	clr.b	$0140(a0)
	clr.b	$0190(a0)
	clr.b	$01e0(a0)
	clr.b	$0230(a0)
	bra	WriteCharSpecExit

WriteCharSpec3:
	cmp.w	#$0009,d0	;TAB
	bne.s	WriteCharSpec5
	move.w	$5e(a6),d1
	and.w	#$0078,d1
	addq.w	#8,d1
	cmp.w	#$50,d1
	bne.s	WriteCharSpec4
	bra.s	WriteCharSpec6
WriteCharSpec4:
	move.w	d1,$5e(a6)
	bra	WriteCharSpecExit

WriteCharSpec5:
	cmp.w	#$000a,d0	;LF
	bne.s	WriteCharSpec8
WriteCharSpec6:
	clr.w	$5e(a6)
	move.w	$14c(a6),d0	;LastScreenLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	WriteCharSpec7
	jsr	_ScrollUp(a6)
	bra.s	WriteCharSpecExit
WriteCharSpec7:
	addq.w	#1,$5c(a6)
	bra.s	WriteCharSpecExit

WriteCharSpec8:
	cmp.w	#$000c,d0
	bne.s	WriteCharSpec9
	jsr	_ClearScreen(a6)
	bra.s	WriteCharSpecExit

WriteCharSpec9:
	cmp.w	#$000d,d0	;CR
	beq.s	WriteCharSpec6

WriteCharSpecExit:
	move.l	(a7)+,d2
	movem.l	(a7)+,d1/a0-a1
	rts

ScrollUp:				;Scrolls screen upward
	move.l	d0,-(a7)
	move.l	$5c(a6),-(a7)
	move.w	$14c(a6),d0
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	jsr	_ClearLine(a6)
	move.w	$14a(a6),d0
	addq.w	#1,d0
	cmp.w	$14c(a6),d0
	blt.s	ScrollUp1
	move.w	#$0000,d0
ScrollUp1:
	tst.b	$75(a6)
	beq.s	ScrollUp1
	clr.b	$75(a6)
	move.w	d0,$14a(a6)
	move.w	#$ffff,$180(a6)
	move.l	(a7)+,$5c(a6)
	move.l	(a7)+,d0
	rts

ScrollDown:				;Scrolls screen downward
	move.l	d0,-(a7)
	move.l	$5c(a6),-(a7)
	move.w	$14c(a6),d0
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	jsr	_ClearLine(a6)
	move.w	$14a(a6),d0
	bne.s	ScrollDown1
	move.w	$14c(a6),d0
ScrollDown1:
	tst.b	$75(a6)
	beq.s	ScrollDown1
	clr.b	$75(a6)
	subq.w	#1,d0
	move.w	d0,$14a(a6)
	move.w	#$ffff,$180(a6)
	move.l	(a7)+,$5c(a6)
	move.l	(a7)+,d0
	rts

ReadChar:				;Read one char
					;A5=LineAdress,D7=Index,D0out=char
	moveq	#-1,d0
	cmp.w	#$50,d7
	beq.s	ReadCharEnd
	addq.w	#1,d7
	cmp.w	#$50,d7
	beq.s	ReadCharEnd
	moveq	#$00,d0
	move.b	0(a5,d7.w),d0
ReadCharEnd:
	tst.l	d0
	rts

ReadNumber:				;Reads a hex number,any length
					;D0out=Number
	move.l	d1,-(a7)
	moveq	#$00,d1
ReadNumber1:
	bsr.s	ReadChar
	tst.l	d0
	bmi.s	ReadNumberEnd
	cmp.b	#$20,d0
	beq.s	ReadNumber1
ReadNumber2:
	cmp.b	#$30,d0
	bcs.s	ReadNumberEnd
	cmp.b	#$3a,d0
	bcs.s	ReadNumber3
	and.b	#$5f,d0
	cmp.b	#$41,d0
	bcs.s	ReadNumberEnd
	cmp.b	#$47,d0
	bcc.s	ReadNumberEnd
	subq.b	#7,d0
ReadNumber3:
	and.b	#$0f,d0
	lsl.l	#4,d1
	or.b	d0,d1
	bsr.s	ReadChar
	cmp.b	#$20,d0
	bne.s	ReadNumber2
ReadNumberEnd:
	move.l	d1,d0
	move.l	(a7)+,d1
	rts

ReadDecNumber:				;Reads a decimal number
					;D0out=Number
	movem.l	d1/d2,-(a7)
	moveq	#$00,d1
ReadDecNumber1:
	bsr.s	ReadChar
	tst.l	d0
	bmi.s	ReadDecNumberEnd
	cmp.b	#$2f,d0
	bls.s	ReadDecNumber1
	cmp.b	#$39,d0
	bhi.s	ReadDecNumber1
ReadDecNumber2:
	cmp.b	#$2f,d0
	bls.s	ReadDecNumberEnd
	cmp.b	#$39,d0
	bhi.s	ReadDecNumberEnd
	and.l	#$0f,d0
	move.l	d1,d2
	swap	d2
	mulu	#$000a,d1
	mulu	#$000a,d2
	swap	d2
	add.l	d2,d1
	add.l	d0,d1
	bsr	ReadChar
	bra.s	ReadDecNumber2
ReadDecNumberEnd:
	move.l	d1,d0
	movem.l	(a7)+,d1/d2
	rts

ReadNibble:				;Reads a number 0-F
					;D0out=Nibble
	move.l	d1,-(a7)
	moveq	#-1,d1
ReadNibble1:
	bsr	ReadChar
	tst.l	d0
	bmi.s	ReadNibbleEnd
	cmp.b	#$20,d0
	beq.s	ReadNibble1
ReadNibble2:
	cmp.b	#$30,d0
	bcs.s	ReadNibbleEnd
	cmp.b	#$3a,d0
	bcs.s	ReadNibble3
	and.b	#$5f,d0
	cmp.b	#$41,d0
	bcs.s	ReadNibbleEnd
	cmp.b	#$47,d0
	bcc.s	ReadNibbleEnd
	subq.b	#7,d0
ReadNibble3:
	and.b	#$0f,d0
	move.l	d0,d1
ReadNibbleEnd:
	move.l	d1,d0
	move.l	(a7)+,d1
	tst.l	d0
	rts

ReadByte:				;Reads a number 00-FF
					;D0out=Byte
	move.l	d1,-(a7)
	bsr.s	ReadNibble
	tst.l	d0
	bmi.s	ReadByteEnd
	lsl.b	#4,d0
	move.b	d0,d1
	bsr.s	ReadNibble
	tst.l	d0
	bmi.s	ReadByteEnd
	or.b	d1,d0
ReadByteEnd:
	move.l	(a7)+,d1
	tst.l	d0
	rts

ReadStringII:				;Reads a string, don't check 
					;A0=Adress
	movem.l	d1/a0,-(a7)
	moveq	#$00,d1
ReadString0:
	bsr	ReadChar
	tst.l	d0
	bmi	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadString2
	cmp.w	#$20,d0
	bls.s	ReadString0
	bra	ReadString5a

ReadString:				;Reads a string, checks if number
					;A0=Adress
	movem.l	d1/a0,-(a7)
	moveq	#$00,d1
ReadString1:
	bsr	ReadChar
	tst.l	d0
	bmi	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadString2
	cmp.w	#$20,d0
	bls.s	ReadString1
	bra.s	ReadString4
ReadString2:
	bsr	ReadChar
	tst.l	d0
	bmi.s	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadString3
	move.b	d0,0(a0,d1.w)
	addq.w	#1,d1
	bra.s	ReadString2
ReadString3:
	clr.b	0(a0,d1.w)
	move.l	d1,d0
	movem.l	(a7)+,d1/a0
	rts
ReadString4:			;String without ""
	cmp.b	#$20,d0
	bls.s	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadStringEnd
	move.b	d0,0(a0,d1.w)
	addq.w	#1,d1
	cmp.b	#$2f,d0
	bls.s	ReadString5
	cmp.b	#$40,d0
	bhi.s	ReadString4a
	cmp.b	#$39,d0
	bhi.s	ReadString5
ReadString4a:
	tst.b	d0
	bmi.s	ReadString5
	and.b	#$5f,d0
	cmp.b	#'F',d0
	bhi.s	ReadString5
	bsr	ReadChar
	tst.l	d0
	bpl.s	ReadString4
	bmi.s	ReadStringEnd
ReadString5:
	bsr	ReadChar
	tst.l	d0
	bmi.s	ReadStringEnd
	cmp.b	#$20,d0
	bls.s	ReadString3
ReadString5a:
	move.b	d0,0(a0,d1.w)
	addq.w	#1,d1
	bra.s	ReadString5
ReadStringEnd:
	moveq	#-1,d0
	movem.l	(a7)+,d1/a0
	rts

WriteString:				;Writes a nullterminated string
					;A0=String
	move.l	a0,-(a7)
WriteString1:
	move.b	(a0)+,d0
	beq.s	WriteStringEnd
	jsr	_WriteChar(a6)
	bra.s	WriteString1
WriteStringEnd:
	move.l	a0,d0
	move.l	(a7)+,a0
	rts

CopyString:				;Copies one nullterminated string
					;A0=SourceString,A1=DestinString
	movem.l	d0/a0-a1,-(a7)
	moveq	#$4f,d0
CopyString1:
	move.b	(a0)+,(a1)+
	dbeq	d0,CopyString1
	movem.l	(a7)+,d0/a0-a1
	rts

WriteASCIIChar:				;Writes AscII 00-FF as characters
					;D0=char
	movem.l	d1-d2/a0/a1,-(a7)
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	d0,d1
	bpl.s	WriteASCIIChar1
	sub.b	#$0020,d1
	bmi.s	WriteASCIIChar2
	moveq	#-1,d2
	add.b	#$0040,d1
	bra.s	WriteASCIIChar2
WriteASCIIChar1:
	sub.b	#$0020,d1
	bpl.s	WriteASCIIChar2
	moveq	#-1,d2
	add.b	#$0040,d1
WriteASCIIChar2:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteASCIIChar3
	bsr	CalcYAddr
WriteASCIIChar3:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a1
	move.b	d0,0(a1,d1.w)
	move.l	$178(a6),a1
	add.w	d1,a1
	tst.b	d2
	beq.s	WriteASCIIChar4
	move.b	(a0),d0
	eor.b	d2,d0
	move.b	d0,(a1)
	move.b	$00c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d2,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d2,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d2,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d2,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d2,d0
	move.b	d0,$0230(a1)
	bra.s	WriteASCIIChar5
WriteASCIIChar4:
	move.b	(a0),(a1)
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
WriteASCIIChar5:
	addq.w	#1,$5e(a6)
	movem.l	(a7)+,d1-d2/a0/a1
	rts

WriteNumber:				;Writes the numbers 0-F
					;D0=Number
	and.b	#$0f,d0
	cmp.b	#$0a,d0
	bcs.s	WriteNumber1
	addq.b	#7,d0
WriteNumber1:
	add.b	#$30,d0
	jsr	_WriteChar(a6)
	rts

WriteDecNumber:				;Writes a decimal number, same length
					;d0=number,d1=highestten(1000,100...)
	movem.l	d1-d4,-(a7)
	move.l	d1,d3
	moveq	#$00,d4
WriteDecNumber0:
	moveq	#-1,d2
	add.l	d3,d0
WriteDecNumber1:
	sub.l	d3,d0
	addq.b	#1,d2
	cmp.l	d3,d0
	beq.s	WriteDecNumber1
	bhi.s	WriteDecNumber1
	move.l	d0,d1
	move.b	d2,d0
	tst.b	d4
	bne.s	WriteDecNumber2
	tst.b	d2
	beq.s	WriteDecNumber3
WriteDecNumber2:
	moveq	#$01,d4
	jsr	_WriteNumber(a6)
	bra.s	WriteDecNumber4
WriteDecNumber3:
	moveq	#$20,d0
	jsr	_WriteChar(a6)
WriteDecNumber4:
	move.l	d1,d0
	move.l	d3,d1
	clr.w	d3
	swap	d3
	divu	#$000a,d3
	swap	d3
	swap	d1
	move.w	d3,d1
	swap	d1
	divu	#$000a,d1
	move.w	d1,d3
	cmp.l	#$00000001,d1
	bne.s	WriteDecNumber0
	bsr.s	WriteNumber
	movem.l	(a7)+,d1-d4
	rts

WriteDecNumberII:			;Writes a decimal number, any length
					;d0=number,d1=highestten(1000,100...)
	movem.l	d1-d4,-(a7)
	move.l	d1,d3
	moveq	#$00,d4
WriteDecNumberII0:
	moveq	#-1,d2
	add.l	d3,d0
WriteDecNumberII1:
	sub.l	d3,d0
	addq.b	#1,d2
	cmp.l	d3,d0
	beq.s	WriteDecNumberII1
	bhi.s	WriteDecNumberII1
	move.l	d0,d1
	move.b	d2,d0
	tst.b	d4
	bne.s	WriteDecNumberII2
	tst.b	d2
	beq.s	WriteDecNumberII3
WriteDecNumberII2:
	moveq	#$01,d4
	jsr	_WriteNumber(a6)
WriteDecNumberII3:
	move.l	d1,d0
	move.l	d3,d1
	clr.w	d3
	swap	d3
	divu	#$000a,d3
	swap	d3
	swap	d1
	move.w	d3,d1
	swap	d1
	divu	#$000a,d1
	move.w	d1,d3
	cmp.l	#$00000001,d1
	bne.s	WriteDecNumberII0
	jsr	_WriteNumber(a6)
	movem.l	(a7)+,d1-d4
	rts

WriteByte:				;Writes hex numbers 00-FF
					;D0=Byte
	move.l	d1,-(a7)
	move.b	d0,d1
	lsr.b	#4,d0
	jsr	_WriteNumber(a6)
	move.b	d1,d0
	jsr	_WriteNumber(a6)
	move.l	(a7)+,d1
	rts

WriteWord:				;Writes hex numbers 0000-FFFF
					;D0=Word
	move.l	d1,-(a7)
	move.w	d0,d1
	lsr.w	#8,d0
	bsr.s	WriteByte
	move.w	d1,d0
	bsr.s	WriteByte
	move.l	(a7)+,d1
	rts

WriteLong:				;Writes hex numbers 00000000-FFFFFFFF
					;D0=LongWord
	move.l	d1,-(a7)
	move.l	d0,d1
	swap	d0
	bsr.s	WriteWord
	move.l	d1,d0
	bsr.s	WriteWord
	move.l	(a7)+,d1
	rts

ReadMemByte:				;Reads a byte in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	ReadMemByte1
	cmpa.l	$14(a6),a0		;Agnus Base Adress
	bhi.s	ReadMemByte2
	cmpa.l	#$bfffff,a0
	bhi.s	ReadMemByte1
	cmpa.l	#$9fffff,a0
	bhi.s	ReadMemByte3
	cmpa.l	#$0053ff,a0
	bhi.s	ReadMemByte1
	adda.l	$0086(a6),a0
	move.b	(a0)+,d0
	suba.l	$0086(a6),a0
	rts
ReadMemByte1:
	move.b	(a0)+,d0
	rts
ReadMemByte2:
	movem.l	d1/a0,-(a7)
	move.w	a0,d1
	and.w	#$01ff,d1
	move.l	$18a(a6),a0
	move.b	0(a0,d1.w),d0
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

ReadMemByte3:
	movem.l	d1/a0,-(a7)
	move.l	a0,d1
	move.l	$18e(a6),a0
	lsr.w	#1,d1
	bcs.s	ReadMemByte4
	lsr.w	#7,d1
	btst	#5,d1
	bne.s	ReadMemByte5
	and.w	#$000f,d1
	move.b	0(a0,d1.w),d0
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts
ReadMemByte4:
	lsr.w	#7,d1
	btst	#4,d1
	bne.s	ReadMemByte5
	and.w	#$000f,d1
	move.b	$18(a0,d1.w),d0
ReadMemByte5:
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

ReadMemWord:				;Reads a word in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	ReadMemWord1
	cmpa.l	$14(a6),a0
	bhi.s	ReadMemWord2
	cmpa.l	#$bfffff,a0
	bhi.s	ReadMemWord1
	cmpa.l	#$9fffff,a0
	bhi.s	ReadMemWord3
	cmpa.l	#$0053ff,a0
	bhi.s	ReadMemWord1
	adda.l	$0086(a6),a0
	move.w	(a0)+,d0
	suba.l	$0086(a6),a0
	rts
ReadMemWord1:
	move.w	(a0)+,d0
	rts
ReadMemWord2:
	move.l	a0,-(a7)
	move.w	a0,d0
	and.w	#$01fe,d0
	move.l	$18a(a6),a0
	move.w	0(a0,d0.w),d0
	move.l	(a7)+,a0
ReadMemWord3:
	addq.l	#2,a0
	rts

ReadMemLong:				;Reads a longword in memory
					;A0=Adress
	bsr.s	ReadMemWord
	swap	d0
	bra.s	ReadMemWord

WriteMemByte:				;Writes a byte in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	WriteMemByte1
	cmpa.l	$14(a6),a0
	bhi.s	WriteMemByte2
	cmpa.l	#$bfffff,a0
	bhi.s	WriteMemByte1
	cmpa.l	#$9fffff,a0
	bhi.s	WriteMemByte3
	cmpa.l	#$0053ff,a0
	bhi.s	WriteMemByte1
	adda.l	$0086(a6),a0
	move.b	d0,(a0)+
	suba.l	$0086(a6),a0
	rts	
WriteMemByte1:
	move.b	d0,(a0)+
	rts
WriteMemByte2:
	movem.l	d1/a0,-(a7)
	move.w	a0,d1
	and.w	#$01ff,d1
	move.l	$18a(a6),a0
	move.b	d0,0(a0,d1.w)
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

WriteMemByte3:
	movem.l	d1/a0,-(a7)
	move.l	a0,d1
	move.l	$18e(a6),a0
	lsr.w	#1,d1
	bcs.s	WriteMemByte4
	lsr.w	#7,d1
	btst	#5,d1
	bne.s	WriteMemByte5
	and.w	#$000f,d1
	move.b	d0,0(a0,d1.w)
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts
WriteMemByte4:
	lsr.w	#7,d1
	btst	#4,d1
	bne.s	WriteMemByte5
	and.w	#$000f,d1
	move.b	d0,$18(a0,d1.w)
WriteMemByte5:
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

WriteMemWord:				;Writes a word in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	WriteMemWord1
	cmpa.l	$14(a6),a0
	bhi.s	WriteMemWord2
	cmpa.l	#$bfffff,a0
	bhi.s	WriteMemWord1
	cmpa.l	#$9fffff,a0
	bhi.s	WriteMemWord3
	cmpa.l	#$0053ff,a0
	bhi.s	WriteMemWord1
	adda.l	$0086(a6),a0
	move.w	d0,(a0)+
	suba.l	$0086(a6),a0
	rts	
WriteMemWord1:
	move.w	d0,(a0)+
	rts
WriteMemWord2:
	movem.l	d1/a0,-(a7)
	move.w	a0,d1
	and.w	#$01fe,d1
	move.l	$18a(a6),a0
	move.w	d0,0(a0,d1.w)
	movem.l	(a7)+,d1/a0
WriteMemWord3:
	addq.l	#2,a0
	rts

WriteMemLong:				;Writes a longword in memory
					;A0=Adress
	swap	d0
	bsr.s	WriteMemWord
	swap	d0
	bra.s	WriteMemWord

ExchangeRam:				;Exchanges Work and Chip ram
	movem.l	d0-d4/a0-a5,-(a7)
	move.l	$0086(a6),a0
	lea	$0000.w,a1
	move.w	#$053f,d0
ExchangeRam1:
	movem.l	(a0),d1-d4
	movem.l	(a1),a2-a5
	movem.l	a2-a5,(a0)
	lea	$0010(a0),a0
	movem.l	d1-d4,(a1)
	lea	$0010(a1),a1
	dbf	d0,ExchangeRam1
	movem.l	(a7)+,d0-d4/a0-a5
	rts

ClearLine:				;Clears a horisontal line on screen
	movem.l	d1-d4/a0/a1/a5,-(a7)
	lea	$dff000,a5
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	ClearLine1
	bsr	CalcYAddr
ClearLine1:
	move.l	$17c(a6),a0		;Charmap
	move.l	$178(a6),a1		;Bitmap
	move.l	#$20202020,d1
	move.l	d1,d2
	move.l	d1,d3
	move.l	d1,d4
	lea	$0050(a0),a0
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	move.w	#$8440,$96(a5)
	move.l	a1,$54(a5)
	move.l	#$01000000,$40(a5)
	clr.w	$66(a5)
	move.w	#$0140,$58(a5)
ClearLine2:
	btst	#6,$02(a5)
	bne.s	ClearLine2
	move.w	#$0440,$96(a5)
	movem.l	(a7)+,d1-d4/a0/a1/a5
	rts

ClearLineII:				;Clears part of a horisontal line
					;d0 = numbers of chars to clear
	movem.l	d1/d2/a1/a2,-(a7)
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	ClearLineII1
	bsr	CalcYAddr
ClearLineII1:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a1	;Charmap
	add.w	d1,a1
	move.l	$178(a6),a2	;Bitmap
	add.w	d1,a2
	tst.w	d0
	bmi	ClearLineII6
	move.b	$74(a6),d2	;Inverse ON/OFF
	ext.w	d2
	ext.l	d2
ClearLineII2:
	tst.w	d0
	beq	ClearLineII6
	move.l	a1,d1
	lsr.w	#1,d1
	bcs.s	ClearLineII3	;Odd
	cmp.w	#$0003,d0
	bhi.s	ClearLineII5
	cmp.w	#$0001,d0
	bhi.s	ClearLineII4
ClearLineII3:
	move.b	d2,$230(a2)
	move.b	d2,$1e0(a2)
	move.b	d2,$190(a2)
	move.b	d2,$140(a2)
	move.b	d2,$0f0(a2)
	move.b	d2,$0a0(a2)
	move.b	d2,$050(a2)
	move.b	d2,(a2)+
	move.b	#$20,(a1)+
	subq.w	#1,d0
	bra.s	ClearLineII2
ClearLineII4:
	move.w	d2,$230(a2)
	move.w	d2,$1e0(a2)
	move.w	d2,$190(a2)
	move.w	d2,$140(a2)
	move.w	d2,$0f0(a2)
	move.w	d2,$0a0(a2)
	move.w	d2,$050(a2)
	move.w	d2,(a2)+
	move.w	#$2020,(a1)+
	subq.w	#2,d0
	bra.s	ClearLineII2
ClearLineII5:
	move.l	d2,$230(a2)
	move.l	d2,$1e0(a2)
	move.l	d2,$190(a2)
	move.l	d2,$140(a2)
	move.l	d2,$0f0(a2)
	move.l	d2,$0a0(a2)
	move.l	d2,$050(a2)
	move.l	d2,(a2)+
	move.l	#$20202020,(a1)+
	subq.w	#4,d0
	bra	ClearLineII2
ClearLineII6:
	movem.l	(a7)+,d1/d2/a1/a2
	rts

ClearToEOL:				;Clears to end of the horisontal line
	move.l	d0,-(a7)
	move.w	#$0050,d0
	sub.w	$5e(a6),d0
	jsr	_ClearLineII(a6)
	move.l	(a7)+,d0
	rts

ClearToTAB:				;Clears to the next tabulator stop
	move.l	d0,-(a7)
	move.w	$5e(a6),d0
	addq.w	#8,d0
	and.w	#$0078,d0
	sub.w	$5e(a6),d0
	jsr	_ClearLineII(a6)
	move.l	(a7)+,d0
	rts

ClearScreen:				;Clears the whole screen
	movem.l	d0-d4/a0/a1/a5,-(a7)
	lea	$dff000,a5
	clr.w	$14a(a6)
	clr.w	$5c(a6)
	clr.w	$5e(a6)
	bsr	CalcYAddr
	move.l	$04(a6),a0
	move.l	$00(a6),a1
	move.l	#$20202020,d1
	move.l	d1,d2
	move.l	d1,d3
	move.l	d1,d4
	lea	$0a50(a0),a0
	moveq	#$20,d0
ClearScreen1:
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	dbf	d0,ClearScreen1
	move.w	#$8440,$96(a5)
	move.l	a1,$54(a5)
	move.l	#$01000000,$40(a5)
	clr.w	$66(a5)
	move.w	#$2940,$58(a5)
ClearScreen2:
	btst	#6,$02(a5)
	bne.s	ClearScreen2
	move.w	#$0440,$96(a5)
	movem.l	(a7)+,d0-d4/a0/a1/a5
	rts

WaitIfCtrl:				;Waits until Control is released
	btst	#2,$6b(a6)
	bne.s	WaitIfCtrl
	rts

ComError:				;Fatal Command ERROR
	move.w	$dff006,$dff180
	bra.s	ComError
ExecuteCom:				;Executes the command written
	lea	Preferences,a6
	lea	ErrorHandler0(pc),a0
	move.l	a0,$142(a6)
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	ExecuteCom1
	bsr	CalcYAddr
ExecuteCom1:
	move.l	$17c(a6),a5		;Charmap
	moveq	#$00,d7
ExecuteCom2:
	cmp.b	#$20,0(a5,d7.w)
	bne.s	ExecuteCom3
	addq.w	#1,d7
	cmp.w	#$4f,d7
	bne.s	ExecuteCom2
	bra.s	ExecuteComEnd
ExecuteCom3:
	lea	Commands1(pc),a2
	lea	Commands(pc),a1
	move.b	0(a5,d7.w),d0
	bmi.s	ExecuteComEnd
	btst	#6,d0
	beq.s	ExecuteCom4
	and.b	#$5f,d0
ExecuteCom4:
	move.w	d7,d6
	move.l	a1,a0
	move.l	(a2)+,a3
	move.b	(a0)+,d1
	beq.s	ExecuteComEnd
	ext.w	d1
	lea	0(a0,d1.w),a1
	move.b	d0,d2
	bra.s	ExecuteCom6
ExecuteCom5:
	move.b	0(a5,d6.w),d2
	bmi.s	ExecuteCom7
	and.b	#$5f,d2
	btst	#6,d2
	beq.s	ExecuteCom7
	tst.w	d1
	beq.s	ExecuteCom4
ExecuteCom6:
	cmp.b	(a0)+,d2
	bne.s	ExecuteCom4
	addq.w	#1,d6
	cmp.w	#$004f,d6
	bhi.s	ExecuteComEnd
	subq.w	#1,d1
	bra.s	ExecuteCom5
ExecuteCom7:
	move.w	d6,d7
	subq.w	#1,d7
	lea	Ecom(pc),a0
	add.l	a0,a3
	jsr	(a3)
Ecom:
	bra	Loop
ExecuteComEnd:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	bra	Loop

Commands:
	dc.b	1,"A"
	dc.b	1,"B"
	dc.b	1,"C",2,"CD",5,"CLOSE"
	dc.b	1,"D",4,"DATE",6,"DELETE",3,"DIR",8,"DISKCOPY"
	dc.b	1,"E"
	dc.b	1,"F",8,"FILENOTE",6,"FORMAT"
	dc.b	1,"G"
	dc.b	1,"H",7,"HUNTDIS"
	dc.b	1,"I",4,"INFO",7,"INSTALL"
	dc.b	1,"J"
	dc.b	1,"L",7,"LOADSEG"
	dc.b	1,"M",7,"MAKEDIR"
	dc.b	1,"N",3,"NEW"
	dc.b	4,"OPEN"
	dc.b	7,"PROTECT"
	dc.b	1,"Q"
	dc.b	1,"R",6,"RENAME",7,"RELABEL"
	dc.b	1,"S",4,"SAVE",7,"SHOWSEG"
	dc.b	1,"T",4,"TYPE"
	dc.b	7,"WORKBUF"
	dc.b	1,"X"
	dc.b	1,","
	dc.b	1,"'"
	dc.b	1,":"
	dc.b	1,";"
	dc.b	0
	even
Commands1:
	dc.l	AssembleCom-Ecom	;A
	dc.l	BreakpointCom-Ecom	;B
	dc.l	CompareCom-Ecom		;C
	dc.l	ChangeDirCom-Ecom	;CD
	dc.l	CloseCom-Ecom		;CLOSE
	dc.l	DisassembleCom-Ecom	;D
	dc.l	DateCom-Ecom		;DATE
	dc.l	DeleteCom-Ecom		;DELETE
	dc.l	DirectoryCom-Ecom	;DIR
	dc.l	DiskCopyCom-Ecom	;DISKCOPY
	dc.l	ExchangeCom-Ecom	;E
	dc.l	FillCom-Ecom		;F
	dc.l	FileNoteCom-Ecom	;FILENOTE
	dc.l	FormatCom-Ecom		;FORMAT
	dc.l	GoCom-Ecom		;G
	dc.l	HuntCom-Ecom		;H
	dc.l	HuntDisCom-Ecom		;HUNTDIS
	dc.l	InterpretCom-Ecom	;I
	dc.l	InfoCom-Ecom		;INFO
	dc.l	InstallCom-Ecom		;INSTALL
	dc.l	JumpCom-Ecom		;J
	dc.l	LoadCom-Ecom		;L
	dc.l	LoadSegCom-Ecom		;LOADSEG
	dc.l	MemoryCom-Ecom		;M
	dc.l	MakeDirCom-Ecom		;MAKEDIR
	dc.l	NewlocatorCom-Ecom	;N
	dc.l	NewCom-Ecom		;NEW
	dc.l	OpenCom-Ecom		;OPEN
	dc.l	ProtectCom-Ecom		;PROTECT
	dc.l	QuickTraceCom-Ecom	;Q
	dc.l	RegisterCom-Ecom	;R
	dc.l	RenameCom-Ecom		;RENAME
	dc.l	RelabelCom-Ecom		;RELABEL
	dc.l	SaveCom-Ecom		;S
	dc.l	SaveTextCom-Ecom	;SAVE
	dc.l	ShowSegCom-Ecom		;SHOWSEG
	dc.l	TransferCom-Ecom	;T
	dc.l	TypeCom-Ecom		;TYPE
	dc.l	WorkBufCom-Ecom		;WORKBUF
	dc.l	ExitCom-Ecom		;X
	dc.l	DisassembleWriteCom-Ecom;,
	dc.l	InterpretWriteCom-Ecom	;'
	dc.l	MemoryWriteCom-Ecom	;:
	dc.l	RegisterWriteCom-Ecom	;;

AssembleCom:
	jsr	_ReadNumber(a6)
	subq.w	#1,d7
	move.l	d0,$98(a6)
AssembleComA:
	lea	$b4(a6),a1
	move.l	a1,$a0(a6)
	move.w	#$0010,$a4(a6)
AssembleCom1:
	bsr	ReadChar
	bmi	AssembleComError
	cmp.b	#$20,d0
	beq.s	AssembleCom1
	bra.s	AssembleCom3
AssembleCom2:
	bsr	ReadChar
	bmi	AssembleComError
AssembleCom3:
	cmp.b	#'.',d0
	beq.s	AssembleCom4
	cmp.b	#$40,d0
	bls.s	AssembleCom6
	and.b	#$5f,d0
	move.b	d0,(a1)+
	bra.s	AssembleCom2
AssembleCom4:
	bsr	ReadChar
	bmi	AssembleComError
	and.b	#$5f,d0
	moveq	#$08,d1
	cmp.b	#'S',d0
	beq.s	AssembleCom5
	cmp.b	#'B',d0
	beq.s	AssembleCom5
	moveq	#$10,d1
	cmp.b	#'W',d0
	beq.s	AssembleCom5
	moveq	#$20,d1
	cmp.b	#'L',d0
	bne.s	AssembleCom7
AssembleCom5:
	move.w	d1,$a4(a6)
	bra.s	AssembleCom7
AssembleCom6:
	subq.w	#1,d7
AssembleCom7:
	clr.b	(a1)+
	clr.w	$a6(a6)
	clr.l	$a8(a6)
	clr.w	$ac(a6)
	clr.l	$ae(a6)
	clr.l	d6
	lea	AssembleCom8(pc),a2
	lea	$a6(a6),a1
	cmp.l	#'MOVE',$b4(a6)
	bne.s	AssembleCom8
	cmp.b	#'M',$b8(a6)
	bne.s	AssembleCom8
	moveq	#-1,d6
AssembleCom8:
	move.w	d7,d5
	bsr	ReadChar
	bmi	AssembleCom23		;Next operand
	cmp.b	#'#',d0
	beq	AssembleCom21		;Imm
	cmp.b	#'$',d0
	beq	AssembleCom20		;Abs hex,d(An),d(An,Xi)...
	cmp.b	#'(',d0
	beq	AssembleCom16		;(An),(an)+
	cmp.b	#'-',d0
	beq	AssembleCom18		;-(An),-Abs,-d(An)...
	cmp.b	#$2f,d0
	bls.s	AssembleCom8
	cmp.b	#$39,d0
	bls	AssembleCom19		;Abs dec,d(An),d(An,Xi)...
	and.b	#$5f,d0
	cmp.b	#'D',d0
	beq.s	AssembleCom9		;Dn
	cmp.b	#'A',d0
	beq.s	AssembleCom12		;An
	cmp.b	#'C',d0
	beq.s	AssembleCom13		;CCR
	cmp.b	#'S',d0
	beq.s	AssembleCom14		;SR
	cmp.b	#'U',d0
	beq.s	AssembleCom15		;USP
	bra	AssembleComError

AssembleCom9:				;Dn
	move.w	#$0001,(a1)
AssembleCom10:
	tst.l	d6
	bmi	AssembleCom22		;RegListMask
	jsr	_ReadNibble(a6)
	bmi	AssembleComError	
	cmp.b	#$07,d0
	bhi	AssembleComError
	move.w	d0,$2(a1)
AssembleCom11:
	bsr	ReadChar
	bmi	AssembleCom23		;Next Operand
	cmp.b	#',',d0
	beq	AssembleCom23		;Next Operand
	bra.s	AssembleCom11
AssembleCom12:				;An
	move.w	#$0002,(a1)
	bra.s	AssembleCom10

AssembleCom13:				;CCR
	move.w	#$2000,(a1)
	bra.s	AssembleCom11

AssembleCom14:				;SR
	move.w	#$4000,(a1)
	bra.s	AssembleCom11

AssembleCom15:				;USP
	move.w	#$8002,(a1)
	bra.s	AssembleCom11

AssembleCom16:				;(An),(An)+
	move.w	#$0004,(a1)
AssembleCom16a:
	bsr	ReadChar
	bmi	AssembleComError
	and.b	#$5f,d0
	cmp.b	#'A',d0
	bne.s	AssembleCom16
	jsr	_ReadNibble(a6)
	move.w	d0,$2(a1)
AssembleCom17:
	bsr	ReadChar
	bmi	AssembleCom23		;Next operand
	cmp.b	#',',d0
	beq	AssembleCom23		;Next operand
	cmp.b	#'+',d0
	bne.s	AssembleCom17
	move.w	#$0008,(a1)		;(An)+
	bra.s	AssembleCom17
AssembleCom18:				;-
	move.w	#$0010,(a1)
	bsr	ReadChar
	cmp.b	#'(',d0
	beq.s	AssembleCom16a		;-(An)
	cmp.b	#'$',d0
	bne.s	AssembleCom18a
	jsr	_ReadNumber(a6)
	neg.l	d0
	bra.s	AssembleCom18b
AssembleCom18a:
	subq.w	#1,d7
	jsr	_ReadDecNumber(a6)	
	neg.l	d0
AssembleCom18b:
	move.l	d0,$2(a1)
	move.w	#$8100,(a1)		;Abs
	subq.w	#1,d7
AssembleCom18b3:
	move.l	d0,d1
	ext.l	d1
	cmp.l	d1,d0
	bne.s	AssembleCom18c
	move.w	#$8080,(a1)
	bra.s	AssembleCom18c
AssembleCom18b1:
	bsr	ReadChar
	and.b	#$5f,d0
	cmp.b	#'L',d0
	beq.s	AssembleCom18b2
	cmp.b	#'W',d0
	bne	AssembleComError
	move.l	$2(a1),d0
	bra.s	AssembleCom18b3
AssembleCom18b2:	
	move.w	#$8100,(a1)
AssembleCom18c:
	bsr	ReadChar
	bmi	AssembleCom23		;Next operand
	cmp.b	#'.',d0
	beq.s	AssembleCom18b1
	cmp.b	#',',d0
	beq	AssembleCom23		;Next operand
	cmp.b	#'(',d0
	bne.s	AssembleCom18c
	bsr	ReadChar
	and.b	#$5f,d0
	cmp.b	#'P',d0
	beq	AssembleCom18g
	cmp.b	#'A',d0
	bne	AssembleComError
	move.w	#$0020,(a1)		;d(An)
	jsr	_ReadNibble(a6)
	move.w	d0,2(a1)
AssembleCom18d:
	bsr	ReadChar
	bmi	AssembleCom11
	cmp.b	#')',d0
	beq	AssembleCom11
	cmp.b	#',',d0
	bne.s	AssembleCom18d
	lsl.w	(a1)		;d(An,Xi),d(PC,Xi)
AssembleCom18e:
	and.w	#$00ff,$4(a1)
	bsr	ReadChar
	and.b	#$5f,d0
	moveq	#$08,d1
	cmp.b	#'A',d0
	beq.s	AssembleCom18f
	cmp.b	#'D',d0
	bne	AssembleComError
	moveq	#$00,d1
AssembleCom18f:
	jsr	_ReadNibble(a6)
	add.w	d1,d0
	ror.w	#4,d0
	and.w	#$f000,d0
	or.w	#$0800,d0
	or.w	d0,$4(a1)
	bsr	ReadChar
	bmi	AssembleCom11
	cmp.b	#'.',d0
	bne	AssembleCom11
	bsr	ReadChar
	bmi	AssembleComError
	and.b	#$5f,d0
	cmp.b	#'W',d0
	bne	AssembleCom11
	and.w	#$f7ff,4(a1)
	bra	AssembleCom11
AssembleCom18g:
	move.w	#$0200,(a1)		;d(PC)
	move.l	$98(a6),d0
	sub.l	d0,$2(a1)
	subq.l	#2,$2(a1)
	bra	AssembleCom18d

AssembleCom19:				;Abs dec
	subq.w	#1,d7
	jsr	_ReadDecNumber(a6)
	bra	AssembleCom18b

AssembleCom20:				;Abs hex
	jsr	_ReadNumber(a6)
	bra	AssembleCom18b

AssembleCom21:				;Imm
	move.w	#$0800,(a1)
	bsr	ReadChar
	bmi	AssembleComError
	cmp.b	#'$',d0
	beq.s	AssembleCom21b
	cmp.b	#'-',d0
	beq.s	AssembleCom21c
	subq.w	#1,d7
	jsr	_ReadDecNumber(a6)
AssembleCom21a:
	move.l	d0,$2(a1)
	subq.w	#1,d7
	bra	AssembleCom11
AssembleCom21b:
	jsr	_ReadNumber(a6)
	bra.s	AssembleCom21a
AssembleCom21c:
	bsr	ReadChar
	bmi	AssembleComError
	cmp.b	#'$',d0
	beq.s	AssembleCom21d
	subq.w	#1,d7
	jsr	_ReadDecNumber(a6)
	neg.l	d0
	bra.s	AssembleCom21a
AssembleCom21d:
	jsr	_ReadNumber(a6)
	neg.l	d0
	bra.s	AssembleCom21a

AssembleCom22:				;RegListMask
	subq.w	#1,d7
	move.w	#$8003,(a1)
	moveq	#$00,d1
AssembleCom22a:
	bsr	ReadChar
	bmi.s	AssembleCom23		;Next operand
	cmp.b	#',',d0
	beq.s	AssembleCom23		;Next operand
	cmp.b	#'-',d0
	beq.s	AssembleCom22c
	cmp.b	#'/',d0
	beq.s	AssembleCom22a
	and.b	#$5f,d0
	moveq	#$00,d2
	cmp.b	#'D',d0
	beq.s	AssembleCom22b
	moveq	#$08,d2
	cmp.b	#'A',d0
	bne.s	AssembleCom22a
AssembleCom22b:
	jsr	_ReadNibble(a6)
	add.w	d2,d0
	move.w	d0,d1
	move.w	2(a1),d0
	bset	d1,d0
	move.w	d0,2(a1)
	bra.s	AssembleCom22a
AssembleCom22c:
	bsr	ReadChar
	bmi.s	AssembleComError
	and.b	#$5f,d0
	moveq	#$00,d2
	cmp.b	#'D',d0
	beq.s	AssembleCom22d
	moveq	#$08,d2
	cmp.b	#'A',d0
	bne.s	AssembleCom22c
AssembleCom22d:
	jsr	_ReadNibble(a6)
	add.w	d0,d2
	move.w	2(a1),d0
AssembleCom22e:
	addq.w	#1,d1
	bset	d1,d0
	cmp.w	d1,d2
	bne.s	AssembleCom22e
	move.w	d0,2(a1)
	bra.s	AssembleCom22a

AssembleCom23:
	lea	$6(a1),a1
	move.l	a2,a3
	lea	AssembleCom24(pc),a2
	jmp	(a3)

AssembleCom24:
	move.l	$98(a6),a0
	bsr.s	AssembleComFindInstr
	bmi.s	AssembleComError
	clr.w	$5e(a6)			;x cursor
	move.l	$98(a6),a0
	move.l	a0,a1
	bsr	DisassembleCom1
	moveq	#'A',d0
	jsr	_WriteChar(a6)		
	move.l	$9c(a6),d0
	jsr	_WriteLong(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
AssembleComExit:
	rts
AssembleComError:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	rts

*****************************************************************************
	INCLUDE	AssembleFind
*****************************************************************************

BreakpointCom:
	rts
CompareCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	jsr	_ReadNumber(a6)
	move.l	d0,a2
	cmp.w	#$004f,d7
	bhi.s	CompareComExit1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
CompareCom1:
	moveq	#$7f,d2
CompareCom2:
	jsr	_ReadMemByte(a6)
	move.b	d0,d1
	exg	a0,a2
	jsr	_ReadMemByte(a6)
	exg	a0,a2
	cmp.b	d0,d1
	beq.s	CompareCom3
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	bsr	WaitIfCtrl
	cmp.w	#$0047,$5e(a6)
	bls.s	CompareCom3
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
CompareCom3:
	cmpa.l	a0,a1
	bls.s	CompareComExit
	dbf	d2,CompareCom2
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	CompareCom1
	move.l	a0,d0
	bsr	UserBreak
CompareComExit:
	tst.w	$5e(a6)
	beq.s	CompareComExit1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
CompareComExit1:
	rts

DisassembleCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	cmp.w	#$004f,d7
	bls.s	DisassembleCom1b
	move.l	$90(a6),a0
DisassembleCom1b:
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
DisassembleCom1:
	movem.l	a0/a1,-(a7)
	bsr.s	DisassembleComFindInstr
	lea	$b4(a6),a0
	bsr	DisassembleComMakeString
	movem.l	(a7)+,a0/a1
	jsr	_ClearLine(a6)
	moveq	#',',d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
DisassembleCom2:
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	jsr	_ReadMemWord(a6)
	jsr	_WriteWord(a6)
	cmp.l	$9c(a6),a0
	bne.s	DisassembleCom2
	move.w	#$0023,$5e(a6)			;Cursor x
	move.l	a0,-(a7)
	lea	$b4(a6),a0
	jsr	_WriteString(a6)
	move.l	(a7)+,a0
	bsr	WaitIfCtrl
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	cmpa.l	a0,a1
	bls.s	DisassembleComExit
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	DisassembleCom1
DisassembleComExit:
	rts

*****************************************************************************
	INCLUDE	DisassembleFind
*****************************************************************************

*****************************************************************************
	INCLUDE	DisassembleString
*****************************************************************************

DisassembleWriteCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	move.l	a0,$98(a6)
	move.l	a0,$9c(a6)
	cmp.w	#$000a,$5e(a6)
	ble.s	DisassembleWriteCom4
	cmp.w	#$0023,$5e(a6)
	beq.s	DisassembleWriteCom4
	cmp.w	#$0023,$5e(a6)
	bhi.s	DisassembleWriteCom3
DisassembleWriteCom1:
	jsr	_ReadByte(a6)
	bmi.s	DisassembleWriteCom2
	lsl.w	#8,d0
	move.l	d0,d1
	jsr	_ReadByte(a6)
	bmi.s	DisassembleWriteCom2
	or.w	d1,d0
	jsr	_WriteMemWord(a6)
	bra.s	DisassembleWriteCom1
DisassembleWriteCom2:
	clr.w	$5e(a6)
	move.l	$98(a6),a0
	move.l	a0,a1
	bsr	DisassembleCom1
	move.l	$9c(a6),a0
	move.l	a0,a1
	bsr	DisassembleCom1
	subq.w	#1,$5c(a6)
	move.w	#$000a,$5e(a6)
	rts
DisassembleWriteCom3:
	move.w	#$0022,d7
	bsr	AssembleComA
	clr.w	$5e(a6)
	move.l	$9c(a6),a0
	bsr	DisassembleCom1
	subq.w	#1,$5c(a6)
	move.w	#$0023,$5e(a6)
	rts
DisassembleWriteCom4:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	rts

ExchangeCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	jsr	_ReadNumber(a6)
	move.l	d0,a2
	cmp.w	#$004f,d7
	bhi.s	ExchangeComExit
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
ExchangeCom1:
	moveq	#$7f,d2
ExchangeCom2:
	jsr	_ReadMemByte(a6)
	move.b	d0,d1
	exg	a0,a2
	jsr	_ReadMemByte(a6)
	exg	d0,d1
	subq.l	#1,a0
	subq.l	#1,a2
	jsr	_WriteMemByte(a6)
	exg	a0,a2
	move.b	d1,d0
	jsr	_WriteMemByte(a6)
	cmpa.l	a0,a1
	bls.s	ExchangeComExit
	dbf	d2,ExchangeCom2
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	ExchangeCom1
	move.l	a0,d0
	bsr	UserBreak
ExchangeComExit:
	rts

FillCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	cmp.w	#$004f,d7
	bhi.s	FillComExit
	move.l	d7,d6
	move.l	a0,-(a7)
	move.l	$76(a6),a0
	jsr	_ReadString(a6)
	move.l	(a7)+,a0
	move.l	d0,d1
	bpl.s	FillCom2
	move.l	$76(a6),a2
	moveq	#$00,d1
	move.l	d6,d7
FillCom1:
	jsr	_ReadByte(a6)
	tst.l	d0
	bmi.s	FillCom2
	move.b	d0,(a2)+
	addq.w	#1,d1
	bra.s	FillCom1
FillCom2:
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	subq.w	#1,d1
	bmi.s	FillComExit
FillCom3:
	moveq	#$7f,d2
FillCom4:
	move.w	d1,d3
	move.l	$76(a6),a2
FillCom5:
	move.b	(a2)+,d0
	jsr	_WriteMemByte(a6)
	cmpa.l	a0,a1
	bls.s	FillComExit
	dbf	d3,FillCom5
	dbf	d2,FillCom4
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	FillCom3
	move.l	a0,d0
	bsr	UserBreak
FillComExit:
	rts

GoCom:
	jsr	_ReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	GoCom1
	move.l	d0,$90(a6)
GoCom1:	
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	move.w	#$2700,sr
	bsr	MakePrefsCheck
	jsr	_ExchangeRam(a6)
	bsr	WriteAgnus
	bsr	WriteCIA
	move.l	$8a(a6),a7
	move.l	$90(a6),-(a7)
	move.w	$8e(a6),-(a7)
	move.l	$58(a6),a0
	move.l	a0,USP
	movem.l	$1c(a6),d0-d7/a0-a6
	rte

HuntCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	cmp.w	#$004f,d7
	bhi	HuntComExit1
	move.l	d7,d6
	move.l	$76(a6),a2
	lea	$50(a2),a3
	move.l	a0,-(a7)
	move.l	a2,a0
	jsr	_ReadString(a6)
	move.l	(a7)+,a0
	move.l	d0,d1
	beq	HuntComExit1
	bpl.s	HuntCom3
	moveq	#$00,d1
	move.l	d6,d7
HuntCom1:
	jsr	_ReadByte(a6)
	tst.l	d0
	bmi.s	HuntCom2
	move.b	d0,(a2)+
	clr.b	(a3)+
	addq.w	#1,d1
	bra.s	HuntCom1
HuntCom2:
	subq.w	#1,d7
	bsr	ReadChar
	cmp.b	#$3f,d0
	bne.s	HuntCom4
	clr.b	(a2)+
	move.b	d0,(a3)+
	addq.w	#1,d1
	bra.s	HuntCom1
HuntCom3:
	clr.b	(a3)+
	subq.b	#1,d0
	bne.s	HuntCom3
HuntCom4:
	subq.w	#1,d1
	bmi.s	HuntComExit1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
HuntCom5:
	moveq	#$7f,d2
HuntCom6:
	move.w	d1,d3
	move.l	$76(a6),a2
	lea	$50(a2),a3
	move.l	a0,a4
HuntCom7:
	jsr	_ReadMemByte(a6)
	move.b	(a2)+,d4
	tst.b	(a3)+
	bne.s	HuntCom8
	cmp.b	d4,d0
	bne.s	HuntCom9
HuntCom8:
	cmpa.l	a0,a1
	bls.s	HuntComExit
	dbf	d3,HuntCom7
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.l	a4,d0
	jsr	_WriteLong(a6)
	bsr	WaitIfCtrl
	cmp.w	#$0047,$5e(a6)
	bls	HuntCom9
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
HuntCom9:
	move.l	a4,a0
	addq.l	#1,a0
	cmpa.l	a0,a1
	bls.s	HuntComExit
	dbf	d2,HuntCom6
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	HuntCom5
	move.l	a0,d0
	bsr	UserBreak
HuntComExit:
	tst.w	$5e(a6)
	beq.s	HuntComExit1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
HuntComExit1:
	rts

InterpretCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	cmp.w	#$004f,d7
	bls.s	InterpretCom0
	move.l	$90(a6),a0
InterpretCom0:
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
InterpretCom1:
	jsr	_ClearLine(a6)
	moveq	#$27,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	addq.w	#1,$5e(a6)	;Space
	moveq	#$3f,d1
InterpretCom2:
	jsr	_ReadMemByte(a6)
	jsr	_WriteASCIIChar(a6)
	dbf	d1,InterpretCom2
	bsr	WaitIfCtrl
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	cmpa.l	a0,a1
	bls.s	InterpretComExit
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	InterpretCom1
InterpretComExit:
	rts
InterpretWriteCom:
	jsr	_ReadNumber(a6)
	addq.w	#1,d7
	cmp.w	$5e(a6),d7		;Cursor X position
	bge.s	InterpretWriteComExit
	subq.w	#1,d7
	cmp.w	#$004f,d7
	bhi.s	InterpretWriteComExit
	move.l	d0,a0
	move.l	a0,a2
	moveq	#$3f,d1
InterpretWriteCom1:
	bsr	ReadChar
	tst.l	d0
	bmi.s	InterpretWriteCom2
	jsr	_WriteMemByte(a6)
	dbf	d1,InterpretWriteCom1
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr.s	InterpretCom1	;Write Line Again
	moveq	#$27,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	rts
InterpretWriteCom2:
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr	InterpretCom1	;Write Line Again
	rts
InterpretWriteComExit:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	rts

JumpCom:
	move.l	$90(a6),a2
	jsr	_ReadNumber(a6)
	cmp.w	#$004f,d7
	bhi.s	JumpCom1
	move.l	d0,a2
JumpCom1:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	move.w	#$2700,sr
	bsr	MakePrefsCheck
	jsr	_ExchangeRam(a6)
	bsr	WriteAgnus
	bsr	WriteCIA
	move.l	$58(a6),a0		;USP
	move.l	$8a(a6),a7		;SSP
	lea	Start3(pc),a1		;Return adress to Monitor
	btst	#5,$8e(a6)		;Test if Supervisor Mode
	bne.s	JumpCom2
	move.l	$90(a6),-(a0)
	move.l	a1,-(a0)		;Push on USP
	bra.s	JumpCom3
JumpCom2:
	move.l	$90(a6),-(a7)
	move.l	a1,-(a7)		;Push on SSP
JumpCom3:
	move.l	a0,USP
	move.l	a2,-(a7)
	move.w	$8e(a6),-(a7)
	movem.l	$1c(a6),d0-d7/a0-a6
	rte

LoadCom:
	move.l	d7,d6
	move.l	$76(a6),a0
	jsr	_ReadString(a6)
	tst.l	d0
	bmi	LoadCom1
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,a1
	jsr	_ReadNumber(a6)
	move.l	d0,a2
	bsr	LoadFile
	bra.s	LoadCom2
LoadCom1:
	move.l	d6,d7
	jsr	_ReadNumber(a6)
	move.b	d0,$11c(a6)
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,d1
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,d2
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,a0
	cmp.w	#1760,d1
	bcc.s	LoadCom2
	move.l	d1,d0
	move.l	d2,d1
	bsr	ReadBlocks
LoadCom2:
	move.l	d0,d1
	lea	LoadComText1(pc),a0
	jsr	_WriteString(a6)
	move.l	d1,d0
	jsr	_WriteLong(a6)
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
LoadComExit:
	rts

LoadComText1:
	dc.b	$0a,"* End address ",0
	even

MemoryCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	cmp.w	#$004f,d7
	bls.s	MemoryCom1
	move.l	$90(a6),a0
MemoryCom1:
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
MemoryCom2:
	jsr	_ClearLine(a6)
	moveq	#$3a,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	move.l	$76(a6),a2	;Buffert
	moveq	#$03,d1
MemoryCom3:
	moveq	#$03,d2
MemoryCom4:
	addq.w	#1,$5e(a6)	;Space
	jsr	_ReadMemByte(a6)
	move.b	d0,(a2)+
	jsr	_WriteByte(a6)
	dbf	d2,MemoryCom4
	addq.w	#1,$5e(a6)	;Space
	dbf	d1,MemoryCom3
	moveq	#$0f,d1
	move.l	$76(a6),a2	;Buffert
MemoryCom5:
	move.b	(a2)+,d0
	jsr	_WriteASCIIChar(a6)
	dbf	d1,MemoryCom5
	bsr	WaitIfCtrl
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	cmpa.l	a0,a1
	bls.s	MemoryComExit
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	MemoryCom2
MemoryComExit:
	rts

MemoryWriteCom:
	jsr	_ReadNumber(a6)
	addq.w	#1,d7
	cmp.w	$5e(a6),d7		;Cursor X position
	bge	MemoryWriteComExit
	subq.w	#1,d7
	cmp.w	#$004f,d7
	bhi	MemoryWriteComExit
	move.l	d0,a0
	move.l	a0,a2
	moveq	#$0f,d1
	add.w	#$0034,d7
	cmp.w	$5e(a6),d7
	beq	MemoryWriteComExit
	subq.w	#1,d7
	cmp.w	$5e(a6),d7
	blt.s	MemoryWriteCom3
	sub.w	#$0033,d7
MemoryWriteCom1:
	jsr	_ReadByte(a6)
	tst.l	d0
	bmi.s	MemoryWriteCom2
	jsr	_WriteMemByte(a6)
	dbf	d1,MemoryWriteCom1
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr	MemoryCom2	;Write Line Again
	moveq	#$3a,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	rts
MemoryWriteCom2:
	cmp.w	#$000f,d1
	beq.s	MemoryWriteComExit
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	move.l	d1,-(a7)
	bsr	MemoryCom2	;Write Line Again
	move.l	(a7)+,d1
	subq.w	#1,$5c(a6)
	eor.w	#$000f,d1
	move.w	d1,d2
	add.w	d1,d1
	add.w	d2,d1
	lsr.w	#2,d2
	add.w	d2,d1
	add.w	#$000a,d1
	move.w	d1,$5e(a6)
	rts
MemoryWriteCom3:
	bsr	ReadChar
	tst.l	d0
	bmi.s	MemoryWriteCom2
	jsr	_WriteMemByte(a6)
	dbf	d1,MemoryWriteCom3
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr	MemoryCom2	;Write Line Again
	moveq	#$3a,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	add.w	#$0033,$5e(a6)
	rts
MemoryWriteComExit:
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

NewlocatorCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	jsr	_ReadNumber(a6)
	move.l	d0,d2
	jsr	_ReadNumber(a6)
	move.l	d0,d3
	jsr	_ReadNumber(a6)
	move.l	d0,d4
	cmp.w	#$004f,d7
	bhi	NewLocatorComExit
	sub.l	d2,d4
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
NewLocatorCom1:
	moveq	#$7f,d2
NewLocatorCom2:
	movem.l	d2-d4/a1,-(a7)
	bsr	DisassembleComFindInstr
	movem.l	(a7)+,d2-d4/a1
	move.l	$a0(a6),a2
	cmp.b	#'?',(a2)
	beq	NewLocatorComError	;False Instruction
	move.w	$a6(a6),d0
	move.w	d0,d1
	and.w	#$0180,d1
	beq.s	NewLocatorCom4
	cmp.l	$a8(a6),d2
	bhi.s	NewLocatorCom4
	cmp.l	$a8(a6),d3
	bls.s	NewLocatorCom4
	add.l	d4,$a8(a6)
	move.l	$b8(a6),d5
	exg	a0,d5
	cmp.w	#$0080,d0
	beq.s	NewLocatorCom3
	move.w	$a8(a6),d0
	jsr	_WriteMemWord(a6)
NewLocatorCom3:
	move.w	$aa(a6),d0
	jsr	_WriteMemWord(a6)
	exg	a0,d5
	*bra.s	NewLocatorCom4
NewLocatorCom4:
	move.w	$ac(a6),d0
	move.w	d0,d1
	and.w	#$0180,d1
	beq.s	NewLocatorCom6
	cmp.l	$ae(a6),d2
	bhi.s	NewLocatorCom6
	cmp.l	$ae(a6),d3
	bls.s	NewLocatorCom6
	add.l	d4,$ae(a6)
	move.l	$bc(a6),d5
	exg	a0,d5
	cmp.w	#$0080,d0
	beq.s	NewLocatorCom5
	move.w	$ae(a6),d0
	jsr	_WriteMemWord(a6)
NewLocatorCom5:
	move.w	$b0(a6),d0
	jsr	_WriteMemWord(a6)
	exg	a0,d5
NewLocatorCom6:
	cmpa.l	a0,a1
	bls.s	NewLocatorComExit
	dbf	d2,NewLocatorCom2
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	NewLocatorCom1
	move.l	a0,d0
	bsr	UserBreak
NewLocatorComExit:
	rts
NewLocatorComError:
	move.l	$98(a6),a0
	suba.l	a1,a1
	bra	DisassembleCom1

QuickTraceCom:
	rts

RegisterCom:
	lea	RegisterString1(pc),a0
	jsr	_WriteString(a6)
	lea	$1c(a6),a0
	moveq	#";",d0
	jsr	_WriteChar(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	moveq	#$07,d1
RegisterCom1:
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.l	(a0)+,d0
	jsr	_WriteLong(a6)
	dbf	d1,RegisterCom1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	moveq	#";",d0
	jsr	_WriteChar(a6)
	moveq	#";",d0
	jsr	_WriteChar(a6)
	moveq	#$07,d1
RegisterCom2:
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.l	(a0)+,d0
	jsr	_WriteLong(a6)
	dbf	d1,RegisterCom2
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	moveq	#";",d0
	jsr	_WriteChar(a6)
	moveq	#";",d0
	jsr	_WriteChar(a6)
	moveq	#";",d0
	jsr	_WriteChar(a6)
	move.l	$8a(a6),d0
	jsr	_WriteLong(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.l	$90(a6),d0
	move.l	d0,a0
	jsr	_WriteLong(a6)
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.w	$8e(a6),d0
	jsr	_WriteWord(a6)
	addq.w	#5,$5e(a6)
	bsr	DisassembleComFindInstr
	lea	$b4(a6),a0
	bsr	DisassembleComMakeString
	lea	$b4(a6),a0
	jsr	_WriteString(a6)
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

RegisterString1:
	dc.b	$0a,"  D0 A0 SSP D1 A1 PC D2 A2 SR D3    A3"
	dc.b	" D4    A4 D5    A5 D6    A6 D7   USP",$0a,0
	even

RegisterWriteCom:
	bsr	ReadChar
	cmp.b	#";",d0
	beq.s	RegisterWriteCom1
	lea	$1c(a6),a0
	bra.s	RegisterWriteCom3
RegisterWriteCom1:
	bsr	ReadChar
	cmp.b	#";",d0
	beq.s	RegisterWriteCom2
	lea	$3c(a6),a0
RegisterWriteCom3:
	moveq	#$07,d1
RegisterWriteCom4:
	jsr	_ReadNumber(a6)
	move.l	d0,(a0)+
	dbf	d1,RegisterWriteCom4
	bra.s	RegisterWriteComExit
RegisterWriteCom2:
	jsr	_ReadNumber(a6)
	move.l	d0,$8a(a6)
	jsr	_ReadNumber(a6)
	move.l	d0,$90(a6)
	jsr	_ReadNumber(a6)
	move.w	d0,$8e(a6)
RegisterWriteComExit:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	rts	

SaveCom:
	move.l	d7,d6
	move.l	$76(a6),a0
	jsr	_ReadString(a6)
	tst.l	d0
	bmi	SaveCom1
	jsr	_ReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	SaveComExit
	move.l	d0,a1
	jsr	_ReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	SaveComExit
	move.l	d0,a2
	bsr	SaveFile
	bra.s	SaveCom2
SaveCom1:
	move.l	d6,d7
	jsr	_ReadNumber(a6)
	move.b	d0,$11c(a6)
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	SaveComExit
	move.l	d0,d1
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	SaveComExit
	move.l	d0,d2
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	SaveComExit
	move.l	d0,a0
	cmp.w	#1760,d1
	bcc.s	SaveCom2
	move.l	d1,d0
	move.l	d2,d1
	bsr	WriteBlocks
	bsr	WriteLastTrack
SaveCom2:
	move.l	d0,d1
	lea	LoadComText1(pc),a0
	jsr	_WriteString(a6)
	move.l	d1,d0
	jsr	_WriteLong(a6)
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
SaveComExit:
	rts

TransferCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a0
	jsr	_ReadNumber(a6)
	move.l	d0,a1
	jsr	_ReadNumber(a6)
	move.l	d0,a2
	cmp.w	#$004f,d7
	bhi.s	TransferComExit
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	cmp.l	a2,a0
	bls.s	TransferCom3		;Backwards
TransferCom1:
	moveq	#$7f,d2
TransferCom2:
	jsr	_ReadMemByte(a6)
	exg	a0,a2
	jsr	_WriteMemByte(a6)
	exg	a0,a2
	cmpa.l	a0,a1
	bls.s	TransferComExit
	dbf	d2,TransferCom2
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	TransferCom1
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	move.l	a0,d0
	jsr	_WriteLong(a6)
	bra.s	TransferComExit
TransferCom3:
	add.l	a1,a2
	sub.l	a0,a2
	exg	a0,a1
	subq.l	#1,a0
	subq.l	#1,a1
	subq.l	#1,a2
TransferCom4:
	moveq	#$7f,d2
TransferCom5:
	jsr	_ReadMemByte(a6)
	exg	a0,a2
	jsr	_WriteMemByte(a6)
	exg	a0,a2
	subq.l	#2,a0
	subq.l	#2,a2
	cmpa.l	a1,a0
	beq.s	TransferComExit
	dbf	d2,TransferCom5
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	TransferCom4
	move.l	a0,d0
	bsr	UserBreak
TransferComExit:
	rts

WalktraceCom:
	rts
ExitCom:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	move.w	#$2700,sr
	bsr	LoadExitPar
	bsr	MakePrefsCheck
	jsr	_ExchangeRam(a6)
	bsr	WriteAgnus
	bsr	WriteCIA
	move.l	$8a(a6),a7
	move.l	$90(a6),-(a7)
	move.w	$8e(a6),-(a7)
	move.l	$58(a6),a0
	move.l	a0,USP
	movem.l	$1c(a6),d0-d7/a0-a6
	rte

ChangeDirCom:				;Change Directory
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bpl.s	ChangeDirCom1
	bsr	ShowCurrentDir
	rts
ChangeDirCom1:
	move.l	$76(a6),a0
	bsr	ChangeDirectory
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

CloseCom:
	move.l	$19c(a6),a0		;Filename
	move.l	$150(a6),a1		;Text Start
	move.l	$154(a6),a2		;Text End
	bsr	SaveFile
	move.l	$150(a6),d0		;EDTEXTSTART
	move.l	d0,$154(a6)		;EDTEXTEND
	move.l	d0,$186(a6)		;EDCUTEND
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

DateCom:				;Set/Read Date
DateCom1:
	jsr	_ReadDecNumber(a6)
	cmp.w	#$004f,d7
	bhi	DateCom4
	move.l	d0,d2
	subq.w	#1,d7
	bsr	ReadChar
	cmp.b	#'-',d0
	beq.s	DateCom2
	cmp.b	#':',d0
	bne.s	DateCom4
	jsr	_ReadDecNumber(a6)
	move.l	d0,d1
	cmp.w	#$004f,d7
	bhi.s	DateCom4
	jsr	_ReadDecNumber(a6)
	cmp.w	#$004f,d7
	bhi.s	DateCom4
	exg	d0,d2
	bsr	WriteTODTime
	bra.s	DateCom1
DateCom2:
	bsr	ReadChar
	and.w	#$005f,d0
	move.w	d0,d1
	lsl.w	#8,d1
	bsr	ReadChar
	or.w	#$0020,d0
	move.b	d0,d1
	lsl.l	#8,d1
	bsr	ReadChar
	or.w	#$0020,d0
	move.b	d0,d1
	lsl.l	#8,d1
	lea	Datecodes2+$c(pc),a0
	moveq	#$00,d0
DateCom3:
	cmp.w	#$000c,d0
	beq.s	DateCom4
	addq.w	#1,d0
	cmp.l	(a0)+,d1
	bne.s	DateCom3
	move.l	d0,d1
	jsr	_ReadDecNumber(a6)
	cmp.w	#$004f,d7
	bhi.s	DateCom4
	add.w	#1900,d0
	exg	d0,d2
	bsr	WriteTODDate	
	bra	DateCom1
DateCom4:
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	bsr	ShowDay
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	bsr	ShowDate
	moveq	#$20,d0
	jsr	_WriteChar(a6)
	bsr	ShowTime
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

DeleteCom:				;Delete File/Directory
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_ReadStringII(a6)
	move.l	$76(a6),a0
	bsr	DeleteFile
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

DirectoryCom:				;See Directory
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_ReadStringII(a6)
	move.l	$76(a6),a0
	bsr	ShowDirectory
	rts

DiskCopyCom:				;Format Disk
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	DiskCopyComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	DiskCopyComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,d4			;Source Drive
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	DiskCopyComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	DiskCopyComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,d1			;Destin Drive
	move.b	d4,d0
	bsr	DiskCopy
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
DiskCopyComExit:
	rts

FileNoteCom:				;Set Comment
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	FileNoteComExit
	move.l	$76(a6),a0
	add.l	d0,a0
	addq.l	#1,a0
	move.l	a0,a1			;Comment
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	FileNoteComExit
	move.l	$76(a6),a0		;FileName
	bsr	FileNote
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
FileNoteComExit:
	rts

FormatCom:				;Format Disk
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	FormatComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	FormatComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)		;Drive nr
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	FormatComExit
	move.l	$76(a6),a0		;Name
	move.l	a0,d0
	bsr	FormatDisk
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
FormatComExit:
	rts

HuntDisCom:
	jsr	_ReadNumber(a6)
	move.l	d0,a2
	jsr	_ReadNumber(a6)
	move.l	d0,a3
	cmp.w	#$004f,d7
	bhi	HuntDisComExit
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi	HuntDisComExit
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
HuntDisCom1:
	move.b	(a0)+,d0
	beq.s	HuntDisCom2
	btst	#6,d0
	beq.s	HuntDisCom1
	and.b	#$5f,d0			;Convert to capitals
	move.b	d0,-1(a0)
	bra.s	HuntDisCom1
HuntDisCom2:
	moveq	#$7f,d2
HuntDisCom3:
	move.l	a2,a0
	movem.l	d2/a2-a3,-(a7)
	bsr	DisassembleComFindInstr
	move.l	a0,-(a7)
	lea	$b4(a6),a0
	bsr	DisassembleComMakeString
	move.l	(a7)+,a0
	movem.l	(a7)+,d2/a2-a3
	move.l	a0,a2
	lea	$b4(a6),a0
	move.l	$76(a6),a1
	sub.l	a4,a4
HuntDisCom4:
	move.b	(a1)+,d0
	beq.s	HuntDisCom8
	cmp.b	#' ',d0			;Any characters any length
	beq.s	HuntDisCom5
	cmp.b	#'*',d0			;Any characters any length
	beq.s	HuntDisCom5
	cmp.b	#'?',d0			;Any character
	beq.s	HuntDisCom7
	move.b	(a0)+,d1
	beq.s	HuntDisCom10
	cmp.b	d1,d0
	beq.s	HuntDisCom4
	move.l	a4,d0
	beq.s	HuntDisCom10
	move.l	d0,a1
	bra.s	HuntDisCom4
HuntDisCom5:
	move.l	a1,a4
	move.b	(a1)+,d0
	beq.s	HuntDisCom9		;Found
HuntDisCom6:
	move.b	(a0)+,d1
	beq.s	HuntDisCom10
	cmp.b	d1,d0
	bne.s	HuntDisCom6
	bra.s	HuntDisCom4
HuntDisCom7:
	move.b	(a0)+,d1
	bne.s	HuntDisCom4
	bra.s	HuntDisCom10
HuntDisCom8:
	move.b	(a0)+,d1
	beq.s	HuntDisCom9		;Found
	bra.s	HuntDisCom10
HuntDisCom9:
	move.l	$98(a6),a0
	suba.l	a1,a1
	movem.l	d1-d7/a2-a3,-(a7)
	bsr	DisassembleCom1
	movem.l	(a7)+,d1-d7/a2-a3
HuntDisCom10:				;Not Found
	cmpa.l	a2,a3
	bls.s	HuntDisComExit
	dbf	d2,HuntDisCom3
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	HuntDisCom2
	move.l	a2,d0
	bsr	UserBreak
HuntDisComExit:
	rts

InfoCom:				;Show Disk info
	bsr	ShowInfo
	rts

InstallCom:				;Install Disk
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	InstallComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	InstallComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	bsr	InstallDisk
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
InstallComExit:
	rts

LoadSegCom:
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi	LoadSegComExit
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadSegComExit
	move.l	d0,a1
	bsr	LoadSegFile
	move.l	d0,d1
	lea	LoadSegComText1(pc),a0
	jsr	_WriteString(a6)
	move.l	d1,d0
	jsr	_WriteLong(a6)
	lea	LoadSegComText2(pc),a0
	jsr	_WriteString(a6)
	moveq	#$00,d2
LoadSegCom1:
	move.l	d1,a0
	subq.l	#4,a0
	jsr	_ReadMemLong(a6)
	move.l	d0,d3
	add.l	d0,d2
	jsr	_ReadMemLong(a6)
	add.l	d0,d0
	add.l	d0,d0
	move.l	d0,d1
	bne.s	LoadSegCom1
	subq.l	#8,a0
	move.l	d3,d0
	add.l	a0,d0
	jsr	_WriteLong(a6)
	lea	LoadSegComText3(pc),a0
	jsr	_WriteString(a6)
	move.l	d2,d0
	move.l	#1000000000,d1
	jsr	_WriteDecNumberII(a6)
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
LoadSegComExit:
	rts

LoadSegComText1:
	dc.b	$0a,"* First segment:",0
LoadSegComText2:
	dc.b	" End adress:",0
LoadSegComText3:
	dc.b	" Total length:",0
	even

MakeDirCom:				;Create Directory
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_ReadStringII(a6)
	move.l	$76(a6),a0
	tst.b	(a0)
	beq.s	MakeDirComExit
	bsr	MakeDir
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
MakeDirComExit:
	rts

NewCom:
	move.l	$150(a6),d0		;EDTEXTSTART
	move.l	d0,$154(a6)		;EDTEXTEND
	move.l	d0,$186(a6)		;EDCUTEND
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

OpenCom:
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi	OpenComExit
	move.l	$150(a6),a1		;Text Start
	move.l	$182(a6),a2		;Work End
	moveq	#$0e,d7
	move.l	a2,d1
	sub.l	a1,d1
	beq	ErrorHandler		;No workbuffer
	bcs	ErrorHandler		;No workbuffer
	bsr	GetFileLength
	moveq	#$0f,d7
	cmp.l	d1,d0
	bhi	ErrorHandler		;File too long
	move.l	a1,$154(a6)		;No Textlength
	bsr	LoadFile
	move.l	d0,$154(a6)		;Text End
	move.l	d0,$186(a6)		;Cut End
	clr.l	$158(a6)		;Textline nr
	move.l	d0,d1
	sub.l	a1,d1
	move.l	$19c(a6),a1		;Filename
OpenCom1:
	move.b	(a0)+,(a1)+
	bne.s	OpenCom1
	lea	OpenComText1(pc),a0
	jsr	_WriteString(a6)
	move.l	d1,d0
	move.l	#1000000000,d1
	jsr	_WriteDecNumberII(a6)
	lea	OpenComText2(pc),a0
	jsr	_WriteString(a6)
OpenComExit:
	rts
OpenComText1:
	dc.b	$a,"* File length ",0
OpenComText2:
	dc.b	" bytes",$a,0
	even

ProtectCom:				;Set Protect
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	ProtectComExit
	move.l	$76(a6),a0
	add.l	d0,a0
	addq.l	#1,a0
	move.l	a0,a1			;Protect
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	ProtectComExit
	move.l	$76(a6),a0		;FileName
	bsr	ProtectFile
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
ProtectComExit:
	rts

RelabelCom:				;ReLabel Disk
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	RelabelComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	RelabelComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)		;Drive nr
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	RelabelComExit
	beq.s	RelabelComExit
	move.l	$76(a6),a0		;Name
	bsr	RelabelDisk
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
RelabelComExit:
	rts

RenameCom:				;Rename File
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	RenameComExit
	move.l	$76(a6),a0
	add.l	d0,a0
	addq.l	#1,a0
	move.l	a0,a1			;New Name
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	RenameComExit
	move.l	$76(a6),a0		;FileName
	bsr	RenameFile
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
RenameComExit:
	rts

SaveTextCom:
	move.l	$76(a6),a0
	jsr	_ReadStringII(a6)
	tst.l	d0
	bmi.s	SaveTextCom2		;No Filename specified
	move.l	$19c(a6),a1		;Filename
SaveTextCom1:
	move.b	(a0)+,(a1)+
	bne.s	SaveTextCom1
SaveTextCom2:
	move.l	$19c(a6),a0		;Text FileName
	move.l	$150(a6),a1		;Text Start
	move.l	$154(a6),a2		;Text End
	bsr	SaveFile
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts

ShowSegCom:
	jsr	_ReadNumber(a6)
	cmp.w	#$0050,d7
	beq	ShowSegComExit
	move.l	d0,a0
	bsr	ShowSegList
ShowSegComExit:
	rts

TypeCom:				;Type File
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_ReadStringII(a6)
	move.l	$76(a6),a0
	bsr	TypeFile
	rts

WorkBufCom:
	jsr	_ReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	WorkBufCom1
	move.l	d0,d1
	jsr	_ReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	WorkBufComExit
	move.l	d1,$150(a6)		;EDWORKSTART
	move.l	d1,$154(a6)		;EDTEXTEND
	move.l	d1,$186(a6)		;EDCUTEND
	move.l	d0,$182(a6)		;EDWORKEND
	bra.s	WorkBufCom1
WorkBufComExit:
	rts
WorkBufCom1:
	lea	WorkBufComText1(pc),a0
	move.l	$150(a6),d1
	move.l	$182(a6),d2
	bsr.s	WorkBufCom2
	lea	WorkBufComText2(pc),a0
	move.l	$150(a6),d1
	move.l	$154(a6),d2
	bsr.s	WorkBufCom2
	lea	WorkBufComText3(pc),a0
	move.l	$186(a6),d1
	move.l	$182(a6),d2
	bsr.s	WorkBufCom2
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	rts
WorkBufCom2:
	jsr	_WriteString(a6)
	move.l	d1,d0
	jsr	_WriteLong(a6)
	lea	WorkBufComText5(pc),a0
	jsr	_WriteString(a6)
	move.l	d2,d0
	jsr	_WriteLong(a6)
	lea	WorkBufComText4(pc),a0
	jsr	_WriteString(a6)
	move.l	d2,d0
	sub.l	d1,d0
	move.l	#1000000000,d1
	jsr	_WriteDecNumberII(a6)
	rts

WorkBufComText1:
	dc.b	$a,"* Workbuffer:",$9,0
WorkBufComText2:
	dc.b	$a,"* Source:",$9,0
WorkBufComText3:
	dc.b	$a,"* Free:",$9,$9,0
WorkBufComText4:
	dc.b	" Length:",0
WorkBufComText5:
	dc.b	" - ",0
	even

UserBreak:
	movem.l	d1/a0,-(a7)
	move.l	d0,d1
	tst.w	$5e(a6)
	beq.s	UserBreak1
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
UserBreak1:
	lea	UserBreakText(pc),a0
	jsr	_WriteString(a6)
	move.l	d1,d0
	jsr	_WriteLong(a6)
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	movem.l	(a7)+,d1/a0
	rts

UserBreakText:
	dc.b	"* User-Break at adress ",0
	even

ShowSegList:			;a0=First segment
	movem.l	d1-d3/a0-a1,-(a7)
	move.l	a0,a1
	move.l	#1000000000,d1
	moveq	#$00,d2		;Segnr
	moveq	#$00,d3		;Tot Length
ShowSegList1:
	lea	ShowSegListText1(pc),a0
	jsr	_WriteString(a6)
	move.l	d2,d0
	jsr	_WriteDecNumberII(a6)
	move.w	#$0010,$5e(a6)
	lea	ShowSegListText2(pc),a0
	jsr	_WriteString(a6)
	move.l	a1,d0
	addq.l	#4,d0
	jsr	_WriteLong(a6)
	lea	ShowSegListText3(pc),a0
	jsr	_WriteString(a6)
	lea	-4(a1),a0
	jsr	_ReadMemLong(a6)
	add.l	d0,d3
	subq.l	#8,d0
	jsr	_WriteDecNumberII(a6)
	bsr	WaitIfCtrl
	jsr	_ReadKeyboard(a6)
	cmp.b	#$1b,d0
	beq.s	ShowSegListExit
	move.l	a1,a0
	jsr	_ReadMemLong(a6)
	tst.l	d0
	beq.s	ShowSegListExit
	move.l	d0,a1
	add.l	a1,a1
	add.l	a1,a1
	addq.l	#1,d2
	bra.s	ShowSegList1
ShowSegListExit:
	lea	ShowSegListText4(pc),a0
	jsr	_WriteString(a6)
	move.l	d3,d0
	jsr	_WriteDecNumberII(a6)
	moveq	#$0a,d0
	jsr	_WriteChar(a6)
	movem.l	(a7)+,d1-d3/a0-a1
	rts

ShowSegListText1:
	dc.b	$a,"* Segment ",0
ShowSegListText2:
	dc.b	" Address ",0
ShowSegListText3:
	dc.b	" Length ",0
ShowSegListText4:
	dc.b	$a,"* Total length ",0
	even


ReadExpression:			;d0out=Answer 32
	movem.l	d1-d7/a0-a6,-(a7)
	moveq	#$00,d0
ReadExpression1:
	bsr	ReadChar
	tst.l	d0
	beq.s	ReadExpressionQuit
	cmp.b	#' ',d0
	beq.s	ReadExpressionQuit1
	cmp.b	#'+',d0
	beq.s	ReadExpression2
	cmp.b	#'-',d0
	beq.s	ReadExpression3
	cmp.b	#'*',d0
	beq.s	ReadExpression4
	cmp.b	#'/',d0
	beq.s	ReadExpression5
	cmp.b	#'(',d0
	beq.s	ReadExpression6
	cmp.b	#')',d0
	beq.s	ReadExpression7
	bsr.s	ReadExpressionLastChar
ReadExpression2:			;"+"
	bsr.s	ReadExpressionNumber
ReadExpression3:			;"+"
ReadExpression4:			;"+"
ReadExpression5:			;"+"
ReadExpression6:			;"+"
ReadExpression7:			;"+"
ReadExpressionQuit1:
	bsr.s	ReadExpressionLastChar
ReadExpressionQuit:
	movem.l	(a7)+,d1-d7/a0-a6
	rts

ReadExpressionLastChar:
	cmp.w	#$004f,d7
	bhi.s	ReadExpressionLastChar1
	subq.w	#1,d7
ReadExpressionLastChar1:
	rts

ReadExpressionThisChar:

ReadExpressionNumber:
	

MultiplyInteger:		;d0=Factor1 32 , d1=Factor2 32
				;d0out=Product 32
	movem.l	d2/d3,-(a7)
	moveq	#$00,d2		;Product
	moveq	#$1f,d3
MultiplyInteger1:
	lsr.l	#1,d1
	bcc.s	MultiplyInteger2
	add.l	d0,d2
MultiplyInteger2:
	lsl.l	#1,d0
	dbf	d3,MultiplyInteger1
	move.l	d2,d0
	movem.l	(a7)+,d2/d3
	rts
		
DivideInteger:			;d0=Dividend 32 , d1=Divisor 32
				;d0out=Quote 32 , d1out=Rest 32
	movem.l	d2-d5,-(a7)
	moveq	#$00,d2
	moveq	#$1f,d4
	moveq	#$00,d5
	move.l	d2,d3
	tst.l	d1
	beq.s	DivideInteger2
DivideInteger1:
	bmi.s	DivideInteger2
	addq.w	#1,d2
	lsl.l	#1,d0
	roxl.l	#1,d3
	lsl.l	#1,d1
	bra.s	DivideInteger1
DivideInteger2:
	lsl.l	#1,d0
	roxl.l	#1,d3
	bcs.s	DivideInteger3
	cmp.l	d3,d1
	bls.s	DivideInteger3
	lsl.l	#1,d5
	bra.s	DivideInteger4
DivideInteger3:
	lsl.l	#1,d5
	bset	#0,d5
	sub.l	d1,d3
DivideInteger4:
	subq.w	#1,d4
	bpl.s	DivideInteger2
DivideInteger5:
	lsr.l	d2,d3
	move.l	d3,d1
	move.l	d5,d0
	movem.l	(a7)+,d2-d5
	rts
		
ReadTODDate:
			;d0out=Day,d1out=Month,d2out=Year
	movem.l	d3/d4/a0,-(a7)
	lea	$dc0036,a0
	and.w	#$fffe,(a0)	;Start Clock
	lea	$dc0018,a0
	bsr.s	ReadTODDate1
	move.l	d3,d0
	bsr.s	ReadTODDate1
	move.l	d3,d1
	bsr.s	ReadTODDate1
	move.l	d3,d2
	add.w	#1900,d2	;Year 1990-1999
	cmp.w	#1989,d2
	bhi.s	ReadTODDate0
	add.w	#100,d2		;Year 2000-2089	!
ReadTODDate0:
	movem.l	(a7)+,d3/d4/a0
	rts

ReadTODDate1:
	move.l	(a0)+,d3
	and.w	#$000f,d3
	move.l	(a0)+,d4
	and.w	#$000f,d4
	mulu	#10,d4
	add.w	d4,d3
	ext.l	d3
	rts

ReadTODTime:
			;d0out=Hours,d1out=Min,d2out=Secs
	movem.l	d3/d4/a0,-(a7)
	lea	$dc0036,a0
	and.w	#$fffe,(a0)		;Start Clock
	lea	$dc0000,a0
	bsr.s	ReadTODTime1
	move.l	d3,d2
	bsr.s	ReadTODTime1
	move.l	d3,d1
	bsr.s	ReadTODTime1
	move.l	d3,d0
	movem.l	(a7)+,d3/d4/a0
	rts

ReadTODTime1:
	move.l	(a0)+,d3
	and.w	#$000f,d3
	move.l	(a0)+,d4
	and.w	#$000f,d4
	mulu	#10,d4
	add.w	d4,d3
	ext.l	d3
	rts

WriteTODTime:
			;d0=Hours,d1=Min,d2=Secs
	movem.l	d3/a0,-(a7)
	lea	$dc003e,a0
	move.w	#$fff1,(a0)		;Clear MicroSeconds
	move.w	#$fff5,(a0)
	move.w	#$fff4,(a0)
	lea	$dc0000,a0
	move.l	d2,d3
	bsr.s	WriteTODTime1
	move.l	d1,d3
	bsr.s	WriteTODTime1
	move.l	d0,d3
	bsr.s	WriteTODTime1
	movem.l	(a7)+,d3/a0
	rts
WriteTODTime1:
	divu	#10,d3
	swap	d3
	move.l	d3,(a0)+
	swap	d3
	move.l	d3,(a0)+
	rts

WriteTODDate:
			;d0=Day,d1=Month,d2=Year
	movem.l	d3/a0,-(a7)
	lea	$dc003e,a0
	move.w	#$fff1,(a0)		;Clear MicroSeconds
	move.w	#$fff5,(a0)
	move.w	#$fff4,(a0)
	lea	$dc0018,a0
	move.l	d0,d3
	bsr.s	WriteTODDate1
	move.l	d1,d3
	bsr.s	WriteTODDate1
	move.l	d2,d3
	ext.l	d3
	divu	#100,d3
	clr.w	d3
	swap	d3
	bsr.s	WriteTODDate1
	movem.l	(a7)+,d3/a0
	rts
WriteTODDate1:
	divu	#10,d3
	swap	d3
	move.l	d3,(a0)+
	swap	d3
	move.l	d3,(a0)+
	rts

ShowDay:
	movem.l	d1/d2/a0,-(a7)
	bsr	ReadTODDate
	bsr	GetDayOfWeek
	move.l	d0,a0
	jsr	_WriteString(a6)
	movem.l	(a7)+,d1/d2/a0
	rts

ShowDate:
	movem.l	d1/d2,-(a7)
	bsr	ReadTODDate
	bsr	WriteDate
	movem.l	(a7)+,d1/d2
	rts

ShowTime:
	movem.l	d1/d2,-(a7)
	bsr	ReadTODTime
	bsr	WriteTime
	movem.l	(a7)+,d1/d2
	rts

WriteTime:		;d0=Hours,d1=Min,d2=Secs
	movem.l	d0-d3,-(a7)
	bsr.s	WriteTime1
	moveq	#':',d0
	jsr	_WriteChar(a6)
	move.l	d1,d0
	bsr.s	WriteTime1
	moveq	#':',d0
	jsr	_WriteChar(a6)
	move.l	d2,d0
	bsr.s	WriteTime1
	movem.l	(a7)+,d0-d3
	rts
WriteTime1:
	divu	#10,d0
	move.l	d0,d3
	swap	d3
	jsr	_WriteNumber(a6)
	move.w	d3,d0
	jsr	_WriteNumber(a6)
	rts

WriteDate:		;d0=Daynr,d1=Month,d2=Year
	movem.l	d0-d4/a0,-(a7)
	divu	#10,d0
	move.l	d0,d4
	swap	d4
	jsr	_WriteNumber(a6)
	move.w	d4,d0
	jsr	_WriteNumber(a6)
	moveq	#'-',d0
	jsr	_WriteChar(a6)
	lea	Datecodes2(pc),a0
	move.b	-1(a0,d1.w),d1
	ext.w	d1
	add.w	d1,a0
	jsr	_WriteString(a6)
	moveq	#'-',d0
	jsr	_WriteChar(a6)
	move.l	d2,d0
	divu	#100,d0
	swap	d0
	ext.l	d0
	divu	#10,d0
	move.l	d0,d4
	swap	d4
	jsr	_WriteNumber(a6)
	move.w	d4,d0
	jsr	_WriteNumber(a6)
	movem.l	(a7)+,d0-d4/a0
	rts

GetDayOfWeek:		;d0=Daynr,d1=Month,d2=Year
			;d0out=DayOfWeek-Name
	movem.l	d1-d3/a0,-(a7)
	move.w	d2,d3
	and.w	#$0003,d3
	bne.s	GetDayOfWeek1
	cmp.w	#$0002,d1
	bhi.s	GetDayOfWeek1
	addq.w	#6,d0
GetDayOfWeek1:
	divu	#100,d2
	lea	Timecodes3(pc),a0
	add.b	0(a0,d2.w),d0		;Century
	swap	d2
	lea	Timecodes4(pc),a0
	add.b	0(a0,d2.w),d0		;Year
	lea	Timecodes2(pc),a0
	add.b	-1(a0,d1.w),d0		;Month
	addq.w	#3,d0
	ext.w	d0
	ext.l	d0
	divu	#$0007,d0
	swap	d0
	lea	Timecodes1(pc),a0
	move.b	0(a0,d0.w),d0
	ext.w	d0
	add.w	d0,a0
	move.l	a0,d0
	movem.l	(a7)+,d1-d3/a0
	rts

*****************************************************************************
	INCLUDE	DiskSystem
*****************************************************************************
	
*****************************************************************************
	INCLUDE	TrackDisk
*****************************************************************************

ErrorHandler:
	bsr	UnselectDrive
	lea	Preferences,a6
	move.l	$142(a6),a0
	jmp	(a0)
ErrorHandler0:
	moveq	#$0d,d0
	jsr	_WriteChar(a6)
	move.l	$94(a6),a7
	lea	Errortext(pc),a0
ErrorHandler1:
	move.b	(a0)+,d0
	cmp.b	#$ff,d0
	beq	ErrorHandler4
	cmp.b	d7,d0
	beq	ErrorHandler3
ErrorHandler2:
	tst.b	(a0)+
	bne.s	ErrorHandler2
	bra.s	ErrorHandler1
ErrorHandler3:
	jsr	_WriteString(a6)
	clr.w	$5e(a6)		;CRSR X
ErrorHandler4:
	lea	ErrorHandler3(pc),a0
	add.l	#Loop-ErrorHandler3,a0
	jmp	(a0)

Errortext:
	dc.b	$01,"* Drive not present error.",0
	dc.b	$02,"* Bad disk error.",0
	dc.b	$03,"* Disk writeprotected error.",0
	dc.b	$04,"* File not found error.",0
	dc.b	$05,"* Directory not found error.",0
	dc.b	$06,"* Disk not validated error.",0
	dc.b	$07,"* Directory not empty error.",0
	dc.b	$08,"* Disk is full error.",0
	dc.b	$09,"* No disk in drive error.",0
	dc.b	$0a,"* File already exists error.",0
	dc.b	$0b,"* Can't rename to another disk error.",0
	dc.b	$0c,"* File is not an object module error.",0
	dc.b	$0d,"* Can't access word at odd adress error.",0
	dc.b	$0e,"* No workbuffer specified error.",0
	dc.b	$0f,"* Workbuffer too small error.",0
	dc.b	$ff
	even

*****************************************************************************
	INCLUDE	AssemblerCodes
*****************************************************************************

*****************************************************************************
	INCLUDE	TimeCodes
*****************************************************************************

	END

Prefs:
	blk.l   $80,0		;DFF000 Write Only Registers

	STRUCTURE	CCSLibrary,0
	APTR	ccs_AgnusBase
	APTR	ccs_MemList
	APTR	ccs_StackBase
	APTR	ccs_RAMCopy
	APTR	ccs_CustomRegs
	APTR	ccs_CIARegs
	APTR	ccs_ExitRegs
	SCRUCT	ccs_M68000Regs,m68_SIZEOF
	STRUCT	ccs_ScreenDev,scr_SIZEOF
	STRUCT	ccs_KeyDev,key_SIZEOF
	STRUCT	ccs_PointerDev,poi_SIZEOF
	STRUCT	ccs_EditorDev,ed_SIZEOF
	STRUCT	ccs_Assembler,$20
	APTR	ccs_StringBuffer
	UWORD	ccs_Startup
	APTR	ccs_ErrorHandler
	APTR	ccs_ErrorHandlerStack
	UWORD	ccs_CIATimers
	UBYTE	ccs_CIAAIRQReq
	UBYTE	ccs_CIAAIRQEna
	UBYTE	ccs_CIABIRQReq
	UBYTE	ccs_CIABIRQEna
	UWORD	ccs_LeftMouseShift
	UWORD	ccs_RightMouseShift
	APTR	ccs_CSISequence
	LABEL	ccs_SIZEOF

	STRUCTURE	ChipMemUsage,0
	STRUCT	cmu_M68000,$c0
	STRUCT	cmu_BitMap,$5280
	STRUCT	cmu_Pointer,$40
	STRUCT	cmu_Cursor,$80
	STRUCT	cmu_Disk,$3340
	LABEL	cmu_SIZEOF

	STRUCTURE	ScreenDevice,0
	APTR	scr_FontBase
	APTR	scr_FontBitMap
	APTR	scr_FontCharMap
	APTR	scr_BitMap
	APTR	scr_CharMap
	UWORD	scr_BackColor
	UWORD	scr_ForeColor1
	UWORD	scr_ColorCheckSum
	UWORD	scr_CursorY
	UWORD	scr_CursorX
	UWORD	scr_CursorCheckSum
	UBYTE	scr_Inverse
	UBYTE	scr_VertBlank
	UWORD	scr_ScrollStartLine
	UWORD	scr_ScreenLastLine
	UWORD	scr_RasterLine
	APTR	scr_BitmapLineAddr
	APTR	scr_CharLineAddr
	ULONG	scr_LastYLine
	UWORD	scr_ForeColor2
	UWORD	scr_InfoRasterLine
	UWORD	scr_SwapRasterLine
	UBYTE	scr_InfoEnable
	UBYTE	scr_RasterType
	APTR	scr_CursorImage
	UWORD	scr_CursorColor
	APTR	scr_MarkedMap
	LABEL	scr_SIZEOF
	
	STRUCTURE	KeyboardDevice,0
	APTR	key_Map
	APTR	key_Buffer
	UWORD	key_BufferIndex
	UBYTE	key_Mode
	UBYTE	key_Vanilla
	UBYTE	key_CapsLock
	UBYTE	key_LastKey
	UWORD	key_Repeat
	LABEL	key_SIZEOF

	STRUCTURE	PointerDevice,0
	APTR	poi_Sprite
	UWORD	poi_Y
	UWORD	poi_X
	UWORD	poi_Mouse
	UWORD	poi_Color1
	UWORD	poi_Color2
	UWORD	poi_Color3
	LABEL	poi_SIZEOF

	STRUCTURE	DiskDevice,0
	APTR	dis_BlockBuffer
	APTR	dis_RootBlock
	APTR	dis_DMABuffer
	UBYTE	dis_Drive0Track
	UBYTE	dis_Drive1Track
	UBYTE	dis_Drive2Track
	UBYTE	dis_Drive3Track
	UBYTE	dis_CurrentUnit
	UBYTE	dis_DirectoryUnit
	UWORD	dis_DirectoryBlock
	APTR	dis_TrackBuffer
	BYTE	dis_TrackBufferUnit
	BYTE	dis_TrackBufferNr
	WORD	dis_DriveMotor
	WORD	dis_TrackBufferChange
	UWORD	dis_HashBlock
	UWORD	dis_HashIndex
	APTR	dis_BAMBuffer
	UWORD	dis_DirectoryChecksum
	LABEL	dis_SIZEOF

	STRUCTURE	M68000Regs,0
	LONG	m68_D0
	LONG	m68_D1
	LONG	m68_D2
	LONG	m68_D3
	LONG	m68_D4
	LONG	m68_D5
	LONG	m68_D6
	LONG	m68_D7
	LONG	m68_A0
	LONG	m68_A1
	LONG	m68_A2
	LONG	m68_A3
	LONG	m68_A4
	LONG	m68_A5
	LONG	m68_A6
	LONG	m68_A7
	LONG	m68_SSP
	WORD	m68_SR
	LONG	m68_PC
	LABEL	m68_SIZEOF

	STRUCTURE	EditorDevice,0
	APTR	ed_TextStart
	APTR	ed_TextEnd
	ULONG	ed_CurrentLine
	ULONG	ed_CurrentBufferLine
	APTR	ed_TextBuffer
	UWORD	ed_TextBufferLength
	UWORD	ed_CurrentTextColumn
	UWORD	ed_TextBufferOldLength
	UWORD	ed_TextBufferChanged
	UWORD	ed_TextBufferIndex
	UWORD	ed_StartColumn
	APTR	ed_FirstTextLine
	APTR	ed_ScreenBackup
	APTR	ed_WorkbufferEnd
	APTR	ed_CutbufferEnd
	APTR	ed_Filename
	APTR	ed_MarkBegin
	APTR	ed_MarkEnd
	UWORD	ed_MarkMode
	APTR	ed_RemLineAddr
	UWORD	ed_RemLineLength
	UWORD	ed_RemLineY
	APTR	ed_Stackpointer
	UBYTE	ed_TextSaved
	UBYTE	ed_EditorActive
	APTR	ed_LastFind
	APTR	ed_FindString
	UWORD	ed_FindParameters
	LABEL	ed_SIZEOF

Preferences:			;Usage: $10000 bytes
	dc.l	$0000C0		;0	Screenmemory Bitmap
	dc.l	prend		;4	Screenmemory Chars
	dc.w	$0888		;8	Background Color
	dc.w	$0ccc		;A	Foreground Color
	dc.l	$0		;C	Fontpointer Bitmap
	dc.l	$0		;10	Fontpointer Chars 20-FF
	dc.l	$0		;14	Agnus Chip Base adress
	dc.l	$0		;18	Fontpointer BASE
	blk.l	$10,0		;1C	68000 Register A0-A7/D0-D7
	dc.w	$0		;5C	Cursor Y
	dc.w	$0		;5E	Cursor X
	dc.l	$0		;60	Keymap
	dc.l	prend+$a50	;64	Keyboardbuffer length 100
	dc.w	$0		;68	Keyboardbuffer ,index
	dc.b	$0		;6a	Keyboardmode 00-05
	dc.b	$0		;6b	Keyboardvanillakeys 00-07
	dc.b	$0		;6c	Keyboard Caps Lock Key +/-
	dc.b	$ff		;6d	Keyboard Last Key
	dc.w	$0		;6e	Keyboard Repeat counter
	dc.w	$0		;70	Startupcode
	dc.w	$0		;72	Color Checksum (8,A)
	dc.b	$0		;74	Inverse Chars 00/FF
	dc.b	$0		;75	Vertical Blank Event
	dc.l	prend+$b50	;76	Stringbuffert length 100
	dc.l	prend+$c50	;7a	Diskbuffert length 200
	dc.l	prend+$e50	;7e	Diskbuffert length 200 Rootblock
	dc.l	$005400		;82	Diskbuffert DMA length $3340
	dc.l	prend+$2650	;86	Ram Saver Address $0-$8740
	dc.l	$0		;8a	Supervisor Stack Pointer
	dc.w	$0		;8e	Status Register
	dc.l	$0		;90	Program Counter
	dc.l	prefs+$10000	;94	Monitor Stack Pointer
	blk.l	$20,0		;98	Assembler workarea
	dc.b	$0		;118	Drive 0 Track
	dc.b	$0		;119	Drive 1 Track
	dc.b	$0		;11a	Drive 2 Track
	dc.b	$0		;11b	Drive 3 Track
	dc.b	$0		;11c	Current Drive Unit
	dc.b	$0		;11d	Directory Drive Unit
	dc.w	$FFFF		;11e	Directory Block nr
	dc.l	prend+$1050	;120	Track buffer $1600
	dc.b	$0		;124	Drive nr of track in buffer
	dc.b	$FF		;125	Track nr of track in buffer
	dc.w	$0		;126	Drive motor off counter
	dc.l	$005340		;128	SpritePointer
	dc.w	$0		;12c	Sprite Y
	dc.w	$0		;12e	Sprite X
	dc.w	$0		;130	Last Mouse Value
	dc.w	$0d22		;132	Pointer Color 1
	dc.w	$0000		;134	Pointer Color 2
	dc.w	$0fca		;136	Pointer Color 3
	dc.w	$0000		;138	Write Track Buffer? ($1234=Yes)
	dc.w	0		;13a	BlockNr of Hashpointer
	dc.w	0		;13c	Index of Hashpointer
	dc.l	prend+$ad90	;13e	BAMbuffert $200
	dc.l	0		;142	ErrorHandler
	dc.l	0		;146	ErrorHandler Stackpointer
	dc.w	0		;14a	ScreenScrollStartLine
	dc.w	$21		;14c	ScreenLastLine
	dc.w	0		;14e	RasterLine
	dc.l	0		;150	ED:TextStart
	dc.l	0		;154	ED:TextEnd
	dc.l	0		;158	ED:CurrentTextLine
	dc.l	0		;15c	ED:CurrentTextLine in Buffer
	dc.l	prend+$af90	;160	ED:TextBuffer ($200 bytes)
	dc.w	0		;164	ED:TextBuffer Length
	dc.w	0		;166	ED:CurrentTextColumn
	dc.w	0		;168	ED:TextBuffer OldLength
	dc.w	0		;16a	ED:TextBuffer Changed ($1234=Yes)
	dc.w	0		;16c	ED:TextBuffer Index
	dc.w	0		;16e	ED:StartColumn on Screen
	dc.l	0		;170	ED:First TextLine Addr
	dc.l	prend+$b190	;174	ED:ScreenBackup ($a50 bytes)
	dc.l	0		;178	Bitmap Line Addr
	dc.l	0		;17c	Chars Line Addr
	dc.w	$ffff		;180	Last Y Line
	dc.l	0		;182	ED:Workbuffer END
	dc.l	0		;186	ED:Cutbuffer END
	dc.l	prend+$bbe0	;18a	DFF000 Registers ($200 bytes)
	dc.l	prend+$bde0	;18e	CIA Registers ($30 bytes)
	dc.w	0		;192	Cursor Checksum (5C,5E,14A)
	dc.w	0		;194	Directory Checksum (11D,11E)
	dc.l	prend+$be10	;196	Exit Parameters ($280 bytes)
	dc.w	0		;19a	CIA Timers (Bit 9,8,1,0)
	dc.l	prend+$c090	;19c	ED:Filename ($50 bytes)
	dc.w	0		;1a0	LastRasterLine
	dc.w	$0fff		;1a2	Second Forground Color
	dc.w	0		;1a4	InfoRasterLine
	dc.w	0		;1a6	SwapscreenRasterLine
	dc.b	0		;1a8	Infoline enable
	dc.b	0		;1a9	Rastertype nr
	dc.l	0		;1aa	ED:Mark Begin
	dc.l	0		;1ae	ED:Mark End
	dc.w	0		;1b2	ED:Mark mode
	dc.l	0		;1b4	ED:Rem Line Addr
	dc.w	0		;1b8	ED:Rem Line Length
	dc.w	0		;1ba	ED:Rem Line Y
	dc.b	0		;1bc	CIAA IRQ Request Register
	dc.b	0		;1bd	CIAA IRQ Enable Register
	dc.b	0		;1be	CIAB IRQ Request Register
	dc.b	0		;1bf	CIAB IRQ Enable Register
	dc.w	0		;1c0	Mouse Left Button Shift Reg.
	dc.w	0		;1c2	Mouse Right Button Shift Reg.
	dc.l	prend+$c0e0	;1c4	CSI Sequence (char,nr,pars)($20bytes)
	dc.w	0		;1c8	Menu Head Item Nr
	dc.w	0		;1ca	Menu Sub Item Nr
	dc.l	0		;1cc	Menu Routine
	dc.l	0		;1d0	Menu Head Info
	dc.l	0		;1d4	Window Coords
	dc.l	0		;1d8	Window Info
	dc.b	0		;1dc	Window Inputline Start X
	dc.b	0		;1dd	Window Inputline Cursor X
	dc.b	0		;1de	Window Current Object Nr
	dc.b	0		;1df	Window Inputline Width
	dc.l	0		;1e0	ED:Edit Stackpointer
	dc.b	0		;1e4	ED:Text Saved
	dc.b	0		;1e5	ED:Editor Active
	dc.l	0		;1e6	ED:Last Find
	dc.l	prend+$c100	;1ea	ED:Find String ($50 bytes)
	dc.w	0		;1ee	ED:Find Parameters
	dc.l	$005380		;1f0	Cursor Image
	dc.w	$0444		;1f4	Cursor Color
	dc.l	prend+$c150	;1f6	Screenmemory Marked ($0150 bytes)
prend:
