#include "common.h"

int CLP(int c)
{
	return c<-128?-128:c>127?127:c;
}

char randtab[4096];

//************************************************************
// constants

int vidstop;

#define W 256
#define H 256
#define LW 8


 int QMAT[3][16]= {
			{5*256/6,4*256/6,5*256/6,6*256/6,8*256/6,10*256/6,12*256/6,14*256/6,16*256/6,18*256/6,20*256/6,23*256/6,26*256/6,29*256/6,32*256/6,35*256/6},
                        {5*2*256/6,4*2*256/6,5*2*256/6,6*2*256/6,8*2*256/6,10*2*256/6,12*2*256/6,14*2*256/6,16*2*256/6,18*2*256/6,20*2*256/6,23*2*256/6,26*2*256/6,29*2*256/6,32*2*256/6,35*2*256/6}
                        };
#define DCTTHR 1
#define Q 4
#define MAX 7		// code range is from -MAX-1 to MAX
#define OBITS 4		// number of btis needed to encode output

const int DEQUANT[]={       0,  1*Q,  4*Q,  9*Q, 16*Q,25*Q,36*Q,49*Q,
			-64*Q,-49*Q,-36*Q,-25*Q,-16*Q,-9*Q,-4*Q,-1*Q};

FILE_ vidfile;

//************************************************************
// bitio

char *buf,*bufptr;
int bufsize;
int bitpos=1,bitcount=0;
int getbit()
{
    bitcount++;
	int i=(bufptr[0]&bitpos);
	if ((bitpos<<=1)==256) {bitpos=1;bufptr++;}
	return i;
}
int getbits(int c)
{
	int i=(((int*)bufptr)[0]>>(bitcount&7))&((1<<c)-1);
        bitcount+=c;
        if ((bitpos<<=c)>=256)
        {
                bufptr++;bitpos>>=8;
        }	
	return i;
}
inline int getbits_d(int c)
{
	if (!getbit()) return 0;
	if (!getbit()) return getbit()?-1:1;
	int i=getbits(c+1);
	c=1<<c;
	if (i>=c) 
	{		
		return i-(c<<1)-1;	
	}	
	return i+2;
}
inline int getbits_s(int c)
{
	int i=getbits(c);
	c=32-c;	
	return (i<<c)>>c;
}

//************************************************************
// wavelet stuff

#define _C0 (0.332671  )
#define _C1 (0.806891  )
#define _C2 (0.459877  )
#define _C3 (-0.135011 )
#define _C4 (-0.085411 )
#define _C5 (0.035226  )

#define _D0 0.035226
#define _D1 0.085411
#define _D2 -0.135011
#define _D3 -0.459877
#define _D4 0.806891
#define _D5 -0.332671

void unfilter6(float *in, float *out, int w)
{
	int c1;
	int w2=w>>1;
	float *in2=in+w2;

	// first 4 lines of matrix
	out[0]=in[0]*_C0+in2[0]*_D0+in[w2-2]*_C4+in2[w2-2]*_D4+in[w2-1]*_C2+in2[w2-1]*_D2;
	out[W]=in[0]*_C1+in2[0]*_D1+in[w2-2]*_C5+in2[w2-2]*_D5+in[w2-1]*_C3+in2[w2-1]*_D3;
	out[W*2]=in[0]*_C2+in2[0]*_D2+in[1]*_C0+in2[1]*_D0+in[w2-1]*_C4+in2[w2-1]*_D4;
	out[W*3]=in[0]*_C3+in2[0]*_D3+in[1]*_C1+in2[1]*_D1+in[w2-1]*_C5+in2[w2-1]*_D5;
	out+=W*4;
	c1=(w2-2)/2;
	for (;c1--;)
	{
		out[0]=in[0]*_C4+in2[0]*_D4+in[1]*_C2+in2[1]*_D2+in[2]*_C0+in2[2]*_D0;
		out[W]=in[0]*_C5+in2[0]*_D5+in[1]*_C3+in2[1]*_D3+in[2]*_C1+in2[2]*_D1;
		out[W*2]=in[1]*_C4+in2[1]*_D4+in[2]*_C2+in2[2]*_D2+in[3]*_C0+in2[3]*_D0;
		out[W*3]=in[1]*_C5+in2[1]*_D5+in[2]*_C3+in2[2]*_D3+in[3]*_C1+in2[3]*_D1;
		in+=2;in2+=2;
		out+=W*4;
	}
}
void unfilter6b(float *in, float *out, int w)
{
	int c1;
	int w2=w>>1;
	float *in2=in+(w2<<LW);

	// first 4 lines of matrix
	*out++=in[(0)<<LW]*_C0+in2[(0)<<LW]*_D0+in[(w2-2)<<LW]*_C4+in2[(w2-2)<<LW]*_D4+in[(w2-1)<<LW]*_C2+in2[(w2-1)<<LW]*_D2;
	*out++=in[(0)<<LW]*_C1+in2[(0)<<LW]*_D1+in[(w2-2)<<LW]*_C5+in2[(w2-2)<<LW]*_D5+in[(w2-1)<<LW]*_C3+in2[(w2-1)<<LW]*_D3;
	*out++=in[(0)<<LW]*_C2+in2[(0)<<LW]*_D2+in[(1)<<LW]*_C0+in2[(1)<<LW]*_D0+in[(w2-1)<<LW]*_C4+in2[(w2-1)<<LW]*_D4;
	*out++=in[(0)<<LW]*_C3+in2[(0)<<LW]*_D3+in[(1)<<LW]*_C1+in2[(1)<<LW]*_D1+in[(w2-1)<<LW]*_C5+in2[(w2-1)<<LW]*_D5;
    int c2=(w2-2)/2;
	for (c1=c2;c1--;)
	{
		out[0]=in[(0)<<LW]*_C4+in[(1)<<LW]*_C2+in[(2)<<LW]*_C0;
		out[1]=in[(0)<<LW]*_C5+in[(1)<<LW]*_C3+in[(2)<<LW]*_C1;
        out[2]=in[(1)<<LW]*_C4+in[(2)<<LW]*_C2+in[(3)<<LW]*_C0;
		out[3]=in[(1)<<LW]*_C5+in[(2)<<LW]*_C3+in[(3)<<LW]*_C1;
		out+=4;
		in+=W*2;
	}
	in+=W*2;
	out-=w-4;
	for (c1=c2;c1--;)
	{
		out[0]+=in[(0)<<LW]*_D4+in[(1)<<LW]*_D2+in[(2)<<LW]*_D0;
		out[1]+=in[(0)<<LW]*_D5+in[(1)<<LW]*_D3+in[(2)<<LW]*_D1;
        out[2]+=in[(1)<<LW]*_D4+in[(2)<<LW]*_D2+in[(3)<<LW]*_D0;
		out[3]+=in[(1)<<LW]*_D5+in[(2)<<LW]*_D3+in[(3)<<LW]*_D1;
		out+=4;
		in+=W*2;
	}
}


//************************************************************
// dct  stuff

#include "videodct.h"

//************************************************************
// un packer

int covered[32];
int fsqr(int f)
{
	return (f<0)?-f*f:f*f;
}
void decode0(float *f, int q)
{
	DCTBLOCK d;
    int i,j;
	int numbits=getbits(6);

        int *zz=&zigzag[0][0];
        int *zb=&zigbits[0];
	if (q==3)
	{
                j=(numbits<36)?numbits:36;
                for (i=0;i<j;i++,zz+=2,zb++) d[zz[0]][zz[1]]=getbits_s(*zb -1);
                for (;i<numbits;i++,zz+=2) d[zz[0]][zz[1]]=getbits_d(2);
	}
        else
        if (q==0)
	{
                for (i=0;i<numbits;i++,zz+=2,zb++) d[zz[0]][zz[1]]=getbits_s(*zb +1);
	}
	else
	{
                for (i=0;i<numbits;i++,zz+=2,zb++) d[zz[0]][zz[1]]=getbits_s(*zb);
	}
	for (;i<64;i++,zz+=2) d[zz[0]][zz[1]]=0;
	DCTELEM *dt=&d[0][0];
        zz=QMAT[(q==3)?1:0];
	for (i=0;i<8;i++)
	for (j=0;j<8;j++,dt++) *dt = (fsqr(*dt) * zz[i+j])>>8;

	j_rev_dct(d);

	dt=&d[0][0];
	for (j=0;j<8;j++,f+=W-8)
	for (i=0;i<8;i++) *f++=(*dt++ << 3) ;

}



int checkzero(float *f,int x, int y, int w, int logsc)
{

	int *cv,c2,mask;
    c2=w>>logsc;
	mask=((1<<c2)-1)<<(x>>logsc);
    if (!c2) goto itsnotcovered;    
    cv=covered+(y>>logsc);
	for (;c2--;cv++) if ((*cv)&mask) goto itsnotcovered;
	return 1;	// already covered!
itsnotcovered:
	if (getbit()) return 0;
	// zero it out...
	float *f2=f+(y<<LW)+x;
	for (c2=w;c2--;f2+=W) memset(f2,0,w<<2);        
	//for (c2=y;c2<y+w;c2++) memset(f+c2*W+x,0,w*4);
	// super?
	if (logsc==3) return 1;
	if (getbit())
	{

		// aww its a super...
                c2=w>>logsc;
				//mask=((1<<c2)-1)<<(x>>logsc);
                mask=~mask;
                cv=covered+(y>>logsc);
	        for (;c2--;cv++) *cv &= mask;

		// zero it out recursively...
		while (logsc++<3)
		{
                        x<<=1;y<<=1;w<<=1;
			for (c2=y;c2<y+w;c2++) memset(f+c2*W+x,0,w*4);
		}
	}
	return 1;
}

void rebuild(float *f,int x, int y, int w, int logsc)
{
	int i,j;

	if (checkzero(f,x,y,w,logsc)) return;
	if (getbit())
	{
		
		if (w==4)
		{			
			// store
			//mark(x,y,w,7);
			for (j=0;j<w;j++)
			for (i=0;i<w;i++)
			{
				f[(x+i)+W*(y+j)]=DEQUANT[getbits(OBITS)];
			}
		}
		else
		{			
			// subdivide
			int w2=w>>1;
			rebuild(f,x,y,w2,logsc);
			rebuild(f,x+w2,y,w2,logsc);
			rebuild(f,x,y+w2,w2,logsc);
			rebuild(f,x+w2,y+w2,w2,logsc);
		}
	}
	else
	{
		// relative
		//mark(x,y,w,6);
		int alpha,flip,bdx,bdy,step,tx,ty;
		alpha=getbits_s(6);
		flip=getbits(2);
		if (logsc==0)
		{
			bdx=getbits(3);
			bdy=getbits(3);
		}
		else
		{
			bdx=getbits(4);
			bdy=getbits(4);
		}
		step=(logsc>0)?logsc-1:0;
		tx=((x&(16<<logsc))>>1)+(bdx<<step);
		ty=((y&(16<<logsc))>>1)+(bdy<<step);		

		float *s=f+tx+(ty<<LW);
		f+=x+(y<<LW);
		float a=alpha/31.0f;

                switch (flip)
		{
                case 0:
			for (j=0;j<w;j++,f+=W-w,s+=W-w)
			for (i=0;i<w;i++) *f++ = a* *s++;
			return;
                case 1:
                        s+=w-1;
			for (j=0;j<w;j++,f+=W-w,s-=(w<<LW)+1)
			for (i=0;i<w;i++,s+=W) *f++ = a* *s;
			return;

		case 2:
                        s+=w-1+((w-1)<<LW);
			for (j=0;j<w;j++,f+=W-w, s-=W-w)
			for (i=0;i<w;i++) *f++ = a* *s--;
			return;
                case 3:
                        s+=(w-1)<<LW;
			for (j=0;j<w;j++,f+=W-w, s+=(w<<LW)+1)
			for (i=0;i<w;i++,s-=W) *f++ = a* *s;
			return;

		}
	}
}
void decoden(float *f,int x, int y, int w, int logsc)
{
	if (checkzero(f,x,y,w,logsc)) return;	
	int sw=w>>3;if (sw<4) sw=4;
	int x2,y2;
	for (x2=x;x2<x+w;x2+=sw)
	for (y2=y;y2<y+w;y2+=sw)
	{
		rebuild(f,x2,y2,sw,logsc);
	}
}
void unpack(float *f)
{	
	memset(covered,-1,sizeof(covered));
	decode0(f,0);
	decode0(f+8*W,1);
	decode0(f+8,2);
	decode0(f+8*W+8,3);
    int c3=0;
	for (int c2=16;c2<=128;c2<<=1,c3++)
	{
		decoden(f,c2,0,c2, c3);
		decoden(f,0,c2,c2, c3);
		decoden(f,c2,c2,c2, c3);
	}	
}
void dewlet(float *a, float *b)
{	
	int c1,c2;
	// dewavelet it    
	for (c1=16;c1<=256;c1<<=1)
	{
		//for (c2=0;c2<c1;c2++) unfilter6(a+W*c2,b+c2,c1);for (c2=0;c2<c1;c2++) unfilter6(b+W*c2,a+c2,c1);
        for (c2=0;c2<c1;c2++) unfilter6b(a+c2,b+(c2<<LW),c1);          
		for (c2=0;c2<c1;c2++) unfilter6b(b+c2,a+(c2<<LW),c1);
	}	
}

#define CLIP 128
int cwlet,m1wlet,m2wlet;
float *tempbuf,*m1buf,*m2buf,*colbuf;
short *surfbuf;
int numpages,numframes,curframe;
int ytab[CLIP*2+256],crtab1[CLIP*2+256],crtab2[CLIP*2+256],cbtab1[CLIP*2+256],cbtab2[CLIP*2+256];
short redtab[CLIP*2+256],grntab[CLIP*2+256],blutab[CLIP*2+256];

	

#define NUMSTEPS 24
#define VIDEOFPS 15
int steptime;
int curstep,curpage,sectionstart,sectionfirst,stopframe;

int CurTime()
{
	return gTime;
}

void colconv(float *buf, float *cbuf, int step)
{
	int i,j,cb,cr,y,crcb;
	float *cbuf2;
	short *out=surfbuf;

	buf+=step*W*H/4;
	cbuf+=step*W*H/8;
	out+=step*W*H/4;
	cbuf2=cbuf+W-1;
	for (j=0;j<H/8;j++)
	{
		char *randsrc=randtab+(rand()&2047);
		for (i=0;i<W/2;i++)
		{
			/*
			y=CLP(buf[0])+128+CLIP;
				out[0]=redtab[y]|grntab[y]|blutab[y];
				y=CLP(buf[1])+128+CLIP;
				out[1]=redtab[y]|grntab[y]|blutab[y];
				y=CLP(buf[W])+128+CLIP;
				out[W]=redtab[y]|grntab[y]|blutab[y];
				y=CLP(buf[W+1])+128+CLIP;
				out[W+1]=redtab[y]|grntab[y]|blutab[y];

				/*/

			cb=cbtab1[CLIP+128+int(*cbuf)];
			cr=crtab1[CLIP+128+int(*cbuf2)];
			crcb=cbtab2[CLIP+128+int(*cbuf++)]+crtab2[CLIP+128+int(*cbuf2--)];						
			y=ytab[CLIP+128+int(buf[0])]+CLIP+128+*randsrc++;		
			out[0]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
			y=ytab[CLIP+128+int(buf[1])]+CLIP+128+*randsrc++;						
			out[1]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];				
			y=ytab[CLIP+128+int(buf[W])]+CLIP+128+*randsrc++;						
			out[W+0]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
			y=ytab[CLIP+128+int(buf[W+1])]+CLIP+128+*randsrc++;						
			out[W+1]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];			
	
			buf+=2;
			out+=2;
		}
		buf+=W;
		out+=W;
		cbuf+=W/2;
		cbuf2+=W/2+W;
	}
}
void unpack(float *f, int step)
{	
	//if (step==0) unpack(f);	return;

	if (step==0)
	{
		memset(covered,-1,sizeof(covered));
		decode0(f,0);
		decode0(f+8*W,1);
		decode0(f+8,2);
		decode0(f+8*W+8,3);
		return;
	}
    int c3=step-1,c2,c2b;
	c2=8<<step;c2b=c2;if (step==3) c2b=128;
	for (;c2<=c2b;c2<<=1,c3++)
	{
		decoden(f,c2,0,c2, c3);
		decoden(f,0,c2,c2, c3);
		decoden(f,c2,c2,c2, c3);
	}
}
void dewlet(float *a, int step)
{	
	float *b=tempbuf;
	//if(step==0) dewlet(a,b);return;
	
	int c2;
	switch (step)
	{
	case 0:		
		for (c2=0;c2<16;c2++) unfilter6b(a+c2,b+(c2<<LW),16);          
		for (c2=0;c2<16;c2++) unfilter6b(b+c2,a+(c2<<LW),16);		
		for (c2=0;c2<32;c2++) unfilter6b(a+c2,b+(c2<<LW),32);          
		for (c2=0;c2<32;c2++) unfilter6b(b+c2,a+(c2<<LW),32);
		break;
	case 1:
		for (c2=0;c2<64;c2++) unfilter6b(a+c2,b+(c2<<LW),64);          
		for (c2=0;c2<64;c2++) unfilter6b(b+c2,a+(c2<<LW),64);		
		break;
	case 2:
		for (c2=0;c2<128;c2++) unfilter6b(a+c2,b+(c2<<LW),128);          
		break;
	case 3:
		for (c2=0;c2<128;c2++) unfilter6b(b+c2,a+(c2<<LW),128);		
		break;
	case 4:
		for (c2=0;c2<128;c2++) unfilter6b(a+c2,b+(c2<<LW),256);          
		break;
	case 5:
		for (c2=128;c2<256;c2++) unfilter6b(a+c2,b+(c2<<LW),256);          
		break;
	case 6:
		for (c2=0;c2<128;c2++) unfilter6b(b+c2,a+(c2<<LW),256);		
		break;
	case 7:
		for (c2=128;c2<256;c2++) unfilter6b(b+c2,a+(c2<<LW),256);		
		break;
	}    	
}



void v_initsection(CTexture *mytex)
{
	v_initrgb(&mytex->mPixelFormat);
	steptime=TICKSPERSEC*2/(VIDEOFPS*NUMSTEPS);
	curstep=curpage=0;	
	// this first unpack is done by the end of the previous frame
	unpack(m1buf);
	sectionstart=CurTime();
	v_step(mytex);
	sectionstart=CurTime();
}

void v_setfps(int fps)
{
		steptime=TICKSPERSEC*2/(fps*NUMSTEPS);
}

void v_skipto(CTexture *mytex, int targetframe)
{
	v_setstop(targetframe);
	v_step2(mytex,targetframe * NUMSTEPS/2 + NUMSTEPS, 1);		
}

void v_setstart()
{
	gD->GetTime();
	sectionstart=CurTime();
	sectionfirst=curframe * NUMSTEPS/2 + NUMSTEPS;
	vidstop=0;
}

void v_setstop(int f)
{
	vidstop=0;
	stopframe=f * NUMSTEPS/2 + NUMSTEPS;
}

void v_step(CTexture *mytex)
{
	int t=CurTime()-sectionstart;
	int targetstep=t/steptime+sectionfirst;
	v_step2(mytex,targetstep,0);
}

int v_stopped()
{
	return vidstop;
}

void v_step2(CTexture *mytex, int targetstep, int skip)
{
	static int targetpage=0;
	
	if (targetstep>=stopframe)
	{
		targetstep=stopframe;
		vidstop=1;
	}

	targetpage=targetstep/NUMSTEPS+1;
	targetstep%=NUMSTEPS;

	/*
	targetstep+=NUMSTEPS;
	if (targetstep>=NUMSTEPS)
	{
		targetstep-=NUMSTEPS;
		targetpage++;
	}
	*/
	
	if (targetpage>=numpages)
	{
		targetpage=numpages-1;
		targetstep=0;
		vidstop=1;
	}

	
	while (targetpage>curpage || (targetpage==curpage && targetstep>curstep))
	{
		if (targetpage==curpage) skip=0;
		// do step
		if ((curpage&1)==0)
		{
			// even page
			if (curstep<8) {if (!skip) dewlet(m1buf,curstep);} else
			if (curstep<12) unpack(colbuf,curstep-8); else
			if (curstep<20) {if (!skip) dewlet(colbuf,curstep-12);} else
			if (curstep<24) {if (!skip) colconv(m1buf,colbuf,curstep-20);}	// 24
		}		
		else
		{
			// odd page
			if (curstep<4) unpack(m2buf,curstep); else
			if (curstep<12) {if (!skip) dewlet(m2buf,curstep-4);} else
			if (curstep<16) unpack(m1buf,curstep-12); else
			if (curstep<20) {if (!skip) colconv(m2buf,colbuf+W*H/2,curstep-16);}	
		}
		curstep++;
		if (curstep==NUMSTEPS)
		{
			curstep=0;
			curpage++;
			if (curpage==targetpage)
			{
				// download it
				short *out;
				int pitch;
				if ((out=(short*)mytex->Lock(&pitch))!=NULL)
				{
					short *in=surfbuf;					
					for (int y=0;y<H;y++,out+=pitch,in+=W) memcpy(out,in,W*2);					
					mytex->Unlock();
				}
			}
		}
	}
	curframe=(curpage-1)*2;if (curstep>=NUMSTEPS/2) curframe++;
}

void v_initcol(float sat, float con)
{	
	for (int c1=-128-CLIP;c1<127+CLIP;c1++)
	{
		ytab[c1+CLIP+128]=CLP(c1*con);
		crtab1[c1+CLIP+128]=CLP(c1*1.402*sat);
		crtab2[c1+CLIP+128]=CLP(c1*0.71414*sat);
		cbtab1[c1+CLIP+128]=CLP(c1*1.772*sat);
		cbtab2[c1+CLIP+128]=CLP(c1*0.34414*sat);
	}
}

void v_initrgb(int rc,int rp, int gc, int gp, int bc, int bp)
{
	rc=1<<rc;
	gc=1<<gc;
	bc=1<<bc;
	for (int c1=-128-CLIP;c1<127+CLIP;c1++)
	{
		redtab[c1+CLIP+128]=(((CLP(c1)+128)*rc)/256)<<rp;
		grntab[c1+CLIP+128]=(((CLP(c1)+128)*gc)/256)<<gp;
		blutab[c1+CLIP+128]=(((CLP(c1)+128)*bc)/256)<<bp;
	}
}
void v_initrgb(DDPIXELFORMAT *pf)
{
	v_initrgb(countbits(pf->dwRBitMask),countzeros(pf->dwRBitMask),
			  countbits(pf->dwGBitMask),countzeros(pf->dwGBitMask),
			  countbits(pf->dwBBitMask),countzeros(pf->dwBBitMask));
}



void v_init()
{
	v_initcol(1.5,1.1);
	numframes=numpages=0;
	// initialise
	m1buf=new float [W*H];
	colbuf=new float [W*H];
	tempbuf=new float[W*H];
    m2buf=new float [W*H];
	surfbuf=new short [W*H];
	for (int c1=0;c1<4096;c1++) randtab[c1]=8*((rand()/float(RAND_MAX)-0.5f)+(rand()/float(RAND_MAX)-0.5f)+(rand()/float(RAND_MAX)-0.5f));
}
void v_deinit()
{
	
	delete [] m1buf;
	delete [] colbuf;
	delete [] tempbuf;
	delete [] m2buf;
	delete [] surfbuf;
	delete [] buf;
}
int v_load(char *fname)
{		
	// read file
	int w,h,thrcol,thrmono;
	vidfile.open(fname);	
	numpages=w=h=thrmono=thrcol=0;
	vidfile.read(&numpages,2);
	vidfile.read(&w,2);if (w!=W) return -1;
	vidfile.read(&h,2);if (w!=H) return -1;
	vidfile.read(&thrmono,2);
	vidfile.read(&thrcol,2);
	bufsize=vidfile.len-10;	
	bitpos=1;bitcount=0;
	bufptr=buf=new char[bufsize];
	vidfile.read(buf,bufsize);
	vidfile.close();
	numframes=(numpages/3)*4;
	numpages=numframes/2;
	return numframes;
}


