#include	"common.h"

//****************************************************************************************************

const	char	REGISTRY_COMPANY_NAME[] = "Software\\Statix";

//****************************************************************************************************
CRegistry::CRegistry( const char* product_name , BOOL machine )
{
	strcpy( mKeyName , REGISTRY_COMPANY_NAME );
	strcat( mKeyName , "\\" );
	strcat( mKeyName , product_name );
	mRootKey = machine ? HKEY_LOCAL_MACHINE : HKEY_CURRENT_USER; 
}

//****************************************************************************************************
CRegistry::~CRegistry()
{
}

//****************************************************************************************************
SINT	CRegistry::GetInt( const char* name , SINT def )
{
	HKEY	key;
	SINT	buffer;
	DWORD	buffertype;
	DWORD	buffersize = sizeof(buffer);

	//ASSERTMSG( name , "CRegistry::GetInt - NULL name passed" );

	if ( RegOpenKeyEx( mRootKey , mKeyName , 0 , KEY_READ , &key ) == ERROR_SUCCESS )
	{
		if ( !(RegQueryValueEx( key , name , NULL , &buffertype , (LPBYTE) &buffer , &buffersize ) == ERROR_SUCCESS &&
			 (buffertype == REG_DWORD || buffertype == REG_DWORD_LITTLE_ENDIAN)) )
			 buffer = def;
		RegCloseKey( key );
	}
	else 
		buffer = def;

	return buffer;
}

//****************************************************************************************************
void	CRegistry::SetInt( const char* name , SINT value )
{
	HKEY	key;
	DWORD	disp;

	//ASSERTMSG( name , "CRegistry::SetInt - NULL name passed" );

	if ( RegCreateKeyEx( mRootKey , mKeyName , 0 , NULL , 0 , KEY_WRITE , NULL , &key , &disp ) == ERROR_SUCCESS )
	{
		RegSetValueEx( key , name , 0 , REG_DWORD , (const BYTE*)&value , sizeof(SINT) );
		RegCloseKey( key );
	}
}

//****************************************************************************************************
void	CRegistry::GetString( const char* name , char* buffer , const char* def , UINT buffer_len )
{
	HKEY	key;
	DWORD	buffertype;

	//ASSERTMSG( name , "CRegistry::GetString - NULL name passed" );
	//ASSERTMSG( name , "CRegistry::GetString - NULL buffer passed" );

	if ( RegOpenKeyEx( mRootKey , mKeyName , 0 , KEY_READ , &key ) == ERROR_SUCCESS )
	{
		if ( !(RegQueryValueEx( key , name , NULL , &buffertype , (LPBYTE)buffer , (DWORD*)&buffer_len ) == ERROR_SUCCESS &&
			 buffertype == REG_SZ) )
		{
			if (def) strcpy( buffer , def );
		}
		RegCloseKey( key );
	}
	else 
	{
		if (def) strcpy( buffer , def );
	}
}

//****************************************************************************************************
void	CRegistry::SetString( const char* name , char* value )
{
	HKEY	key;
	DWORD	disp;

	//ASSERTMSG( name , "CRegistry::SetString - NULL name passed" );
	//ASSERTMSG( name , "CRegistry::SetString - NULL value passed" );

	if ( RegCreateKeyEx( mRootKey , mKeyName , 0 , NULL , 0 , KEY_WRITE , NULL , &key , &disp ) == ERROR_SUCCESS )
	{
		RegSetValueEx( key , name , 0 , REG_SZ , (const BYTE*)value , strlen(value) + 1 );
		RegCloseKey( key );
	}
}

//****************************************************************************************************
void	CRegistry::GetBinary( const char* name , char* buffer , const char* def , UINT len )
{
	HKEY	key;
	DWORD	buffertype;

	//ASSERTMSG( name , "CRegistry::GetBinary - NULL name passed" );
	//ASSERTMSG( name , "CRegistry::GetBinary - NULL buffer passed" );
	
	if ( RegOpenKeyEx( mRootKey , mKeyName , 0 , KEY_READ , &key ) == ERROR_SUCCESS )
	{
		if ( !(RegQueryValueEx( key , name , NULL , &buffertype , (LPBYTE)buffer , (DWORD*)&len ) == ERROR_SUCCESS &&
			 buffertype == REG_BINARY) )
		{			
			if (def) memcpy( buffer , def , len);
		}
		RegCloseKey( key );
	}
	else 
	{
		if (def)  memcpy( buffer , def , len);
	}
}

//****************************************************************************************************
void	CRegistry::SetBinary( const char* name , char* value , UINT len)
{
	HKEY	key;
	DWORD	disp;

	//ASSERTMSG( name , "CRegistry::SetBinary - NULL name passed" );
	//ASSERTMSG( name , "CRegistry::SetBinary - NULL value passed" );

	if ( RegCreateKeyEx( mRootKey , mKeyName , 0 , NULL , 0 , KEY_WRITE , NULL , &key , &disp ) == ERROR_SUCCESS )
	{
		RegSetValueEx( key , name , 0 , REG_BINARY , (const BYTE*)value , len );
		RegCloseKey( key );
	}
}


//****************************************************************************************************
GUID	CRegistry::GetGUID( const char* name , const GUID& def )
{
	HKEY	key;
	DWORD	buffertype;
	GUID	rc = def;
	char	buffer[8+1+4+1+4+1+16+1];
	DWORD	bufferlen = sizeof(buffer);

	//ASSERTMSG( name , "CRegistry::GetGUID - NULL name passed" );

	if ( RegOpenKeyEx( mRootKey , mKeyName , 0 , KEY_READ , &key ) == ERROR_SUCCESS )
	{
		if ( RegQueryValueEx( key , name , NULL , &buffertype , (LPBYTE)buffer , &bufferlen ) == ERROR_SUCCESS &&
			 buffertype == REG_SZ )
		{
			sscanf( buffer , "%8lx-%4hx-%4hx-%8lx%8lx" ,
				    &rc.Data1 , &rc.Data2 , &rc.Data3 , &rc.Data4[0] , &rc.Data4[4] );
		}
		RegCloseKey( key );
	}

	return rc;
}

//****************************************************************************************************
void	CRegistry::SetGUID( const char* name , const GUID& value )
{
	HKEY	key;
	DWORD	disp;

	//ASSERTMSG( name , "CRegistry::SetGUID - NULL name passed" );

	if ( RegCreateKeyEx( mRootKey , mKeyName , 0 , NULL , 0 , KEY_WRITE , NULL , &key , &disp ) == ERROR_SUCCESS )
	{
		char	buffer[8+1+4+1+4+1+16+1];
		sprintf( buffer , "%08lx-%04hx-%04hx-%08lx%08lx" ,
				 value.Data1 , value.Data2 , value.Data3 , *((SINT*)(&value.Data4[0])) ,
				 *((SINT*)(&value.Data4[4])) );
		RegSetValueEx( key , name , 0 , REG_SZ , (const unsigned char*)buffer , strlen(buffer)+1 );
		RegCloseKey( key );
	}
}
