#include "common.h"
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "mpeg.h"

#pragma warning (disable:4305)

const static float bignum=  8425472.f-4096+8192;
static union
{
	float f;
	int i;
} utemp;
#define WRITE_SAMPLE(samples,sum) utemp.f=sum+ (8425472.f-4096+8192);utemp.i=(utemp.i&0xfffff)-(32768+8192);*samples=(utemp.i<-32767)?-32767:(utemp.i>32766)?32766:utemp.i;

int synth_1to1_mono(real *bandPtr,unsigned char *samples)
{
  int i,ret = synth_1to1(bandPtr,0,samples);
  for(i=0;i<32;i++) {
    ((short *)samples)[1] = ((short *)samples)[0];
    samples+=4;
  }
  return ret;
}

int synth_2to1_mono(real *bandPtr,unsigned char *samples)
{
  int i,ret = synth_2to1(bandPtr,0,samples);
  for(i=0;i<16;i++) {
    ((short *)samples)[1] = ((short *)samples)[0];
    samples+=4;
  }
  return ret;
}

int synth_4to1_mono(real *bandPtr,unsigned char *samples)
{
  int i,ret = synth_4to1(bandPtr,0,samples);
  for(i=0;i<8;i++) {
    ((short *)samples)[1] = ((short *)samples)[0];
    samples+=4;
  }
  return ret;
}


int synth_1to1(real *bandPtr,int channel,unsigned char *out)
{
  static real buffs[2][2][0x110];
  static int bo = 1;
  short *samples = (short *) out;

  real *b0,(*buf)[0x110];
  
  int bo1;
  static const int step = 2;

  if(!channel) {
    bo--;
    bo &= 0xf;
    buf = buffs[0];
  }
  else {
    samples++;
    buf = buffs[1];
  }

  if(bo & 0x1) {
    b0 = buf[0];
    bo1 = bo;
    dct64(buf[1]+((bo+1)&0xf),buf[0]+bo,bandPtr);
  }
  else {
    b0 = buf[1];
    bo1 = bo+1;
    dct64(buf[0]+bo,buf[1]+bo+1,bandPtr);
  }


  {
    register int j;
    real *window = decwin + 16 - bo1;
 
    for (j=8;j;j--,window+=0x20,b0+=16,samples+=step)
    {
      real sum;
	  sum=+window[0] * b0[0]
		  -window[1] * b0[1]
		  +window[2] * b0[2]
		  -window[3] * b0[3]
		  +window[4] * b0[4]
		  -window[5] * b0[5]
		  +window[6] * b0[6]
		  -window[7] * b0[7]
		  +window[8] * b0[8]
		  -window[9] * b0[9]
		  +window[10] * b0[10]
		  -window[11] * b0[11]
		  +window[12] * b0[12]
		  -window[13] * b0[13]
		  +window[14] * b0[14]
		  -window[15] * b0[15];
      WRITE_SAMPLE(samples,sum);
	  window+=0x20,b0+=16,samples+=step;
	  sum=+window[0] * b0[0]
		  -window[1] * b0[1]
		  +window[2] * b0[2]
		  -window[3] * b0[3]
		  +window[4] * b0[4]
		  -window[5] * b0[5]
		  +window[6] * b0[6]
		  -window[7] * b0[7]
		  +window[8] * b0[8]
		  -window[9] * b0[9]
		  +window[10] * b0[10]
		  -window[11] * b0[11]
		  +window[12] * b0[12]
		  -window[13] * b0[13]
		  +window[14] * b0[14]
		  -window[15] * b0[15];


      WRITE_SAMPLE(samples,sum);
    }

    {
      real sum;
      sum  = window[0x0] * b0[0x0];
      sum += window[0x2] * b0[0x2];
      sum += window[0x4] * b0[0x4];
      sum += window[0x6] * b0[0x6];
      sum += window[0x8] * b0[0x8];
      sum += window[0xA] * b0[0xA];
      sum += window[0xC] * b0[0xC];
      sum += window[0xE] * b0[0xE];
      WRITE_SAMPLE(samples,sum);
      b0-=0x10,window-=0x20,samples+=step;
    }
    window += (bo1<<1) - 16;

    for (j=7;j;j--,b0-=0x10,window-=0x20,samples+=step)
    {
      real sum;
	  sum= -window[15] * b0[0]
		   -window[14] * b0[1]
		   -window[13] * b0[2]
		   -window[12] * b0[3]
		   -window[11] * b0[4]
		   -window[10] * b0[5]
		   -window[ 9] * b0[6]
		   -window[ 8] * b0[7]
		   -window[ 7] * b0[8]
		   -window[ 6] * b0[9]
		   -window[ 5] * b0[10]
		   -window[ 4] * b0[11]
		   -window[ 3] * b0[12]
		   -window[ 2] * b0[13]
		   -window[ 1] * b0[14]
		   -window[ 0] * b0[15];
      WRITE_SAMPLE(samples,sum);
	  b0-=0x10,window-=0x20,samples+=step;
	  sum= -window[15] * b0[0]
		   -window[14] * b0[1]
		   -window[13] * b0[2]
		   -window[12] * b0[3]
		   -window[11] * b0[4]
		   -window[10] * b0[5]
		   -window[ 9] * b0[6]
		   -window[ 8] * b0[7]
		   -window[ 7] * b0[8]
		   -window[ 6] * b0[9]
		   -window[ 5] * b0[10]
		   -window[ 4] * b0[11]
		   -window[ 3] * b0[12]
		   -window[ 2] * b0[13]
		   -window[ 1] * b0[14]
		   -window[ 0] * b0[15];
      WRITE_SAMPLE(samples,sum);
    }

	{
		real sum;
		sum= -window[15] * b0[0]
		   -window[14] * b0[1]
		   -window[13] * b0[2]
		   -window[12] * b0[3]
		   -window[11] * b0[4]
		   -window[10] * b0[5]
		   -window[ 9] * b0[6]
		   -window[ 8] * b0[7]
		   -window[ 7] * b0[8]
		   -window[ 6] * b0[9]
		   -window[ 5] * b0[10]
		   -window[ 4] * b0[11]
		   -window[ 3] * b0[12]
		   -window[ 2] * b0[13]
		   -window[ 1] * b0[14]
		   -window[ 0] * b0[15];
      WRITE_SAMPLE(samples,sum);
	}
  }

  return 0;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int synth_2to1(real *bandPtr,int channel,unsigned char *out)
{
  static real buffs[2][2][0x110];
  static const int step = 2;
  static int bo = 1;
  short *samples = (short *) out;

  real *b0,(*buf)[0x110];
  
  int bo1;

  if(!channel) {
    bo--;
    bo &= 0xf;
    buf = buffs[0];
  }
  else {
    samples++;
    buf = buffs[1];
  }

  if(bo & 0x1) {
    b0 = buf[0];
    bo1 = bo;
    dct64(buf[1]+((bo+1)&0xf),buf[0]+bo,bandPtr);
  }
  else {
    b0 = buf[1];
    bo1 = bo+1;
    dct64(buf[0]+bo,buf[1]+bo+1,bandPtr);
  }

  {
    register int j;
    real *window = decwin + 16 - bo1;

    for (j=8;j;j--,b0+=0x10,window+=0x30)
    {
      real sum;
      sum  = *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;

      WRITE_SAMPLE(samples,sum); samples += step;
#if 0
      WRITE_SAMPLE(samples,sum); samples += step;
#endif
    }

    {
      real sum;
      sum  = window[0x0] * b0[0x0];
      sum += window[0x2] * b0[0x2];
      sum += window[0x4] * b0[0x4];
      sum += window[0x6] * b0[0x6];
      sum += window[0x8] * b0[0x8];
      sum += window[0xA] * b0[0xA];
      sum += window[0xC] * b0[0xC];
      sum += window[0xE] * b0[0xE];
      WRITE_SAMPLE(samples,sum); samples += step;
#if 0
      WRITE_SAMPLE(samples,sum); samples += step;
#endif
      b0-=0x20,window-=0x40;
    }
    window += bo1<<1;

    for (j=7;j;j--,b0-=0x30,window-=0x30)
    {
      real sum;
      sum = -*(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;

      WRITE_SAMPLE(samples,sum); samples += step;
#if 0
      WRITE_SAMPLE(samples,sum); samples += step;
#endif
    }
  }

  return 0;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int synth_4to1(real *bandPtr,int channel,unsigned char *out)
{
  static real buffs[2][2][0x110];
  static const int step = 2;
  static int bo = 1;
  short *samples = (short *) out;

  real *b0,(*buf)[0x110];
  int clip = 0; 
  int bo1;

  if(!channel) {
    bo--;
    bo &= 0xf;
    buf = buffs[0];
  }
  else {
    samples++;
    buf = buffs[1];
  }

  if(bo & 0x1) {
    b0 = buf[0];
    bo1 = bo;
    dct64(buf[1]+((bo+1)&0xf),buf[0]+bo,bandPtr);
  }
  else {
    b0 = buf[1];
    bo1 = bo+1;
    dct64(buf[0]+bo,buf[1]+bo+1,bandPtr);
  }

  {
    register int j;
    real *window = decwin + 16 - bo1;

    for (j=4;j;j--,b0+=0x30,window+=0x70)
    {
      real sum;
      sum  = *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;
      sum += *window++ * *b0++;
      sum -= *window++ * *b0++;

      WRITE_SAMPLE(samples,sum); samples += step;
    }

    {
      real sum;
      sum  = window[0x0] * b0[0x0];
      sum += window[0x2] * b0[0x2];
      sum += window[0x4] * b0[0x4];
      sum += window[0x6] * b0[0x6];
      sum += window[0x8] * b0[0x8];
      sum += window[0xA] * b0[0xA];
      sum += window[0xC] * b0[0xC];
      sum += window[0xE] * b0[0xE];
      WRITE_SAMPLE(samples,sum); samples += step;
      b0-=0x40,window-=0x80;
    }
    window += bo1<<1;

    for (j=3;j;j--,b0-=0x50,window-=0x70)
    {
      real sum;
      sum = -*(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;
      sum -= *(--window) * *b0++;

      WRITE_SAMPLE(samples,sum); samples += step;
    }
  }

  return 0;
}


