// main
//

#include "common.h"
#include "coords.h"
#include "crtdbg.h"
#include "d3derr.h"

#pragma  warning(disable:4244 4305)

HINSTANCE gInst;
HWND gHWnd;

char gQuit=0;
char appname[]="stxdemo";

void DDError(HRESULT error, char *context)
{
	char c2[1024];
	sprintf(c2,"Error context was:\n\n%s\n\nSorry guv'nor.\nTry a different mode/driver/computer/life",context);
	MessageBox(NULL,c2,"Direct-X Error!",MB_OK|MB_ICONERROR);
}

void SoundError()
{
	char c2[1024];
	sprintf(c2,"Sorry guv'nor.\nThere's a problem with the sound.\nTry a different mode/driver/computer/life");
	MessageBox(NULL,c2,"Direct-Sound Error!",MB_OK|MB_ICONERROR);
}



int findword(FILE *f,char *s)
{
	static char s2[128];
	int c;
	do
	{
		do
		{
			if ((c=getc(f))==EOF) return  0;
		} while (c!='*');
		fscanf(f,"%s",s2);
	} while (stricmp(s2,s));
	return 1;
}	

char *getword(FILE *f)
{
	static char s2[128];
	fscanf(f,"%s",s2);
	return s2;
}	

struct SVertex
{
	FVector p,rp,v;
	float x,y;
};

struct Spring
{
	SVertex *a,*b;
	float len;
	int draw;
};

struct Cube
{
	SVertex *s[8];
};

struct Vertex
{
	FVector p,cp,rp;
	FVector n;
	float col;
	float x,y;
	Cube *c;
};

struct Face
{
	FVector n[4];
	FVector col;
	Vertex *a,*b,*c;
	int m;
};

struct Camera
{
	FVector p;
	FMatrix m;
};

Camera cam;
int numv=0;
int numf=0;
Vertex vtx[8192];
Face tri[8192];
D3DTLVERTEX d3dvtx[8192][3];
int numsv=0;
int nums=0;
int numc=0;
SVertex svtx[8192*4];
Spring spr[16384*4];
Cube cube[1024];
Cube *selc;
int maxx,maxy;
float scale;
float dalpha=0,dtheta=0;

#define MINZ 100
#define R_MINZ -150
#define R_MAXZ 150
#define R_MINX -150
#define R_MAXX 150
#define R_MINY -200
#define R_MAXY 100

float GRAV=0.006f;
float VDAMP=0.995f;
float REST=0.7f;
float K=0.0052f;
int RES=3;

int showcubes=0;



SVertex *addsvertex(FVector &v)
{
	for (int c1=0;c1<numsv;c1++) if ((svtx[c1].p-v).MagnitudeSq()<0.01) return &svtx[c1];
	svtx[c1].p=v;
	svtx[c1].v=FVector(0,0,0);
	numsv++;
	return &svtx[c1];
}

Spring *addspring(SVertex *a, SVertex *b, int d=0)
{
	if (a<b)
	{
		SVertex *c=a;a=b;b=c;	
	}
	for (int c1=0;c1<nums;c1++) if (spr[c1].a==a && spr[c1].b==b) return &spr[c1];
	spr[c1].a=a;
	spr[c1].b=b;
	spr[c1].draw=d;
	spr[c1].len=(a->p-b->p).Magnitude();
	nums++;
	return &spr[c1];
}

Cube *addcube(float x1, float y1, float z1, float x2, float y2, float z2)
{
	SVertex *s[8];
	s[0]=addsvertex(FVector(x1,y1,z1));
	s[1]=addsvertex(FVector(x2,y1,z1));
	s[2]=addsvertex(FVector(x1,y2,z1));
	s[3]=addsvertex(FVector(x2,y2,z1));
	s[4]=addsvertex(FVector(x1,y1,z2));
	s[5]=addsvertex(FVector(x2,y1,z2));
	s[6]=addsvertex(FVector(x1,y2,z2));
	s[7]=addsvertex(FVector(x2,y2,z2));
	memcpy(cube[numc].s,s,4*8);

	// edges
	addspring(s[0],s[1],1);addspring(s[3],s[1],1);addspring(s[3],s[2],1);addspring(s[0],s[2],1);
	addspring(s[4],s[5],1);addspring(s[5],s[7],1);addspring(s[7],s[6],1);addspring(s[6],s[4],1);
	addspring(s[0],s[4],1);addspring(s[1],s[5],1);addspring(s[2],s[6],1);addspring(s[3],s[7],1);
	// small diagonals
	addspring(s[0],s[3]);addspring(s[5],s[6]);addspring(s[1],s[2]);addspring(s[4],s[7]);
	addspring(s[7],s[1]);addspring(s[2],s[4]);addspring(s[5],s[3]);addspring(s[0],s[6]);
	addspring(s[0],s[5]);addspring(s[7],s[2]);addspring(s[1],s[4]);addspring(s[3],s[6]);
	// big diagonals
	addspring(s[0],s[7]);addspring(s[1],s[6]);addspring(s[3],s[4]);addspring(s[2],s[5]);		
	return &cube[numc++];
}

void hitcube(FVector &v)
{
	v=cam.m.Transpose()*v;
	v*=0.1f;
	for (int c2=0;c2<numsv;c2++) svtx[c2].v+=v;	
}

void makecubes(int xc, int yc, int zc)
{
	numc=nums=numsv=0;
	int x,y,z;
	FVector minv(0,0,0),maxv(0,0,0),m1,m2;
	for (int c1=0;c1<numv;c1++) 
	{	
		if (vtx[c1].p.X<minv.X) minv.X=vtx[c1].p.X;if (vtx[c1].p.X>maxv.X) maxv.X=vtx[c1].p.X;
		if (vtx[c1].p.Y<minv.Y) minv.Y=vtx[c1].p.Y;if (vtx[c1].p.Y>maxv.Y) maxv.Y=vtx[c1].p.Y;
		if (vtx[c1].p.Z<minv.Z) minv.Z=vtx[c1].p.Z;if (vtx[c1].p.Z>maxv.Z) maxv.Z=vtx[c1].p.Z;
	}
	maxv=(maxv-minv)*1.001f;
	maxv.X/=xc;
	maxv.Y/=yc;
	maxv.Z/=zc;
	for (x=0;x<xc;x++)
	for (y=0;y<yc;y++)
	for (z=0;z<zc;z++)
	{
		m1=FVector(minv.X+x*maxv.X,minv.Y+y*maxv.Y,minv.Z+z*maxv.Z);
		m2=m1+maxv;
		Cube *c=NULL;
		for (c1=0;c1<numv;c1++) 
		{
			if (vtx[c1].p.X>=m1.X && vtx[c1].p.X<=m2.X &&
				vtx[c1].p.Y>=m1.Y && vtx[c1].p.Y<=m2.Y &&
				vtx[c1].p.Z>=m1.Z && vtx[c1].p.Z<=m2.Z)
			{
				if (!c) c=addcube(m1.X,m1.Y,m1.Z,m2.X,m2.Y,m2.Z);
				vtx[c1].c=c;
				vtx[c1].cp=vtx[c1].p-m1;
				vtx[c1].cp.X/=maxv.X;
				vtx[c1].cp.Y/=maxv.Y;
				vtx[c1].cp.Z/=maxv.Z;				
			}
		}
		if (x==xc/2 && y==yc/2 && z==zc/2) selc=c;
	}
}


void animcubes()
{
	int c1;
	// do springs forces
	Spring *s=spr;
	for(c1=0;c1<nums;c1++,s++)
	{
		FVector v=s->a->p-s->b->p;
		float f=v.Magnitude();
		f=K*(f-s->len)/f;
		v=v*f;
		s->a->v-=v;
		s->b->v+=v;
	}

	// rotate and move points
	SVertex *v=svtx;
	for (c1=0;c1<numsv;c1++,v++)
	{
		v->v=v->v*VDAMP;
		v->v.Y+=GRAV;
		v->p+=v->v;
		if (v->p.X>R_MAXX) {v->p.X=R_MAXX;if (v->v.X>0){v->v.X=-v->v.X;v->v=v->v*REST;}}
		if (v->p.X<R_MINX) {v->p.X=R_MINX;if (v->v.X>0){v->v.X=-v->v.X;v->v=v->v*REST;}}
		if (v->p.Y>R_MAXY) {v->p.Y=R_MAXY;if (v->v.Y>0){v->v.Y=-v->v.Y;v->v=v->v*REST;}}
		if (v->p.Y<R_MINY) {v->p.Y=R_MINY;if (v->v.Y>0){v->v.Y=-v->v.Y;v->v=v->v*REST;}}
		if (v->p.Z>R_MAXZ) {v->p.Z=R_MAXZ;if (v->v.Z>0){v->v.Z=-v->v.Z;v->v=v->v*REST;}}
		if (v->p.Z<R_MINZ) {v->p.Z=R_MINZ;if (v->v.Z>0){v->v.Z=-v->v.Z;v->v=v->v*REST;}}
		
		v->rp=cam.m*(v->p-cam.p);		
	}
	// deform mesh
	Vertex *vv=vtx;
	float x1,y1,z1,x2,y2,z2;
	for(c1=0;c1<numv;c1++,vv++)
	{
		SVertex **s=vv->c->s;
		x2=vv->cp.X;y2=vv->cp.Y;z2=vv->cp.Z;
		x1=(1-x2);y1=(1-y2);z1=(1-z2);
		vv->rp=FVector(s[0]->rp.X*x1*y1*z1+s[1]->rp.X*x2*y1*z1+s[2]->rp.X*x1*y2*z1+s[3]->rp.X*x2*y2*z1+
			           s[4]->rp.X*x1*y1*z2+s[5]->rp.X*x2*y1*z2+s[6]->rp.X*x1*y2*z2+s[7]->rp.X*x2*y2*z2,
					   s[0]->rp.Y*x1*y1*z1+s[1]->rp.Y*x2*y1*z1+s[2]->rp.Y*x1*y2*z1+s[3]->rp.Y*x2*y2*z1+
			           s[4]->rp.Y*x1*y1*z2+s[5]->rp.Y*x2*y1*z2+s[6]->rp.Y*x1*y2*z2+s[7]->rp.Y*x2*y2*z2,
					   s[0]->rp.Z*x1*y1*z1+s[1]->rp.Z*x2*y1*z1+s[2]->rp.Z*x1*y2*z1+s[3]->rp.Z*x2*y2*z1+
			           s[4]->rp.Z*x1*y1*z2+s[5]->rp.Z*x2*y1*z2+s[6]->rp.Z*x1*y2*z2+s[7]->rp.Z*x2*y2*z2);
	}
}

void drawcage()
{
	// project points
	int c1;
 	static Vertex rv[8];
	const int lista[12]={0,1,3,2,4,5,7,6,0,1,2,3};
	const int listb[12]={1,3,2,0,5,7,6,4,4,5,6,7};


	Vertex *v=rv;
	for (c1=0;c1<8;c1++,v++)
	{		
		v->p=FVector((c1&1)?R_MINX:R_MAXX,(c1&2)?R_MINY:R_MAXY,(c1&4)?R_MINZ:R_MAXZ);
		v->rp=cam.m*(v->p-cam.p);
		if (v->rp.Z>MINZ)
		{
			float p=scale/v->rp.Z;
			v->x=maxx/2+p*v->rp.X;
			v->y=maxy/2+p*v->rp.Y;
		}
	}

	D3DTLVERTEX *tl=d3dvtx[0];	
	for (c1=0;c1<12;c1++)
	{
		Vertex *a=rv+lista[c1];
		Vertex *b=rv+listb[c1];
		tl->sx=a->x;
		tl->sy=a->y;
		tl->rhw=tl->sz=1-MINZ/a->rp.Z;	// ooh, dont do that!
		tl->color=D3DRGB(0,1-tl->rhw,1-tl->rhw);
		tl->tu=tl->tv=0;
		tl++;

		tl->sx=b->x;
		tl->sy=b->y;
		tl->rhw=tl->sz=1-MINZ/b->rp.Z;	// ooh, dont do that!
		tl->color=D3DRGB(0,1-tl->rhw,1-tl->rhw);
		tl->tu=tl->tv=0;
		tl++;
	}
	gD->mD3DD2->DrawPrimitive(D3DPT_LINELIST,D3DVT_TLVERTEX,d3dvtx,tl-d3dvtx[0],D3DDP_WAIT);		
}


void drawcubes()
{
	// project points
	int c1;
	SVertex *v=svtx;
	for (c1=0;c1<numsv;c1++,v++)
	{		
		if (v->rp.Z>MINZ)
		{
			float p=scale/v->rp.Z;
			v->x=maxx/2+p*v->rp.X;
			v->y=maxy/2+p*v->rp.Y;
		}
	}

	D3DTLVERTEX *tl=d3dvtx[0];
	Spring *s=spr;
	for (c1=0;c1<nums;c1++,s++) if (s->draw)
	{
		tl->sx=s->a->x;
		tl->sy=s->a->y;
		tl->rhw=tl->sz=1-MINZ/s->a->rp.Z;	// ooh, dont do that!
		tl->color=D3DRGBA(1-tl->rhw,1-tl->rhw,0,0);
		tl++;

		tl->sx=s->b->x;
		tl->sy=s->b->y;
		tl->rhw=tl->sz=1-MINZ/s->b->rp.Z;	// ooh, dont do that!
		tl->color=D3DRGBA(1-tl->rhw,1-tl->rhw,0,1);		
		tl++;
	}
	
	gD->mD3DD2->DrawPrimitive(D3DPT_LINELIST,D3DVT_TLVERTEX,d3dvtx,tl-d3dvtx[0],D3DDP_WAIT);		
}

int loadobject(char *fname)
{
	int a,b,c,m,numvo,numfo,sub,c1,c2,c3;
	float x,y,z;

	FILE *f=fopen(fname,"r");
	if (!f) goto error;
	while (!feof(f))
	{
		if (findword(f,"geomobject"))
		{
			if (!findword(f,"node_name")) goto error;
			TRACE("found object ");
			TRACE(getword(f));
			if (!findword(f,"MESH_NUMVERTEX")) goto error;
			numvo=atoi(getword(f));
			if (!findword(f,"MESH_NUMFACES")) goto error;
			numfo=atoi(getword(f));
			for (c1=0;c1<numvo;c1++)
			{
				if (!findword(f,"MESH_VERTEX")) goto error;
				c2=atoi(getword(f));
				if (c1!=c2) goto error;
				x=atof(getword(f));
				y=atof(getword(f));
				z=atof(getword(f));	
				vtx[numv+c1].p=FVector(x,-z,y);				
				vtx[numv+c1].n=FVector(0,0,0);				
			}
			for (c1=0;c1<numfo;c1++)
			{
				if (!findword(f,"MESH_FACE")) goto error;
				c2=atoi(getword(f));
				if (c1!=c2) goto error;
				//*MESH_FACE    0:    A: 124 B: 125 C: 126 AB:   1 BC:   1 CA:   1	 *MESH_SMOOTHING 1 	*MESH_MTLID 0
				getword(f); // A:
				a=atoi(getword(f));
				getword(f); // B:
				b=atoi(getword(f));
				getword(f); // C:
				c=atoi(getword(f));
				if (!findword(f,"MESH_MTLID")) goto error;
				m=atoi(getword(f));
				tri[numf+c1].c=&vtx[numv+a];
				tri[numf+c1].b=&vtx[numv+b];
				tri[numf+c1].a=&vtx[numv+c];
				tri[numf+c1].m=m;				
			}
			/*
			for (c1=0;c1<numfo;c1++)
			{
				if (!findword(f,"MESH_FACENORMAL")) goto error;
				c2=atoi(getword(f));
				if (c1!=c2) goto error;
				x=atof(getword(f));
				y=atof(getword(f));
				z=atof(getword(f));		
				tri[numf+c1].n[3]=FVector(x,y,z);
				tri[numf+c1].a->n=tri[numf+c1].a->n+FVector(x,y,z);
				tri[numf+c1].b->n=tri[numf+c1].b->n+FVector(x,y,z);
				tri[numf+c1].c->n=tri[numf+c1].c->n+FVector(x,y,z);
				for (c2=0;c2<3;c2++)
				{
					if (!findword(f,"MESH_VERTEXNORMAL")) goto error;
					c3=atoi(getword(f));				
					x=atof(getword(f));
					y=atof(getword(f));
					z=atof(getword(f));		
					tri[numf+c1].n[2-c2]=FVector(x,y,z);					
				}
			}

			*/
			if (!findword(f,"MATERIAL")) goto error;
			if (!findword(f,"MATERIAL_CLASS")) goto error;
			
			if (stricmp(getword(f),"\"Multi/Sub-Object\"")==0) sub=1; else sub=0;
			if (!findword(f,"MATERIAL_DIFFUSE")) goto error;
			x=atof(getword(f));
			y=atof(getword(f));
			z=atof(getword(f));					
			for (c1=0;c1<numfo;c1++) tri[numf+c1].col=FVector(x,y,z);
			if (sub)
			{
				if (!findword(f,"NUMSUBMTLS")) goto error;
				sub=atoi(getword(f));
				for (c2=0;c2<sub;c2++)
				{
					if (!findword(f,"SUBMATERIAL")) goto error;
					if (!findword(f,"MATERIAL_DIFFUSE")) goto error;
					x=atof(getword(f));
					y=atof(getword(f));
					z=atof(getword(f));					
					for (c1=0;c1<numfo;c1++) if (tri[numf+c1].m==c2) tri[numf+c1].col=FVector(x,y,z);
				}
			}
			TRACE("\nok!\n");
			numf+=numfo;
			numv+=numvo;
		}
	}	
	// normalise normals
	for (c1=0;c1<numv;c1++) vtx[c1].n.Normalise();
	return 0;
error:
	TRACE("error loading asc file");
	return 1;
}



void drawstr(char *str, char *o, int pitch=gD->mPitch, int bits=gD->mVM->mB)
{
	bits/=8;
	int x,x2,y,m;
	static int i=0;
	static char font[256][8];
	if (!i)
	{
		i=1;
		FILE *f=fopen("font.fnt","rb");
		fread(font,256,8,f);
		fclose(f);
	}
	char *o2=o;
	while (*str)
	{
		if (*str==13 || *str==10)
		{	
			o2+=pitch*8;
			o=o2;
			str++;
			continue;
		}
		char *b=font[*str++];
		for (y=0;y<8;y++,b++)
		{
			m=*b;
			for (x=0;x<8;x++,m<<=1,o+=bits) if (m&128)  for (x2=0;x2<bits;x2++) o[x2]=-1;
			o+=pitch-bits*8;
		}
		o-=pitch*8-bits*8;
	}
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg)
	{
	case WM_DESTROY:
		gQuit=1;
		break;
	case WM_KEYDOWN:
		switch ((wparam))
		{
		case VK_F1:GRAV-=0.0005;break;
		case VK_F2:GRAV+=0.0005;break;
		case VK_F3:if (VDAMP>0) VDAMP-=0.0005;break;
		case VK_F4:if (VDAMP<1) VDAMP+=0.0005;break;
		case VK_F5:if (REST>0) REST-=0.05;break;
		case VK_F6:if (REST<1) REST+=0.05;break;
		case VK_F7:if (K>0) K-=0.0005;break;
		case VK_F8:if (K<1) K+=0.0005;break;
		case VK_F11:
		if (RES>1)
		{
			RES--;
	 		makecubes(RES,RES,RES);
		}
		break;
		case VK_F12:
		if (RES<6)
		{
			RES++;
			makecubes(RES,RES,RES);	
		}
		break;
		case VK_LEFT:
				if (lparam&(1<<24)) dalpha=-1; else	hitcube(FVector(-1,0,0));
				break;
		case VK_RIGHT:
				if (lparam&(1<<24)) dalpha=1; else	hitcube(FVector(+1,0,0));
				break;
		case VK_UP:
				if (lparam&(1<<24)) dtheta=-1; else	hitcube(FVector(0,-1,0));
				break;
		case VK_DOWN:
				if (lparam&(1<<24)) dtheta=+1; else	hitcube(FVector(0,+1,0));
				break;
		case VK_HOME:
		case VK_PRIOR:
				if (lparam&(1<<24)) ; else	hitcube(FVector(0,0,-1));
				break;
		case VK_END:
		case VK_NEXT:
				if (lparam&(1<<24)) ; else	hitcube(FVector(0,0,+1));
				break;
		}
		return 1;
	case WM_KEYUP:
		switch (toupper(wparam))
		{
		case VK_LEFT:
				if (lparam&(1<<24)) dalpha=0;
				break;
		case VK_RIGHT:
				if (lparam&(1<<24)) dalpha=0;
				break;
		case VK_UP:
				if (lparam&(1<<24)) dtheta=0;
				break;
		case VK_DOWN:
				if (lparam&(1<<24)) dtheta=0;
				break;
		}
		return 0;
	case WM_CHAR:
		switch (toupper(wparam))
		{
		case ' ':
		case 'R':
			makecubes(RES,RES,RES);
			break;
		case 'C':
			showcubes=!showcubes;
			break;
		case 27:
			DestroyWindow(hwnd);
			break;		
		}		
		return 0;
	case WM_CREATE:
		return 0;	
	}
	if (gD) return gD->WndProc(hwnd,msg,wparam,lparam); else return DefWindowProc(hwnd,msg,wparam,lparam);
}

int CD3DRGB(float r, float g, float b)
{
	if (r>1) r=1;
	if (g>1) g=1;
	if (b>1) b=1;
	return D3DRGB(r,g,b);
}


int WINAPI WinMain(HINSTANCE hinst, HINSTANCE hpinst, PSTR cmdline, int show)
{
#ifdef _DEBUG
	_CrtMemState memstate1;
	_CrtMemCheckpoint(&memstate1);
#endif

	gInst=hinst;

	// create window
	WNDCLASSEX wc={sizeof(wc),CS_HREDRAW|CS_VREDRAW,WndProc,0,0,hinst,LoadIcon(NULL,IDI_APPLICATION),
		LoadCursor(NULL,IDC_ARROW),(HBRUSH)GetStockObject(WHITE_BRUSH),NULL,appname,LoadIcon(NULL,IDI_APPLICATION)};
	RegisterClassEx(&wc);
	gHWnd=CreateWindow(appname,"dt3 player",WS_CAPTION|WS_SYSMENU|WS_BORDER,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
						NULL,NULL,hinst,NULL);
	ShowWindow(gHWnd,SW_HIDE);	

	
	if (loadobject("troll.asc")) return 1;
	makecubes(RES,RES,RES);
	

	gD=new CD3D();

	if (gD->Init()) 
	{
		delete gD;
		return 1;
	}

	if (gD->InitScreen())
	{
		delete gD;
		return 1;
	}

	/*
	if (gD->InitSound())
	{
		gD->CloseScreen();
		SoundError();
		delete gD;
		return 1;
	}
	*/

	int frame=0;
	float fps=0;
	int time1=GetTickCount();

	maxx=gD->mVM->mW;
	maxy=gD->mVM->mH;
	scale=maxx;

	cam.p=FVector(0,0,-500);
	cam.m.MakeID();
	
	FVector light=FVector(200,-300,-200);
	light.Normalise();

	int r;
	float alpha=0;
	float theta=-0.27f;
	float da=0;
	float dt=0;
	do
	{



		r=gD->mD3DD2->BeginScene();
		if (r) trace_d3d_error(r);
		//{for (int dd=0;dd<3*655360;dd++);}
	
		
		FMatrix m1,m2;
		m1.MakeYRot(alpha);
		m2.MakeXRot(theta);
		cam.m=m2*m1;	
		if (dalpha) da=dalpha; else da*=0.95f;
		if (dtheta) dt=dtheta; else dt*=0.95f;
		
		alpha+=0.01f *da;
		theta+=0.01f*dt;
		
		cam.p=cam.m.Row[2]*-400;		

		/*
		for (int c1=0;c1<10;c1++)
		{
		D3DTLVERTEX myv[]={	{{rand()%640},{rand()%480},{0.5},{0.5},{D3DRGBA(1,0,0,0.5)},{0},{0},{0}},
							{{rand()%640},{rand()%480},{0.5},{0.5},{D3DRGBA(0,0,1,0.5)},{0},{0},{0}},
							{{rand()%640},{rand()%480},{0.5},{0.5},{D3DRGBA(0,1,0,0.5)},{0},{0},{0}}};
		WORD myi[]={0,1,2,2,1,0};
		gD->mD3DD2->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,D3DVT_TLVERTEX,myv,3,myi,6,D3DDP_WAIT);		
		}
		*/

		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREHANDLE , NULL );

		animcubes();
		if (showcubes) drawcubes();
		drawcage();

		Vertex *v;
		Face *f;
		int c1;		
		// work out new face normals...
		for (v=vtx,c1=0;c1<numv;c1++,v++) v->n=FVector(0,0,0);
		for (f=tri,c1=0;c1<numf;c1++,f++)
		{
			FVector a=f->a->rp-f->b->rp;
			a=a^(f->c->rp-f->b->rp);			
			f->n[3]=a;
			f->a->n=f->a->n+a;
			f->b->n=f->b->n+a;
			f->c->n=f->c->n+a;
		}
		
	
		// project points, and light them		
		
		FVector rlight=cam.m*light;
		v=vtx;
		for (c1=0;c1<numv;c1++,v++)
		{
			//v->rp=cam.m*(v->p-cam.p);
			if (v->rp.Z>MINZ)
			{
				float p=scale/v->rp.Z;
				v->x=maxx/2+p*v->rp.X;
				v->y=maxy/2+p*v->rp.Y;
				v->n.Normalise();
				p=(v->n*rlight)+0.5;
				if (p<0) p=0;
				else p=(0.7*p*p);				
				v->col=p;
			}
		}
		// light polygons and write tlvertices (GOD this is so BUDGET)
		D3DTLVERTEX *tl=d3dvtx[0];
		f=tri;
		float p;
		for (c1=0;c1<numf;c1++,f++)
		{
			p=f->a->col;
			tl->sx=f->a->x;
			tl->sy=f->a->y;
			tl->rhw=tl->sz=1-MINZ/f->a->rp.Z;	// ooh, dont do that!
			tl->color=CD3DRGB(f->col.R*p,f->col.G*p,f->col.B*p);
			tl++;

			p=f->b->col;
			tl->sx=f->b->x;
			tl->sy=f->b->y;
			tl->rhw=tl->sz=1-MINZ/f->b->rp.Z;	// ooh, dont do that!
			tl->color=CD3DRGB(f->col.R*p,f->col.G*p,f->col.B*p);
			tl++;

			p=f->c->col;
			tl->sx=f->c->x;
			tl->sy=f->c->y;
			tl->rhw=tl->sz=1-MINZ/f->c->rp.Z;	// ooh, dont do that!
			tl->color=CD3DRGB(f->col.R*p,f->col.G*p,f->col.B*p);
			tl++;

		}
		r=gD->mD3DD2->DrawPrimitive(D3DPT_TRIANGLELIST,D3DVT_TLVERTEX,d3dvtx,numf*3,D3DDP_WAIT);		
		if (r) trace_d3d_error(r);

		// SHADOW!!
		// project points, and light them		
		v=vtx;
		FMatrix caminv=cam.m.Transpose();
		for (c1=0;c1<numv;c1++,v++)
		{
			FVector p=(caminv*v->rp)+cam.p;
			float e=(p.Y-R_MAXY)/light.Y;
			p=p-light*e;
			v->rp=cam.m*(p-cam.p);		
			if (v->rp.Z<MINZ) v->rp.Z=MINZ;			
			{
				float p=scale/v->rp.Z;
				v->x=maxx/2+p*v->rp.X;
				v->y=maxy/2+p*v->rp.Y;
			}
		}
		// light polygons and write tlvertices (GOD this is so BUDGET)
		tl=d3dvtx[0];
		f=tri;		
		for (c1=0;c1<numf;c1++,f++)
		{			
			tl->sx=f->a->x;
			tl->sy=f->a->y;
			tl->rhw=tl->sz=1-MINZ/f->a->rp.Z;	// ooh, dont do that!
			tl->color=D3DRGB(0.1,0.1,0.1);
			tl++;
		
			tl->sx=f->b->x;
			tl->sy=f->b->y;
			tl->rhw=tl->sz=1-MINZ/f->b->rp.Z;	// ooh, dont do that!
			tl->color=D3DRGB(0.1,0.1,0.1);
			tl++;

			tl->sx=f->c->x;
			tl->sy=f->c->y;
			tl->rhw=tl->sz=1-MINZ/f->c->rp.Z;	// ooh, dont do that!
			tl->color=D3DRGB(0.1,0.1,0.1);
			tl++;

		}
		r=gD->mD3DD2->DrawPrimitive(D3DPT_TRIANGLELIST,D3DVT_TLVERTEX,d3dvtx,numf*3,D3DDP_WAIT);		
		if (r) trace_d3d_error(r);

				
		

		r=gD->mD3DD2->EndScene();
		if (r) trace_d3d_error(r);
		

		
		if (!gD->Lock())
		{
			char ss[1024];																					       
			sprintf(ss,"gravity: %0.5f  damping: %0.5f\nrestitution: %0.5f  spring constant: %0.6f\nresolution: %d  show-cubes: %s    fps: %0.2f",GRAV,VDAMP,REST,K,RES,showcubes?"yes":"no",fps);		
			drawstr(ss,gD->mScreenMem);
			gD->Unlock();
		}
		
		
		
		gD->DoTick(DT_FLIPCLEAR);

		frame++;
		int time2=GetTickCount()-time1;
		if (time2>2500)
		{			
			fps=frame*1000.0f/time2;
			time1=GetTickCount();
			frame=0;
	
		}
		
	} while (!gQuit);

	//gD->CloseSound();
	gD->CloseScreen();

	delete gD;

#ifdef _DEBUG
	_CrtMemState memstate2,memdiff;
	_CrtMemCheckpoint(&memstate2);
	if (_CrtMemDifference(&memdiff,&memstate1,&memstate2)) 
	{
		_CrtMemDumpStatistics(&memdiff);
		_CrtDumpMemoryLeaks();
		MessageBox(NULL,"Memory leaks detected!\nCheck debug trace!","Memory leaks detected",MB_OK|MB_ICONINFORMATION);
	}
#endif
	return 0;	
	
}