#include "common.h"

direntry *libdir=NULL;
char *libdata=NULL;
int numlib=0;
int compopen=0;

int unzip(char *dest, int count);
void InitializeDictionary(char *src);
void InitialiseStorage();
void FreeStorage();


int	openlib(char *fname)
{
	if (libdir) closelib();
	FILE *f=fopen(fname,"rb");
	if (!f) return -1;
	int id;
	fread(&id,1,4,f);
	if (id!='XELA') {fclose(f);return -2;}
	fread(&numlib,1,4,f);
	fread(&id,1,4,f);
	libdata = new char[id];
	libdir=new direntry[numlib];
	fseek(f,0,SEEK_SET);
	fread(libdata,1,id,f);
	fread(libdir,numlib,sizeof(direntry),f);
	fclose(f);
	InitialiseStorage();
	return 0;
}

void closelib()
{
	if (!libdir) return;
	delete [] libdata;
	delete [] libdir;
	libdata=NULL;
	libdir=NULL;
	numlib=0;
	FreeStorage();
}

void FILE_::close()
{
	if (mode&F_OWNPACKED) delete [] packed;
	if (mode&F_OWNUNPACKED) delete [] unpacked;
	if (mode&F_COMPRESSED) compopen=0;
	mode=pos=0;
	packed=unpacked=unpackedbase=NULL;
}

int FILE_::open(char *fname, int comp)
{
	if (mode) close();
	if (libdir)
	{
		for (int c1=0;c1<numlib;c1++) if (stricmp(fname,libdir[c1].name)==0)
		{
			// get it from the library!
			len=libdir[c1].len;
			clen=libdir[c1].clen;
			packed=libdata+libdir[c1].ofs;
			if (libdir[c1].comp)
			{
				if (compopen) return -1;
				compopen=1;
				mode|=F_COMPRESSED;
				InitializeDictionary(packed);
			}
			else
			{
				unpacked=unpackedbase=packed;
			}
			return 0;
		}
	}
	// load it off disk
	static char moo[128];
	sprintf(moo,"data\\%s",fname);	
	FILE *f=fopen(moo,"rb");
	if (!f) 
	{
		TRACE("ERROR! couldn't open file %s",fname);
		return -1;
	}
	TRACE("WARNING!!! loading file %s from disk",fname);
	fseek(f,0,SEEK_END);
	clen=len=ftell(f);
	fseek(f,0,SEEK_SET);
	packed=new char[len];
	fread(packed,1,len,f);
	fclose(f);
	mode|=F_OWNPACKED;
	if (comp)
	{
		if (compopen) return -1;
		compopen=1;
		mode|=F_COMPRESSED;
		InitializeDictionary(packed);
	}
	else
	{
		unpacked=unpackedbase=packed;
	}
	return 0;
}

int		FILE_::read(void *buf, int c)
{
	if (pos+c>len) c=len-pos;
	if (c<=0) return 0;
	if (unpacked) memcpy(buf, unpackedbase+pos, c); else
	{
		unzip((char*)buf,c);
	}
	pos+=c;
	return c;
}
int		FILE_::seek(int pos)
{
	// not implemented
	return -1;
}

int		FILE_::tell()
{
	return pos;
}

char*	FILE_::getbuf()
{
	if (unpacked) 
	{
		pos=len;
		return unpackedbase+pos;
	}
	mode|=F_OWNUNPACKED;
	char *temp=new char[len-pos];
	unpackedbase=temp-pos;
	read(temp,len-pos);
	unpacked=temp;
	return unpacked;	// NOTE! pos is now at the end of the file
}




// lzw stuff

typedef			unsigned char		UBYTE;
typedef			signed char			SBYTE;
typedef			unsigned char		BYTE;
typedef			unsigned short int	UWORD;
typedef			signed short int		SWORD;
typedef			unsigned short int	WORD;
//typedef			unsigned int		ULONG;
typedef			signed int			SLONG;
//typedef			unsigned int		LONG;
typedef			unsigned int		UDWORD;
typedef			signed int			SDWORD;

#define BITS                       15
#define MAX_CODE                   ( ( 1 << BITS ) - 1 )
#define TABLE_SIZE                 35023L
#define END_OF_STREAM              256
#define BUMP_CODE                  257
#define FLUSH_CODE                 258
#define FIRST_CODE                 259
#define UNUSED                     -1
typedef struct {
    char character;
    SLONG code_value;
    SLONG parent_code;
} DICTIONARY;



//LONG RAMReadBits(LONG n);

DICTIONARY *dict;
char decode_stack[ TABLE_SIZE ];
ULONG next_code;
SLONG current_code_bits;
ULONG next_bump_code;
ULONG new_code;
ULONG old_code;
LONG character;
BYTE *RAMPtr,RAMRack,RAMMask;
LONG numdecode;


LONG RAMReadBits(LONG n)
{
	LONG mask=1L<<(n-1),val=0;
	while (mask)
	{
	  if (RAMMask==0x80) RAMRack=*RAMPtr++;
	  if (RAMMask & RAMRack) val|=mask;
	  if (!(RAMMask>>=1)) RAMMask=0x80;
	  mask >>=1;
	}
	return(val);
}

int unzip(char *src, int count)
{
	int temp;
	_asm
	{
		push ebp
		mov	ecx,count
		mov	edi,src
		mov	esi,RAMPtr
		mov	dl,RAMRack
		mov	dh,RAMMask
		mov	temp,edi
outer:
		mov	ebx,numdecode
		or	ebx,ebx
		jz	inner
outer2:
		dec	ebx
		mov	al,decode_stack[ebx]
		stosb
		dec	ecx
		jz	done
		or	ebx,ebx
		jnz	outer2
inner:
        //readbit//
		mov	bl,cl
		mov	cl,byte ptr current_code_bits
		xor	eax,eax
		mov	ebp,80000000h
		rol	ebp,cl
		mov	cl,bl
getloop2:cmp dh,80h
		jne	noget2
		mov	dl,[esi]
		inc	esi
noget2:  test dl,dh
		jz	noor2
		or	eax,ebp
noor2:   ror dh,1
		shr	ebp,1
		jnz	getloop2



		mov	new_code,eax
		cmp	eax,END_OF_STREAM
		je	done
		cmp	eax,FLUSH_CODE
		je	doflush
		cmp	eax,BUMP_CODE
		je	dobump
		xor	ebp,ebp
		cmp	eax,next_code
		jb	nofix
		mov	al, byte ptr character
		mov    byte ptr decode_stack,al
		inc	ebp
		mov	eax, old_code
nofix:
		cmp	eax,255
		jbe	doneit
again:
		lea	ebx,[eax*8]
		add	ebx, dict
		mov	eax,[ebx+4]
		mov	bl,[ebx]
		mov	 decode_stack[ebp],bl
		inc	ebp
		cmp	eax,255
		ja	again
doneit:
		mov	 byte ptr decode_stack[ebp],al
		mov	 byte ptr character,al
		inc	ebp
		mov	numdecode,ebp
		mov	ebx,next_code
		shl	ebx,3
		add	ebx,dict
		mov	[ebx],al
		mov	eax,old_code
		mov	[ebx+4],eax
		inc	next_code
		mov	eax,new_code
		mov	 old_code,eax
		jmp	outer

done:
		mov	numdecode,ebx
		pop ebp
		sub	temp,edi
		mov	RAMPtr,esi
		mov	RAMRack,dl
		mov	RAMMask,dh
		jmp doneitatlast
dobump:
		inc	byte ptr current_code_bits
		jmp	inner
doflush:
		mov	next_code,FIRST_CODE
		mov	current_code_bits,9
        //readbit//
		mov	bl,cl
		mov	cl,byte ptr current_code_bits
		xor	eax,eax
		mov	ebp,80000000h
		rol	ebp,cl
		mov	cl,bl
getloop:cmp dh,80h
		jne	noget
		mov	dl,[esi]
		inc	esi
noget:  test dl,dh
		jz	noor
		or	eax,ebp
noor:   ror dh,1
		shr	ebp,1
		jnz	getloop



		mov	old_code,eax
		mov	byte ptr character,al
		mov	byte ptr decode_stack,al
		mov	numdecode,1
		jmp	outer
doneitatlast:
		
	}
	return -temp;
}

void InitializeDictionary(char *src)
{
	ULONG i;

	RAMRack=0;
	RAMMask=0x80;
	RAMPtr=(BYTE*)src;
	InitialiseStorage();
	
	for ( i = 0 ; i < TABLE_SIZE ; i++ )
	  dict[ i ].code_value = UNUSED;
	next_code = FIRST_CODE;
	current_code_bits = 9;
	next_bump_code = 511;

	old_code = (ULONG) RAMReadBits(current_code_bits );
	decode_stack[0] = character = old_code;
	numdecode=1;


}

void InitialiseStorage()
{
	if (dict) return;
	  dict = (DICTIONARY *)
			   malloc( (TABLE_SIZE+1) * sizeof (DICTIONARY) );
}

void FreeStorage()
{
	free(dict);
	dict=NULL;
}


