		org	0x100

BIOS_TIMER	equ	0x46c

		cld
		finit
		mov	ax, cs
		add	ah, 0x10
		mov	[back_seg], ax
		mov	ax, 0x13
		int	0x10

		xor	eax, eax
		mov	gs, ax			; gs - zero segment
		mov	[frame], eax
		mov	dx, 0x3c8		; set grayscale palette
		mov	cx, 256
		out	dx, al
		inc	dx
set_pal_loop:	mov	ax, 256
		sub	ax, cx
		shr	al, 2
		out	dx, al
		out	dx, al
		out	dx, al
		loop	set_pal_loop
set_pal_break:

		fldz
		fstp	dword [flt_alpha]
		mov	eax, [gs:BIOS_TIMER]
		mov	[t0], eax
main_loop:
		; clear
		mov	es, [back_seg]
		xor	di, di
		xor	eax, eax
		mov	cx, 16000
		rep	stosd

		fld	dword [flt_alpha]
		fstp	dword [flt_tmp]

		mov	byte [spot_shade], 0
		mov	dword [spot_r], 0x10000	; spot radius
		mov	cx, 25
draw_spot_loop:
		; FLT_FIX( sin( a + cos( a / 0.91f ) ) * 50.0f ) + 160fix
		fld	dword [flt_65536]		; calc x
		fld	dword [flt_alpha]
		fld	dword [flt_xradius]
		fld	dword [flt_0_91]
		fld	st2
		fdiv	st0, st1
		fcos
		fadd	st0, st3
		fsin
		fmul	st0, st2
		fmul	st0, st4
		fistp	dword [spot_x]
		fstp	st0
		fstp	st0
		add	dword [spot_x], 0xa00000

		; FLT_FIX( sin( a / 2.1f ) * 50.0f ) + 100fix
		; FPU stack: st0 = flt_alpha, st1 = flt_65536
		fld	dword [flt_yradius]		; calc y
		fld	dword [flt_2_1]
		fld	st2				; load alpha
		fdiv	st0, st1
		fsin
		fmul	st0, st2
		fmul	st0, st4
		fistp	dword [spot_y]
		fstp	st0
		fstp	st0
		fstp	st0
		fstp	st0
		add	dword [spot_y], 0x640000

		push	cx
		call	draw_spot
		pop	cx

		 fld	dword [flt_step2]	; alpha += flt_step2
		 fld	dword [flt_alpha]
		 fadd	st0, st1
		 fstp	dword [flt_alpha]
		 fstp	st0

		add	byte [spot_shade], 10
		add	dword [spot_r], 0xe000	; spot radius
		loop	draw_spot_loop

		; restore alpha
		fld	dword [flt_tmp]
		fstp	dword [flt_alpha]

		; wait for full vertical retrace & blit
		push	ds			; prepare for fast blit
		mov	es, [video_seg]		;  after retrace
		mov	ds, [back_seg]
		xor	si, si
		xor	di, di
		mov	cx, 16000
		mov	dx, 0x3da
wvsl0:		in	al, dx
		test	al, 8
		jnz	wvsl0
wvsl1:		in	al, dx
		test	al, 8
		jz	wvsl1
		rep	movsd
		pop	ds

		inc	dword [frame]		; frame++

		mov	eax, [gs:BIOS_TIMER]
		sub	eax, [t0]
		mov	[t1], eax
		fild	dword [frame]
		fld	dword [flt_speed]
		fild	dword [t1]
		fdiv	st0, st1
		fdiv	st0, st2
		fld	dword [flt_alpha]
		fadd	st0, st1
		fstp	dword [flt_alpha]
		fstp	st0
		fstp	st0
		fstp	st0

		fld	dword [flt_step]	; alpha += flt_step
		fld	dword [flt_alpha]
		fadd	st0, st1
		fstp	dword [flt_alpha]
		fstp	st0

		in	al, 0x60
		cmp	al, 1
		jne	main_loop

		mov	ax, 3
		int	0x10
		ret

		include	'spot.inc'

; initialized vars
video_seg	dw	0xa000
flt_speed	dd	10.0
flt_step	dd	0.025
flt_step2	dd	0.2
flt_xradius	dd	50.0
flt_yradius	dd	40.0
flt_65536	dd	65536.0
flt_2_1		dd	2.1
flt_0_91	dd	0.91
y_aspect	dd	0x12000

; uninitialized vars
back_seg	dw	?
frame		dd	?
t0		dd	?
t1		dd	?
flt_alpha	dd	?
flt_tmp		dd	?

; spot vars
spot_shade	db	?
spot_x		dd	?		; fixed
spot_y		dd	?
spot_r		dd	?
i		dw	?
xl		dd	?
xr		dd	?
yu		dd	?
yd		dd	?
rm1		dd	?
dist		dd	?
