#ifndef	__VBECLS_H__
#define	__VBECLS_H__

typedef struct _vbe_info {
	char	VbeSignature[4];	/* VBE Signature			*/
	short	VbeVersion;		/* VBE Version				*/
	long	OemStringPtr;		/* Pointer to OEM String		*/
	char	Capabilities[4];	/* Capabilities of graphics controller	*/
	long	VideoModePtr;		/* Pointer to VideoModeList		*/
	short	TotalMemory;		/* Number of 64kb memory blocks		*/
					/* Added for VBE 2.0			*/
	short	OemSoftwareRev;		/* VBE implementation Software revision	*/
	long	OemVendorNamePtr;	/* Pointer to Vendor Name String	*/
	long	OemProductNamePtr;	/* Pointer to Product Name String	*/
	long	OemProductRevPtr;	/* Pointer to Product Revision String	*/
	char	Reserved[222];		/* Reserved for VBE implementation	*/
					/* scratch area				*/
	char	OemData[256];		/* Data Area for OEM Strings		*/
} vbe_info;

typedef struct _vbe_modeinfo {
	short	ModeAttributes;		/* Mode attributes                  */
	char	WinAAttributes;		/* Window A attributes              */
	char	WinBAttributes;		/* Window B attributes              */
	short	WinGranularity;		/* Window granularity in k          */
	short	WinSize;		/* Window size in k                 */
	short	WinASegment;		/* Window A segment                 */
	short	WinBSegment;		/* Window B segment                 */
	void *	WinFuncPtr;		/* Pointer to window function       */
	short	BytesPerScanLine;	/* Bytes per scanline               */
	short	XResolution;		/* Horizontal resolution            */
	short	YResolution;		/* Vertical resolution              */
	char	XCharSize;		/* Character cell width             */
	char	YCharSize;		/* Character cell height            */
	char	NumberOfPlanes;		/* Number of memory planes          */
	char	BitsPerPixel;		/* Bits per pixel                   */
	char	NumberOfBanks;		/* Number of CGA style banks        */
	char	MemoryModel;		/* Memory model type                */
	char	BankSize;		/* Size of CGA style banks          */
	char	NumberOfImagePages;	/* Number of images pages           */
	char	res1;			/* Reserved                         */
	char	RedMaskSize;		/* Size of direct color red mask    */
	char	RedFieldPosition;	/* Bit posn of lsb of red mask      */
	char	GreenMaskSize;		/* Size of direct color green mask  */
	char	GreenFieldPosition;	/* Bit posn of lsb of green mask    */
	char	BlueMaskSize;		/* Size of direct color blue mask   */
	char	BlueFieldPosition;	/* Bit posn of lsb of blue mask     */
	char	RsvdMaskSize;		/* Size of direct color res mask    */
	char	RsvdFieldPosition;	/* Bit posn of lsb of res mask      */
	char	DirectColorModeInfo;	/* Direct color mode attributes     */

	/* VESA 2.0 variables */
	long	PhysBasePtr;		/* physical address for flat frame buffer  */
	long	OffScreenMemOffset;	/* pointer to start of off screen memory   */
	short	OffScreenMemSize;	/* amount of off screen memory in 1k units */
	char	res2[206];		/* Pad to 256 byte block size              */
} vbe_modeinfo;

class VBECLS
{
public:
	vbe_info	info;
	int		cur_page;
	vbe_modeinfo	cur_mode;
	unsigned long	scr_size;
	unsigned long	scr_linear;
	int GetVBEInfo( vbe_info * );
	int GetModeInfo( int, vbe_modeinfo * );
	long GetPhysBase( void );
	int InitMode( int, unsigned long * );
	int SetDisplayStart( short, short );
	int GetCurrentPage( void );
	int SetPage( int );
	int SwapPages( void );
	void WaitVSync( void );
	void Blit( void * );
};

typedef VBECLS *	LPVBECLS;

int CreateVBEClass( LPVBECLS * );
void DestroyVBEClass( LPVBECLS );

#endif
