#include "tri.h"

#define	WIDTH	320
#define	HEIGHT	200

#define	sort_vertices( s0, s1, s2, d0, d1, d2 )			\
	fixed	ty0, ty1, ty2;					\
	ty0 = s0->y;						\
	ty1 = s1->y;						\
	ty2 = s2->y;						\
	if ( ty0 < ty1 ) {					\
		if ( ty0 < ty2 ) {				\
			d0 = s0;				\
			if ( ty1 < ty2 ) {			\
				d1 = s1;			\
				d2 = s2;			\
			} else {	/* ty1 > ty2 */		\
				d1 = s2;			\
				d2 = s1;			\
			}					\
		} else {		/* ty2 < ty0 */		\
			d0 = s2;				\
			d1 = s0;				\
			d2 = s1;				\
		}						\
	} else {			/* ty0 > ty1 */		\
		if ( ty1 < ty2 ) {				\
			d0 = s1;				\
			if ( ty2 < ty0 ) {			\
				d1 = s2;			\
				d2 = s0;			\
			} else {	/* ty2 > ty0 */		\
				d1 = s0;			\
				d2 = s2;			\
			}					\
		} else {		/* ty1 > ty2 */		\
			d0 = s2;				\
			d1 = s1;				\
			d2 = s0;				\
		}						\
	}

long *		tri_back;
fixed *		tri_zbuff;
long *		tri_texture;

int		tri_clip_x0	= 1;
int		tri_clip_y0	= 1;
int		tri_clip_x1	= 319;
int		tri_clip_y1	= 199;

void tri_init( void )
{
	// TODO: init
}

void tri_set_back( long *back )
{
	tri_back = back;
}

void tri_set_zbuff( fixed *zbuff )
{
	tri_zbuff = zbuff;
}

void tri_set_texture( long *texture )
{
	tri_texture = texture;
}

void tri_set_clip( int x0, int y0, int x1, int y1 )
{
	tri_clip_x0 = x0;
	tri_clip_y0 = y0;
	tri_clip_x1 = x1;
	tri_clip_y1 = y1;
}

inline long bilinear_gray( fixed u, fixed v, fixed s )
{
	fixed	ss;
	fixed	fu, fv;
	fixed	u1, v1;
	long	c0, c1, c2, c3, i;
	fixed	rr0, rr1, rr2, rr3;
	fixed	gg0, gg1, gg2, gg3;
	fixed	bb0, bb1, bb2, bb3;
	fixed	rv0, rv1, ru;
	fixed	gv0, gv1, gu;
	fixed	bv0, bv1, bu;

	fu = u & 0x0000ffff;
	fv = v & 0x0000ffff;

	i = ((v >> 8) & 0xff00) + (u >> 16);
	c0 = tri_texture[i];
	c1 = tri_texture[i + 1];
	c2 = tri_texture[i + 256];
	c3 = tri_texture[i + 257];

	rr0 = INT_FIX( (c0 >> 16) & 0xff );
	gg0 = INT_FIX( (c0 >> 8) & 0xff );
	bb0 = INT_FIX( c0 & 0xff );

	rr1 = INT_FIX( (c1 >> 16) & 0xff );
	gg1 = INT_FIX( (c1 >> 8) & 0xff );
	bb1 = INT_FIX( c1 & 0xff );

	rr2 = INT_FIX( (c2 >> 16) & 0xff );
	gg2 = INT_FIX( (c2 >> 8) & 0xff );
	bb2 = INT_FIX( c2 & 0xff );

	rr3 = INT_FIX( (c3 >> 16) & 0xff );
	gg3 = INT_FIX( (c3 >> 8) & 0xff );
	bb3 = INT_FIX( c3 & 0xff );

	rv0 = rr0 + FixMul( rr2 - rr0, fv );
	rv1 = rr1 + FixMul( rr3 - rr1, fv );
	ru  = rv0 + FixMul( rv1 - rv0, fu );

	gv0 = gg0 + FixMul( gg2 - gg0, fv );
	gv1 = gg1 + FixMul( gg3 - gg1, fv );
	gu  = gv0 + FixMul( gv1 - gv0, fu );

	bv0 = bb0 + FixMul( bb2 - bb0, fv );
	bv1 = bb1 + FixMul( bb3 - bb1, fv );
	bu  = bv0 + FixMul( bv1 - bv0, fu );

/*	ru += s;
	gu += s;
	bu += s;*/

	ss = (s >> 8) + 0x100;
	ru = FixMul( ru + s, ss );
	gu = FixMul( gu + s, ss );
	bu = FixMul( bu + s, ss );

	if ( ru > 0xff0000 ) ru = 0xff0000;
	if ( gu > 0xff0000 ) gu = 0xff0000;
	if ( bu > 0xff0000 ) bu = 0xff0000;
	return (FIX_INT( ru ) << 16) | (FIX_INT( gu ) << 8) | FIX_INT( bu );
}

inline void inner_z_texbl_gs( long *p, fixed *z, fixed x0, fixed x1,
	fixed z0, fixed z1, fixed s0, fixed s1, fixed u0, fixed u1, fixed v0, fixed v1 )
{
	fixed	length, clip_l;
	fixed	dx, dz, ds, du, dv, x0c, x1c, x0ic;

	x0c = FixCeil( x0 );
	x1c = FixCeil( x1 );

	// clip
	if ( FIX_INT( x1c ) < tri_clip_x0 ) return;
	if ( FIX_INT( x0c ) > tri_clip_x1 ) return;

	length = x1c - x0c;
	if ( !length ) return;

	x0ic = FIX_INT( x0c );
	p += x0ic;
	z += x0ic;

	dx = FixDiv( INT_FIX( 1 ), x1 - x0 );
	dz = FixMul( z1 - z0, dx );
	ds = FixMul( s1 - s0, dx );
	du = FixMul( u1 - u0, dx );
	dv = FixMul( v1 - v0, dx );

	// sub-texel accuracy
	dx = x0c - x0;
	z0 += FixMul( dz, dx );
	s0 += FixMul( ds, dx );
	u0 += FixMul( du, dx );
	v0 += FixMul( dv, dx );

	length = FIX_INT( length );

	// clip
	if ( FIX_INT( x1c ) > tri_clip_x1 ) length -= FIX_INT( x1c ) - tri_clip_x1;
	if ( FIX_INT( x0c ) < tri_clip_x0 ) {
		clip_l = INT_FIX( tri_clip_x0 ) - x0c;
		z0 += FixMul( dz, clip_l );
		s0 += FixMul( ds, clip_l );
		u0 += FixMul( du, clip_l );
		v0 += FixMul( dv, clip_l );
		p += FIX_INT( clip_l );
		z += FIX_INT( clip_l );
		length -= FIX_INT( clip_l );
	}

	while ( length-- > 0 ) {
		if ( *z < z0 ) {
			*p = bilinear_gray( u0, v0, s0 );
			*z = z0;
		}
		z0 += dz;
		s0 += ds;
		u0 += du;
		v0 += dv;
		z++;
		p++;
	}
}

void tri_z_texbl_gs( tri_vertex *sv0, tri_vertex *sv1, tri_vertex *sv2 )
{
#define	DO_INC()	xx0 += dx0;	\
			xx1 += dx1;	\
			zz0 += dz0;	\
			zz1 += dz1;	\
			ss0 += ds0;	\
			ss1 += ds1;	\
			uu0 += du0;	\
			uu1 += du1;	\
			vv0 += dv0;	\
			vv1 += dv1;	\
			p += WIDTH;	\
			z += WIDTH;	\
			y++;

	int		y, l;
	long *		p;
	fixed *		z;
	tri_vertex *	v0;
	tri_vertex *	v1;
	tri_vertex *	v2;
	int		clip_y;
	fixed		clip_h;
	fixed		y0c, y1c, y2c;
	fixed		y2_y0, y1_y0, y2_y1, y0c_y0, y1c_y1;
	fixed		xx0, xx1, zz0, zz1, ss0, ss1, uu0, uu1, vv0, vv1;
	fixed		dx0, dx1, dz0, dz1, ds0, ds1, du0, du1, dv0, dv1;

	sort_vertices( sv0, sv1, sv2, v0, v1, v2 );

	y0c = FixCeil( v0->y );
	y1c = FixCeil( v1->y );
	y2c = FixCeil( v2->y );

	// clip all
	if ( FIX_INT( y0c ) > tri_clip_y1 ) return;
	if ( FIX_INT( y2c ) < tri_clip_y0 ) return;
	if ( y2c <= y0c ) return;

	y = FIX_INT( y0c );
	l = y * WIDTH;
	p = tri_back + l;
	z = tri_zbuff + l;

	y2_y0 = FixDiv( INT_FIX( 1 ), v2->y - v0->y );
	dx0 = FixMul( v2->x - v0->x, y2_y0 );
	dz0 = FixMul( v2->z - v0->z, y2_y0 );
	ds0 = FixMul( v2->s - v0->s, y2_y0 );
	du0 = FixMul( v2->u - v0->u, y2_y0 );
	dv0 = FixMul( v2->v - v0->v, y2_y0 );

	// sub-pixel accuracy
	y0c_y0 = y0c - v0->y;
	xx0 = v0->x + FixMul( dx0, y0c_y0 );
	zz0 = v0->z + FixMul( dz0, y0c_y0 );
	ss0 = v0->s + FixMul( ds0, y0c_y0 );
	uu0 = v0->u + FixMul( du0, y0c_y0 );
	vv0 = v0->v + FixMul( dv0, y0c_y0 );

	// clip y0
	if ( FIX_INT( y0c ) < tri_clip_y0 ) {
		clip_h = INT_FIX( tri_clip_y0 ) - y0c;
		xx0 += FixMul( dx0, clip_h );
		zz0 += FixMul( dz0, clip_h );
		ss0 += FixMul( ds0, clip_h );
		uu0 += FixMul( du0, clip_h );
		vv0 += FixMul( dv0, clip_h );
		y += FIX_INT( clip_h );
		p += FIX_INT( clip_h ) * WIDTH;
		z += FIX_INT( clip_h ) * WIDTH;
	}

	if ( y0c < y1c ) {
		// clip y1
		clip_y = FIX_INT( y1c );
		if ( FIX_INT( y1c ) > tri_clip_y1 ) clip_y = tri_clip_y1;

		y1_y0 = FixDiv( INT_FIX( 1 ), v1->y - v0->y );
		dx1 = FixMul( v1->x - v0->x, y1_y0 );
		dz1 = FixMul( v1->z - v0->z, y1_y0 );
		ds1 = FixMul( v1->s - v0->s, y1_y0 );
		du1 = FixMul( v1->u - v0->u, y1_y0 );
		dv1 = FixMul( v1->v - v0->v, y1_y0 );

		// sub-pixel accuracy
		xx1 = v0->x + FixMul( dx1, y0c_y0 );
		zz1 = v0->z + FixMul( dz1, y0c_y0 );
		ss1 = v0->s + FixMul( ds1, y0c_y0 );
		uu1 = v0->u + FixMul( du1, y0c_y0 );
		vv1 = v0->v + FixMul( dv1, y0c_y0 );

		// clip y0
		if ( FIX_INT( y0c ) < tri_clip_y0 ) {
			clip_h = INT_FIX( tri_clip_y0 ) - y0c;
			xx1 += FixMul( dx1, clip_h );
			zz1 += FixMul( dz1, clip_h );
			ss1 += FixMul( ds1, clip_h );
			uu1 += FixMul( du1, clip_h );
			vv1 += FixMul( dv1, clip_h );
		}

		if ( dx0 < dx1 ) {
			while ( y < clip_y ) {
				inner_z_texbl_gs( p, z, xx0, xx1, zz0, zz1,
					ss0, ss1, uu0, uu1, vv0, vv1 );
				DO_INC();
			}
		} else {
			while ( y < clip_y ) {
				inner_z_texbl_gs( p, z, xx1, xx0, zz1, zz0,
					ss1, ss0, uu1, uu0, vv1, vv0 );
				DO_INC();
			}
		}
	}

	// clip bottom
	if ( FIX_INT( y1c ) > tri_clip_y1 ) return;
	if ( y2c <= y1c ) return;

	// clip y1
	clip_y = FIX_INT( y2c );
	if ( FIX_INT( y2c ) > tri_clip_y1 ) clip_y = tri_clip_y1;

	y2_y1 = FixDiv( INT_FIX( 1 ), v2->y - v1->y );
	dx1 = FixMul( v2->x - v1->x, y2_y1 );
	dz1 = FixMul( v2->z - v1->z, y2_y1 );
	ds1 = FixMul( v2->s - v1->s, y2_y1 );
	du1 = FixMul( v2->u - v1->u, y2_y1 );
	dv1 = FixMul( v2->v - v1->v, y2_y1 );

	// sub-pixel accuracy
	y1c_y1 = y1c - v1->y;
	xx1 = v1->x + FixMul( dx1, y1c_y1 );
	zz1 = v1->z + FixMul( dz1, y1c_y1 );
	ss1 = v1->s + FixMul( ds1, y1c_y1 );
	uu1 = v1->u + FixMul( du1, y1c_y1 );
	vv1 = v1->v + FixMul( dv1, y1c_y1 );

	// clip y0
	if ( FIX_INT( y1c ) < tri_clip_y0 ) {
		clip_h = INT_FIX( tri_clip_y0 ) - y1c;
		xx1 += FixMul( dx1, clip_h );
		zz1 += FixMul( dz1, clip_h );
		ss1 += FixMul( ds1, clip_h );
		uu1 += FixMul( du1, clip_h );
		vv1 += FixMul( dv1, clip_h );
	}

	if ( xx0 < xx1 ) {
		while ( y < clip_y ) {
			inner_z_texbl_gs( p, z, xx0, xx1, zz0, zz1,
				ss0, ss1, uu0, uu1, vv0, vv1 );
			DO_INC();
		}
	} else {
		while ( y < clip_y ) {
			inner_z_texbl_gs( p, z, xx1, xx0, zz1, zz0,
				ss1, ss0, uu1, uu0, vv1, vv0 );
			DO_INC();
		}
	}
#undef	DO_INC
}

void pixel_transp( int x, int y, long c, fixed alpha )
{
	int	i;
	fixed	r0, g0, b0, r1, g1, b1, alpha1;
	if ( x < 0 || x >= WIDTH || y < 0 || y >= HEIGHT ) return;
	i = WIDTH * y + x;
	alpha1 = INT_FIX( 1 ) - alpha;
	r0 = c & 0xff0000;
	g0 = (c << 8) & 0xff0000;
	b0 = (c << 16) & 0xff0000;
	c = tri_back[i];
	r1 = c & 0xff0000;
	g1 = (c << 8) & 0xff0000;
	b1 = (c << 16) & 0xff0000;
	r0 = FixMul( r0, alpha ) + FixMul( r1, alpha1 );
	g0 = FixMul( g0, alpha ) + FixMul( g1, alpha1 );
	b0 = FixMul( b0, alpha ) + FixMul( b1, alpha1 );
	tri_back[i] = (r0 & 0xff0000) | ((g0 >> 8) & 0xff00) | ((b0 >> 16) & 0xff);
}

void pixel_aaxi( fixed x, fixed y, long c )
{
	int	yc, yf, ix;
	fixed	yca, yfa;
	ix = FIX_INT( x );
	yc = FixIntCeil( y );
	yf = FixIntFloor( y );
	yca = y & 0xffff;
	yfa = 0xffff - yca;
	pixel_transp( ix, yc, c, yca );
	pixel_transp( ix, yf, c, yfa );
}

void pixel_aayi( fixed x, fixed y, long c )
{
	int	xc, xf, iy;
	fixed	xca, xfa;
	iy = FIX_INT( y );
	xc = FixIntCeil( x );
	xf = FixIntFloor( x );
	xca = x & 0xffff;
	xfa = 0xffff - xca;
	pixel_transp( xc, iy, c, xca );
	pixel_transp( xf, iy, c, xfa );
}

void tri_antialias_edge( tri_vertex *p0, tri_vertex *p1 )
{
	fixed	x, y;
	fixed	dx, dy;
	fixed	u0, v0;
	fixed	u1, v1;
	fixed	du, dv;
	fixed	s0, ds;
	long	ix, iy, c;
	dx = p1->x - p0->x;
	dy = p1->y - p0->y;
	if ( FIX_ABS( dx ) > FIX_ABS( dy ) ) {
		if ( p0->x > p1->x ) { tri_vertex *tmp = p0; p0 = p1; p1 = tmp; }
		s0 = p0->s; u0 = p0->u; v0 = p0->v;
		dx = p1->x - p0->x;
		ds = FixDiv( p1->s - s0, dx );
		du = FixDiv( p1->u - u0, dx );
		dv = FixDiv( p1->v - v0, dx );
		dy = FixDiv( p1->y - p0->y, dx );
		for ( ix = FixIntCeil( p0->x ); ix < FixIntCeil( p1->x ); ix++ ) {
			y = p0->y + FixMul( dy, INT_FIX( ix ) - p0->x );
			c = bilinear_gray( u0, v0, s0 );
//			c1 = bilinear_gray( u0, v0, s0 );
			pixel_aaxi( INT_FIX( ix ), y, c );
			s0 += ds;
			u0 += du;
			v0 += dv;
		}
	} else {
		if ( p0->y > p1->y ) { tri_vertex *tmp = p0; p0 = p1; p1 = tmp; }
		s0 = p0->s; u0 = p0->u; v0 = p0->v;
		dy = p1->y - p0->y;
		ds = FixDiv( p1->s - s0, dy );
		du = FixDiv( p1->u - u0, dy );
		dv = FixDiv( p1->v - v0, dy );
		dx = FixDiv( p1->x - p0->x, dy );
		for ( iy = FixIntCeil( p0->y ); iy < FixIntCeil( p1->y ); iy++ ) {
			x = p0->x + FixMul( dx, INT_FIX( iy ) - p0->y );
			c = bilinear_gray( u0, v0, s0 );
			pixel_aayi( x, INT_FIX( iy ), c );
			s0 += ds;
			u0 += du;
			v0 += dv;
		}
	}
}
