#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "tri.h"
#include "vector.h"
#include "mesh.h"
#include "tri.h"
#include "vbe.h"

#define			PI		3.1415926535897932384626433832795

#define			WIDTH		1024
#define			HEIGHT		768

LPVBECLS		lpVBE;
int			vbe_ver;
unsigned long		video_lfb;
int			frame		= 0;
long *			back;
float *			zbuff;
long *			texture;

mesh			torus;

void main( void )
{
	int		i, j;
	vector		v[4];
	tri_vertex	p[4];

	if ( !mesh_generate_torus( &torus, 256, 128, 7.5f, 5.0f ) ) return;
	mesh_generate_normals( &torus, 0 );

	vbe_ver = CreateVBEClass( &lpVBE );

	zbuff = new float [WIDTH * HEIGHT];

	texture = new long [256 * 256];
	for ( j = 0; j < 256; j++ )
	for ( i = 0; i < 256; i++ ) {
//		texture[(j << 8) + i] = (((j >> 1) + (i >> 1)) & 1) ? 0xaabbcc : 0;
		texture[(j << 8) + i] = ((long)(rand() % 200) << 8) | 0xff0000;
	}

	// 0x410f -  320x200@32
	// 0x4112 -  640x480@32
	// 0x4115 -  800x600@32
	// 0x4118 - 1024x768@32
	lpVBE->InitMode( 0x4118, &video_lfb );

	back = (long *)video_lfb;
	tri_init( back, zbuff );
	tri_set_texture( texture );

	for ( i = 0; i < WIDTH * HEIGHT; i++ ) {
//		back[i] = 0;
		back[i] = 0xaabbccdd;
		zbuff[i] = 10000.0f;
	}

	mesh_rotate( &torus, PI / 2.0f + 0.9f, 0.3f, 0.0f );
	mesh_generate_chrome_uv( &torus, 31.0f, 31.0f );

//	getch();
	mesh_render( &torus );

	getch();
	lpVBE->InitMode( 0, 0 );
}
