#pragma once

#define AVIIF_KEYFRAME  0x00000010L // this frame is a key frame.

#include <windows.h>
#include <windowsx.h>
#include <memory.h>
#include <mmsystem.h>
#include <vfw.h>
#include <math.h>


#ifdef _DEBUG
#pragma comment (lib, "avicompiler_debug.lib")     
#else
#pragma comment (lib, "avicompiler.lib")     
#endif
#pragma comment (lib, "vfw32.lib")     


namespace avicompiler {

	BOOL AVI_Init();

	BOOL AVI_FileOpenWrite(	PAVIFILE * pfile, char *filename);

	BOOL AVI_CreateStream(	PAVIFILE pfile, 
							PAVISTREAM * ps, 
							int rate,
							unsigned long buffersize,
							int rectwidth,
							int rectheight);

	BOOL AVI_SetOptions(PAVISTREAM * ps, 
						PAVISTREAM * psCompressed, 
						LPBITMAPINFOHEADER lpbi);

	BOOL AVI_SetText(	PAVIFILE pfile, 
						PAVISTREAM psText,
						char *szText,
						int width,
						int height,
						int TextHeight);

	BOOL AVI_AddFrame(	PAVISTREAM psCompressed,
						int time,
						LPBITMAPINFOHEADER lpbi);

	BOOL AVI_AddText(	PAVISTREAM psText,
						int time,
						char *szText);

	BOOL AVI_CloseStream(	PAVISTREAM ps,
							PAVISTREAM psCompressed,
							PAVISTREAM psText);

	BOOL AVI_CloseFile(PAVIFILE pfile);

	BOOL AVI_Exit();

	BOOL AVI_AddFramePixels(	PAVISTREAM psCompressed,
						int time,
						unsigned int *pixels);

	//////////////



	HANDLE CreateDIB(HBITMAP hBitmap);
	void startAVI(char *filename, int, int, int);
	void addFrame(unsigned int *pixels);
	void endAVI();


};