#include "RarFile.h"
#include <string.h>
#include <io.h>


CRarFile::CRarFile(const char *filename) :
	CCompressedFile(filename, "rar"),
	m_fileList(0),
	m_currentFile(0)
{

	if (m_filename) {
		urarlib_list(m_filename, (ArchiveList_struct*)&m_fileList);
		resetFileList();
	}
}


CRarFile::~CRarFile() {

	if (m_fileList) 
		  urarlib_freelist(m_fileList);
}


void CRarFile::resetFileList() {

	if (m_fileList) 
		m_currentFile = m_fileList;
}


bool CRarFile::getNextFile() {

	if (m_currentFile!=NULL) {
		m_currentFile = m_currentFile->next;
		return (m_currentFile!=NULL);
	} else {
		return false;
	}
}

char *CRarFile::getFilename() {

	if (m_currentFile!=NULL) {
		return m_currentFile->item.Name;
	} else {
		return 0;
	}
}

int	CRarFile::getFile(void *output, unsigned long *size, const char *filename) {
	return urarlib_get(output, size, (char *)filename, m_filename, 0);
}

bool CRarFile::isDirectory() {
	if (m_currentFile)
		return ((m_currentFile->item.FileAttr&_A_SUBDIR)!=0);
	else
		return false;
}

bool CRarFile::isHidden() {
	if (m_currentFile)
		return ((m_currentFile->item.FileAttr&_A_HIDDEN)!=0);
	else 
		return false;
}

bool CRarFile::fileExists(const char *filename) {
	
	resetFileList();
	do {
		if (stricmp(filename, getFilename())==0)
			return true;
	}while(getNextFile());

	return false;
}