#include "imagecontext.h"
#include "ansifont.h"
#include <memory.h>
#include "AcidImage.h"
#include "ImageData.h"
#include "resource.h"
#include "XbinLoader.h"


int			CImageContext::m_numResolutions= 4;
int			CImageContext::m_numFonts	   = 4;
int			CImageContext::m_numPalettes   = 3;
bool		CImageContext::m_staticLoaded  = false;


//One extra for user loaded versions
CAnsiFont	*CImageContext::m_fonts[5];
ANSIPalette *CImageContext::m_palettes[4];


int color_table_rev[16] = {
  0x000000,
  0xAB0000,
  0x00AB00,
  0xAB5700,
  0x0000AB,
  0xAB00AB,
  0x00ABAB, 
  0xABABAB,

  0x575757,
  0xff5757,
  0x57ff57,
  0xffff57,
  0x5757ff,
  0xff57ff,
  0x57ffff,
  0xffffff
}; 


int color_table_bw[16] = {
  0x000000,
  0x393939,
  0x393939,
  0x565656,
  0x393939,
  0x727272,
  0x727272, 
  0xABABAB,

  0x575757,
  0x8f8f8f,
  0x8f8f8f,
  0xc7c7c7,
  0x8f8f8f,
  0xc7c7c7,
  0xc7c7c7,
  0xffffff
}; 


CImageContext::CImageContext() : 
	m_speed(2400),
	m_animation(DEPENDENT),
	m_recordMovie(false),
	m_fps(20),
	m_enableRip(false),
	m_blink(false),
	m_resolution(rNormal),
	m_binWidth(160),
	m_iceColors(false),
	m_scaleWidth(0),
	m_savedDC(0),
	m_binaryScaleX(1),
	m_binaryScaleY(1),
	m_9thPixel(false)
{
	
	if (!m_staticLoaded) {

		int i;
		for (i=0; i<m_numPalettes; i++)
			m_palettes[i] = new ANSIPalette;

		/*! \todo do not need two copies of the font in memory, should load this stuff from a resource file */
		memcpy(m_palettes[DOS_PALETTE]->cols, color_table_rev, 4*16);
		memcpy(m_palettes[GRAYSCALE_PALETTE]->cols, color_table_bw, 4*16);
		for (i=0; i<16; i++)
			m_palettes[ASCII_PALETTE]->cols[i] = 0xABABAB;
			
		HRSRC hrsrc;
		hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_TEXT_FONT_DEFAULT), "TEXT_FONT");
		if (hrsrc) {
			HGLOBAL hglobal = LoadResource(NULL, hrsrc);
			if (hglobal) {				
				LPVOID buf = LockResource(hglobal);		
				m_fonts[DOS_FONT]     = new CAnsiFont(8, 16, 256, (unsigned char *)buf);
			}//if loaded resource
		}//if found resource
		

		hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_TEXT_FONT_ACIDVIEW), "TEXT_FONT");
		if (hrsrc) {
			HGLOBAL hglobal = LoadResource(NULL, hrsrc);
			if (hglobal) {				
				LPVOID buf = LockResource(hglobal);		
				m_fonts[ACIDVIEW_FONT]     = new CAnsiFont(8, 16, 256, (unsigned char *)buf);
			}//if loaded resource
		}//if found resource

		hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_TEXT_FONT_AMIGA_TOPAZ), "TEXT_FONT");
		if (hrsrc) {
			HGLOBAL hglobal = LoadResource(NULL, hrsrc);
			if (hglobal) {				
				LPVOID buf = LockResource(hglobal);		
				m_fonts[AMIGA_FONT]     = new CAnsiFont(8, 16, 256, (unsigned char *)buf);
			}//if loaded resource
		}//if found resource

		hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_TEXT_FONT_8X8), "TEXT_FONT");
		if (hrsrc) {
			HGLOBAL hglobal = LoadResource(NULL, hrsrc);
			if (hglobal) {				
				LPVOID buf = LockResource(hglobal);		
				m_fonts[DOS_8X8_FONT]     = new CAnsiFont(8, 8, 256, (unsigned char *)buf);
			}//if loaded resource
		}//if found resource

		m_fonts[LOADED_FONT]  = 0;
		m_palettes[LOADED_PALETTE] = 0;

		m_font                = m_fonts[DOS_FONT];
		m_staticLoaded = true;
	}

	m_palette	= m_palettes[DOS_PALETTE];
	m_font		= m_fonts[DOS_FONT];
}


CImageContext::~CImageContext() {
	
#ifdef _DEBUG
	OutputDebugString("CImageContext destructor\n");
#endif
}


void CImageContext::loadRegistryValues(CWinApp *pApp) {

	m_speed		  = pApp->GetProfileInt(_T("Settings"),_T("speed"), 2400);
	m_resolution  = (ViewResolution)pApp->GetProfileInt(_T("Settings"),_T("resolution"), rNormal);
	FontType font = (FontType)pApp->GetProfileInt(_T("Settings"),_T("font"), DOS_FONT);
	m_font = m_fonts[font];
	PaletteType pal = (PaletteType)pApp->GetProfileInt(_T("Settings"),_T("palette"), DOS_PALETTE);
	m_palette = m_palettes[pal];	
	m_9thPixel	  = pApp->GetProfileInt(_T("Settings"),_T("9thPixel"), 0)==1;
}


void CImageContext::setRegistryValues(CWinApp *pApp) {
	
	pApp->WriteProfileInt("Settings", "speed", m_speed);
	pApp->WriteProfileInt("Settings", "resolution", m_resolution);
	
	/*! \todo add binary scale*/
	pApp->WriteProfileInt("Settings", "9thPixel", m_9thPixel==1?1:0);


	FontType font = DOS_FONT;
	for (int i=0; i<m_numFonts; i++)
		if (m_font==m_fonts[i])
			font = (FontType)i;
	font = (font==LOADED_FONT)?DOS_FONT:font;
	pApp->WriteProfileInt("Settings", "font", font);

	PaletteType pal = DOS_PALETTE;
	for (i=0; i<m_numPalettes; i++)
		if (m_palette==m_palettes[i])
			pal = (PaletteType)i;
	pal = (pal==LOADED_PALETTE)?DOS_PALETTE:pal;
	pApp->WriteProfileInt("Settings", "palette", pal);
}


void CImageContext::setFont(FontType f) {
	m_font = m_fonts[f];
}


void CImageContext::setPalette(PaletteType p) {
	m_palette = m_palettes[p];
}


void CImageContext::setResolution(ViewResolution v) {
	m_resolution = v;
}


void CImageContext::staticShutdown() {

	int i;
	for (i=0; i<m_numPalettes; i++)
		delete m_palettes[i];

	for (i=0; i<m_numFonts; i++) 
		delete m_fonts[i];
}


bool CImageContext::isAnimation(CAcidImage *image) {

	if ((m_animation==ON && image->m_data->m_animateable) ||
		(m_animation==DEPENDENT && image->m_data->m_animation)) 
		return true;
	else
		return false;
}


void CImageContext::loadFont(const char *filename) {

	if (CXbinLoader::loadFont(filename, &m_fonts[LOADED_FONT])) {
		m_font     = m_fonts[LOADED_FONT];
		m_numFonts = 5;
	} 
}


void CImageContext::loadPalette(const char *filename) {

	if (CXbinLoader::loadPalette(filename, &m_palettes[LOADED_PALETTE])) {
		m_palette     = m_palettes[LOADED_PALETTE];
		m_numPalettes = 4;
	} 
}

bool CImageContext::isAscii() {
	bool b = (m_palette==m_palettes[ASCII_PALETTE]); 
	return b;
}