#ifndef AFX_DIRTREECTRL_H__1E4F97A0_B41E_11D2_955E_204C4F4F5020__INCLUDED_
#define AFX_DIRTREECTRL_H__1E4F97A0_B41E_11D2_955E_204C4F4F5020__INCLUDED_

// DirTreeCtrl.h : Header-Datei
//

/////////////////////////////////////////////////////////////////////////////
// Fenster CDirTreeCtrl 

class CDirTreeCtrl;
struct DirTreeCtrlThreadData {
	CDirTreeCtrl	*tree;
	CString			strPath;
};


class CDirTreeCtrl : public CTreeCtrl
{
private:
	static	UINT DisplayTreeImp(LPVOID);
	static	DirTreeCtrlThreadData	m_threadData;
	bool	m_loaded;

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CDirTreeCtrl)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

public:
	CString		m_fileMask;

	
	void	SetFileMask(CString);
	BOOL	SetSelPath( LPCTSTR strPath );
	CString GetFullPath( HTREEITEM hItem );
	LPCTSTR GetSubPath( LPCTSTR strPath );
	BOOL	DisplayTree( LPCTSTR strRoot, BOOL bFiles = FALSE );
	BOOL	JumpToDir(LPCTSTR strRoot, BOOL setSel=TRUE);
	void	OpenNext();
	void	OpenPrevious();

	CString	GetSelected();

	CDirTreeCtrl();
	virtual ~CDirTreeCtrl();



	CString		m_strRoot, m_strError;
	CImageList	m_imgList;
	
	BOOL		IsValidPath( LPCTSTR strPath );
	void		ExpandItem( HTREEITEM hItem, UINT nCode );
	HTREEITEM	SearchSiblingItem( HTREEITEM hItem, LPCTSTR strText );
	BOOL		FindSubDir( LPCTSTR strPath );
	HTREEITEM	AddItem( HTREEITEM hParent, LPCTSTR strPath, BOOL exists=TRUE, BOOL useFolderIcon=FALSE);
	void		DisplayPath( HTREEITEM hParent, LPCTSTR strPath );
	BOOL		DisplayDrives();
	BOOL		GetSysImgList();
	//{{AFX_MSG(CDirTreeCtrl)
	afx_msg void OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelChanged(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio fgt zustzliche Deklarationen unmittelbar vor der vorhergehenden Zeile ein.

#endif // AFX_DIRTREECTRL_H__1E4F97A0_B41E_11D2_955E_204C4F4F5020__INCLUDED_
