#pragma once


#include "CompressedFileFactory.h"
#include "CompressedFile.h"
#include "StdAfx.h"
#include <vector>


/*! Wrapper of CFileFind to handle searching through compressed files. Would have extended from
	CFileFind, but there's not enough information on how to do that. 

	Does not return filenames of hidden files or not matching the mask and does not return
	dirs that are dots. */
class CCompressedFileFind {


private:

	CFileFind			*m_fileFind;	
	CCompressedFile		*m_compressedFile;
	CString				m_dir, m_compressedFilename;
	std::vector<char *> m_extensions;
	bool				m_starDotStar, m_lastFile;
	bool				m_loadedFirstCompressedFile;

	bool				matchesExtension(const char *);

public:

	CCompressedFileFind(const char *dir);
	~CCompressedFileFind();

	bool	findFile(const char *mask);
	bool	findNextFile();
	bool	isDirectory();
	bool	isCompressed();
	CString	getFilePath();
};