#include "CompressedFileFind.h"


using namespace std;


CCompressedFileFind::CCompressedFileFind(const char *dir) :
	m_fileFind(0),
	m_compressedFile(0),
	m_dir(dir),
	m_starDotStar(true),
	m_lastFile(false),
	m_loadedFirstCompressedFile(false)
{
}


CCompressedFileFind::~CCompressedFileFind() {

	delete m_fileFind;	
	//Do not need to delete m_compressedFile, that is handled by the factory

	for(vector<char *>::iterator i=m_extensions.begin(); i!=m_extensions.end(); i++) {
		delete [] (*i);
	}
}



bool CCompressedFileFind::findFile(const char *mask) {

	if (!mask || strcmp(mask, "*.*")==0) {

		m_starDotStar = true;

	} else {

		m_starDotStar = false;	
		CString temp = mask;
		temp.ReleaseBuffer();
		char *token = strtok((char *)(const char *)temp, ";");
		while(token!=NULL) {
			int l = strlen(token);
			if (l) {
				
				int i=l;
				do {
					i--;
				} while(i>=0 && token[i]!='.');

				if (i>=0) {
					char *ext = new char[(l-i)+1];
					strcpy(ext, token+i+1);
					m_extensions.push_back(ext);
				}
			}
			token = strtok(NULL, ";");
		}
	}

	if (CCompressedFileFactory::containsCompressedFile(m_dir)) {
		m_compressedFile = CCompressedFileFactory::getFactory()->loadFile(m_dir);
		if (m_compressedFile) {
			m_compressedFilename = m_compressedFile->getCompressedFilename();
			m_compressedFilename += "\\";
		}
		return (m_compressedFile!=0);
	} else {
		m_fileFind = new CFileFind();
		return (m_fileFind->FindFile(m_dir+"*.*")==TRUE);
	}
}


bool CCompressedFileFind::findNextFile() {

	if (m_compressedFile) {

		/*! Compressed files start with the first file already loaded */
		bool b = !m_loadedFirstCompressedFile?true:m_compressedFile->getNextFile();
		m_loadedFirstCompressedFile = true;
		while(b) {
			
#ifdef _DEBUG
			CString s = m_compressedFile->getFilename();
#endif

			if (!m_compressedFile->isHidden()) {			
				if (m_compressedFile->isDirectory()) {
					return true;
				} else if (	m_starDotStar || 
							matchesExtension(m_compressedFile->getFilename()) ) {
					return true;
				}
			}

			b = m_compressedFile->getNextFile();
		}

		return false;
	} else {
		
				
		while(!m_lastFile) {
		
			m_lastFile = (m_fileFind->FindNextFile()==0);
			
			if (!m_fileFind->IsHidden()) {
				if (m_fileFind->IsDirectory()) {
					if (!m_fileFind->IsDots())
						return true;
				} else if (	m_starDotStar || 
							CCompressedFileFactory::isCompressedFile(m_fileFind->GetFilePath()) ||
							matchesExtension(m_fileFind->GetFilePath())) {
					return true;
				}
			}			
		}
		
		
		return false;
	}
}


bool CCompressedFileFind::isDirectory() {

	if (m_compressedFile) {
	
		return m_compressedFile->isDirectory();

	} else {

		if (CCompressedFileFactory::isCompressedFile(m_fileFind->GetFilePath()) ||
			m_fileFind->IsDirectory())
			return true;
	}

	return false;
}

bool CCompressedFileFind::matchesExtension(const char *filename) {

	int j = strlen(filename);
	do {
		j--;
	} while(j>=0 && filename[j]!='.');
		

	if (j>=0) {
		const char *ext = filename+j+1;
		for(vector<char *>::iterator i=m_extensions.begin(); i!=m_extensions.end(); i++) {
			if (stricmp(*i, ext)==0) {
				return true;
			}
		}
	}

	return false;
}


CString CCompressedFileFind::getFilePath() {

	if (m_compressedFile) {

		CString filename = m_compressedFile->getFilename();
		if (filename.Left(1)=="\\")
			filename = filename.Right(filename.GetLength()-1);
		if (filename.Right(1)=="\\")
			filename = filename.Left(filename.GetLength()-1);

		CString s = m_compressedFilename + filename;
		return s;
	} else {

		return m_fileFind->GetFilePath();
	}
}


bool CCompressedFileFind::isCompressed() {

	return (m_compressedFile!=0);
}

