#include "AdfLoader.h"


CAdfLoader::CAdfLoader(CImageRenderer *renderer) :
	CTextLoader(renderer)
{

}


CAdfLoader::~CAdfLoader() {


}


bool CAdfLoader::isFileType(const char *, const char *filename) {

	if (filename && stricmp(filename,"adf")==0) {
		return true;
	}
	return false;	
}

/* 
Black            0         0         ESC[0;30m
Blue             1         1         ESC[0;34m
Green            2         2         ESC[0;32m
Cyan             3         3         ESC[0;36m
Red              4         4         ESC[0;31m
Purple           5         5         ESC[0;35m
Brown            6        20         ESC[0;33m
White            7         7         ESC[0;37m
Dk. Grey         8        56         ESC[1;30m
Br. Blue         9        57         ESC[1;34m
Br. Green       10        58         ESC[1;32m
Br. Cyan        11        59         ESC[1;36m
Br. Red         12        60         ESC[1;31m
Br. Purple      13        61         ESC[1;35m
Yellow          14        62         ESC[1;33m
Br. White       15        63         ESC[1;37m

  nonsense... utter nonsense
*/
int colorConversion[] = {	 0, 1, 2, 3, 4, 5,-1, 7,	// 0 -  7
							-1,-1,-1,-1,-1,-1,-1,-1,	// 8 - 15
							-1,-1,-1,-1, 6,-1,-1,-1,	//16 - 23
							-1,-1,-1,-1,-1,-1,-1,-1,	//24 - 31
							-1,-1,-1,-1,-1,-1,-1,-1,	//32 - 39
							-1,-1,-1,-1,-1,-1,-1,-1,	//40 - 47
							-1,-1,-1,-1,-1,-1,-1,-1,	//48 - 55
							8, 9,10,11,12,13,14,15};	//56 - 63


void CAdfLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	
	CTextData *textData = (CTextData *)imageData;
	textData->m_fileType = ADF;
	textData->m_iceColors = true;	

	int offset = 0;
	
	//load palette
	char version = data[offset++];
	unsigned char pal[3*64];
	memcpy(pal, data+offset, 192);	offset+=192;
	textData->m_userPalette = new ANSIPalette;
	memset(textData->m_userPalette->cols, 0, 16*4);
	for (int i=0; i<64; i++) {
		
		int realCol = colorConversion[i];
		if (realCol!=-1) {
			int r,g,b;
			r = ((int)pal[i*3+0])<<2;
			g = ((int)pal[i*3+1])<<2;
			b = ((int)pal[i*3+2])<<2;
			textData->m_userPalette->cols[realCol] = (r<<16) | (g<<8) | (b<<0);   
		}
	}
	
	//load font
	textData->m_userFont = new CAnsiFont(8, 16, 256, (const unsigned char *)(data+193));
	
	//load image data
	//initialize to 80 col wide
	int width = 80;
	textData->m_list->init(width*2);
	offset = 4289;
	while (offset<length) {
		if (data[offset]==CTRLZ) 
			break;		
		char *line = textData->m_list->forwardCat();
		memcpy(line, data+offset, width*2);
		offset += width*2;
	}		
}



