;**********************************************************;
;* ZE v1.1 - Binary to Text Encoder, Better than UUENCODE *;
;* Size Increase only 27%, Fast, and Small - 188 Bytes!   *;
;*                                                        *;
;*                    By Tenie Remmel                     *;
;**********************************************************;

Ideal

Model Tiny
P186
CodeSeg
Org 100h

Proc        Program

            mov ah,3Fh         ;Read file/device
            xor bx,bx          ;handle for STDIN
            mov dx,15872       ;Start at DS:15.5K
            mov cx,49152       ;48K bytes (max)
            int 21h            ;DOS services
            mov cx,ax          ;Number of bytes in CX

            mov si,15872       ;SI = 15.5K
            mov di,1024        ;DI = 1K
            mov bx,2           ;BX = 2 (words)

            mov ah,'A'         ;AH = 'A'
            mov al,ch          ;First digit
            shr al,4           ;Shift over
            add al,ah          ;Adjust to text
            stosb              ;Store byte
            mov al,ch          ;Second digit
            and al,0Fh         ;AND mask
            add al,ah          ;Adjust to text
            stosb              ;Store byte
            mov al,cl          ;Third digit
            shr al,4           ;Shift over
            add al,ah          ;Adjust to text
            stosb              ;Store byte
            mov al,cl          ;Last digit
            and al,0Fh         ;AND mask
            add al,ah          ;Adjust to text
            stosb              ;Store byte

            add cx,si          ;CX = limit for SI

InpLoop:    call In13          ;Input 13 bits
            mov dl,91          ;Divide AX by 91
            div dl             ;now AL, AH <= 90
            add ax,2121h       ;Adjust to text
            cmp al,40h         ;Eliminate @ char

            jl AL_ok           ;which is char 40h
            inc ax
AL_ok:      cmp ah,40h
            jl AH_ok
            inc ah
AH_ok:      stosw              ;Store word
            inc bx             ;Inc line counter
            cmp bx,32          ;64 chars on this line?
            jl Next            ;Jump if not
            xor bx,bx          ;Clear line counter

            mov ax,0A0Dh       ;Put a CRLF in AX
            stosw              ;Store it
Next:       cmp si,cx          ;SI > CX?
            jbe InpLoop        ;Jump if not

            mov al,'}'         ;Store bracket (ending char)
            stosb

            mov ah,40h         ;Write file/device
            mov bx,1           ;handle for STDOUT
            mov cx,di          ;Number of bytes
            mov dx,1024        ;Start at DS:1K
            sub cx,dx          ;Adjust CX
            int 21h            ;DOS services
            ret                ;Exit

EndP        Program

BitBuf      dw 0               ;The bit buffer
BitCnt      db 0               ;The bit counter

Proc        In13

            push bx cx         ;Save registers
            mov dx,[BitBuf]    ;Load buffer in DX
            mov cl,[BitCnt]    ;Load count in CL
            mov bl,cl          ;Count in BL also
            and cl,7           ;CL = shift count
            lodsb              ;Load byte
            mov ah,al          ;Put it in AH
            xor al,al          ;Clear AL
            shr ax,cl          ;Adjust AX
            or dx,ax           ;Put byte in buffer
            mov ch,dh          ;Shift byte out into CH
            mov dh,dl
            xor dl,dl          ;Clear DL
            cmp bl,5           ;5 bits in buffer?
            jae GetLow         ;Jump if yes
            lodsb              ;Load byte
            mov ah,al          ;Put it in AH
            xor al,al          ;Clear AL
            shr ax,cl          ;Adjust AX
            or dx,ax           ;Put byte in buffer
            add bl,8           ;Adjust bit count
GetLow:     mov al,dh          ;Shift 5 bits out
            shl dx,5
            sub bl,5           ;Adjust bit count
            mov ah,ch          ;Get high byte
            shr ax,3           ;Adjust AX
            mov [BitBuf],dx    ;Save buffer
            mov [BitCnt],bl    ;Save bit count
            pop cx bx          ;Restore registers
            ret                ;Return

EndP        In13

End Program
