#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <process.h>

void writeKeyFile(char *str);
int readKeyFile(char *str);


char *keysite = "POWERPPL HOME";
char keytype;
int keymakerversion = 100;

void main(int argc, char *argv[])
{
char chaine[255]="";
FILE *out;

if (argc < 3)
	{
	printf("PowerPPL KeyFile Generator v1.0\n"
		   "\n"
		   "KEY-SITE : %s\n"
		   "\n"
		   "Usage :\n"
		   "PPKEY FIRSTNAME LASTNAME\n"
		   "\n"
		   "Generated KeyFile will be found as PP.KEY\n\n", keysite);
	sound(1000);
	delay(500);
	nosound();
	exit(255);
	}

char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
int flags;
char log[MAXFILE];

fnsplit(argv[0],drive,dir,file,ext);
fnmerge(log, drive, dir, "PPKEY", ".LOG");

char regtype[5][30]={
	{"NORMAL REGISTRATION"},
	{"BETA TESTER REGISTRATION"},
	{"PRO REGISTRATION"},
	{"SPC1"},
	{"SPC2"}};


struct date d;
getdate(&d);
struct time t;
gettime(&t);

if (argc == 3)
	keytype = 1;
else
	keytype = (char)atoi(argv[3]);


sprintf(chaine,"%35s %35s %02d %02d %04d %2d %02d %02d"
			   " %25s"
			   " %c"
			   " %03d"
			   ,strupr(argv[1])
			   ,strupr(argv[2])
			   ,d.da_mon
			   ,d.da_day
			   ,d.da_year
			   ,t.ti_hour
			   ,t.ti_min
			   ,t.ti_sec
			   ,keysite
			   ,keytype
			   ,keymakerversion);

writeKeyFile(chaine);

printf("PowerPPL KeyFile Generator v1.0\n\n"
	   "Key File             : PP.KEY\n"
	   "Key Owner            : %s %s\n"
	   "Generation Date/Time : %02d/%02d/%04d - %2d:%02d:%02d\n"
	   "Key Site             : %s\n"
	   "Key Type             : %s\n"
	   ,strupr(argv[1])
	   ,strupr(argv[2])
	   ,d.da_mon
	   ,d.da_day
	   ,d.da_year
	   ,t.ti_hour
	   ,t.ti_min
	   ,t.ti_sec
	   ,keysite
	   ,regtype[keytype-1]);

if ((out = fopen(log, "at")) == NULL)
   	fprintf(stderr, "WARNING : Cannot update log file\n");
else
	{
    fprintf(out, "--------------------------------------------------\n");
	fprintf(out, "Generation Date/Time : %02d/%02d/%04d - %2d:%02d:%02d\n", d.da_mon,d.da_day,d.da_year,t.ti_hour,t.ti_min,t.ti_sec);
	fprintf(out, "Key Owner            : %s %s\n" , strupr(argv[1]),strupr(argv[2]));
	fprintf(out, "Key Site             : %s\n",keysite);
	fprintf(out, "Key Type             : %s\n",regtype[keytype-1]);
    fclose(out);
	}

}


void writeKeyFile(char *str)
{
int a;
int b;
unsigned int seed;
FILE *out;
unsigned char c;
unsigned int sum=0;

randomize();
restartall:

if ((out = fopen("PP.KEY", "wb"))
	== NULL)
{
   fprintf(stderr, "Cannot open output file.\n");
   return;
}
fwrite("PowerPPL KeyFile ", 17, 1, out);

retir:
seed = rand();

if (((seed & 0xFF) < 32) || ((seed & 0xFF) > 127) || (((seed & 0xFF00) >> 8) < 32) || (((seed & 0xFF00) >> 8) > 127))
	goto retir;

fwrite(&seed, sizeof(seed), 1, out);

srand(seed);
sum = strlen(str);
fwrite(&sum, sizeof(sum), 1, out);
sum=0;
for (a=0;a<strlen(str);a++)
	{
	c = (unsigned char)random(95)+33;
	if (c > 80)
		{
		while(1)
			{
			c = random(95)+33;
			fputc(c,out);
			if (random(30) == 6) break;
			}
		c = (unsigned char)random(95)+33;
		}
	if (c > 50 && c < 100)
		c += random(95)+33;
	lp1:
	if (c <= 32)
		c += random(95)+33;
	if (c >= 127)
		c -= random(95)+33;
	if (c <= 32)
		goto lp1;
	sum += str[a];
	c = str[a] ^ c;
	b = 0;
	while (c < 33 || c > 127)
		{
		b++;
		c += random(95)+33;
		if (b > 127-33)
			{
			fclose(out);
			goto restartall;
			}
		}
	fputc(c,out);
	c = b + 33;
	fputc(c,out);
	}

b=0;
c = (sum & 0xFF00) >> 8;
while (c < 33 || c > 127)
	{
	b++;
	c += random(95)+33;
	if (b > 127-33)
		{
		fclose(out);
		goto restartall;
		}
	}
fputc(c,out);
c = b + 33;
fputc(c,out);

b=0;
c = (sum & 0xFF);
while (c < 33 || c > 127)
	{
	b++;
	c += random(95)+33;
	if (b > 127-33)
		{
		fclose(out);
		goto restartall;
		}
	}
fputc(c,out);
c = b + 33;
fputc(c,out);

fclose(out);

}


