/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1994-1998 Francis Gastellu
                      aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <ctype.h>
#include <string.h>

#define NORMALTEXT 1
#define COMMENTS   2
#define SYMBOLS    3
#define NUMBERS    4
#define STRINGS    5
#define LABELS     6
#define RESERVED   7
#define PREDEFINED 8


int findcolor(char *str)
{
char str2[255];

strcpy(str2,strupr(str));

if (str2[0] > 'N') goto _n;

switch (str2[0])
	{
	case 'A': goto a;
	case 'B': goto b;
	case 'C': goto c;
	case 'D': goto d;
	case 'E': goto e;
	case 'F': goto f;
	case 'G': goto g;
	case 'H': goto h;
	case 'I': goto i;
	case 'J': goto j;
	case 'K': goto k;
	case 'L': goto l;
	case 'M': goto m;
	}
_n:
switch (str2[0])
	{
	case 'N': goto n;
	case 'O': goto o;
	case 'P': goto p;
	case 'Q': goto q;
	case 'R': goto r;
	case 'S': goto s;
	case 'T': goto t;
	case 'U': goto u;
	case 'V': goto v;
	case 'W': goto w;
	case 'X': goto x;
	case 'Y': goto y;
	default : goto unknown;
	}
a:
if (!strcmp(str2,"AUTO")) return PREDEFINED;
if (!strcmp(str2,"ACC_STAT")) return PREDEFINED;
if (!strcmp(str2,"ACC_TIME")) return PREDEFINED;
if (!strcmp(str2,"ACC_MSGR")) return PREDEFINED;
if (!strcmp(str2,"ACC_MSGW")) return PREDEFINED;
if (!strcmp(str2,"ATTACH_LIM_U")) return PREDEFINED;
if (!strcmp(str2,"ATTACH_LIM_P")) return PREDEFINED;
goto unknown;
b:
if (!strcmp(str2,"BOOLEAN")) return RESERVED;
if (!strcmp(str2,"BYTE")) return RESERVED;
if (!strcmp(str2,"BIGSTR")) return RESERVED;
if (!strcmp(str2,"BREAK")) return RESERVED;
if (!strcmp(str2,"BELL")) return PREDEFINED;
if (!strcmp(str2,"BEGIN")) return RESERVED;
goto unknown;
c:
if (!strcmp(str2,"CONTINUE")) return RESERVED;
if (!strcmp(str2,"CUR_USER")) return PREDEFINED;
if (!strcmp(str2,"CASE")) return RESERVED;
if (!strcmp(str2,"CRC_FILE")) return PREDEFINED;
if (!strcmp(str2,"CRC_STR")) return PREDEFINED;
if (!strcmp(str2,"CHRG_CALL")) return PREDEFINED;
if (!strcmp(str2,"CHRG_TIME")) return PREDEFINED;
if (!strcmp(str2,"CHRG_PEAKTIME")) return PREDEFINED;
if (!strcmp(str2,"CHRG_CHAT")) return PREDEFINED;
if (!strcmp(str2,"CHRG_MSGREAD")) return PREDEFINED;
if (!strcmp(str2,"CHRG_MSGCAP")) return PREDEFINED;
if (!strcmp(str2,"CHRG_MSGWRITE")) return PREDEFINED;
if (!strcmp(str2,"CHRG_MSGECHOED")) return PREDEFINED;
if (!strcmp(str2,"CHRG_MSGPRIVATE")) return PREDEFINED;
if (!strcmp(str2,"CHRG_DOWNFILE")) return PREDEFINED;
if (!strcmp(str2,"CHRG_DOWNBYTES")) return PREDEFINED;
if (!strcmp(str2,"CRED_UPFILE")) return PREDEFINED;
if (!strcmp(str2,"CRED_UPBYTES")) return PREDEFINED;
if (!strcmp(str2,"CRED_SPECIAL")) return PREDEFINED;
if (!strcmp(str2,"CMAXMSGS")) return PREDEFINED;
goto unknown;
d:
if (!strcmp(str2,"DOUBLE")) return RESERVED;
if (!strcmp(str2,"DREAL")) return RESERVED;
if (!strcmp(str2,"DWORD")) return RESERVED;
if (!strcmp(str2,"DATE")) return RESERVED;
if (!strcmp(str2,"DEFS")) return PREDEFINED;
if (!strcmp(str2,"DO")) return RESERVED;
if (!strcmp(str2,"DECLARE")) return RESERVED;
if (!strcmp(str2,"DEFAULT")) return RESERVED;
if (!strcmp(str2,"DDATE")) return RESERVED;
if (!strcmp(str2,"DEB_CALL")) return PREDEFINED;
if (!strcmp(str2,"DEB_TIME")) return PREDEFINED;
if (!strcmp(str2,"DEB_MSGREAD")) return PREDEFINED;
if (!strcmp(str2,"DEB_MSGCAP")) return PREDEFINED;
if (!strcmp(str2,"DEB_MSGWRITE")) return PREDEFINED;
if (!strcmp(str2,"DEB_MSGECHOED")) return PREDEFINED;
if (!strcmp(str2,"DEB_MSGPRIVATE")) return PREDEFINED;
if (!strcmp(str2,"DEB_DOWNFILE")) return PREDEFINED;
if (!strcmp(str2,"DEB_DOWNBYTES")) return PREDEFINED;
if (!strcmp(str2,"DEB_CHAT")) return PREDEFINED;
if (!strcmp(str2,"DEB_TPU")) return PREDEFINED;
if (!strcmp(str2,"DEB_SPECIAL")) return PREDEFINED;
goto unknown;
e:
if (!strcmp(str2,"ELSE")) return RESERVED;
if (!strcmp(str2,"EDATE")) return RESERVED;
if (!strcmp(str2,"END")) return RESERVED;
if (!strcmp(str2,"ECHODOTS")) return PREDEFINED;
if (!strcmp(str2,"ERASELINE")) return PREDEFINED;
if (!strcmp(str2,"ELSEIF")) return RESERVED;
if (!strcmp(str2,"ENDIF")) return RESERVED;
if (!strcmp(str2,"ENDWHILE")) return RESERVED;
if (!strcmp(str2,"ENDPROC")) return RESERVED;
if (!strcmp(str2,"ENDFUNC")) return RESERVED;
goto unknown;
f:
if (!strcmp(str2,"FOR")) return RESERVED;
if (!strcmp(str2,"FLOAT")) return RESERVED;
if (!strcmp(str2,"FALSE")) return PREDEFINED;
if (!strcmp(str2,"FCL")) return PREDEFINED;
if (!strcmp(str2,"FIELDLEN")) return PREDEFINED;
if (!strcmp(str2,"FNS")) return PREDEFINED;
if (!strcmp(str2,"F_EXP")) return PREDEFINED;
if (!strcmp(str2,"F_MW")) return PREDEFINED;
if (!strcmp(str2,"F_REG")) return PREDEFINED;
if (!strcmp(str2,"F_SEL")) return PREDEFINED;
if (!strcmp(str2,"F_SYS")) return PREDEFINED;
if (!strcmp(str2,"FUNCTION")) return RESERVED;
if (!strcmp(str2,"FUNC")) return RESERVED;
goto unknown;
g:
if (!strcmp(str2,"GOSUB")) return RESERVED;
if (!strcmp(str2,"GOTO")) return RESERVED;
if (!strcmp(str2,"GRAPH")) return PREDEFINED;
if (!strcmp(str2,"GUIDE")) return PREDEFINED;
goto unknown;
h:
if (!strcmp(str2,"HIGHASCII")) return PREDEFINED;
if (!strcmp(str2,"HDR_ACTIVE")) return PREDEFINED;
if (!strcmp(str2,"HDR_BLOCKS")) return PREDEFINED;
if (!strcmp(str2,"HDR_DATE")) return PREDEFINED;
if (!strcmp(str2,"HDR_ECHO")) return PREDEFINED;
if (!strcmp(str2,"HDR_FROM")) return PREDEFINED;
if (!strcmp(str2,"HDR_MSGNUM")) return PREDEFINED;
if (!strcmp(str2,"HDR_MSGREF")) return PREDEFINED;
if (!strcmp(str2,"HDR_PWD")) return PREDEFINED;
if (!strcmp(str2,"HDR_REPLY")) return PREDEFINED;
if (!strcmp(str2,"HDR_RPLYDATE")) return PREDEFINED;
if (!strcmp(str2,"HDR_RPLYTIME")) return PREDEFINED;
if (!strcmp(str2,"HDR_STATUS")) return PREDEFINED;
if (!strcmp(str2,"HDR_SUBJ")) return PREDEFINED;
if (!strcmp(str2,"HDR_TIME")) return PREDEFINED;
if (!strcmp(str2,"HDR_TO")) return PREDEFINED;
goto unknown;
i:
if (!strcmp(str2,"INT")) return RESERVED;
if (!strcmp(str2,"INTEGER")) return RESERVED;
if (!strcmp(str2,"IF")) return RESERVED;
if (!strcmp(str2,"INCLUDE")) return RESERVED;
goto unknown;
j:
goto unknown;
k:
goto unknown;
l:
if (!strcmp(str2,"LOOP")) return RESERVED;
if (!strcmp(str2,"LET")) return RESERVED;
if (!strcmp(str2,"LONG")) return RESERVED;
if (!strcmp(str2,"LANG")) return PREDEFINED;
if (!strcmp(str2,"LFAFTER")) return PREDEFINED;
if (!strcmp(str2,"LFBEFORE")) return PREDEFINED;
if (!strcmp(str2,"LOGIT")) return PREDEFINED;
if (!strcmp(str2,"LOGITLEFT")) return PREDEFINED;
goto unknown;
m:
if (!strcmpi(str2,"MONEY")) return RESERVED;
if (!strcmpi(str2,"MAXMSGS")) return PREDEFINED;
goto unknown;
n:
if (!strcmp(str2,"NC")) return PREDEFINED;
if (!strcmp(str2,"NEWLINE")) return PREDEFINED;
if (!strcmp(str2,"NOCLEAR")) return PREDEFINED;
if (!strcmp(str2,"NO_USER")) return PREDEFINED;
if (!strcmp(str2,"NEXT")) return RESERVED;
if (!strcmp(str2,"NEWBALANCE")) return PREDEFINED;
goto unknown;
o:
if (!strcmp(str2,"O_RD")) return PREDEFINED;
if (!strcmp(str2,"O_RW")) return PREDEFINED;
if (!strcmp(str2,"O_WR")) return PREDEFINED;
goto unknown;
p:
if (!strcmp(str2,"PROCEDURE")) return RESERVED;
if (!strcmp(str2,"PROC")) return RESERVED;
if (!strcmp(str2,"PAY_UPFILE")) return PREDEFINED;
if (!strcmp(str2,"PAY_UPBYTES")) return PREDEFINED;
goto unknown;
q:
if (!strcmp(str2,"QUIT")) return RESERVED;
goto unknown;
r:
if (!strcmp(str2,"RETURN")) return RESERVED;
if (!strcmp(str2,"REAL")) return RESERVED;
if (!strcmp(str2,"REDIM")) return RESERVED;
goto unknown;
s:
if (!strcmp(str2,"STOP")) return RESERVED;
if (!strcmp(str2,"STEP")) return RESERVED;
if (!strcmp(str2,"SBYTE")) return RESERVED;
if (!strcmp(str2,"SWORD")) return RESERVED;
if (!strcmp(str2,"SDWORD")) return RESERVED;
if (!strcmp(str2,"SHORT")) return RESERVED;
if (!strcmp(str2,"STRING")) return RESERVED;
if (!strcmp(str2,"SEC")) return PREDEFINED;
if (!strcmp(str2,"STACKED")) return PREDEFINED;
if (!strcmp(str2,"S_DB")) return PREDEFINED;
if (!strcmp(str2,"S_DN")) return PREDEFINED;
if (!strcmp(str2,"S_DR")) return PREDEFINED;
if (!strcmp(str2,"S_DW")) return PREDEFINED;
if (!strcmp(str2,"SELECT")) return RESERVED;
if (!strcmp(str2,"SEC_DROP")) return PREDEFINED;
if (!strcmp(str2,"STK_LIMIT")) return PREDEFINED;
if (!strcmp(str2,"START_BAL")) return PREDEFINED;
if (!strcmp(str2,"START_SESSION")) return PREDEFINED;
if (!strcmp(str2,"SEEK_SET")) return PREDEFINED;
if (!strcmp(str2,"SEEK_CUR")) return PREDEFINED;
if (!strcmp(str2,"SEEK_END")) return PREDEFINED;

goto unknown;
t:
if (!strcmp(str2,"THEN")) return RESERVED;
if (!strcmp(str2,"TIME")) return RESERVED;
if (!strcmp(str2,"TO")) return RESERVED;
if (!strcmp(str2,"TRUE")) return PREDEFINED;
goto unknown;
u:
if (!strcmp(str2,"UNSIGNED")) return RESERVED;
if (!strcmp(str2,"UBYTE")) return RESERVED;
if (!strcmp(str2,"UWORD")) return RESERVED;
if (!strcmp(str2,"UDWORD")) return RESERVED;
if (!strcmp(str2,"UPCASE")) return PREDEFINED;
if (!strcmp(str2,"U_CLS")) return PREDEFINED;
if (!strcmp(str2,"U_DEF79")) return PREDEFINED;
if (!strcmp(str2,"U_EXPERT")) return PREDEFINED;
if (!strcmp(str2,"U_FSE")) return PREDEFINED;
if (!strcmp(str2,"U_FSEP")) return PREDEFINED;
if (!strcmp(str2,"U_LONGHDR")) return PREDEFINED;
if (!strcmp(str2,"U_SCROLL")) return PREDEFINED;
if (!strcmp(str2,"U_EXPDATE")) return PREDEFINED;
if (!strcmp(str2,"U_PWDEXP")) return PREDEFINED;
if (!strcmp(str2,"U_EXPSEC")) return PREDEFINED;
if (!strcmp(str2,"U_PAGELEN")) return PREDEFINED;
if (!strcmp(str2,"U_SEC")) return PREDEFINED;
if (!strcmp(str2,"U_ADDR")) return PREDEFINED;
if (!strcmp(str2,"U_ALIAS")) return PREDEFINED;
if (!strcmp(str2,"U_BDPHONE")) return PREDEFINED;
if (!strcmp(str2,"U_CITY")) return PREDEFINED;
if (!strcmp(str2,"U_CMNT1")) return PREDEFINED;
if (!strcmp(str2,"U_CMNT2")) return PREDEFINED;
if (!strcmp(str2,"U_HVPHONE")) return PREDEFINED;
if (!strcmp(str2,"U_NOTES")) return PREDEFINED;
if (!strcmp(str2,"U_PWD")) return PREDEFINED;
if (!strcmp(str2,"U_TRANS")) return PREDEFINED;
if (!strcmp(str2,"U_VER")) return PREDEFINED;
if (!strcmp(str2,"USEFUNCS")) return RESERVED;
goto unknown;
v:
if (!strcmp(str2,"VAR")) return RESERVED;
goto unknown;
w:
if (!strcmp(str2,"WORD")) return RESERVED;
if (!strcmp(str2,"WORDWRAP")) return PREDEFINED;
if (!strcmp(str2,"WHILE")) return RESERVED;
if (!strcmp(str2,"WARN_LEVEL")) return PREDEFINED;
goto unknown;
x:
goto unknown;
y:
if (!strcmp(str2,"YESNO")) return PREDEFINED;
unknown:
return NORMALTEXT;
}

