/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
                           + Project Frontier +

 PPE Executor

 MAIN 

*/

#include <io.h>
#include <dir.h>
#include <process.h>
#include <conio.h>
#include <stdlib.h>
#include "fortify.h"
#include "..\lang\ppl_type.h"
#include "..\lang\ppl.h"
#include "..\com\startup.h"
#include "..\com\system.h"

extern unsigned _stklen = 32767U;

extern long totalAllocated;

int directvideo = 1;
int swapType = 1;

main (int argc, char **argv)
{
char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
char fullFilename[MAXPATH];
int a;

if (argc < 2)
	{
    printf("Frontier Runtime v1.0 - (c) 1996,97 The Aegis Corporation\nPPE Virtual Machine v1.08\n\n");
	printf("PPD <filename[.PPE]>\n");
	exit(-1);
    }
#ifdef FORTIFY
Fortify_EnterScope();
#endif
frontierStartup(argc, argv);
getUser(1, &user);
userLoggedNum = 1;

fnsplit(argv[1], drive, dir, file, ext);
if (ext[0] == 0)
	strcpy(ext, ".PPE");
fnmerge(fullFilename, drive, dir, file, ext);

cls();
gotoxy(1,1);
join(0);
color(7);

*tmpStr=0;
for (a=2;a<argc;a++)
    {
	if (*tmpStr != 0)
		strcat(tmpStr, " ");
    strcat(tmpStr, argv[a]);
    }
tokenize(tmpStr, tokenStr);
totalAllocated=0;
fppe_runPPE(fullFilename);

frontierCloseup ();
#ifdef FORTIFY
Fortify_LeaveScope();
#endif
}
