/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/**************************************************************************/
/******** VFS 1.0                                                  ********/
/********                                    Functions Prototypes  ********/
/********     Virtual File System                                  ********/
/**************************************************************************/

#define _FILE_INC 32767
#define _FILE_READBIN 0
#define _FILE_READTXT 1
#define _FILE_WRITEBIN 2
#define _FILE_WRITETXT 3

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif


typedef struct {
	huge unsigned char *data;
    unsigned long ptr;
    unsigned long size;
    unsigned long limit;
//    unsigned long truesize;
    char filename[255];
    char mode;
    } _file;


_file *_fopenread(char *fl, int mode);
void _fread(void *ptr, size_t size, size_t n, _file *buf);
void _fseek(_file *fl, unsigned long i, int whence);
unsigned long _ftell(_file *fl);
void _fclose(_file *fl);
void _fwrite(void *ptr, size_t size, size_t n, _file *buf);
_file *_fopenwrite(char *fl, int mode);
void _fputs(char *str, _file *fl);
void _fputc(char c, _file *fl);
int _feof(_file *fl);
char *_fgets(char *dest, int n, _file *fl);
char _fgetc(_file *fl);
_file *_outtoin(_file *out, int mode);
