/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// PPLX Post-processor sources

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>
#include <alloc.h>
#include <conio.h>
#include "fortify.h"
#include "vfs.h"

#define BUFLEN 16384
#define MAXFORNEXT 512
#define MAXWHILE 512
#define MAXIFTHEN 1024
#define MAXCASE 512
#define MAXSTAK MAXFORNEXT+MAXWHILE+MAXCASE
#define MAXCASEPARTS 256
#define MAXLBL 4096
#define _STRINC 256
#define NSTATUS 12

char *readLine(int line);
char *getArg(char *str, int l, int n);
char *getArgProc(char *argReturned, char *str, int finalLevel, int argNum, int curLevel);
int isForNextTest(char *str);
int isWhileTest(char *str);
int isIfThenTest(char *str);
int openLoop(int l1, int l2);
void indexLabels(void);
void status(int n, int forcefull, int forceEmpty);
char *getCaseVar(char *str);
char *getCaseCase(char *str);
void *my_alloc(long size);
char *my_free(void *ptr);
void removeParenth(char *test);

char far errDisk[] = "Unable to create file on disk\n";

char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
_file *post_in;
FILE *post_out;
int lastLine=0;
char *strt;
int el,nc,ne,il;
int end1,end2,gn1,gn2;
char tempfile[] = "POST.TMP";
int x,y;
int postError;
int nArgs;
int DeepLimiting=0;
int maxElse=32767;
extern int fileNum;
extern char far AegisDevise[];
extern char far remLine[];

char *step;
char *var;
char *max;
char gotoN[16];
char gotoN2[16];
char *test;
int far casePart[MAXCASEPARTS];

typedef struct {
	int initLine;
	int exitLine;
	int gotoNExit;
	int gotoNCont;
	char *step;
	char *var;
	char *max;
	char *init;
} fornextType;

typedef struct {
	int initLine;
	int exitLine;
	int gotoNExit;
	int gotoNCont;
	char *test;
} whileType;

typedef struct {
	int initLine;
    int end1Line;
    int end2Line;
    int gotoNend1;
    int gotoNend2;
    char *test;
    int caseowner;
    int casedefault;
    int elseif;
    int noElseEnd;
} ifthenType;

typedef struct {
    int n;
	int gotoNcont;
    int gotoNexit;
} stackType;

typedef struct {
	char *str;
    int nBloc;
} _str;

typedef struct {
    int initLine;
    int exitLine;
	char *var;
    int in;
} selectcaseType;


void _strcat(_str *arg, char *str);

fornextType far *fornext[MAXFORNEXT];
whileType far *whil[MAXWHILE];
ifthenType far *ifthen[MAXIFTHEN];
selectcaseType far *selectcase[MAXCASE];
stackType far stak[MAXSTAK];
int far stakHist[MAXSTAK];
int far gotoLine[MAXLBL];
int far gotoLine2[MAXLBL];

//
//
// Main
//
//

void post(char *postfile)
{
char filename[256];
int a,b,c,d,e,f,nT,cnt, incNt, decNt;
int nForNext=0, nWhile=0, nIfThen=0, nCase=0, nCasePart;
char *tmp1, *tmp2;
int _nForNext, _nIfThen, _nWhile;

lastLine=0;
nForNext=0;
nWhile=0;
nIfThen=0;
nCase=0;
DeepLimiting=0;

strt = (char *)calloc(BUFLEN+1,1);
strt[0]=0;

x = wherex();
y = wherey();

fnsplit(postfile,drive,dir,file,ext);
sprintf(filename,"%s%s%s",strupr(drive),strupr(dir),strupr(file));
if (strcmp(ext,""))
	strcat(filename, strupr(ext));
else
	strcat(filename,".PPX");

post_in = _fopenread(filename, _FILE_READTXT);

//
// For / Next
//

//cout << "\nSearching For/Next loops...";

indexLabels();

a=0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
while (!_feof(post_in))
	{
    status(1,0,0);
	readLine(++a);
	if (isForNextTest(strt))
		{
		nForNext++;
		if (nForNext > MAXFORNEXT-1)
			{
			cout << "\nToo many For/Next loops!";
			exit(1);
			}
		fornext[nForNext] = (fornextType *)calloc(sizeof(fornextType),1);
		fornext[nForNext]->exitLine = gotoLine[atoi(&gotoN[5])];
		strncpy(gotoN2, readLine(fornext[nForNext]->exitLine-3),14);
		if (!strncmp(gotoN2, ":LABEL", 6))
			fornext[nForNext]->gotoNCont = atoi(&gotoN2[6]);
		else
			fornext[nForNext]->gotoNCont = -1;
		fornext[nForNext]->gotoNExit = atoi(&gotoN[5]);
		fornext[nForNext]->initLine = a-2;
		readLine(a-2);
		fornext[nForNext]->init = getArg(strt, 0, 3);
		fornext[nForNext]->step = step;
		fornext[nForNext]->var = var;
		fornext[nForNext]->max = max;
		}
	}
_fseek(post_in, 0, SEEK_SET);
lastLine = 0;

cnt = nForNext;
for (a=1; a<nForNext;a++)
	{
    for(b=1;b<a;b++)
    	{
        if (fornext[a]->initLine > fornext[b]->initLine && fornext[a]->initLine < fornext[b]->exitLine && fornext[a]->exitLine > fornext[b]->exitLine)
        	{
			fornext[a]->initLine = -1;
			fornext[a]->exitLine = -1;
			fornext[a]->gotoNExit = -1;
			fornext[a]->gotoNCont = -1;
            cnt--;
        	}
        }
    }
_nForNext = cnt;

/*if (cnt > 0)
	cout << "\nReconstructing " << cnt << " For/Next loops...";
else
	cout << "\nNo For/Next loop found...";*/

if ((post_out = fopen(tempfile, "wt")) == NULL)
	{
    cout << errDisk;
    fcloseall();
    exit(-1);
    }
//post_out = _fopenwrite(tempfile, _FILE_WRITETXT);
_fseek(post_in,0,SEEK_SET);
a=0;
strt[0] = 0;
while (!_feof(post_in))
	{
    status(2,0,0);
	a++;
	for (b=1;b<=nForNext;b++)
		if (fornext[b]->initLine == a)
			{
			_fgets(strt, BUFLEN, post_in);
			_fgets(strt, BUFLEN, post_in);
			_fgets(strt, BUFLEN, post_in);
			sprintf(strt, "For %s = %s To %s", fornext[b]->var, fornext[b]->init, fornext[b]->max);
			if (strcmp(fornext[b]->step, "1"))
				{
				strcat(strt, " Step ");
				strcat(strt, fornext[b]->step);
				}
			strcat(strt, "\n");
			a+=2;
			goto wr;
			}

	for (b=1;b<=nForNext;b++)
		if (fornext[b]->exitLine-2 == a)
			{
			_fgets(strt, BUFLEN, post_in);
			_fgets(strt, BUFLEN, post_in);
			strcpy(strt, "Next\n");
			a+=1;
			goto wr;
			}

	wr:
	if (strt[0] == 0)
		_fgets(strt, BUFLEN, post_in);
	while (strt[0] == ' ' || strt[0] == '\t')
		strcpy(strt, &strt[1]);
	fputs(strt, post_out);
	strt[0] = 0;
	ct:
	}
_fclose(post_in);
fclose(post_out);
post_in = _fopenread(tempfile, _FILE_READTXT);
unlink(tempfile);
//post_in = _outtoin(post_out, _FILE_READTXT);
lastLine = 0;
_fseek(post_in, 0, SEEK_SET);

//
// While / Endwhile
//

//cout << "\nSearching While/EndWhile loops...";

indexLabels();

a=0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
while (!_feof(post_in))
	{
    status(3,0,0);
	readLine(++a);
	if (isWhileTest(strt))
		{
		nWhile++;
		if (nWhile > MAXWHILE-1)
			{
			cout << "\nToo many While/EndWhile loops!";
			exit(1);
			}
		whil[nWhile] = (whileType *)calloc(sizeof(whileType),1);
		whil[nWhile]->initLine = il;
		whil[nWhile]->exitLine = el;
		whil[nWhile]->gotoNCont = nc;
		whil[nWhile]->gotoNExit = ne;
		whil[nWhile]->test = test;
		}
	}

cnt = nWhile;
for (a=1; a<nWhile;a++)
	{
    for(b=1;b<a;b++)
    	{
        if (whil[a]->initLine > whil[b]->initLine && whil[a]->initLine < whil[b]->exitLine && whil[a]->exitLine > whil[b]->exitLine)
        	{
			whil[a]->initLine = -1;
			whil[a]->exitLine = -1;
			whil[a]->gotoNExit = -1;
			whil[a]->gotoNCont = -1;
            cnt--;
        	}
        }
    }
_nWhile = cnt;

/*if (cnt > 0)
	cout << "\nReconstructing " << cnt << " While/EndWhile loops...";
else
	cout << "\nNo While/EndWhile loop found...";*/

//post_out = _fopenwrite(tempfile, _FILE_WRITETXT);
if ((post_out = fopen(tempfile, "wt")) == NULL)
	{
    cout << errDisk;
    fcloseall();
    exit(-1);
    }
_fseek(post_in,0,SEEK_SET);
a=0;
strt[0] = 0;
while (!_feof(post_in))
	{
    status(4,0,0);
	a++;
	for (b=1;b<=nWhile;b++)
		if (whil[b]->initLine+1 == a)
			{
			_fgets(strt, BUFLEN, post_in);
			sprintf(strt, "While (%s) Do\n", whil[b]->test);
			goto wr2;
			}

	for (b=1;b<=nWhile;b++)
		if (whil[b]->exitLine-1 == a)
			{
			_fgets(strt, BUFLEN, post_in);
			strcpy(strt, "EndWhile\n");
			goto wr2;
			}

	wr2:
	if (strt[0] == 0)
		_fgets(strt, BUFLEN, post_in);
	while (strt[0] == ' ' || strt[0] == '\t')
		strcpy(strt, &strt[1]);
	fputs(strt, post_out);
	strt[0] = 0;
	ct2:
	}
_fclose(post_in);
fclose(post_out);
post_in = _fopenread(tempfile, _FILE_READTXT);
unlink(tempfile);
//post_in = _outtoin(post_out, _FILE_READTXT);
lastLine = 0;
_fseek(post_in, 0, SEEK_SET);

for (a=1;a<=nWhile;a++)
	{
	if (whil[a]->test != NULL) whil[a]->test=my_free(whil[a]->test);
	if (whil[a] != NULL) whil[a]=(whileType *)my_free(whil[a]);
    }

for (a=1;a<=nForNext;a++)
	{
	if (fornext[a]->step != NULL) fornext[a]->step=my_free(fornext[a]->step);
	if (fornext[a]->var != NULL) fornext[a]->var=my_free(fornext[a]->var);
	if (fornext[a]->max != NULL) fornext[a]->max=my_free(fornext[a]->max);
	if (fornext[a]->init != NULL) fornext[a]->init=my_free(fornext[a]->init);
	if (fornext[a] != NULL) fornext[a]=(fornextType *)my_free(fornext[a]);
    }

//
// Break / Continue
//

//cout << "\nResolving Break/Continue...";
stak[0].gotoNcont=-1;
stak[0].gotoNexit=-1;

a=0;
c=0;
d=0;
e=0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
while (!_feof(post_in))
	{
    status(5,0,0);
	readLine(++a);
    if (!strncmp(strt, "For ", 4) || (!strncmp(strt, "While ", 6) && !strcmp(&strt[strlen(strt)-2], "Do")))
		{
        stakHist[e++] = c;
		c=d+1;
        d++;
        }

    if (!strcmp(strt, "Next") || !strcmp(strt, "EndWhile"))
    	{
        if (!strncmp(readLine(a-1), ":LABEL", 6))
        	stak[c].gotoNcont = atoi(&strt[strlen(strt)-3]);
        else
        	stak[c].gotoNcont = -1;

        if (!strncmp(readLine(a+1), ":LABEL", 6))
        	stak[c].gotoNexit = atoi(&strt[strlen(strt)-3]);
        else
        	stak[c].gotoNexit = -1;
        c = stakHist[--e];
        }
    }

//post_out = _fopenwrite(tempfile, _FILE_WRITETXT);
if ((post_out = fopen(tempfile, "wt")) == NULL)
	{
    cout << errDisk;
    fcloseall();
    exit(-1);
    }

a=0;
c=0;
d=0;
e=0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
while (!_feof(post_in))
	{
    status(6,0,0);
    readLine(++a);
    if (!strncmp(strt, "For ", 4) || (!strncmp(strt, "While ", 6) && !strcmp(&strt[strlen(strt)-2], "Do")))
		{
        stakHist[e++] = c;
		c=d+1;
        d++;
        }
    if (!strcmp(strt, "Next") || !strcmp(strt, "EndWhile"))
        c = stakHist[--e];
    if (!strncmp(&strt[strlen(strt)-13], "Goto LABEL", 10))
    	{
        if (!isIfThenTest(strt)/*strcmp(getArg(strt, 1, 1), "If") || strcmp(getArg(strt, 1, 3), "!")*/)
			{
			b = atoi(&strt[strlen(strt)-3]);
    	    if (b == stak[c].gotoNcont)
	        	strcpy(&strt[strlen(strt)-13], "Continue");
    	    if (b == stak[c].gotoNexit)
	        	strcpy(&strt[strlen(strt)-13], "Break");
            }
        else
	        free(test);
		}
    fputs(strt, post_out);
    fputc('\n', post_out);
    }

_fclose(post_in);
fclose(post_out);
post_in = _fopenread(tempfile, _FILE_READTXT);
unlink(tempfile);
//post_in = _outtoin(post_out, _FILE_READTXT);
lastLine = 0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;

//
// If / Then / Else
//

//cout << "\nSearching If/Then/Else...";

indexLabels();

a=0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
while (!_feof(post_in))
	{
    status(7,0,0);
	readLine(++a);
	if (isIfThenTest(strt))
		{
		nIfThen++;
		if (nIfThen > MAXIFTHEN-1)
			{
			cout << "\nToo many If/Then/Else!";
			exit(1);
			}
		ifthen[nIfThen] = (ifthenType *)calloc(sizeof(ifthenType),1);
		ifthen[nIfThen]->initLine = il;
		ifthen[nIfThen]->end1Line = end1;
		ifthen[nIfThen]->end2Line = end2;
		ifthen[nIfThen]->gotoNend1 = gn1;
		ifthen[nIfThen]->gotoNend2 = gn2;
		ifthen[nIfThen]->test = test;
        ifthen[nIfThen]->caseowner = -1;
        ifthen[nIfThen]->casedefault=0;
		}
	}

for (a=1;a<=nIfThen;a++)
	{
    if (ifthen[a]->end2Line != -1 && ifthen[a]->end2Line - ifthen[a]->end1Line > maxElse)
    	{
		ifthen[a]->end2Line=-1;
		ifthen[a]->gotoNend2=-1;
        }
    }

for (a=1;a<=nIfThen;a++)
	{
    if (ifthen[a]->gotoNend2 != -1)
    	{
        for (b=1;b<a;b++)
        	{
            c = ifthen[b]->end2Line != -1 ? ifthen[b]->end2Line : ifthen[b]->end1Line;
            if (ifthen[a]->initLine > ifthen[b]->initLine && ifthen[a]->initLine < c)
	            if (ifthen[a]->end2Line > ifthen[b]->end2Line)
    	        	{
        	        ifthen[a]->gotoNend2 = -1;
            	    ifthen[a]->end2Line = -1;
	                }
            }
        if (ifthen[a]->end1Line == ifthen[a]->initLine + 2)
        	{
   	        ifthen[a]->gotoNend2 = -1;
       	    ifthen[a]->end2Line = -1;
            }
        }
    }

//cout << "\nSearching Select Case...";
_nIfThen = nIfThen;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
a=0;
while (!_feof(post_in))
	{
    status(8,0,0);
    readLine(++a);
    if (!strncmp(strt, ":LABEL", 6))
    	{
        c=0;
        d=0;
        e=0;
        f=0;
        nCasePart=0;
		tmp1 = NULL;
		tmp2 = NULL;
        for (b=1;b<=nIfThen;b++)
            if ((ifthen[b]->end2Line == a) || (ifthen[b]->end1Line == a && ifthen[b]->end2Line == -1))
            	{
                if (c == 0)
	                {
					tmp1 = getCaseVar(ifthen[b]->test);
                    if (tmp1 != NULL)
                    	{
	                    c++;
    	                d = b;
                        }
                    }
                else
                	{
                    if (tmp2 != NULL)
						tmp2=my_free(tmp2);
                    tmp2 = getCaseVar(ifthen[b]->test);
                    if (!strcmp(tmp1, tmp2) && tmp1 != NULL)
						c++;
                    else
                    	{
                    	if (c == 1)
                        	{
                            if (tmp1 != NULL)
	                            tmp1=my_free(tmp1);
							tmp1 = tmp2;
                            tmp2 = NULL;
                            d = b;
                            }
                        if (c > 1)
                            f = e;
                        }
                    if (c > 1)
                    	{
                    	casePart[nCasePart] = b;
                        nCasePart++;
                        if (nCasePart == MAXCASEPARTS)
                        	{
							cout << "\nToo many Cases";
                            exit(1);
                            }
                        e = b;
                        f = e;
                        }

                    }
				}
        if (c > 1)
        	{
            _nIfThen -= nCasePart+1;
            if (f == 0)
            	f = e;
            nCase++;
            ifthen[d]->caseowner = nCase;
			if (nCase > MAXCASE-1)
				{
				cout << "\nToo many Select Case!";
				exit(1);
				}
		    selectcase[nCase] = (selectcaseType *)calloc(sizeof(selectcaseType),1);
            selectcase[nCase]->initLine = ifthen[d]->initLine;
            selectcase[nCase]->var = tmp1;
            selectcase[nCase]->in=0;
            for (d=0;d<nCasePart;d++)
				ifthen[casePart[d]]->caseowner = nCase;
			if (ifthen[f]->end2Line != -1)
                ifthen[f]->casedefault=1;
            if (ifthen[f]->casedefault)
	            selectcase[nCase]->exitLine = ifthen[f]->end2Line;
            else
	            selectcase[nCase]->exitLine = ifthen[f]->end1Line;
            if (tmp2 != NULL)
            	tmp2=my_free(tmp2);
            tmp1 = NULL;
            }
        else
        	if (tmp1 != NULL)
            	tmp1 = my_free(tmp1);
        }
    }
/*if (nIfThen > 0)
	cout << "\nReconstructing " << nIfThen << " If/Then/Else...";
else
	cout << "\nNo If/Then/Else found...";*/

//post_out = _fopenwrite(tempfile, _FILE_WRITETXT);
for (a=1;a<=nIfThen;a++)
	{
	ifthen[a]->elseif=-1;
    ifthen[a]->noElseEnd=-1;
    }

for (a=1;a<=nIfThen;a++)
    if (ifthen[a]->end2Line != -1 && ifthen[a]->caseowner == -1)
//	    for (b=a+1;b<=nIfThen;b++)
		for (b=a+1;b<=a+2;b++)
        	if (ifthen[b]->initLine == ifthen[a]->end1Line+1 && ifthen[b]->caseowner == -1)
            	{
	            c = ifthen[b]->end2Line == -1 ? ifthen[b]->end1Line : ifthen[b]->end2Line;
	            if (c == ifthen[a]->end2Line)
    	        	{
					ifthen[b]->elseif = 1;
                    ifthen[a]->noElseEnd = 1;
                    }
                }


if ((post_out = fopen(tempfile, "wt")) == NULL)
	{
    cout << errDisk;
    fcloseall();
    exit(-1);
    }
_fseek(post_in,0,SEEK_SET);
lastLine=0;
a=0;
strt[0] = 0;
while (!_feof(post_in))
	{
    status(9,0,0);
	a++;
	for (b=1;b<=nIfThen;b++)
		if (ifthen[b]->initLine == a)
			{
			_fgets(strt, BUFLEN, post_in);
            if (ifthen[b]->caseowner == -1)
            	{
                if (ifthen[b]->elseif != -1)
                	sprintf(strt, "ElseIf (%s) Then\n", ifthen[b]->test);
                else
					sprintf(strt, "If (%s) Then\n", ifthen[b]->test);
                }
            else
            	{
            	if (selectcase[ifthen[b]->caseowner]->in == 0)
                	{
					sprintf(strt, "Select Case (%s)\n", selectcase[ifthen[b]->caseowner]->var);
					fputs(strt, post_out);
                	selectcase[ifthen[b]->caseowner]->in = 1;
                    }
                tmp1 = getCaseCase(ifthen[b]->test);
                sprintf(strt, "Case %s\n", tmp1);
                if (tmp1 != NULL)
					tmp1=my_free(tmp1);
                }

			goto wr3;
			}

   	for (b=1;b<=nIfThen;b++)
	    if (ifthen[b]->gotoNend2 != -1 && ifthen[b]->end1Line-1 == a)
            {
			_fgets(strt, BUFLEN, post_in);
            if (ifthen[b]->caseowner != -1)
            	{
                if (ifthen[b]->casedefault==1)
	                {
					sprintf(strt, "Case Else\n");
                    goto wr3;
                    }
            	goto ct3;
                }
            if (ifthen[b]->noElseEnd != -1)
            	goto ct3;
			strcpy(strt, "Else\n");
	        goto wr3;
            }

	for (b=1;b<=nIfThen;b++)
		if ((ifthen[b]->gotoNend2 == -1 && ifthen[b]->end1Line == a) || (ifthen[b]->end2Line != -1 && ifthen[b]->end2Line == a))
        	{
            if (ifthen[b]->caseowner != -1)
            	{
                if (selectcase[ifthen[b]->caseowner]->exitLine == a)
                	{
					fputs("End Select\n", post_out);
                	selectcase[ifthen[b]->caseowner]->in = 0;
                    goto wr3;
                    }
                else
	            	goto ct3;
                }
            if (ifthen[b]->noElseEnd == -1)
				fputs("Endif\n", post_out);
            }

	wr3:
	if (strt[0] == 0)
		_fgets(strt, BUFLEN, post_in);
	while (strt[0] == ' ' || strt[0] == '\t')
		strcpy(strt, &strt[1]);
	fputs(strt, post_out);
	ct3:
	strt[0] = 0;
	}

_fclose(post_in);
fclose(post_out);
post_in = _fopenread(tempfile, _FILE_READTXT);
unlink(tempfile);
//post_in = _outtoin(post_out, _FILE_READTXT);
lastLine = 0;
_fseek(post_in, 0, SEEK_SET);


for (a=1;a<=nIfThen;a++)
	{
	if (ifthen[a]->test != NULL) ifthen[a]->test=my_free(ifthen[a]->test);
	if (ifthen[a] != NULL) ifthen[a]=(ifthenType*)my_free(ifthen[a]);
    }
for (a=1;a<=nCase;a++)
	{
	if (selectcase[a]->var != NULL) selectcase[a]->var=my_free(selectcase[a]->var);
	if (selectcase[a] != NULL) my_free(selectcase[a]);
    }

//
// Indentation / Goto inutiles de fin de case
//

//cout << "\nIndenting source...";

indexLabels();

lastLine = 0;
_fseek(post_in, 0, SEEK_SET);

for (a=0;a<MAXLBL;a++)
	gotoLine2[a]=0;
a=0;
while (!_feof(post_in))
	{
    status(10,0,0);
	readLine(++a);
	if (!strncmp(&strt[strlen(strt)-13], "Goto LABEL",10) || !strncmp(&strt[strlen(strt)-14], "Gosub LABEL",11))
		{
		b = atoi(&strt[strlen(strt)-3]);
		if (b>MAXLBL-1)
			{
			cout << "\nToo much labels!\n";
			exit(1);
			}
        if (!(strt[strlen(strt)-11] == 't' && gotoLine[b] == a+1))
        gotoLine2[b] = -1;
		}
	}

lastLine = 0;
_fseek(post_in, 0, SEEK_SET);

a=0;
c=1;
while (!_feof(post_in))
	{
    status(11,0,0);
	readLine(++a);
	if (!strncmp(strt, ":LABEL",6))
		{
		b = atoi(&strt[strlen(strt)-3]);
        if (gotoLine2[b] == -1)
        	{
			gotoLine2[b] = c;
            c++;
            }
		}
	}

//post_out = _fopenwrite(/*tempfile*/filename, _FILE_WRITETXT);
if ((post_out = fopen(filename, "wt")) == NULL)
	{
    cout << errDisk;
    fcloseall();
    exit(-1);
    }
_fseek(post_in,0,SEEK_SET);
lastLine=0;
a=0;
c=0;
d=0;
nT = 1;
while (!_feof(post_in))
	{
    if (nT < 1)
    	postError=1;
    decNt=0;
    incNt=0;
    status(12,0,0);
	readLine(++a);
    if (!strncmp(strt, AegisDevise, strlen(AegisDevise)-1))
    	break;
    if (!strncmp(strt, ":LABEL", 6))
    	{
        b = atoi(&strt[6]);
        if (!gotoLine2[b])
	        continue;
        sprintf(&strt[6], "%03d", gotoLine2[b]);
        }
    if (!strncmp(strt, "Goto LABEL", 10))
		{
        b = atoi(&strt[strlen(strt)-3]);
        readLine(a+1);
        if (!strcmp(strt, "End Select"))
            if (gotoLine[b] == a+2)
        		continue;
        readLine(a);
        if (gotoLine[b] == a+1)
        	continue;
		}
	if (!strncmp(&strt[strlen(strt)-13], "Goto LABEL",10) || !strncmp(&strt[strlen(strt)-14], "Gosub LABEL",11))
		{
        b = atoi(&strt[strlen(strt)-3]);
        sprintf(&strt[strlen(strt)-3], "%03d", gotoLine2[b]);
        }
    if (!strncmp(strt, "For ", 4)/* || !strncmp(strt, "Procedure ",10) || !strncmp(strt, "Function ", 9)*/ || (!strncmp(strt, "While ", 6) && !strcmp(&strt[strlen(strt)-2], "Do")))
    	{
		incNt = 1;
        goto wr4;
        }
    if (!strncmp(strt, "Select Case ", 12))
    	{
		incNt = 2;
        goto wr4;
        }
    if (!strncmp(strt, "Case ", 5) || !strcmp(strt, "Case Else"))
    	{
        nT--;
        incNt = 1;
        }
	if (!strcmp(strt, "End Select"))
    	{
		nT -= 2;
        goto wr4;
        }
    if (!strcmp(strt, "Next") || !strcmp(strt, "EndWhile")/* || !strcmp(strt, "EndProc") || !strcmp(strt, "EndFunc")*/)
    	{
		nT--;
        goto wr4;
        }
    if (!strncmp(strt, "If ", 3) && !strcmp(&strt[strlen(strt)-4], "Then"))
    	{
        incNt = 1;
        goto wr4;
        }
    if (!strcmp(strt, "Else") || !strncmp(strt, "ElseIf", 6))
    	{
        nT--;
        incNt=1;
        goto wr4;
        }
    if (!strcmp(strt, "Endif"))
    	{
        nT--;
        goto wr4;
        }

    wr4:
    if (strt[0] != ';' && strt[0] != 0)
	    for (c=0;c<nT;c++)
    		fputs("    ", post_out);
    if (!strncmp(strt, "If ", 3))
    	{
		d=0;
        tmp1 = NULL;
        while (1)
        	{
            d++;
            tmp1 = getArg(strt, 0, d);
            if (tmp1 != NULL)
            	{
                if (d == 2)
                	{
                    removeParenth(tmp1);
                    fprintf(post_out, " (%s)", tmp1);
                    }
                else
                	{
	                if (d > 1)
    	               	fputs(" ", post_out);
	    	        fputs(tmp1, post_out);
                    }
                tmp1 = my_free(tmp1);
                }
            else
            	break;
            }
        }
    else
	    fputs(strt, post_out);
	fputs("\n", post_out);
    if (incNt)
		nT+=incNt;
    if (decNt)
       	nT-=decNt;
    }

fputs(";\n",post_out);
fputs("; Postprocessing report\n", post_out);
fputs(";\n",post_out);
fprintf(post_out,";    %-4d    For/Next\n", _nForNext);
fprintf(post_out,";    %-4d    While/EndWhile\n", _nWhile);
fprintf(post_out,";    %-4d    If/Then or If/Then/Else\n", _nIfThen);
fprintf(post_out,";    %-4d    Select Case\n", nCase);
fputs(";\n",post_out);
fputs(remLine,post_out);
fputs(AegisDevise, post_out);
fputs(remLine,post_out);

if (nT != 1)
	postError=1;

//strcpy(post_out->filename, filename);
status(11,1,0);
cout << "                                                  ";
gotoxy(x,y);
fclose(post_out);
_fclose(post_in);
strt=my_free(strt);

}

//
//
// Readline
//
//

char *readLine(int line)
{
int n,l;
static long lastOff;

if (lastLine == 0)
	lastOff = 0;

_fseek(post_in, lastOff, SEEK_SET);

if (lastLine >= line)
	{
	_fseek(post_in, -1, SEEK_CUR);
	while (lastLine >= line)
		{
		_fseek(post_in, -1, SEEK_CUR);
		if (_fgetc(post_in) == '\n')
//			{
			lastLine--;
/*			_fseek(post_in, -1, SEEK_CUR);
			}*/
		_fseek(post_in, -1, SEEK_CUR);
		}
	_fseek(post_in, 1, SEEK_CUR);
	}

l = line - lastLine;

for (n=0;n<l;n++)
	_fgets(strt, BUFLEN, post_in);

strt[strlen(strt)-1] = 0;
while (strt[0] == ' ' || strt[0] == '\b')
	strcpy(strt, &strt[1]);

lastLine = line;
//strt[255]=0;
lastOff = _ftell(post_in);
return strt;
}

//
//
// isForNextTest
//
//

int isForNextTest(char *str)
{
char *tmp;

tmp = getArg(str, 4, 8);
if (strcmp(tmp, "<"))
    goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 13);
if (strcmp(tmp, ">="))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 19);
if (strcmp(tmp, ">="))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 24);
if (strcmp(tmp, "<="))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 10);
if (strcmp(tmp, "&&"))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 15);
if (strcmp(tmp, "||"))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 21);
if (strcmp(tmp, "&&"))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 4, 3);
if (strcmp(tmp, "!"))
	goto not1;
if (tmp != NULL) tmp=my_free(tmp);

step = getArg(str, 4, 7);
var = getArg(str, 4, 12);
max = getArg(str, 4, 14);
tmp = getArg(str, 4, 27);
strncpy(gotoN,tmp,14);
if (tmp != NULL) tmp=my_free(tmp);

return 1;

not1:

if (tmp != NULL) tmp=my_free(tmp);
return 0;

}

//
//
// getArg
//
//

char *getArg(char *str, int level, int n)
{
char *argReturned;
char *tmp;
int a;

if (str[0] == ';' || str[0] == 0)
	return NULL;

a = strlen(str)+1;
argReturned = (char *)calloc(a,1);

tmp = getArgProc(argReturned, str, level, n, 0);
if (tmp == NULL)
    {
	argReturned=my_free(argReturned);
    return NULL;
    }

return argReturned;
}

//
//
// getArgProc
//
//

char *getArgProc(char *argReturned, char *str, int finalLevel, int argNum, int curLevel)
{
char oper[] = "=<>!&|";
char math[] = "^*/%+-";
static int curArg;
char x[2]="X";
char c;
int idx=0;
int parenth=0;
char *t;
int n;
int localArg=0;
int removePar=0;
n=0;
_str sCurArg;

sCurArg.nBloc=0;
sCurArg.str=NULL;

while (strchr(oper, str[n]) && str[n] != 0)
	n++;
if (n == strlen(str))
	return NULL;

if (curLevel == 0)
	{
	curArg=0;
	idx=0;
	parenth=0;
	localArg=0;
	removePar=0;
    }

if (curLevel > finalLevel)
	return NULL;

while (idx < strlen(str))
	{
	c = str[idx];
    if (c == '\"')
    	{
		x[0] = c;
		_strcat(&sCurArg, x);
        while (1)
			{
            idx++;
            if (idx == strlen(str))
            	goto x1;
			c = str[idx];
            if (c == '\"')
            	break;
			x[0] = c;
			_strcat(&sCurArg, x);
            }
        }
	if (c == '(' || c == '[')
		{
		parenth++;
		if ((sCurArg.str == NULL || sCurArg.str[0] == 0) && parenth == 1)
			{
			c = 0;
			removePar=1;
			}
		}
	if (c == ')' || c == ']')
		{
		parenth--;
		if (parenth == 0)
			if (!removePar)
				{
				x[0] = c;
				_strcat(&sCurArg, x);
				}
            else
            	removePar = 0;
		}
	if (parenth == 0 && (strchr(oper,c) || (c == ')' || c == ']') || (c == ' ' && !(strchr(math,str[idx+1]) || strchr(math,str[idx-1]) )) ))
		{
		curArg++;
		localArg++;
		n=0;
		while (strchr(oper,str[idx]) && str[idx] != 0)
			{
			c = str[idx];
			if (c != ' ')
				{
				x[0] = c;
				_strcat(&sCurArg, x);
				}
			n++;
			idx++;
			}
		if (n>0)
		idx--;
		if (curArg == argNum)
			{
			strcpy(argReturned, sCurArg.str);
            if (sCurArg.str != NULL);
				sCurArg.str=my_free(sCurArg.str);
			return argReturned;
			}
        if (DeepLimiting && !strcmp(str, sCurArg.str))
            {
			curArg--;
        	goto x2;
            }
		t = getArgProc(argReturned, sCurArg.str, finalLevel, argNum, curLevel+1);
		if (t != NULL)
        	{
            if (sCurArg.str != NULL);
				sCurArg.str=my_free(sCurArg.str);
			return t;
            }
		while (str[idx+1] == ' ' || str[idx+1] == '\t')
			idx++;
        if (sCurArg.str == NULL)
        	_strcat(&sCurArg, " ");
		sCurArg.str[0]=0;
		}
	else
		{
		x[0] = c;
		_strcat(&sCurArg, x);
		}
	idx++;
	}
x1:
if (localArg == 0)
    {
	if (sCurArg.str != NULL);
		sCurArg.str=my_free(sCurArg.str);
	return NULL;
    }
if (sCurArg.str != NULL && sCurArg.str[0] != 0)
	{
	curArg++;
	if (curArg == argNum)
		{
		strcpy(argReturned, sCurArg.str);
        if (sCurArg.str != NULL);
			sCurArg.str=my_free(sCurArg.str);
		return argReturned;
		}
	t = getArgProc(argReturned, sCurArg.str, finalLevel, argNum, curLevel+1);
	if (t != NULL)
        {
        if (sCurArg.str != NULL);
			sCurArg.str=my_free(sCurArg.str);
		return t;
        }
	}
x2:
if (sCurArg.str != NULL);
	sCurArg.str=my_free(sCurArg.str);
nArgs = curArg;
return NULL;
}

void _strcat(_str *arg, char *str)
{

while (arg->nBloc * _STRINC <= strlen(arg->str) + strlen(str))
	{
    if (arg->nBloc == 0)
		arg->str = (char *)calloc(_STRINC,1);
    else
    	arg->str = (char *)farrealloc(arg->str, (arg->nBloc+1) * _STRINC);
    arg->nBloc++;
    }

strcat(arg->str, str);

}


//
//
// isWhileTest
//
//

int isWhileTest(char *str)
{
int a,b,c;
char *tmp;

c = lastLine;

tmp = getArg(str, 1, 1);
if (strcmp(tmp, "If"))
    goto not2;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 1, 3);
if (strcmp(tmp, "!"))
	goto not2;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 1, 5);
if (strcmp(tmp, "Goto"))
	goto not2;
if (tmp != NULL) tmp=my_free(tmp);
il = lastLine-1;
a = atoi(&str[strlen(str)-3]);
ne = a;
el = gotoLine[a];
if (el < lastLine)
	return 0;
if (strncmp(readLine(lastLine-1), ":LABEL", 6))
	return 0;
b = atoi(&strt[strlen(strt)-3]);
if (!strncmp(readLine(gotoLine[a]-2), ":LABEL", 6))
	nc = atoi(&strt[6]);
else
	nc = -1;
if (strncmp(readLine(gotoLine[a]-1), "Goto LABEL", 10))
	return 0;
a = atoi(&strt[strlen(strt)-3]);
if (a != b)
	return 0;
test = getArg(readLine(c), 1, 4);
removeParenth(test);
return 1;

not2:
if (tmp != NULL) tmp=my_free(tmp);
return 0;
}


//
//
// isIfThen
//
//

int isIfThenTest(char *str)
{
int a,b,c;
char *tmp;

c = lastLine;
tmp = getArg(str, 1, 1);
if (strcmp(tmp, "If"))
	goto not3;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 1, 3);
if (strcmp(tmp, "!"))
	goto not3;
if (tmp != NULL) tmp=my_free(tmp);
tmp = getArg(str, 0, 3);
if (strcmp(tmp, "Goto"))
	goto not3;
if (tmp != NULL) tmp=my_free(tmp);
il = lastLine;
gn1 = atoi(&str[strlen(str)-3]);
end1 = gotoLine[gn1];
if (end1 < lastLine)
	return 0;

gn2 = -1;
end2 = -1;
if (!strncmp(readLine(end1-1), "Goto LABEL", 10))
	{
	a = atoi(&strt[strlen(strt)-3]);
	b = gotoLine[a];
    if (b > end1 && !openLoop(end1, b))
    	{
        gn2 = a;
        end2 = b;
        }
	}

test = getArg(readLine(c), 1, 4);
removeParenth(test);
return 1;

not3:
if (tmp != NULL) tmp=my_free(tmp);
return 0;
}

//
//
// openLoop // Teste si un bloc est complet au niveau des boucles
//
//

int openLoop(int l1, int l2)
{
char s[256];
int c,a;

c=0;
_fseek(post_in, 0, SEEK_SET);
lastLine=0;
for (a=l1;a<=l2;a++)
	{
	readLine(a);
    if (!strncmp(strt, "For ", 4) || !strncmp(strt, "While ", 4))
        c++;

    if (!strncmp(strt, "Next",4) || !strncmp(strt, "EndWhile",8))
    	c--;
    }

return (c!=0);
}

void indexLabels(void)
{
int a,b;

_fseek(post_in, 0, SEEK_SET);
lastLine=0;
for (a=1;!_feof(post_in);a++)
	{
	readLine(a);
	if (!strncmp(strt, ":LABEL", 6))
		{
		b = atoi(&strt[6]);
		if (b>MAXLBL-1)
			{
			cout << "\nToo much labels!\n";
			exit(1);
			}
		gotoLine[b] = a;
		}
	}
}

void status(int n, int forcefull, int forceEmpty)
{
float f_a, f_b;
int percent;
static int previousPercent=100;
int b;

f_a = post_in->ptr;
f_b = post_in->size;
if (f_b != 0)
	percent = f_a / f_b * (100/NSTATUS) + (100/NSTATUS)*(n-1);
if (forcefull)
	percent = 100;
if (forceEmpty)
	percent = 0;
if (percent != previousPercent)
   	{
    for (b=0;b<percent>>2;b++)
    cout << "";
    for (;b<25;b++)
    	cout << "";
        if (forceEmpty)
        	percent = 100;
		printf(" %d%%  ",percent);
		gotoxy(x,y);
        previousPercent = percent;
    }

}

char *getCaseVar(char *str)
{
int a;
int b;
int c;
char *tmp1;
char *tmp2;
char *tmp3;
char *tmp4;

    tmp1 = NULL;
    tmp2 = NULL;
    tmp4 = NULL;
    DeepLimiting=1;
    tmp3 = getArg(str, 512, 512);
	if (tmp3 != NULL)
		tmp3=my_free (tmp3);
	c = nArgs;
    a = ((nArgs - 3) / 6);//+ 1;
    for (b = c-2; b> 0; b-=5)
    	{
        if (tmp2 != NULL)
        	tmp2=my_free(tmp2);
	    tmp2 = getArg(str, a, b);
        tmp4 = getArg(str, a, b+1);
        if (strcmp(tmp4, "=="))
        	{
            if (tmp1 != NULL)
				tmp1=my_free(tmp1);
            if (tmp2 != NULL)
	            tmp2=my_free(tmp2);
            if (tmp4 != NULL)
            	tmp4=my_free(tmp4);
		    DeepLimiting=0;
            return NULL;
            }
        if (tmp4 != NULL)
        	tmp4 = my_free(tmp4);
		if (tmp1 == NULL)
        	{
            tmp1 = tmp2;
            tmp2 = NULL;
            }
        else
        	{
            if (strcmp(tmp1, tmp2))
            	{
                if (tmp1 != NULL)
					tmp1=my_free(tmp1);
                if (tmp2 != NULL)
	                tmp2=my_free(tmp2);
	            if (tmp4 != NULL)
    	        	tmp4=my_free(tmp4);
			    DeepLimiting=0;
                return NULL;
                }
            }
        }
    if (tmp2 != NULL)
	    tmp2=my_free(tmp2);
	if (tmp4 != NULL)
    	tmp4=my_free(tmp4);
    DeepLimiting=0;
    return tmp1;
}

char *getCaseCase(char *str)
{
int a;
int b;
int c;
int d;
char *tmp1;
char *tmp2;
char *tmp3;
char *tmp4;

tmp2 = (char *)calloc(strlen(str)+1,1);
tmp3 = (char *)calloc(strlen(str)+1,1);
tmp2[0] = 0;
tmp3[0] = 0;

    d=0;
    DeepLimiting=1;
    tmp4 = getArg(str, 512, 512);
	if (tmp4 != NULL)
		tmp4=my_free (tmp4);
	c = nArgs;
    a = ((nArgs - 3) / 6) + 1;
    for (b = c; b> 2; b-=5)
    	{
        if (d > 0)
        	{
        	strcpy(tmp3, ", ");
            strcat(tmp3, tmp2);
            strcpy(tmp2, tmp3);
            }
        d++;
	    tmp1 = getArg(str, a, b);
        strcpy(tmp3, tmp1);
        strcat(tmp3, tmp2);
        strcpy(tmp2, tmp3);
        if (tmp1 != NULL)
			tmp1=my_free(tmp1);
        }
    tmp3=my_free(tmp3);
    DeepLimiting=0;
    return tmp2;
}

void removeParenth(char *test)
{
int b,c;

while (test[0] == '(')
	{
    c=0;
    for (b=1;b<strlen(test);b++)
    	{
        if (test[b] == '\"')
        	for (;b<strlen(test) && test[b] != '\"';b++);
        if (test[b] == ')')
        	c--;
        if (test[b] == '(')
        	c++;
        if (c < 0)
        	break;
        }
    if (c == -1 && b == strlen(test)-1)
    	{
        strcpy(test, &test[1]);
        test[strlen(test)-1]=0;
        }
    else
    	break;
    }
}
