/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
                           + Project Frontier +

 PPE Debugger

 MAIN 

*/
#include <dir.h>

#include <process.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lang\fortify.h"
#include "..\lang\ppl_type.h"
#include "..\lang\ppl.h"
#include "..\com\startup.h"
#include "..\com\system.h"
#include "..\com\closeup.h"
#include "..\com\vio.h"
#include "..\lang\debug.h"

extern unsigned _stklen = 49151U;

extern directvideo = 1;
char far fullFilename[MAXPATH];
int far ppMode=0;
char prcFile[256]="";
char ppSource[256]="";

main (int argc, char **argv)
{
char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
int arg=1,a;

if (argc < 2)
	{
    printf("PowerPPL Debugger v1.02 - (c)1996,97 The Aegis Corporation\nPPE Virtual Machine v1.08\n\n");
	printf("PPD <filename[.PPE]>\n");
	exit(-1);
    }

if (!strcmpi(argv[1], "/PP"))
	{
	strcpy(ppSource, argv[2]);
	ppMode=1;
    arg+=2;
    }
if (!strcmpi(argv[1], "/PPRUN"))
	{
	strcpy(ppSource, argv[2]);
	ppMode=1;
    arg+=2;
	fullRun=1;
    traceOver=0;
    quitLoop=1;
    }


/*fnsplit(argv[0], drive, dir, file, ext);
fnmerge(system*/

Fortify_EnterScope();
frontierStartup(argc, argv);
getUser(1, &user);
userLoggedNum = 1;

fnsplit(argv[arg], drive, dir, file, ext);
if (ext[0] == 0)
	strcpy(ext, ".PPE");
fnmerge(fullFilename, drive, dir, file, ext);

fnsplit(argv[arg], drive, dir, file, NULL);
fnmerge(prcFile, drive, dir, file, ".PRC");


cls();
gotoxy(1,1);
join(0);
color(7);

*tmpStr=0;
for (a=arg+1;a<argc;a++)
    {
	if (*tmpStr != 0)
		strcat(tmpStr, " ");
    strcat(tmpStr, argv[a]);
    }
tokenize(tmpStr, tokenStr);

debuggerInit();
while (!globalQuitDebugger)
	{
	debuggerRun();
    if (ppMode) break;
    }
debuggerReset();

color(0x07);
VIOgotoxy_blind(0, 24);
for (a=0;a<80;a++)
   	puts_blind(" ");

frontierCloseup ();
}
