/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*
                           + Project Frontier +

 PPE Virtual Machine - Debugger


 DEBUGGER 


*/

#include <stdio.h>
#include <dir.h>
#include <alloc.h>
#include "..\lang\ppl.h"
#include "..\lang\debug.h"
#include "..\lang\vfs.h"
#include "..\lang\fortify.h"

typedef struct {
	unsigned long codeOffset;
    unsigned int line;
    } symType;

int nocontrol=0;
extern char far fullFilename[];
int far symbolPresent=0;
int far symCodeSize=0;
int far symCodePos=0;
symType *symCode=NULL;
char far sourceFilename[MAXPATH];

//---------------------------------------------------------------------------

void debugger(void)
{
if (nocontrol) return;
}

//---------------------------------------------------------------------------

void initDebugger(void)
{
}

//---------------------------------------------------------------------------

void resetDebugger(void)
{
if (symCode != NULL)
	{
	free(symCode);
    symCode = NULL;
    }
}

//---------------------------------------------------------------------------

void loadSymbols(vfs_file *ppe, long offset)
{
long n;
int a;
unsigned char c;
long pos;

if (vfs_feof(ppe))
	symbolPresent=0;
else
	symbolPresent=1;

pos = vfs_ftell(ppe);
vfs_fseek(ppe, offset, SEEK_SET);
vfs_fread(&n, 4, 1, ppe);

symCodeSize = n;
symCode = calloc(symCodeSize, sizeof(symType));
symCodePos = 0;

for (a=0;a<n;a++)
	{
    vfs_fread(&symCode[a].codeOffset, 2, 1, ppe);
	vfs_fread(&symCode[a].line, 2, 1, ppe);
    }
for (a=0;a<totalPPLVars;a++)
	{
    c = vfs_fgetc(ppe);
    vars[totalPPLVars-a]->name = calloc(c+1,1);
    vfs_fread(vars[totalPPLVars-a]->name, c, 1, ppe);
    }

c = vfs_fgetc(ppe);
vfs_fread(&sourceFilename, c, 1, ppe);
vfs_fseek(ppe, pos, SEEK_SET);
}
