/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Conversion from Microsoft Binary Format (MBF) to IEEE format

Used to read PCBoard's old BASIC files


*/

#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <math.h>

#include "..\com\mbfieee.h"

double BdReal2Double(bdreal value)
{
int posi,i,j;
long k,l;
double base,num;

	base = pow(2,value[7]-0x81);
    posi = value[6] < 0x80;
    value[6] &= 0x7f;
	num = (double)base;
	for (i=6,j=3;i>1;i--,j+=8){
		l = value[i] >> 4;
		num += l*base / pow(2,j);
		l = value[i] & 0xf;
		num += l*base / pow(2,j+4);
		}
	if (!posi) num = -num;
	return num;
}

void Double2BdReal(bdreal bdval, double value)
{
double base,result,i;
unsigned char e;
long j;
int nbase;

*(long*)bdval=0;
*((long*)(bdval+4))=0;

bdval[0] = 0x7;
if (value == 0)
	return;

if (value < 0)
	{
	bdval[6]+=0x80;
    value = -value;
    }
i = log(value)/log(2);
bdval[7] = (unsigned char)i+0x81;
base = pow(2,(int)i);
value -= base;
base /=8;
for (j=6;j>0;j--,base /= 16)
	{
    nbase=(int)(value / base);
    value -= nbase * base;
    bdval[j] += nbase << 4;

    base /= 16;
    nbase=(int)(value / base);
    value -= nbase * base;
    bdval[j] += nbase;

	if (value == 0) return;
    }

}

bsreal Long2BsReal(long Value)
{
bsreal Result, Exponent=24;

if(Value==0L)
   return(0x80000000);
Result=Value & 0x7FFFF;
while(!(Result&0x800000))
  {
  Result<<=1;
  Exponent--;
  }
return((Result&0x7FFFFF)+((Exponent+0x80)<<24));
}


long BsReal2Long(bsreal Value)
{
return(((Value&0x7FFFFF)|0x800000)>>(24L-((Value>>24)-0x80)));
}


