/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Terminate session

*/


#include <stdio.h>
#include <dir.h>
#include <alloc.h>
#include "..\lang\fortify.h"
#include "..\com\vio.h"
#include "..\com\system.h"
#include "..\com\closeup.h"
#include "..\com\pcbdat.h"
#include "..\com\ppeswap.h"

int skipCloseUp=0;
int closing=0;

int frontierCloseup(void)
{
int ox, oy, oc;
int n;
struct ffblk ffblk;
int done;

fclose(logFile);

if (!skipCloseUp)
	{
    closing=1;
    sprintf(tmpStr, "%02d:%02d", userTimeLog / 60, userTimeLog % 60);
    strncpy(user.LastTimeOn, tmpStr, 5);
    PPLDateToSysCharDate(tmpStr, userDateLog);
    strncpy(user.LastDateOn, tmpStr, 6);
    user.TimesOn++;
    user.LastConfIn = curConf;
	putUser(&user);
    }

if (!skipCloseUp)
	AsyncClose();
else
	suspendCom();

free(ppeReturnValue.value);

ox = VIOwherex();
oy = VIOwherey();

VIOgotoxy_blind(0, 24);
VIOsetback(0);
VIOsetfore(7);
VIOputs("                                                                                ");
VIOgotoxy_blind(ox, oy);

invalidCommands();
freeData();

#ifdef FORTIFY
Fortify_LeaveScope();
#endif

done = findfirst("*.$$$",&ffblk,0);
while (!done)
{
   unlink(ffblk.ff_name);
   done = findnext(&ffblk);
}

if (!skipCloseUp) deleteNodeFile();
exit(0);
}

void freeData(void)
{
free(sysopDispName);
free(sysopSystemPass);
free(helpFilesPath);
free(secFilesPath);
free(userIndexFilesPath);
free(usersFile);
free(callersLogFile);
free(downloadTxtFile);
free(boardName);
free(functionKey1);
free(functionKey2);
free(functionKey3);
free(functionKey4);
free(functionKey5);
free(functionKey6);
free(functionKey7);
free(functionKey8);
free(functionKey9);
free(functionKey10);
free(functionKey11);
free(functionKey12);
free(tempFilesPath);
free(systemPPEPath);
free(tpaPath);
free(netFilesPath);
xmsCloseUp();

st_Disabled=1;
while (nCMDlist)
	{
	free(CMD[nCMDlist-1].command);
	free(CMD[nCMDlist-1].keystroke);
    nCMDlist--;
    }
st_Disabled=0;

dispOn();
*(unsigned int *)0x0040001AL = *(unsigned int *)0x0040001CL; // Flush keyboard
}
