;-----------------------------------------------------------------------------
; _2KSBMOD 28/10/00
;-----------------------------------------------------------------------------
; 2 KILOBYTE .MOD PLAYER for SB16+ compatible by KOZMIK/NEXTEMPIRE 
; 0kozmik2nextempire.com) Works in real and v86 modes (windows 9x).
; The size of the exe is around 8kb because it includes a module.
; composed a long time ago by KENSHI/NEXTEMPIRE (thanks to him).
;
; Notes:
; ------
; Use ScreamTracker3 to compose a standard 4 channel Amiga format .MOD module
; Do not forget to disable "Enable Stereo" In View Order/Variable before save
; Save it as "MUSICMOD.MOD"
; Use 2asm.exe or any other bin2db tool to convert module to asm data.
; Use tasm  4.0+
; Use tlink 7.0+
; Use apack 0.97+
; You can change any of the below default standard config  
;     Soundblaster address is hardcoded to 220h
;     Soundblaster irq     is hardcoded to 5 
;     Soundblaster dma     is hardcoded to 1
; You can VERIFY the 2KB footprint by commenting
;     "INCLUDE         MUSICMOD.ASM"
;     and decommenting the line following it
;     "MUSICMOD       db 0"
;
; Makefile:
; ---------
; 2ASM     MUSICMOD.MOD
; TASM     _2KSBMOD.ASM
; TLINK    _2KSBMOD.OBJ
; APACK -T _2KSBMOD.EXE 
; DEL      _2KSBMOD.EXE 
; MOVE     OUT.EXE _2KSBMOD.EXE
; CLS
; DIR      _2KSBMOD.EXE
;
; And yes plenty of optimizations are left for you to do.
; And no don't mail me as I lack necessary time to respond.
; This is just to help out newbies, not for glory or flames.
; Greets to Adok,Thorin,Nytrik,Franky,Ritz and all demosceners alike.
;
;                       _
;   _ __  ___ __   __ _| |_ ___  _  _  ___  _ _  __ ____ 
;  | /  \/  _ \  \/  /_   _/ _ \/ \/ \/ _ \| | |/  /  _ \
;  |  /| |  __/>    <  | ||  __/     | |_| | |  /|_|  __/
;  |_| |_\____/__/\__\ \___\___/_|_|_|  __/|_|_|   \____/
;                                    |_| 
;              http://www.nextempire.com
;
;-----------------------------------------------------------------------------


.286
.MODEL TINY
JUMPS
NOSMART
STACK  200H
SBDEFTEMPO      EQU         6
SBDEFBPM        EQU       125
SBMIDCRATE      EQU      8448
SBVOLTABLE      EQU     32767;SIZ=16640                 ; db 16640 dup (?)
SBDOUBLEBUFFER  EQU     49407;SIZ=4096                  ; db  4096 dup (?)
SBPITCHTABLE    EQU     57599;SIZ=1714                  ; dw   857 dup (?)
SBHEADER        EQU     59313;SIZ=1084                  ; db  1084 dup (?)
SBMODINFO       EQU     60397;SIZ=506                   ; db   506 dup (?)
SBPSP           EQU     61143;SIZ=2                     ; dw            ?
SBPROGSIZE      EQU     61145;SIZ=2                     ; dw            ?
SBMIXSPEED      EQU     61147;SIZ=2                     ; dw            ?
SBORDERPOS      EQU     61149;SIZ=1                     ; db            ?
SBTEMPO         EQU     61150;SIZ=1                     ; db            ?
SBTEMPOWAIT     EQU     61151;SIZ=1                     ; db            ?
SBBPM           EQU     61152;SIZ=1                     ; db            ?
SBROW           EQU     61153;SIZ=1                     ; db            ?
SBBREAKROW      EQU     61154;SIZ=1                     ; db            ?
SBBPMSAMPLES    EQU     61155;SIZ=2                     ; dw            ?
SBBUFPTR        EQU     61157;SIZ=2                     ; dw            ?
SBBUFLEN        EQU     61159;SIZ=2                     ; dw            ?
SBBUFREP        EQU     61161;SIZ=2                     ; dw            ?
SBNOTE          EQU     61163;SIZ=4                     ; dd            ?
SBADDR          EQU     61167;SIZ=2                     ; dw            ?
SBIRQ           EQU     61169;SIZ=2                     ; dw            ?
SBDMAFLAG       EQU     61171;SIZ=2                     ; dw            ?
SBDMABUFFER     EQU     61173;SIZ=2                     ; dw            ?
SBDMAHANDLER    EQU     61175;SIZ=4                     ; dd            ?
SBTIMERHANDLER  EQU     61179;SIZ=4                     ; dd            ?
SBLOADCOUNT     EQU     61183;SIZ=2                     ; dw            ?
SBMODINDEX      EQU     61185;SIZ=2                     ; dw            ?
SBSAMPLEBUFF    EQU     61187;SIZ=4                     ; dd            ?
SBSAMPLECOUNT   EQU     61191;SIZ=2                     ; dw            ?


_SBADDR EQU 220H
_SBIRQ  EQU 005H
;===========================================
;EQU
;===========================================
;===========================================
;DATA
;===========================================

.data
SBMIXBUFFER       dw      4096/2 dup (0)
SBTRACKS          dw       136/2 dup (0)
CMAMEM000         dw      0
SBPERIODTABLE     dw      856,808,762,720,678,640,604,570,538,508,480,453
                  dw      428,404,381,360,339,320,302,285,269,254,240,226
                  dw      214,202,190,180,170,160,151,143,135,127,120,113
SBSINTABLE        db      0,25,50,74,98,120,142,162,180,197,212,225
                  db      236,244,250,254,255,254,250,244,236,225
                  db      212,197,180,162,142,120,98,74,50,25


INCLUDE         MUSICMOD.ASM
;MUSICMOD       db 0

;===========================================
;CODE
;===========================================
.586
.code
START:
                mov     ax,@Data                ; DS points to my DATA
                mov     ds,ax                   ; segment.
                mov     word ptr fs:[SBPSP],es                ; Save the SBPSP address.
                mov     bx,ss                   ; Shrinks my Memory Block
                mov     cx,sp                   ; to get more core for
                shr     cx,4                    ; the MODule data.
                add     bx,cx
                sub     bx,word ptr fs:[SBPSP]
                inc     bx
                mov     word ptr fs:[SBPROGSIZE],bx           ; Save my Program Size.
ShrinkProg:     mov     ax,4A00h                ; Shrink!
                mov     bx,word ptr fs:[SBPROGSIZE]
                int     21h
                mov     ah,48h
                mov     bx,1000h  
                int     21h
                mov     ds:[CMAMEM000],ax
                mov     fs,ax
                mov     dx,220h             ; SB Port Address Found!
                mov     cx,5
;                mov     word ptr fs:[SBADDR],dx             ; SB Port Address Found!
;                mov     word ptr fs:[SBIRQ],cx
                push    bp
                mov     bp,sp
                pusha
                push    ds
                push    es
                pusha
                push    es
                mov     ax,ds
                mov     es,ax
                mov     di,SBMODINFO
                mov     cx,506;Size ModInfoRec
                cld
                xor     ax,ax
ClearModInfo1:  mov     byte ptr fs:[di],al
                inc     di  
                loop    ClearModInfo1
                pop     es
                popa
                push    ds
                pop     es
                mov     si,offset MUSICMOD
                mov     di,SBHEADER
                mov     cx,1084
                mov     word ptr fs:[SBLOADCOUNT],cx
HeaderCopy:     mov     al,byte ptr ds:[SI]
                mov     byte ptr fs:[di],al
                cmpsb        ;inc si/inc di
                loop    HeaderCopy
                mov     al,byte ptr fs:[SBHEADER+950]    ;mhOrderLen
                mov     byte ptr fs:[SBMODINFO],al
                mov     al,byte ptr fs:[SBHEADER+951]     ;mhReStart
                cmp     al,byte ptr fs:[SBHEADER+950]     ;mhOrderLen
                jb      SetReStart
                mov     al,7Fh
SetReStart:     mov     byte ptr fs:[SBMODINFO+1],al
                mov     cx,128
                xor     ax,ax
                xor     bx,bx
CopyOrder:      mov     ah,byte ptr fs:[SBHEADER+bx+952]     ;mhOrder+bx
                mov     byte ptr fs:[SBMODINFO+2+bx],ah
                cmp     ah,al
                jb      NextOrder
                mov     al,ah
NextOrder:      inc     bx
                loop    CopyOrder
                xor     bx,bx
                mov     bl,al
                inc     bx
                push    bx
                shl     bx,6
                mov     ax,4800h
                int     21h
                pop     bx
                mov     Word Ptr fs:[SBMODINFO+130],0
                mov     Word Ptr fs:[SBMODINFO+132],ax
                mov     si,offset MUSICMOD
                add     si,word ptr fs:[SBLOADCOUNT]
                les     di,dword ptr fs:[SBMODINFO+130]
                mov     cx,bx
                shl     cx,10 
                add     word ptr fs:[SBLOADCOUNT],cx
                rep     movsb
                mov     si,SBHEADER+20     ;lea mhSamples
                xor     di,di
CopySamples:    mov     ax,word ptr fs:[si+22]
                xchg    al,ah
                shl     ax,1
                mov     word ptr fs:[SBMODINFO+258+di],ax
                mov     al,byte ptr fs:[si+25]
                xor     ah,ah
                mov     word ptr fs:[SBMODINFO+444+di],ax
                mov     ax,word ptr fs:[si+26]
                xchg    al,ah
                shl     ax,1
                mov     word ptr  fs:[SBMODINFO+320+di],ax
                mov     ax,word ptr fs:[si+28]
                xchg    al,ah
                shl     ax,1
                mov     word ptr  fs:[SBMODINFO+382+di],ax
                add     si,30 ;Size ModSample
                add     di,2
                cmp     di,62
                jb      CopySamples
                xor     si,si
AllocSamples:   mov     bx,word ptr fs:[SBMODINFO+258+si]
                shr     bx,4
                je      NextSample
                push    si
                inc     bx
                mov     ax,4800h
                int     21h
                pop     si
                mov     word ptr fs:[SBMODINFO+134+si],0
                mov     word ptr fs:[SBMODINFO+196+si],ax
                push    si
                push    di
                push    word ptr fs:[SBMODINFO+196+si]
                pop     es 
                mov     cx,word ptr fs:[SBMODINFO+258+si]
                mov     di,word ptr fs:[SBMODINFO+134+si]
                mov     si,offset MUSICMOD
                add     si,word ptr fs:[SBLOADCOUNT]
                add     word ptr fs:[SBLOADCOUNT],cx
                rep     movsb
                pop     di
                pop     si
NextSample:     add     si,2
                cmp     si,62
                jb      AllocSamples
Failed:         pop     es
                pop     ds
                popa
                pop     bp
PlayNow:        mov     word ptr fs:[SBMIXSPEED],10240;22000        ; Mixing at 22 kHz
Sbinit:         pusha
                push    ds
                push    es
StartPlaying:   pusha
                push    ds
                push    es
SetModParms:    mov     byte ptr fs:[SBORDERPOS],0
                mov     byte ptr fs:[SBTEMPO],SBDEFTEMPO
                mov     byte ptr fs:[SBTEMPOWAIT],SBDEFTEMPO
                mov     byte ptr fs:[SBBPM],SBDEFBPM
                mov     byte ptr fs:[SBROW],64
                mov     byte ptr fs:[SBBREAKROW],0
                mov     ax,word ptr fs:[SBMIXSPEED]
                xor     dx,dx
                mov     bx,24*SBDEFBPM/60
                div     bx
                mov     word ptr fs:[SBBPMSAMPLES],ax
ClearTracks:    mov     di,offset SBTRACKS
                mov     ax,ds
                mov     es,ax
                mov     cx,136     ;NumTracks * (Size TrackInfo)
                xor     ax,ax
                cld
                rep     stosb
                mov     word ptr fs:[SBBUFPTR],ax
                mov     word ptr fs:[SBBUFLEN],ax
MakePitch:      mov     ax,SBMIDCRATE
                mov     bx,428
                mul     bx
                div     word ptr fs:[SBMIXSPEED]
                xor     dh,dh
                mov     dl,ah
                mov     ah,al
                xor     al,al
                mov     cx,857
                xor     bx,bx
                mov     di,SBPITCHTABLE
PitchLoop:      push    ax
                push    dx
                cmp     dx,bx
                jae     NoDiv
                div     bx
NoDiv:          mov     word ptr fs:[di],ax
                add     di,2
                pop     dx
                pop     ax
                inc     bx
                loop    PitchLoop
MakeVolume:     mov     cx,16640
                mov     bx,cx
VolLoop:        dec     bx
                mov     al,bl
                imul    bh
                mov     byte ptr fs:[SBVOLTABLE+bx],ah
                loop    VolLoop
                pop     es
                pop     ds
                popa
                cli
                in      al,21h
                push    ax
                mov     al,11111111b
                out     21h,al
SetBuffer:      mov     word ptr fs:[SBDMAFLAG],0
                mov     ax,SBDOUBLEBUFFER
                mov     word ptr fs:[SBDMABUFFER],ax
                mov     dx,ds
                mov     bx,dx
                shr     dh,4
                shl     bx,4
                add     ax,bx
                adc     dh,0
                mov     cx,ax
                neg     cx
                cmp     cx,2048
                jae     SetDma
                add     word ptr fs:[SBDMABUFFER],cx
                add     ax,cx
                adc     dh,0
SetDma:         mov     bx,ax
                mov     cx,2048
                dec     cx
                mov     al,05h
                out     0Ah,al
                xor     al,al
                out     0Ch,al
                mov     al,bl
                out     02h,al
                mov     al,bh
                out     02h,al
                mov     al,dh
                out     83h,al
                mov     al,cl
                out     03h,al
                mov     al,ch
                out     03h,al
                mov     al,59h
                out     0Bh,al
                mov     al,01h
                out     0Ah,al
ClearBuffer:    mov     di,word ptr fs:[SBDMABUFFER]
                mov     cx,2048
                mov     ax,ds
                mov     es,ax
                mov     al,80h
                cld
                rep     stosb
SetIrq:         xor     ax,ax
                mov     es,ax

;                mov     bx,word ptr fs:[SBIRQ]
;                add     bx,08h
;                shl     bx,2
mov bx,(_SBIRQ+8)*4

                fld     dword ptr es:[bx+0]
                fstp    dword ptr fs:[SBDMAHANDLER+0]
                mov     ax,offset SbIrqHandler
                mov     word ptr es:[bx+0],ax
                mov     word ptr es:[bx+2],cs
SetTimer:       fld     dword ptr es:[70h+0]
                fstp    dword ptr fs:[SBTIMERHANDLER+0]
                mov     ax,offset SbPoll
                mov     word ptr es:[70h],ax
                mov     word ptr es:[72h],cs
;               mov     dx,word ptr fs:[SBADDR]
;               add     dx,06h
                mov     dx,226h
                mov     al,1
                out     dx,al
                in      al,dx
                in      al,dx
                in      al,dx
                in      al,dx
                xor     al,al
                out     dx,al
                mov     cx,100
WaitId2:
;               mov     dx,word ptr fs:[SBADDR]
;               add     dx,0Eh
                mov     dx,22eh
                in      al,dx
                or      al,al
                js      GetID2
                loop    WaitId2
                jmp     Exit
GetId2:
;               mov     dx,word ptr fs:[SBADDR]
;               add     dx,0Ah
                mov     dx,22ah
                in      al,dx
                cmp     al,0AAh
                je      SbOk
                loop    WaitId2
                jmp     Exit
SbOk:
;               mov     dx,word ptr fs:[SBADDR]
;               add     dx,0Ch
                mov     dx,22ch
SbOutWait04:    in      al,dx
                or      al,al
                js      SbOutWait04
                mov     al,0D1h
                out     dx,al
                mov     ax,1000
                mul     ax
                div     word ptr fs:[SBMIXSPEED]
                neg     al
                mov     ah,al
;                mov     dx,word ptr fs:[SBADDR]
;                add     dx,0Ch
mov dx,22ch
SbOutWait05:    in      al,dx
                or      al,al
                js      SbOutWait05
                mov     al,40h
                out     dx,al
SbOutWait06:    in      al,dx
                or      al,al
                js      SbOutWait06
                mov     al,ah
                out     dx,al
SbOutWait07:    in      al,dx
                or      al,al
                js      SbOutWait07
                mov     al,14h
                out     dx,al
SbOutWait08:    in      al,dx
                or      al,al
                js      SbOutWait08
                mov     al,0ffh
                out     dx,al
SbOutWait09:    in      al,dx
                or      al,al
                js      SbOutWait09
                mov     al,0ffh
                out     dx,al
Exit:           pop     ax
;               mov     cx,word ptr fs:[SBIRQ]
                mov     cx,_sbirq
                mov     ah,1
                shl     ah,cl
                not     ah
                and     al,ah
                out     21h,al
                sti
                pop     es
                pop     ds
                popa
                jmp     overISRs
SbIrqHandler:   push    ax
                push    dx
                push    ds
                mov     ax,@Data
                mov     ds,ax
;               mov     dx,word ptr fs:[SBADDR]
;               add     dx,0Eh
                mov     dx,22eh
                in      al,dx
                sub     dx,02h
SbOutWait01:    in      al,dx
                or      al,al
                js      SbOutWait01
                mov     al,14h
                out     dx,al
SbOutWait02:    in      al,dx
                or      al,al
                js      SbOutWait02
                mov     al,0ffh
                out     dx,al
SbOutWait03:    in      al,dx
                or      al,al
                js      SbOutWait03
                mov     al,0ffh
                out     dx,al
                mov     al,20h
                out     20h,al
                pop     ds
                pop     dx
                pop     ax
                iret
SbPoll:         pusha
                push    ds
                push    es
                mov     ax,@Data
                mov     ds,ax
GetDmaCount:    in      al,03h
                mov     cl,al
                in      al,03h
                mov     ch,al
                mov     ax,word ptr fs:[SBDMAFLAG]
                test    ax,ax
                jne     SecondHalf
FirstHalf:      cmp     cx,1024
                jae     Bye
                mov     si,word ptr fs:[SBDMABUFFER]
                mov     cx,1024
                mov     word ptr fs:[SBSAMPLEBUFF+2],ds
                mov     word ptr fs:[SBSAMPLEBUFF+0],si
                mov     word ptr fs:[SBSAMPLECOUNT],cx
                call    GetSamples
                inc     word ptr fs:[SBDMAFLAG]
                jmp     Bye
SecondHalf:     cmp     cx,1024
                jb      Bye
                mov     si,word ptr fs:[SBDMABUFFER]
                mov     cx,1024
                add     si,cx
                mov     word ptr fs:[SBSAMPLEBUFF+2],ds
                mov     word ptr fs:[SBSAMPLEBUFF+0],si
                mov     word ptr fs:[SBSAMPLECOUNT],cx
                call    GetSamples
                dec     word ptr fs:[SBDMAFLAG]
Bye:            pop     es
                pop     ds
                popa
                iret
overISRS:
DEMOLOOP:       MOV     AH,1                                  ; IN AL,60H
                INT     16H                                   ; DAS
                JZ      DEMOLOOP                              ; JC DEMOLOOP
SbDone:         cli
                in      al,21h
                push    ax
                mov     al,11111111b
                out     21h,al
                xor     ax,ax
                mov     es,ax

;               mov     bx,word ptr fs:[SBIRQ]
;               add     bx,08h
;               shl     bx,2
                mov     bx,(_SBIRQ+8)*4
                fld     dword ptr fs:[SBDMAHANDLER+0]
                fstp    dword ptr es:[bx+0]
                fld     dword ptr fs:[SBTIMERHANDLER+0]
                fstp    dword ptr es:[70h+0]
;               mov     dx,word ptr fs:[SBADDR]
;               add     dx,0Ch
                mov     dx,22ch
SbOutWait10:    in      al,dx
                or      al,al
                js      SbOutWait10
                mov     al,0D0h
                out     dx,al
SbOutWait11:    in      al,dx
                or      al,al
                js      SbOutWait11
                mov     al,0D3h
                out     dx,al
                pop     ax
;               mov     cx,word ptr fs:[SBIRQ]
                mov     cx,_sbirq
                mov     ah,1
                shl     ah,cl
                or      al,ah
                out     21h,al
                sti
FreeModule:     pusha
                push    ds
                push    es
                mov     ax,@Data
                mov     ds,ax
FreePatterns:   mov     ax,4900h
                mov     bx,Word Ptr fs:[SBMODINFO+132]
                test    bx,bx
                je      FreeSamples
                mov     es,bx
                int     21h
FreeSamples:    xor     si,si
FreeLoop:       mov     ax,word ptr fs:[SBMODINFO+258+si]
                mov     bx,word ptr fs:[SBMODINFO+196+si]
                test    ax,ax
                je      FreeNext
                test    bx,bx
                je      FreeNext
                push    si
                mov     ax,4900h
                mov     es,bx
                int     21h
                pop     si
FreeNext:       add     si,2
                cmp     si,62
                jb      FreeLoop
                pusha
                push    es
                mov     ax,ds
                mov     es,ax
                mov     di,SBMODINFO
                mov     cx,506;Size ModInfoRec
                cld
                xor     ax,ax
ClearModInfo2:  mov     byte ptr fs:[di] ,al
                inc     di  
                loop    ClearModInfo2
                pop     es
                popa
                pop     es
                pop     ds
                popa
                mov     ax,4c00h
                int     21h
;--------------------------------------------------------------------------
BeatTrack:      mov     dx,word ptr ds:[di+18]
                test    dx,dx
                je      noVolSlide
                cmp     dh,00h
                je      Arpeggio
                cmp     dh,01h
                je      PortUp
                cmp     dh,02h
                je      PortDown
                cmp     dh,03h
                je      TonePort
                cmp     dh,04h
                jne     noVibrato
                jmp     Vibrato
noVibrato:      cmp     dh,05h
                jne     noPortSlide
                jmp     PortSlide
noPortSlide:    cmp     dh,06h
                jne     noVibSlide
                jmp     VibSlide
noVibSlide:     cmp     dh,0Ah
                jne     noVolSlide
                jmp     VolSlide
                add     di,34
noVolSlide:     ret
Arpeggio:       mov     bx,word ptr ds:[di+32]
                mov     ax,word ptr ds:[di+26+bx]
                mov     word ptr ds:[di+16],ax
                add     bx,2
                cmp     bx,6
                jb      SetArpIndex
                xor     bx,bx
SetArpIndex:    mov     word ptr ds:[di+32],bx
                ret
PortUp:         xor     dh,dh
                mov     bx,word ptr ds:[di+14]
                sub     bx,dx
                cmp     bx,113
                jge     NotSmall
                mov     bx,113
NotSmall:       mov     word ptr ds:[di+14],bx
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+16],ax
                ret
PortDown:       xor     dh,dh
                mov     bx,word ptr ds:[di+14]
                add     bx,dx
                cmp     bx,856
                jle     NotBig
                mov     bx,856
NotBig:         mov     word ptr ds:[di+14],bx
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+16],ax
                ret
TonePort:       xor     dh,dh
                mov     ax,word ptr ds:[di+20]
                mov     bx,word ptr ds:[di+14]
                cmp     bx,ax
                je      NoPort
                jg      PortToUp
PortToDown:     add     bx,dx
                cmp     bx,ax
                jle     SetPort
FixPort:        mov     bx,ax
                jmp     SetPort
PortToUp:       sub     bx,dx
                cmp     bx,ax
                jl      FixPort
SetPort:        mov     word ptr ds:[di+14],bx
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+16],ax
NoPort:         ret
Vibrato:        mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                shl     dh,2
                add     byte ptr ds:[di+23],dh
                mov     dh,byte ptr ds:[di+23]
                mov     bl,dh
                shr     bl,2
                and     bx,1Fh
                mov     al,byte ptr ds:[SBSINTABLE+bx]
                mul     dl
                rol     ax,1
                xchg    al,ah
                and     ah,1
                test    dh,dh
                jns     VibUp
                neg     ax
VibUp:          add     ax,word ptr ds:[di+14]
                mov     bx,ax
                cmp     bx,113
                jge     NoLoVib
                mov     bx,113
NoLoVib:        cmp     bx,856
                jle     NoHiVib
                mov     bx,856
NoHiVib:        add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+16],ax
                ret
PortSlide:      call    VolSlide
                mov     dl,byte ptr ds:[di+22]
                jmp     TonePort
VibSlide:       call    VolSlide
                mov     dl,byte ptr ds:[di+24]
                jmp     Vibrato
VolSlide:       mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                mov     al,byte ptr ds:[di+12]
                sub     al,dl
                jge     NoLoVol
                xor     al,al
NoLoVol:        add     al,dh
                cmp     al,64
                jbe     NoHiVol
                mov     al,64
NoHiVol:        mov     byte ptr ds:[di+12],al
                ret
;--------------------------------------------------------------------------
GetTrack:       seges   lodsw
                xchg    al,ah
                mov     bl,ah
                and     ah,0Fh
                mov     cx,ax
                seges   lodsw
                xchg    al,ah
                mov     bh,ah
                and     ah,0Fh
                mov     dx,ax
                mov     word ptr ds:[di+18],dx
                and     bl,0F0h
                shr     bh,4
                or      bl,bh
                je      SetPeriod
SetSample:      xor     bh,bh
                dec     bx
                add     bx,bx
                mov     ax,word ptr fs:[SBMODINFO+444+bx]
                mov     byte ptr ds:[di+12],al
                mov     ax,word ptr fs:[SBMODINFO+134+bx]
                mov     Word Ptr ds:[di],ax
                mov     ax,word ptr fs:[SBMODINFO+196+bx]
                mov     Word Ptr ds:[di+2],ax
                mov     ax,word ptr fs:[SBMODINFO+258+bx]
                mov     word ptr ds:[di+6],ax
                mov     ax,word ptr fs:[SBMODINFO+320+bx]
                mov     word ptr ds:[di+8],ax
                mov     ax,word ptr fs:[SBMODINFO+382+bx]
                mov     word ptr ds:[di+10],ax
SetPeriod:      test    cx,cx
                je      SetEffect
                mov     word ptr ds:[di+20],cx
                cmp     dh,03h
                je      SetEffect
                mov     word ptr ds:[di+14],cx
                mov     bx,cx
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+16],ax
                mov     word ptr ds:[di+4],0
SetEffect:      test    dx,dx
                je      InitNone
                cmp     dh,00h
                jne     noInitArpeggio
                jmp     InitArpeggio
noInitArpeggio: cmp     dh,03h
                je      InitTonePort
                cmp     dh,04h
                je      InitVibrato
                cmp     dh,09h
                je      SampleOfs
                cmp     dh,0Bh
                je      PosJump
                cmp     dh,0Ch
                je      SetVolume
                cmp     dh,0Dh
                je      Break
                cmp     dh,0Fh
                je      SetSpeed
                add     di,34
InitNone:       ret
InitTonePort:   test    dl,dl
                jne     SetPortParm
                mov     dl,byte ptr ds:[di+22]
SetPortParm:    mov     byte ptr ds:[di+22],dl
                mov     word ptr ds:[di+18],dx
                ret
InitVibrato:    mov     al,byte ptr ds:[di+24]
                mov     ah,al
                and     al,0Fh
                and     ah,0F0h
                test    dl,0Fh
                jne     OkDepth
                or      dl,al
OkDepth:        test    dl,0F0h
                jne     OkRate
                or      dl,ah
OkRate:         mov     byte ptr ds:[di+24],dl
                mov     word ptr ds:[di+18],dx
                test    cx,cx
                je      OkPos
                mov     byte ptr ds:[di+23],0
OkPos:          ret
SampleOfs:      test    dl,dl
                jne     SetSampleOfs
                mov     dl,byte ptr ds:[di+25]
SetSampleOfs:   mov     byte ptr ds:[di+25],dl
                mov     dh,dl
                xor     dl,dl
                mov     word ptr ds:[di+4],dx
                ret
PosJump:        mov     byte ptr fs:[SBORDERPOS],dl
                mov     byte ptr fs:[SBROW],64
                ret
SetVolume:      cmp     dl,64
                jbe     OkVol
                mov     dl,64
OkVol:          mov     byte ptr ds:[di+12],dl
                ret
Break:          mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                add     dh,dh
                add     dl,dh
                shl     dh,2
                add     dl,dh
                mov     byte ptr fs:[SBBREAKROW],dl
                mov     byte ptr fs:[SBROW],64
                ret
SetSpeed:       test    dl,dl
                je      Skip
                cmp     dl,31
                ja      SetBpm
SetTempo:       mov     byte ptr fs:[SBTEMPO],dl
                mov     byte ptr fs:[SBTEMPOWAIT],dl
                ret
SetBpm:         mov     byte ptr fs:[SBBPM],dl
                mov     al,103
                mul     dl
                mov     bl,ah
                xor     bh,bh
                mov     ax,word ptr fs:[SBMIXSPEED]
                xor     dx,dx
                div     bx
                mov     word ptr fs:[SBBPMSAMPLES],ax
Skip:           ret
InitArpeggio:   mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                mov     cx,36
                xor     bx,bx
                mov     ax,word ptr ds:[di+14]
ScanPeriod2:    cmp     ax,word ptr ds:[SBPERIODTABLE+bx]
                jae     SetArp
                add     bx,2
                loop    ScanPeriod2
SetArp:         add     dx,dx
                add     dh,bl
                add     dl,bl
                mov     bx,word ptr ds:[SBPERIODTABLE+bx]
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+26],ax
                mov     bl,dh
                xor     bh,bh
                mov     bx,word ptr ds:[SBPERIODTABLE+bx]
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+28],ax
                mov     bl,dl
                xor     bh,bh
                mov     bx,word ptr ds:[SBPERIODTABLE+bx]
                add     bx,bx
                mov     ax,word ptr fs:[SBPITCHTABLE+bx]
                mov     word ptr ds:[di+30],ax
                mov     word ptr ds:[di+32],0
                ret
;--------------------------------------------------------------------------
MixTrack:       cmp     word ptr ds:[si+10],2
                ja      MixLooped
MixNonLooped:   les     dx,[si]
                mov     bx,word ptr ds:[si+4]
                mov     bp,word ptr ds:[si+6]
                push    dx
                push    si
                add     bx,dx
                add     bp,dx
                mov     dx,word ptr ds:[si+16]
                mov     al,byte ptr ds:[si+12]
                mov     ah,byte ptr ds:[si+13]
                mov     si,bx
                mov     bh,al
                mov     al,dl
                mov     dl,dh
                xor     dh,dh
nlMixSamp:      cmp     si,bp
                jae     nlMixBye
                mov     bl,byte ptr es:[si]
                mov     bl,byte ptr fs:[SBVOLTABLE+bx]
                add     byte ptr ds:[di],bl
                inc     di
                add     ah,al
                adc     si,dx
                loop    nlMixSamp
nlMixBye:       mov     bx,si
                pop     si
                pop     dx
                sub     bx,dx
                mov     word ptr ds:[si+4],bx
                mov     byte ptr ds:[si+13],ah
                ret
MixLooped:      les     dx,[si]
                mov     bx,word ptr ds:[si+4]
                mov     bp,word ptr ds:[si+10]
                mov     word ptr fs:[SBBUFREP],bp
                add     bp,word ptr ds:[si+8]
                push    dx
                push    si
                add     bx,dx
                add     bp,dx
                mov     dx,word ptr ds:[si+16]
                mov     al,byte ptr ds:[si+12]
                mov     ah,byte ptr ds:[si+13]
                mov     si,bx
                mov     bh,al
                mov     al,dl
                mov     dl,dh
                xor     dh,dh
lpMixSamp:      cmp     si,bp
                jb      lpMixNow
                sub     si,word ptr fs:[SBBUFREP]
lpMixNow:       mov     bl,byte ptr es:[si]
                mov     bl,byte ptr fs:[SBVOLTABLE+bx]
                add     byte ptr ds:[di],bl
                inc     di
                add     ah,al
                adc     si,dx
                loop    lpMixSamp
lpMixBye:       mov     bx,si
                pop     si
                pop     dx
                sub     bx,dx
                mov     word ptr ds:[si+4],bx
                mov     byte ptr ds:[si+13],ah
                ret
;--------------------------------------------------------------------------
GetSamples:     pusha
                push    ds
                push    es
                cld
                mov     es,word ptr fs:[SBSAMPLEBUFF+2]
                mov     di,word ptr fs:[SBSAMPLEBUFF+0]
                mov     bx,word ptr fs:[SBSAMPLECOUNT]
NextChunk:      cmp     word ptr fs:[SBBUFLEN],0
                je      noCopyChunk
                jmp     CopyChunk
noCopyChunk:    push    bx
                push    di
                push    es
MixChunk:       mov     di,offset SBMIXBUFFER
                mov     cx,word ptr fs:[SBBPMSAMPLES]
                mov     word ptr fs:[SBBUFPTR],di
                mov     word ptr fs:[SBBUFLEN],cx
                mov     ax,ds
                mov     es,ax
                mov     al,80h
                rep     stosb
                mov     si,offset SBTRACKS
                mov     word ptr fs:[SBMODINDEX],bx
                mov     di,word ptr fs:[SBBUFPTR]
                mov     cx,word ptr fs:[SBBUFLEN]
                call    MixTrack
                add     si,34
                mov     di,word ptr fs:[SBBUFPTR]
                mov     cx,word ptr fs:[SBBUFLEN]
                call    MixTrack
                add     si,34
                mov     di,word ptr fs:[SBBUFPTR]
                mov     cx,word ptr fs:[SBBUFLEN]
                call    MixTrack
                add     si,34
                mov     di,word ptr fs:[SBBUFPTR]
                mov     cx,word ptr fs:[SBBUFLEN]
                call    MixTrack
                add     si,34
UpdateTracks:   dec     byte ptr fs:[SBTEMPOWAIT]
                je      GetTracks
BeatTracks:     mov     di,offset SBTRACKS      ;NumTracks=4,Size TrackInfo=34
                call    BeatTrack
                call    BeatTrack
                call    BeatTrack
                call    BeatTrack
                jmp     noUpdate
GetTracks:      mov     al,byte ptr fs:[SBTEMPO]
                mov     byte ptr fs:[SBTEMPOWAIT],al
                les     si,dword ptr fs:[SBNOTE]
                cmp     byte ptr fs:[SBROW],64
                jb      NoPattWrap
                les     si,dword ptr fs:[SBMODINFO+130]
                mov     bl,byte ptr fs:[SBORDERPOS]
                cmp     bl,byte ptr fs:[SBMODINFO]
                jb      NoOrderWrap
                mov     bl,byte ptr fs:[SBMODINFO+1]
                mov     byte ptr fs:[SBORDERPOS],bl
                cmp     bl,byte ptr fs:[SBMODINFO]
                jae     NoUpdate
NoOrderWrap:    xor     bh,bh
                mov     bl,byte ptr fs:[SBMODINFO+2+bx]
                shl     bx,10
                add     si,bx
                mov     bl,byte ptr fs:[SBBREAKROW]
                mov     byte ptr fs:[SBROW],bl
                xor     bh,bh
                mov     byte ptr fs:[SBBREAKROW],bh
                shl     bx,4
                add     si,bx
                mov     word Ptr fs:[SBNOTE+0],si
                mov     word Ptr fs:[SBNOTE+2],es
                inc     byte ptr fs:[SBORDERPOS]
NoPattWrap:     inc     byte ptr fs:[SBROW]
                cld
                mov     di,offset SBTRACKS      ;NumTracks=4,Size TrackInfo=34
                call    GetTrack
                call    GetTrack
                call    GetTrack
                call    GetTrack
                mov     word Ptr fs:[SBNOTE+0],si
NoUpdate:       pop     es
                pop     di
                pop     bx
CopyChunk:      mov     cx,word ptr fs:[SBBUFLEN]
                cmp     cx,bx
                jbe     MoveChunk
                mov     cx,bx
MoveChunk:      mov     si,word ptr fs:[SBBUFPTR]
                add     word ptr fs:[SBBUFPTR],cx
                sub     word ptr fs:[SBBUFLEN],cx
                sub     bx,cx
                rep     movsb
                test    bx,bx
                je      noNextChunk
                jmp     NextChunk
noNextChunk:    pop     es
                pop     ds
                popa
                ret
;--------------------------------------------------------------------------
end start
