COMMENT ^

From : Mike Phillips                                          1:124/2145
To   : Fanny Pahlplatz                     
Subj : Re: MATH-COPROCESSOR COM                                              

 FP> No quest here (though modern math does find much interest in these
 FP> nonlinear diff. eqs.), but it is an attractive family of curves, I
 FP> thought.

I agree, and I have modified your code to make it work with the 486DX.
Here are the changes I made:

Removed the 287 autodetection logic.  If you want to detect an FPU, at
least use a model independent method, and don't use FPU instructions to
do it!

Fixed graphics routines.  A 486 is too fast for your graphics.  It needs
to wait for vertical retrace.  You were drawing *3* curves on the screen
between retraces.  It looks much better with one curve at a time :)
Your code would make someone cross-eyed after a while.  I can only
imagine how bad it would be on a Pentium-166!

Changed symbol 'display' to '_display' to keep it from interfering with
TASM's reserved word 'display'.

Changed background color to black.  The gray was distracting as fast as
these curves are drawn.  The gray was informative, but if you want to do
a history trace, at least make it die away after a while.

Here is the modified code:

COMMENT ENDS^

              .286
              .287

              .model small
              .stack

             .data
 control     dw   0
 oldmode     dw   0
 m           dw   1
 c_100       dw   100
 hinv        dw   20h
 ; Initialize for gridlines at x = 2,1,0,-1,-2 (scale 100).
 ; Proc next_x will write calculated values into ix[].
 ix          LABEL WORD
             REPT  128
             dw   -200,-100,0,100,200
             ENDM

             .code

 ; Comments show the copro stack, top at right. Capitals for results.
 next_x   PROC
 FLD1                  ;  h m x y 1
 FLD    st(2)          ;  h m x y 1 x
 FMUL   st, st(3)      ;  h m x y 1 xx
 FSUB                  ;  h m x y 1-xx
 FLD    st(3)          ;  h m x y 1-xx m
 FMUL                  ;  h m x y M
 FLD    st(1)          ;  h m x y M y
 FMUL                  ;  h m x y My
 FLD    st(2)          ;  h m x y My x
 FSUB                  ;  h m x y My-x
 FLD    st(4)          ;  h m x y My-x h
 FMUL                  ;  h m x y (My-x)h
 FLD    st(1)          ;  h m x y (My-x)h y
 FADD                  ;  h m x y Y
 FXCH                  ;  h m x Y y
 FLD    st(4)          ;  h m x Y y h
 FMUL                  ;  h m x Y yh
 FADDP  st(2), st      ;  h m X Y
 FLD    st(1)          ;  h m X Y X
 FILD   c_100          ;  h m X Y X 100
 FMUL                  ;  h m X Y 100X
 FISTP  ix[si]         ;  h m X Y
 FWAIT
               ret
 next_x        ENDP

 @setport        MACRO   n, value
                 mov     dx,3CEh
                 mov     al,n
                 out     dx,al
                 inc     dx
                 mov     al, value
                 out     dx,al
                 ENDM
 @SR             MACRO   color
                 @setport 0, color
                 ENDM
 @ESR            MACRO   planes
                 @setport 1, planes
                 ENDM
 @BM             MACRO   pixels
                 @setport 8, pixels
                 ENDM

 setpixel    PROC
             mov    cx, si       ; si points to words, so
             shr    cx, 1        ;    count by twos [cfr. below]
             and    cx, 0007     ; pixel position in byte
             mov    ah, 80h
             shr    ah, cl
             @BM    ah           ; Bitmask
             @SR    bl           ; set color
             mov    di, 240      ; address byte =
             sub    di, ix[si]   ;    (240-row)
             shl    di, 4
             mov    ax, di
             shl    ax, 2
             add    di, ax       ;    * 80
             mov    ax, si       ;
             shr    ax, 4        ;    [1 extra, counting by twos]
             add    di, ax       ;    + col >> 3
             mov    ah, es:[di]  ; dummy read/write
             mov    es:[di], ah
             ret
 setpixel    ENDP

 ; gray the old pixel, calculate x(t), color the new pixel, step -- until key
 _display     PROC
 dismore:    mov    bl, 0      ; Black looks better on 486 - MP
             call   setpixel
             call   next_x
             mov    bl, 12     ; red
             call   setpixel
             inc    si
             inc    si
             cmp    si, 1280   ; 640 pixels wide; si points to words
             jl     @F

; slow it down a bit - MP

             MOV     DX,3DAh
_WAIT:       IN      AL,DX
             TEST    AL,08h
             JZ      _WAIT
Retr:        IN      AL,DX
             TEST    AL,08h
             JNZ     Retr

; now only one trace will be drawn at a time - MP

             sub    si, 1280
 @F:         mov    ah, 11h
             int    16h        ; kbhit?
             jz     dismore
             ret
 _display     ENDP

 main:
             mov    ax, @DATA
             mov    ds, ax
             mov    ax, 0A000h
             mov    es, ax

             mov    ah, 0Fh         ; getmode (be kind)
             int    10h
             xor    ah, ah
             mov    [oldmode], ax
             mov    ax, 0012h       ; setmode
             int    10h
             @ESR   0Fh             ; access bitplanes

             ; check for copro; default 03FF -- for mine, anyway.
             ; but not for 486DX!!! - MP
             FINIT ; This will give an invalid opcode if no coproc - MP
             FSTCW   control
             FWAIT
            ; cmp     control, 03FFh
            ; jnz     g_out

             xor    si, si         ;  timeline

             FLD1                  ;  1
             FILD   hinv           ;  1 20hex
             FDIV                  ;  h=0.08hex
 ; First entry with m=1 (see data seg.)
 ; Initialize x small and level (x'=0), to see it 'find' the curve.
 again:      FILD   m             ; h m
             FLD    st(1)         ; h m x=h
             FLDZ                 ; h m x y=0
             FWAIT
             call   _display
 g_key:      mov    ah, 10h        ; Esc or m = 0 .. 8
             int    16h
             cmp    al, 1Bh
             jz     g_out
             cmp    al, '0'        ; Notice the case m=0 is unstable
                                   ; But it looks cool - MP
             jb     g_key
             cmp    al, '8'
             ja     g_key
             sub    al, '0'
             mov    byte ptr [m], al
             FSTP   st            ; h m x
             FSTP   st            ; h m
             FSTP   st            ; h
             jmp short again
 g_out:      mov    ax, [oldmode]
             int    10h
             mov    ax, 4C00h
             int    21h

 end        main

Mike Phillips
INTERNET:  phil4086@utdallas.edu
