#include "DemoIDEPCH.h"
#include "ToolWindow.h"
#include "SM_Window.h"
#include "resource.h"


int ToolWindow::Init(Window* pParent)
{
  if (InitDialogPrivate ("TOOL", MAKEINTRESOURCE(IDD_TOOLS), pParent) != 0)
  {
    return -1;
  }



  m_bIsOK = true;



  Show();    
  
  return 0;
}

int ToolWindow::ProcessMessage  (const UINT message, const WPARAM wParam, const LPARAM lParam)
{ 
  return Window::ProcessMessage(message, wParam, lParam);
}

void ToolWindow::SetCheckBox         (eCheckBox CheckBox, bool bState)
{
  switch (CheckBox)
  {
  case E_CHK_BPMGUIDE:
    Button_SetCheck(GetDlgItem(m_hwnd, IDC_BPMGUIDE), bState?BST_CHECKED:BST_UNCHECKED);
    break;
  case E_CHK_NOMUSIC:
    Button_SetCheck(GetDlgItem(m_hwnd, IDC_NOSOUND), bState?BST_CHECKED:BST_UNCHECKED);
    break;
  case E_CHK_NOMUSICONSTOP:
    Button_SetCheck(GetDlgItem(m_hwnd, IDC_NOSOUNDONSTOP), bState?BST_CHECKED:BST_UNCHECKED);
    break;
  }
}

int ToolWindow::ProcessDialogMessage(const UINT message, const WPARAM wParam, const LPARAM lParam)
{
  switch (message)
  {
    case WM_INITDIALOG:
    {
      HWND hcombo = GetDlgItem( m_hwnd, IDC_TIMESCALE);
      ComboBox_ResetContent( hcombo );
      ComboBox_InsertString( hcombo, 0, "0.01 sec" );
      ComboBox_InsertString( hcombo, 1, "0.05 sec" );
      ComboBox_InsertString( hcombo, 2, "0.1 sec" );
      ComboBox_InsertString( hcombo, 3, "1 sec" );
      ComboBox_InsertString( hcombo, 4, "5 sec" );
      ComboBox_SetCurSel   (hcombo, 3);

      return TRUE;
    }
    case WM_COMMAND:
    {
      switch ((int) LOWORD(wParam))
      {

      case IDC_BPMGUIDE:
      {
        case BN_CLICKED:            
            BPMGuideEvent Event(Button_GetCheck(GetDlgItem(m_hwnd, IDC_BPMGUIDE))==BST_CHECKED?true:false);
            PostEvent(&Event);            
            break;
      }

      case IDC_VIEWDEBUG:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:            
            DebugTextEvent Event(Button_GetCheck(GetDlgItem(m_hwnd, IDC_VIEWDEBUG))==BST_CHECKED?true:false);
            PostEvent(&Event);            
            break;
        }
        break;
      case IDC_NOSOUND:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:            
            NoMusicEvent Event(Button_GetCheck(GetDlgItem(m_hwnd, IDC_NOSOUND))==BST_CHECKED?true:false,
                               Button_GetCheck(GetDlgItem(m_hwnd, IDC_NOSOUNDONSTOP))==BST_CHECKED?true:false);
            PostEvent(&Event);            
            break;
        }
      case IDC_NOSOUNDONSTOP:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:            
            NoMusicEvent Event(Button_GetCheck(GetDlgItem(m_hwnd, IDC_NOSOUND))==BST_CHECKED?true:false,
                               Button_GetCheck(GetDlgItem(m_hwnd, IDC_NOSOUNDONSTOP))==BST_CHECKED?true:false);
            
            PostEvent(&Event);            
            break;
        }
        break;      
      case IDC_NEWEFFECT:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:
            ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_NEWEFFECT);                        
            PostEvent(&Event);
            break;
        }
        break;
      case IDC_LOAD:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:
            ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_LOAD);                        
            PostEvent(&Event);
            break;
        }
        break;
      case IDC_PLAY:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:
            ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_PLAY);            
            Button_SetState(GetDlgItem( m_hwnd, IDC_PLAY), TRUE);
            PostEvent(&Event);
            break;
        }
        break;
      case IDC_STOP:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:
            ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_STOP);            
            Button_SetState(GetDlgItem( m_hwnd, IDC_PLAY), FALSE);
            PostEvent(&Event);
            break;
        }
        break;
      case IDC_PAUSE:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:
            ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_PAUSE);            
            Button_SetState(GetDlgItem( m_hwnd, IDC_PLAY), FALSE);
            PostEvent(&Event);
            break;
        }
        break;


      case IDC_SAVE:
        switch (HIWORD(wParam))
        {
          case BN_CLICKED:
            ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_SAVE);            
            PostEvent(&Event);
            break;
        }
        break;

      case IDC_EXPORTTGAS:
        {
        ToolButtonPressedEvent Event(ToolButtonPressedEvent::E_EXPORTTGAS);            
        PostEvent(&Event);
        break;
        }



      case IDC_TIMESCALE:
        switch (HIWORD(wParam))
        {
        case CBN_SELENDOK:
          {
            TimescaleUpdateEvent Event;
        
            switch (ComboBox_GetCurSel(GetDlgItem( m_hwnd,IDC_TIMESCALE)))
            {
            case 0:
              Event.m_iScale = 1; break;
            case 1:
              Event.m_iScale = 5; break;
            case 2:
              Event.m_iScale = 10; break;
            case 3:
              Event.m_iScale = 100; break;
            case 4:
              Event.m_iScale = 500; break;                   
            }                   

            PostEvent(&Event);
          }
        }
        break;        
      }      
    }    
  }

  return FALSE;
}

