#ifndef __SM_PLANE

#define  __SM_PLANE

#include "SM_Vector3D.h"

struct Plane
{
  float a,b,c,d;

  void  Init(const Vector3D* pPoint, const Vector3D* pNormal)
  {
    // Assumes normalized normal
    a = pNormal->x;
    b = pNormal->y;
    c = pNormal->z;
    d = -(a*pPoint->x+b*pPoint->y+c*pPoint->z);
  }

  void Normalize()
  {
    float f  =1.0f/sqrtf(a*a+b*b+c*c);
    
    a*=f;
    b*=f;
    c*=f;
    d*=f;
  }

  float Evaluate(const Vector3D* pVector3D) const
  {
    return (a*pVector3D->x+
            b*pVector3D->y+
            c*pVector3D->z+
            d);
  }
};


#endif
