#include "SM_Engine3DPCH.h"
#include "SM_MathPch.h"
#include "SM_MathAux.h"
#include "MFastFPU.h"

#define SINTABLESIZE 512
float SINTABLE[SINTABLESIZE];

void InitMathAux()
{
  int i;

  for (i = 0 ; i < SINTABLESIZE ; i++)
  {
    float fNorm = float(2)*PI*float(i)/float(SINTABLESIZE);
    SINTABLE[i] = (float) sin(fNorm);
  }
}


float SINF(float x)
{
  int index, index2;
  
  float fOffset = (x*SINTABLESIZE*(1.0/(2*PI)));
  int   iOffset = MFPU_ftol(fOffset);
  index = iOffset;
  index&= (SINTABLESIZE-1);
  index2= index+1;
  index2&= (SINTABLESIZE-1);

  float fLerp = fOffset - float(iOffset);

  return SINTABLE[index]+fLerp*(SINTABLE[index2]-SINTABLE[index]);
}

float COSF(float x)
{
  return SINF(x+PI/2);
}
