#include "SM_CommonFXPCh.h"
#include "SM_Engine3DPCH.h"
#include "SM_Spline.h"
#include "MGCNaturalSpline3.h"

Spline::Spline()
{
  m_pControlPoints=0;
  m_pfTimes       =0;
  m_pSpline       =0;
}

Spline::~Spline()
{
  Shutdown();
}

int Spline::Init(unsigned uControlPoints, Vector3D* pControlPoints, float* pfTimes)
{
  m_pControlPoints=new Vector3D[uControlPoints];
  m_pfTimes       =new float[uControlPoints];

  if (!m_pfTimes || !m_pControlPoints)
  {
    return -1;
  }

  memcpy(m_pfTimes, pfTimes, sizeof(float)*uControlPoints);
  memcpy(m_pControlPoints, pControlPoints, sizeof(Vector3D)*uControlPoints);

  m_pSpline=new MgcNaturalSpline3(MgcNaturalSpline3::BT_FREE, uControlPoints-1, m_pfTimes, m_pControlPoints);
  if (!m_pSpline)
  {
    return -1;
  }

  return 0;
}

int Spline::Shutdown()
{
  if (m_pSpline)
  {
    delete m_pSpline;
  }

  return 0;
}

void Spline::Evaluate(float fTime, Vector3D* pVector3D)
{
  *pVector3D=m_pSpline->GetPosition(fTime);
}

void  Spline::GetFrame  (float fTime, Vector3D* pPosition,
                                      Vector3D* pTangent,
                                      Vector3D* pNormal,
                                      Vector3D* pBinormal)
{
  m_pSpline->GetFrame(fTime,
                    *pPosition,
                    *pTangent,
                    *pNormal,
                    *pBinormal);
}

