#include "SM_CommonFXPCH.h"
#include <math.h>
#include "SM_ResourceManager.h"
#include "SM_CommonVF.h"
#include "SM_RenderContext.h"
#include "SM_D3D.h"
#include "Ml.h"
#include "SM_MaxScene.h"
#include "MSystemFunctions.h"
#include "SM_Timer.h"
#include "SM_Slider.h"
#include "FxFilter.h"
#include "FXEscena3D.h"


Escena3D::Escena3D(char const* pcName) : SM_DemoEffect(pcName)
{
  m_bLoaded       =false;
  m_bVisible      =true;
  m_fForwardLength=0.0f;
  m_fAnimationOffset=0.0;
  m_fStartForward   =0.0f;  

  m_VAx=0.0f; m_VAy=0.0f;  m_VAw=640.0f, m_VAh=480.0f;
  m_VBx=0.0f; m_VBy=0.0f;  m_VBw=640.0f, m_VBh=480.0f;    
  m_bViewportTransition=false;
}

Escena3D::~Escena3D()
{
}

int Escena3D::Init()
{
 return (0);
}

int Escena3D::Shutdown()
{
  m_MaxScene.Shutdown();
  return (0);
}

int Escena3D::Start(float fTime)
{
  m_MaxScene.SetAnimationOffset(m_fAnimationOffset);
  return (0);
}

int Escena3D::Stop()
{
  return (0);
}

int Escena3D::Run(float fTime)
{
  if (m_bLoaded && m_bVisible)
  {
    float fOffset=0.0f;
    if (m_fForwardLength)
    {
      fOffset=1.0f/(1.0f+(float)exp(-(75.0f*(-0.05+Timer::GetTime()-m_fStartForward))));

      if (fOffset>0.99f)
      {
        m_fAnimationOffset+=1.0f;
        m_fForwardLength=0.0f;
        fOffset=0.0f;
      }
    }

    if (m_bViewportTransition)
    {
      float fInterp;

      m_bViewportTransition=m_ViewportSlider.GetValue(Timer::GetTime(), &fInterp);

      m_MaxScene.m_fX=(m_VAx+(m_VBx-m_VAx)*fInterp);
      m_MaxScene.m_fY=(m_VAy+(m_VBy-m_VAy)*fInterp);
      m_MaxScene.m_fWidth=(m_VAw+(m_VBw-m_VAw)*fInterp);
      m_MaxScene.m_fHeight=(m_VAh+(m_VBh-m_VAh)*fInterp);           
    }
    else
    {
      m_MaxScene.m_fX=m_VBx;
      m_MaxScene.m_fY=m_VBy;
      m_MaxScene.m_fWidth=m_VBw;
      m_MaxScene.m_fHeight=m_VBh;                          
    }

    // Parche      
    //m_MaxScene.SetAnimationOffset(fOffset+m_fAnimationOffset);

    //g_SceneFilter->SetRenderDepthTarget(0);
    m_MaxScene.Render(0, 0xFFFFFFFF, false);
    //g_SceneFilter->RestoreRenderDepthTarget();


    
    return 1;
    
/*
    FVF_PosRhwDiffuseTex1 pVertices[4];
    unsigned short        pIndices[6]={0,2,1,0,3,2};
    SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    


 
    float fScaleU=1.0f;
    float fScaleV=1.0f;    

    float fxCenter=320.0f;
    float fyCenter=240.0f;

    float fxWidth=320.0f;
    float fyHeight=240.0f;

    float fScale  =1.0f+0.0f*sinf(fTime);

    pVertices[0].x=fxCenter-fxWidth*fScale; pVertices[0].y=fyCenter-fyHeight*fScale ; pVertices[0].z=0.0f; pVertices[0].u=0.0f; pVertices[0].v=0.0f; pVertices[0].oow=1.0f; pVertices[0].diffuse=0xFFFFFFFF;
    pVertices[1].x=fxCenter+fxWidth*fScale; pVertices[1].y=fyCenter-fyHeight*fScale ; pVertices[1].z=0.0f; pVertices[1].u=fScaleU; pVertices[1].v=0.0f; pVertices[1].oow=1.0f; pVertices[1].diffuse=0x00FFFFFF;
    pVertices[2].x=fxCenter+fxWidth*fScale; pVertices[2].y=fyCenter+fyHeight*fScale; pVertices[2].z=0.0f; pVertices[2].u=fScaleU; pVertices[2].v=fScaleV; pVertices[2].oow=1.0f; pVertices[2].diffuse=0xFFFFFFFF;
    pVertices[3].x=fxCenter-fxWidth*fScale; pVertices[3].y=fyCenter+fyHeight*fScale; pVertices[3].z=0.0f; pVertices[3].u=0.0f; pVertices[3].v=fScaleV; pVertices[3].oow=1.0f; pVertices[3].diffuse=0x00FFFFFF;

    SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
    SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
    SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
 
    SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_SELECTARG1);
    SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TEXTURE );

    SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1));

    
    int i;

    for (i=0 ; i<0 ; i++)
    {
      SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1));

      fScale  =1.015f+1*sinf(fTime+i);
      
      pVertices[0].x=fxCenter-fxWidth*fScale; pVertices[0].y=fyCenter-fyHeight*fScale ; pVertices[0].z=0.0f; pVertices[0].u=0.0f; pVertices[0].v=0.0f; pVertices[0].oow=1.0f; pVertices[0].diffuse=0xFFFFFFFF;
      pVertices[1].x=fxCenter+fxWidth*fScale; pVertices[1].y=fyCenter-fyHeight*fScale ; pVertices[1].z=0.0f; pVertices[1].u=fScaleU; pVertices[1].v=0.0f; pVertices[1].oow=1.0f; pVertices[1].diffuse=0x00FFFFFF;
      pVertices[2].x=fxCenter+fxWidth*fScale; pVertices[2].y=fyCenter+fyHeight*fScale; pVertices[2].z=0.0f; pVertices[2].u=fScaleU; pVertices[2].v=fScaleV; pVertices[2].oow=1.0f; pVertices[2].diffuse=0xFFFFFFFF;
      pVertices[3].x=fxCenter-fxWidth*fScale; pVertices[3].y=fyCenter+fyHeight*fScale; pVertices[3].z=0.0f; pVertices[3].u=0.0f; pVertices[3].v=fScaleV; pVertices[3].oow=1.0f; pVertices[3].diffuse=0x00FFFFFF;

    
      SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_MODULATE);
      SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TEXTURE );
      SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2 , D3DTA_TFACTOR);

      unsigned uColor=(5-i)*10;
      uColor=uColor | (uColor<<8) | (uColor<<16);
      SM_D3d::SetRenderState(D3DRS_TEXTUREFACTOR, uColor);

      SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);                
      SM_D3d::SetRenderState(D3DRS_SRCBLEND , D3DBLEND_ONE);
      SM_D3d::SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);  

    
      SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1));
    }

  */
  }
  return (1);
  
}

int Escena3D::Command           (float fTime, const char* pcCommand)
{
  SM_DemoEffect::Command(fTime, pcCommand);

  char  pcPath[256];
  char* pcCopy =0;
  char* pcToken;
  int   iReturn=-1;
  MVFSFILE* pFile=0;
    
  
  pcCopy=new char[strlen(pcCommand)+1];
  strcpy(pcCopy, pcCommand);

  pcToken=strtok(pcCopy, " \t");

  if (strcmp(pcToken, "LOAD")==0)
  {

    pcToken=strtok(0, " \t");

    strcpy(pcPath, "data/scenes/");
    strcat(pcPath, pcToken);    

    char pcCompiledName[_MAX_PATH];
    char pcBaseName[_MAX_PATH];
    MExtractBasename(pcBaseName, pcPath);

    strcpy(pcCompiledName,  "data/scenesbin/");
    strcat(pcCompiledName, pcBaseName);
    strcat(pcCompiledName, ".3PX");

    

    #ifdef MAXSCENE_IMPORTER
    if ( !(pFile=MVFS::fopen(pcCompiledName, "rb")) )
    {
      pFile=MVFS::fopen(pcCompiledName, "wb");
    
      if (m_MaxScene.CompileML(pcPath, pFile)!=0)
      {
        goto EXIT;
      }        
    }
    MVFS::fclose(pFile);    
    #endif

    pFile=MVFS::fopen(pcCompiledName, "rb");
    if (!pFile || m_MaxScene.LoadBin(pFile)!=0)
    {
      MVFS::unlink(pcCompiledName);
      goto EXIT;
    }
    MVFS::fclose(pFile);            
    pFile=0;

    m_bLoaded= true;
  
  }
  else
  if (strcmp(pcToken, "SHOW")==0)
  {
    m_bVisible=true;
  }
  else
  if (strcmp(pcToken, "HIDE")==0)
  {
    m_bVisible=false;
  }
  else 
  if (strcmp(pcToken, "SETTIME")==0)
  {
    pcToken=strtok(0, " \t");
    float fTime=atof(pcToken);

    m_MaxScene.SetAnimationOffset(fTime);
  }
  else 
  if (strcmp(pcToken, "CAMERA")==0)
  {
    pcToken=strtok(0, " \t");
    
    m_MaxScene.SetCamera(pcToken);
  }
  else if (strcmp(pcToken, "FOG")==0)
  {
    pcToken=strtok(0, " \t");

    if (strcmp(pcToken, "ON")==0)
    {
      m_MaxScene.m_bFog=true;


      pcToken=strtok(0, " \t");
      m_MaxScene.m_fFogNear=atof(pcToken);

      pcToken=strtok(0, " \t");
      m_MaxScene.m_fFogFar=atof(pcToken);

      pcToken=strtok(0, " \t");        
      float fRed=atof(pcToken);
      pcToken=strtok(0, " \t");        
      float fGreen=atof(pcToken);
      pcToken=strtok(0, " \t");        
      float fBlue=atof(pcToken);


      m_MaxScene.m_uColor=(int(fRed  *255.0f)<<16) |
                          (int(fGreen*255.0f)<<8)  |
                          (int(fBlue*255.0f)<<0);        

    }
    else
    {
      m_MaxScene.m_bFog=false;
    }
  }
  else if (strcmp(pcToken, "VIEWPORT")==0)
  {
    pcToken=strtok(0, " \t");
    m_VBx=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_VBy=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_VBw=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_VBh=atof(pcToken);                   
  }
  else if (strcmp(pcToken, "VIEWPORTMORPH")==0)
  {
    m_VAx=m_VBx; m_VAy=m_VBy;  m_VAw=m_VBw, m_VAh=m_VBh;

    pcToken=strtok(0, " \t");
    m_VBx=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_VBy=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_VBw=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_VBh=atof(pcToken);                  

    pcToken=strtok(0, " \t");
    float fLength=atof(pcToken);                  

    m_ViewportSlider.Init(fLength);
    m_ViewportSlider.Start(fTime);
    m_bViewportTransition=true;           
  }
  else if (strcmp(pcToken, "NOISE")==0)
  {
    pcToken=strtok(0, " \t");
    m_MaxScene.m_fNoiseX=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_MaxScene.m_fNoiseY=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_MaxScene.m_fNoiseZ=atof(pcToken);
    pcToken=strtok(0, " \t");
    m_MaxScene.m_fNoiseDuration=atof(pcToken);                  
    m_MaxScene.m_fNoiseStartTime=fTime;
  }
  else if (strcmp(pcToken, "FORWARD")==0)
  {

    m_fForwardLength=1.0f;
    m_fStartForward =Timer::GetTime();           
  }
  
  iReturn  = 0;

EXIT:
  if (pFile)  { MVFS::fclose(pFile); pFile=0; }
  if (pcCopy) { delete[] pcCopy; pcCopy=0; }
  return iReturn;
}  

MaxScene* Escena3D::GetScene()
{
  return (&m_MaxScene);
}


DEFINE_EFFECT(Escena3DFX)

Escena3D Efecto00("ESCENA_00");
Escena3D Efecto01("ESCENA_01");
Escena3D Efecto02("ESCENA_02");
Escena3D Efecto03("ESCENA_03");
Escena3D Efecto04("ESCENA_04");
Escena3D Efecto05("ESCENA_05");
Escena3D Efecto06("ESCENA_06");
Escena3D Efecto07("ESCENA_07");
Escena3D Efecto08("ESCENA_08");
Escena3D Efecto09("ESCENA_09");
Escena3D Efecto10("ESCENA_10");
Escena3D Efecto11("ESCENA_11");
Escena3D Efecto12("ESCENA_12");
Escena3D Efecto13("ESCENA_13");
Escena3D Efecto14("ESCENA_14");
Escena3D Efecto15("ESCENA_15");