;
;
; Filename     : moveit.asm
; Included from: Main Assembley Module
; Description  : Animation sequencing routines
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; John Mccarthy would really love to work for a company programming Robots
; or doing some high intensive CPU work.  Hint. Hint.
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
;

        .386p

code32  segment para public use32
        assume cs:code32, ds:code32

        include pmode.ext       ; protected mode externals by TRAN
        include xmouse.ext      ; xmode mouse externals
        include xmode.ext       ; xmode externals by matt pritchard
        include irq.ext         ; irq timing externals
        include 3d.ext
        include stars.ext
        include font.ext
        include land.ext

        extrn objbase:dword     ; object lists and bitmap lists are
        extrn bitbase:dword     ; external! set to 0 if none
        extrn bitx:dword        ; x and y sizes for 3d conversion
        extrn bity:dword

        include macros.inc
        include equ.inc

        public animate_this
        public _standard_screen_draw

framex  dd number_of_spaces dup (0) ; when to access next sequence (# from wait)
framey  dd number_of_spaces dup (0) ; last access to sequence (# for wait)
command dw number_of_spaces dup (0) ; current immediate command (wait type)
comman2 dw number_of_spaces dup (0) ; immediate 2nd command (align type)
speed   dw number_of_spaces dup (0) ; speed if align_d is used
wheads  dd number_of_spaces dup (0) ; offsets to headers
iheads  dw number_of_spaces dup (0) ; indexes in headers
objnum  dw number_of_spaces dup (0) ; object number for header
offseq  dd number_of_spaces dup (0) ; offset of current sequence for headers

hdnum   dw 0                 ; number of headers
animo   dd 0                 ; animation base offset
listas  dd 0                 ; offset to header list
seqas   dd 0                 ; offset to sequence list

curhead dw 0                 ; current header being processed
curobj  dw 0                 ; current object being processed
countdn dw 0                 ; countdown for headers left to process

jumphere dd o _standard_screen_draw ; customized screen update routine

;
; Animate_this: Perform animation sequencing
; In:
;   ESI -> Begining of animation data
;   EDX -> Plot routine (for drawing of main screen)
;      usually offset _standard_screen_draw
;      In:none   Out:z=1 exit
; Out:null
; Notes:
;  See the example file sequence.inc and see the macro file  moveit.inc  for
;  details.  The offset of EDX points to your customized screen plot routine
;  when Z is not equal, routine exits (eg je exit_animation).  EDX does  not
;  have to be set at the start if you dont want.  You can change  it  during
;  the animation by using the new_mainline command.
;

animate_this:
        mov animo,esi        ; save original animation offset
        mov jumphere,edx
        mov edx,esi

        lodsw                ; get number of headers
        mov hdnum,ax

        movzx ecx,ax         ; set counter for next

        xor eax,eax
        lodsw                ; get offset to list
        mov ebx,eax
        lodsw                ; get offset to sequence list

        mov esi,edx
        add eax,esi
        add esi,ebx
        mov listas,esi
        mov seqas,eax

        xor ebp,ebp

load_head_loop:

        xor eax,eax          ; get header offset from "lists"
        lodsw

        add eax,edx          ; add to animation start
        mov wheads[ebp*4],eax

        mov framex[ebp*4],1  ; reset some stuff
        mov framey[ebp*4],1
        mov command[ebp*2],isetup_header ; 1 = setup_header command
        mov comman2[ebp*2],iskip_header  ; 0 = skip header (alignment type)
        mov iheads[ebp*2],0

        inc bp
        loop load_head_loop

big_animation_loop:
        mov ax,hdnum
        mov countdn,ax
        mov curhead,0

; perform immediate commands - waits and alignments

im_loop:
        movzx ebp,curhead

        mov ax,objnum[ebp*2]
        mov curobj,ax

        movzx esi,command[ebp*2]
        jmp immediate_commands[esi*4] ; call command in table

return_imm1:
        movzx ebp,curhead
        movzx esi,comman2[ebp*2]
        jmp immediate_commands[esi*4]

skip_header:
        inc curhead

        dec countdn
        jnz im_loop

        call [jumphere]           ; user defined screen update routine

        jne big_animation_loop

wait_until_the_bimbo_releases_the_esc_key:
        in al,60h                 ; test keyboard again
        cmp al,1
        je wait_until_the_bimbo_releases_the_esc_key

        ret

;
; Thats it folks - the code above is all thats needed for an animation
; the stuff below are just commands for those macros in moveit.inc
;
; Immediate commands - done every frame (not called by sequencer, but flagged
; for calling by macros)
;

setup_header:
        movzx ebp,curhead
        movzx esi,iheads[ebp*2]
        add esi,wheads[ebp*4]
        xor eax,eax
        lodsw                  ; get next header command

        jmp header_commands[eax*4]

align_d:
        movzx ebp,curhead
        movsx ebp,[speed+ebp*2]
        movzx esi,curobj
        mov edi,65535        ; infinite time factor
        call set_speed
        jmp skip_header

align_a:
        movzx ebp,curhead
        movzx edi,[speed+ebp*2]
        movzx esi,curobj
        call point_dir_time
        jmp skip_header

wait_lc:
        mov ax,w framex[ebp*4]
        mov bp,curobj
        cmp lcount[ebp*2],ax
        jle do_more_seqs
        jmp return_imm1

wait_ac:
        mov ax,w framex[ebp*4]
        mov bp,curobj
        cmp acount[ebp*2],ax
        jle do_more_seqs
        jmp return_imm1

wait_fa:
        mov eax,frame_number
        cmp framex[ebp*4],eax
        jle do_more_seqs
        jmp return_imm1

wait_fr:
        mov eax,framex[ebp*4]
        add eax,framey[ebp*4]
        cmp eax,frame_number
        jle do_more_seqs
        jmp return_imm1

;
; header commands
;

done:
        mov command[ebp*2],iskip_header ; set immediate command to skip_header
        mov comman2[ebp*2],iskip_header
        stc
        jmp skip_header

done_all:                      ; exit entire animation
        ret

loopto:                       ; set new location for header index
        lodsw
        mov iheads[ebp*2],ax
        jmp setup_header

seqit:                        ; perform sequence number x until wait or exit
        movzx ebp,curhead
        xor eax,eax
        lodsw
        mov edi,seqas
        mov ax,[edi+eax*2]
        mov esi,animo
        add esi,eax
        add iheads[ebp*2],4
        mov offseq[ebp*4],esi
do_more_seqs:
        movzx ebp,curhead
        mov esi,offseq[ebp*4]
seq_lp:
        movzx ebp,curhead
        xor eax,eax
        mov offseq[ebp*4],esi
        lodsw
        clc
        call sequence_commands[eax*4]
        jnc seq_lp

        jmp setup_header

;
; Sequencing commands
; In:
;  ESI -> macro data from animation
;  EBP -  current header being processed
;   CF=0
; Out:
;  ESI -> next sequence command load location
;   CF=1 - done sequence
;   CF=0 - more commands to perform
; Notes: Look in the moveit.inc file to find out how these are used
;

xoff:
        lodsw
        movzx edi,curobj
        xor ax,0ffffh
        and onoff[edi],al
        clc
        ret
xon:
        lodsw
        movzx edi,curobj
        or onoff[edi],al
        clc
        ret

xnew_object:
        push esi
        call search_next_available_object
        call init_object
        movzx ebp,curhead
        mov objnum[ebp*2],si
        mov curobj,si
        pop esi
        clc
        ret

xcamera:
        movzx ebp,curhead
        mov ax,cameraobject
        mov objnum[ebp*2],ax
        mov curobj,ax
        clc
        ret

xreset_irq:
        call reset_raster_count
        clc
        ret

xset_mode:
        push esi
        lodsw
        push ax
        lodsw
        push ax
        lodsw
        push ax
        lodsw
        push ax
        call set_vga_modex
        pop esi
        add esi,8
        cmp ax,-1               ; test for error in setting videomode
        je zgetoutq
        pop eax
zgetoutq:
        clc
        ret

xset_clip_a:
xset_clip_o:

xshape:
        lodsw
        push esi
        movzx esi,curobj
        call set_shape
        pop esi
        clc
        ret

xmove:
        lodsd
        mov ebx,eax
        lodsd
        mov ecx,eax
        lodsd
        mov ebp,eax
        lodsw
        mov di,ax
        push esi
        movzx esi,curobj
        call move_si
        pop esi
        clc
        ret

xpoint_tm:
        lodsw
        movzx edi,ax
        push esi
        movzx esi,curobj
        call point_dir_time
        pop esi
        clc
        ret

xlocation:
        lodsd
        mov ebx,eax
        lodsd
        mov ecx,eax
        lodsd
        mov ebp,eax
        push esi
        movzx esi,curobj
        call put_object
        pop esi
        clc
        ret

xlocationx:
        lodsd
        movzx edi,curobj
        mov xs[edi*4],eax
        clc
        ret

xlocationy:
        lodsd
        movzx edi,curobj
        mov ys[edi*4],eax
        clc
        ret

xlocationz:
        lodsd
        movzx edi,curobj
        mov zs[edi*4],eax
        clc
        ret

xangle:
        lodsw
        mov bx,ax
        lodsw
        mov cx,ax
        lodsw
        mov bp,ax
        push esi
        movzx esi,curobj
        call set_angle
        pop esi
        clc
        ret

xanglex:
        lodsw
        movzx edi,curobj
        mov vxs[edi*2],ax
        clc
        ret
xangley:
        lodsw
        movzx edi,curobj
        mov vys[edi*2],ax
        clc
        ret
xanglez:
        lodsw
        movzx edi,curobj
        mov vzs[edi*2],ax
        clc
        ret

xwait_for:
        mov eax,frame_number
        mov framey[ebp*4],eax
        xor eax,eax
        lodsw
        mov command[ebp*2],ax
        mov ebx,eax
        lodsd
        mov framex[ebp*4],eax
        mov offseq[ebp*4],esi
        pop ecx                ; remove seq_it return address
        jmp immediate_commands[ebx*4]

xexit:
        stc
        ret

xbitmap:
xbullet:
xalign_a:
        lodsw
        push esi
        movzx ebp,curhead
        mov speed[ebp*2],ax
        mov comman2[ebp*2],ialign_a ; see immediate header command list below
        movzx edi,ax
        movzx esi,curobj
        call point_dir_time
        pop esi
        clc
        ret

xalign_d:
        lodsw
        push esi
        movzx ebp,curhead
        mov speed[ebp*2],ax
        mov comman2[ebp*2],ialign_d ; see immediate header command list below
        movsx ebp,ax
        movzx esi,curobj
        mov edi,65535
        call set_speed
        pop esi
        clc
        ret

xalign_off:
        movzx ebp,curhead
        mov comman2[ebp*2],7
        clc
        ret

xfade_all:
        lodsw
        shl eax,8
        lodsb
        lodsb
        shl eax,8
        lodsb
        lodsb
        push eax
        lodsw
        mov bh,al
        lodsw
        mov bl,al
        pop eax
        pushad
        call _fade_all
        popad
zfade_cont:
        lodsw
        or  ax,ax          ; 0 = wait for fade to complete, >0 = let irq do fade
        jne zwait_fade
        call _wait_for_fade
zwait_fade:
        clc
        ret

xfade_to:
        lodsd
        mov ebp,eax
        add ebp,animo      ; make offset of palette relative!
        lodsw
        mov bh,al
        lodsw
        mov bl,al
        push esi
        mov esi,ebp
        call _fade_palette_read
        pop esi
        jmp zfade_cont

xdraw_icon:
xinitialize:
        push esi
        call wipeoffpalette
        call initpages
        mov ebp,o fontlength
        mov esi,o font0
        mov edi,o font1
        call initfont
        call init_tables
        call reset_raster_count
        pop esi
        clc
        ret

xfollow_me:
        lodsw
        push esi
        movzx esi,curobj
        movzx edi,ax
        call newfollow
        pop esi
        clc
        ret

xfollow_obj:
        lodsw
        mov bp,ax
        lodsw
        push esi
        movzx esi,bp
        movzx edi,ax
        call newfollow
        pop esi
        clc
        ret

xpoint_obj:
        lodsd
        mov ebx,eax
        lodsd
        mov ecx,eax
        lodsd
        mov ebp,eax
        lodsw
        movzx edi,ax
        push esi
        movzx esi,curobj
        call point_time
        pop esi
        clc
        ret

xtext:
        lodsd
        push esi
        mov esi,eax
        call tstring
        pop esi
        clc
        ret

xinit_bitmap:
        lodsw
        movzx edi,ax
        lodsd
        mov bitbase[edi*4],eax
        xor eax,eax
        lodsw
        mov bitx[edi*4],eax
        lodsw
        mov bity[edi*4],eax
        clc
        ret

xinit_shape:
        lodsw
        movzx edi,ax
        lodsd
        add eax,animo       ; shape data is relative to animation offset
        mov objbase[edi*4],eax
        push esi
        call pre_cal_lambert
        pop esi
        clc
        ret

xno_rotation:
        push esi
        movzx esi,curobj
        call use_no_rotations
        pop esi
        clc
        ret

xfull_rotation:
        push esi
        movzx esi,curobj
        call use_full_rotations
        pop esi
        clc
        ret

xxref_palette:
        lodsd
        push esi
        movzx esi,curobj
        mov ebx,eax
        call set_xref_palette
        pop esi
        clc
        ret

xtwist_it:
        lodsd
        mov ebx,eax
        lodsd
        mov ecx,eax
        lodsd
        mov ebp,eax
        lodsw
        mov di,ax
        push esi
        movzx esi,curobj
        call twist_si
        pop esi
        clc
        ret

xtwist_x:
        lodsd
        mov ebx,eax
        lodsw
        mov di,ax
        push esi
        movzx esi,curobj
        call twist_xonly
        pop esi
        clc
        ret

xtwist_y:
        lodsd
        mov ecx,eax
        lodsw
        mov di,ax
        push esi
        movzx esi,curobj
        call twist_yonly
        pop esi
        clc
        ret

xtwist_z:
        lodsd
        mov ebp,eax
        lodsw
        movzx edi,ax
        push esi
        movzx esi,curobj
        call twist_zonly
        pop esi
        clc
        ret

xrotate_it:
        movzx edi,curobj
        lodsw
        mov vxadds[edi*2],ax
        lodsw
        mov vyadds[edi*2],ax
        lodsw
        mov vzadds[edi*2],ax
        lodsw
        mov acount[edi*2],ax
        clc
        ret

xrotate_x:
        movzx edi,curobj
        lodsw
        mov vxadds[edi*2],ax
        lodsw
        mov acount[edi*2],ax
        clc
        ret

xrotate_y:
        movzx edi,curobj
        lodsw
        mov vyadds[edi*2],ax
        lodsw
        mov acount[edi*2],ax
        clc
        ret

xrotate_z:
        movzx edi,curobj
        lodsw
        mov vzadds[edi*2],ax
        lodsw
        mov acount[edi*2],ax
        clc
        ret

xcall_me:
        lodsd
        push esi
        call [eax]
        pop esi
        ret

xnew_mainline:
        lodsd
        mov jumphere,eax
        ret

xoption1:
        clc
        ret
xoption2:
        clc
        ret
xoption3:
        clc
        ret

;
; Immediate commands - done before header commands
; "o" = "offset"
;

imm_num dw (o header_commands - o immediate_commands)/4 ; number of imm comnds

ireturn_imm1  equ 0
isetup_header equ 1
ialign_d      equ 2
iwait_lc      equ 3
iwait_ac      equ 4
iwait_fa      equ 5
iwait_fr      equ 6
iskip_header  equ 7
ialign_a      equ 8

immediate_commands label dword
   dd o return_imm1  ; 0
   dd o setup_header ; 1
   dd o align_d      ; 2   ; continously move it in direction it is pointing
   dd o wait_lc      ; 3
   dd o wait_ac      ; 4
   dd o wait_fa      ; 5
   dd o wait_fr      ; 6
   dd o skip_header  ; 7
   dd o align_a      ; 8   ; continously point it in direction it is moving

;
; Header commands - sequencing redirection and looping
;

header_commands label dword
   dd o done         ; 0
   dd o done_all     ; 1
   dd o loopto       ; 2
   dd o seqit        ; 3

;
; Animation commands:
; * = not yet implemented
; 0 = free space for more commands
;

sequence_commands label dword
   dd o xoff          ; 0
   dd o xon           ; 1
   dd o xnew_object   ; 2
   dd o xcamera       ; 3
   dd 0               ; 4
   dd o xreset_irq    ; 5
   dd o xset_mode     ; 6
   dd o xset_clip_a   ; 7  *
   dd o xset_clip_o   ; 8  *
   dd 0               ; 9
   dd o xshape        ; 10
   dd o xmove         ; 11
   dd o xpoint_tm     ; 12
   dd 0               ; 13
   dd o xlocation     ; 14
   dd o xlocationx    ; 15
   dd o xlocationy    ; 16
   dd o xlocationz    ; 17
   dd o xangle        ; 18
   dd o xanglex       ; 19
   dd o xangley       ; 20
   dd o xanglez       ; 21
   dd o xwait_for     ; 22
   dd o xexit         ; 23
   dd o xbitmap       ; 24 *
   dd o xbullet       ; 25 *
   dd o xalign_a      ; 26
   dd o xalign_d      ; 27
   dd o xalign_off    ; 28
   dd 0               ; 29
   dd o xfade_all     ; 30
   dd o xfade_to      ; 31
   dd o xdraw_icon    ; 32 *
   dd o xinitialize   ; 33
   dd o xfollow_me    ; 34
   dd o xfollow_obj   ; 35
   dd o xpoint_obj    ; 36
   dd o xtext         ; 37
   dd o xinit_bitmap  ; 38
   dd o xinit_shape   ; 39
   dd o xno_rotation  ; 40
   dd o xfull_rotation; 41
   dd o xxref_palette ; 42
   dd o xtwist_it     ; 43
   dd o xtwist_x      ; 44
   dd o xtwist_y      ; 45
   dd o xtwist_z      ; 46
   dd o xrotate_it    ; 50
   dd o xrotate_x     ; 48
   dd o xrotate_y     ; 49
   dd o xrotate_z     ; 50
   dd o xcall_me      ; 51
   dd o xnew_mainline ; 52
   dd 0               ; 53
   dd 0               ; 54
   dd 0               ; 55
   dd 0               ; 56
   dd 0               ; 57
   dd 0               ; 58
   dd 0               ; 59
   dd o xoption1      ; 60
   dd o xoption2      ; 61
   dd o xoption3      ; 62

;
; Standard_screen_draw:
;  Default screen redraw code.  Use this for EDX in before calling animate_this
; In : none
; Out:
;       Z=1 exit
;       Z=0 continue
;

_standard_screen_draw:

        call look_at_it           ; make camera look at selected object
        call setsincose           ; set rotation multipliers for eye
       ;call draw_landscape       ; draw background landscape
        call clear_fill           ; clear video memory (last screen)
        call show_stars           ; plot background stars
        call makeobjs             ; plot all objects in sides table
       ;mov eax,frame_number
       ;mov number_eax,eax
       ;call put_at_top           ; timing tool!
        call flip_page            ; flip video pages
        call updvectors           ; move objects around, rotate them

        in al,60h                 ; test keyboard
        cmp al,1                  ; je = exit

        ret

code32  ends
        end
