
// g3dworld.cpp
//
// Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "g3dworld.h"

G3DWORLD::G3DWORLD ()
  {
    ObjectList = new LINKEDLIST<G3DOBJECT*> (); 
  } // End of Constructor for G3DWORLD

G3DWORLD::~G3DWORLD ()
  {
    if (ObjectList!=NULL)
                        { 
                                ObjectList->ClearAllNode ();
        delete ObjectList;
      } // End if
    ObjectList = NULL;  
  } // End of Destructor for G3DWORLD

BOOLEAN G3DWORLD::AddObject ( G3DOBJECT * NewObject )
  {
    ObjectList->AddObject ( NewObject );  
    return TRUE;  
  } // End of AddObject for G3DWORLD

VOID G3DWORLD::TransformWorldToCamera ( G3DMATRIX CameraMatrix,
                                        CAMERADATA *CameraData )
  {
    LISTOBJECT<G3DOBJECT*> *ObjectNode;
    G3DOBJECT* Object;

    ObjectNode = ObjectList->GetHead ();

    while (ObjectNode!=NULL)
      {
        Object = ObjectNode->Data;
        Object->TransformWorldToCamera ( CameraMatrix, CameraData );
        ObjectNode= ObjectNode->NextObject;  
      } // End while 
  } // End of TransformWorldToCamera for G3DWORLD

BOOLEAN G3DWORLD::Init ()
  {
    LISTOBJECT<G3DOBJECT*> *ObjectNode;
    G3DOBJECT* Object;
    G3DMATRIX Matrix;

    ObjectNode = ObjectList->GetHead ();

    InitMatrix ( Matrix );
    
    while (ObjectNode!=NULL)
      {
        Object = ObjectNode->Data;
        Object->Init ();
        Object->TransformLocalToWorld ( Matrix );
        Object->ComputeRadius ();
        ObjectNode= ObjectNode->NextObject;  
      } // End while
    return TRUE;  
  } // End of Init for G3DWORLD

G3DOBJECT* G3DWORLD::FindObjectByName ( STRING SearchName )
  {
    LISTOBJECT<G3DOBJECT*> *ObjectNode;
    G3DOBJECT* Object;

    ObjectNode = ObjectList->GetHead ();

    while (ObjectNode!=NULL)
      {
        Object = ObjectNode->Data->FindObjectByName ( SearchName );
        if (Object!=NULL)
          return Object;
        ObjectNode= ObjectNode->NextObject;  
      } // End while
    return NULL;        
  } // End of FindObjectByName for G3DWORLD

G3DOBJECT* G3DWORLD::FindObjectByID ( LONG SearchID )
  {
    LISTOBJECT<G3DOBJECT*> *ObjectNode;
    G3DOBJECT* Object;

    ObjectNode = ObjectList->GetHead ();

    while (ObjectNode!=NULL)
      {
        Object = ObjectNode->Data->FindObjectByID ( SearchID );
        if (Object!=NULL)
          return Object;
        ObjectNode= ObjectNode->NextObject;  
      } // End while
    return NULL;        
  } // End of FindObjectByID for G3DWORLD

LONG G3DWORLD::CountNumShapes ()
  {
    LISTOBJECT<G3DOBJECT*> *ObjectNode;
    LONG Count;

    Count = 0;
    
    ObjectNode = ObjectList->GetHead ();

    while (ObjectNode!=NULL)
      {
        ObjectNode->Data->CountNumShapes ( &Count );
        ObjectNode= ObjectNode->NextObject;  
      } // End while
    return Count;              
  } // End of CountNumShapes for G3DWORLD

LONG G3DWORLD::CheckCollision ( FLPVECTOR3D StartPt, FLPVECTOR3D EndPt,
                                COLLIDEDATA *CollideList, LONG MaxNum,
                                float CollideDist, float Gap )
  {
    LISTOBJECT<G3DOBJECT*> *ObjectNode;
    LONG Count;

    Count = 0;
    
    ObjectNode = ObjectList->GetHead ();

    while (ObjectNode!=NULL)
      {
        ObjectNode->Data->CheckCollision ( StartPt, EndPt, CollideList, &Count,
                                           MaxNum, CollideDist, Gap );
        ObjectNode= ObjectNode->NextObject;  
      } // End while
    return Count;              
  } // End of CheckCollision for G3DWORLD                                
  
