; 386POWER VGA/SVGA REGISTER DUMP UTILITY
; It will look what's into the vga registers
; and will write the results into a text file called vgareg.tbl.
; Using the following format:
;
; [PORT] [INDEX]      [VALUE0] [VALUE1] ..... [VALUEn]
;  ^       ^internal       ^                      ^register value
;  |        register       |                       under mode n
;  |        index          |
;  |                       register value under the first graphic mode
;  |                       in the the_mode list
;  |
;  i/o port  "index"

        .386p

code32 segment para public use32
       assume cs:code32,ds:code32

include 386power.inc
include 386file.inc

public  _Main

CR equ 0dh
LF equ 0ah

; DATA
rfile db 'vgatest.tbl',0

; look into the registers of mode
; 320x200(16)  640x480(2) 640x480(16) 320x200(256) 640x400(256) 640x400(256)

modes dd 000Dh,0011h,0012h,0013h,0078h,0079h,0000h

; binary to hexadecimal-ascii conversion table

tohex db '0123456789ABCDEF'

; CODE
wbin2hex: ; in eax=WORD to translate , EDI = ptr to dest
        push ecx
        push ebx
        push edx
        mov ecx,4
        rol eax,20
wb2h:
        mov ebx,eax
        and ebx,0Fh
        rol eax,4
        mov dl,[ebx+tohex]
        mov [edi],dl
        inc edi
        dec ecx
        jne  wb2h
        pop edx
        pop ebx
        pop ecx
        ret

bbin2hex: ; in eax=BYTE to translate , EDI = ptr to dest
        push ecx
        push ebx
        push edx
        mov ecx,2
        rol eax,28
bb2h:
        mov ebx,eax
        and ebx,0Fh
        rol eax,4
        mov dl,[ebx+tohex]
        mov [edi],dl
        inc edi
        dec ecx
        jne  wb2h
        pop edx
        pop ebx
        pop ecx
        ret

rcycle:
        ; ecx=port count/index
        ; edx=base port
        ; edi=text destination, ebx = line width
zook:   dec ecx
        mov al,cl
        out dx,al
        inc edx
        in al,dx
        dec edx
        push edi
        call bbin2hex
        mov dword ptr [edi],200A0D20h
        pop edi
        add edi,ebx
        or ecx,ecx
        jne zook
        ret

chokk:  push edi
        push ecx
        sub edi,ebp
czook:  dec ecx
        push edi
        mov byte ptr [edi],' '
        inc edi
        mov eax,edx
        call wbin2hex
        mov byte ptr [edi],' '
        inc edi
        mov al,cl
        call bbin2hex
        mov dword ptr [edi],20202020h
        pop edi
        add edi,ebx
        or ecx,ecx
        jne czook
        pop ecx
        pop edi
        call rcycle
        ret
;
_Main:  
        sti
        mov ebp,12
        mov esi,offset modes
        mov ebx,(12+3+3+3+3+3+3+2) ; 6 lists with cr+lf on last list
ricicla:
        lodsd            ; read mode to test
        or eax,eax       ;
        je end_of_table  ;

        mov edi,_LoMemBase  ; restart from start of table
        add edi,ebp         ; move to the new column to fill

        mov V86eax,eax  ; set graphic mode
        mov al,10h      ;
        call _ExecINT         ;

        ; Now scan the register values (current settings are for peeking into)
        ; my Chips&Technologies video card
        ; change the base ports and internal register ranges
        ; to read what's in your card.

        mov edx,3c0h  ; test registers accessible from 3c0/1
        mov ecx,20h   ; test 32 registers
        call chokk

        mov edx,3c4h  ;
        mov ecx,20h   ;
        call chokk

        mov edx,3ceh  ;
        mov ecx,20h   ;
        call chokk

        mov edx,3d4h  ;
        mov ecx,30h   ;
        call chokk

        mov edx,3d6h  ; test C&T 450 specific registers
        mov ecx,30h   ;
        call chokk    ; (change this to suit to your board's extensions )

        add ebp,3

        jmp short ricicla
end_of_table:
        mov eax,edi
        mov edi,_LoMemBase
        sub eax,edi
        mov esi,offset rfile
        call _FSave
        mov V86eax,0003h
        mov al,10h
        call _ExecINT
        jmp _Exit


code32  ends
        end

