; modulo per la visualizzazione di bitmap Pcx 320x200
; a 256 colori
.386P
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc
include 386video.inc
include 386file.inc

        public _Pcx2Scr
        public _PcxDecoded,_PcxHasPalette
        public _PcxLoad        
        public _PicPal
        
        align byte
; Palette extracted from last Pcx file read       
_PicPal        db 768 dup(0)

_PcxDecoded    db 0
_PcxHasPalette db 0

Pcx_len   dd 0
Pcx_start dd 0

pcxx dd 0
pcxy dd 0

scrpcx dd 0

_Pcx2Scr:
        ; esi = Pcx data buffer base for a Pcx image
        ;       smaller or equal to the current screen buffer size
        ; eax = Pcx file lenght
        ; expands the Pcx image to _ScrBase
        ; starting from coordinates (0,0)
        
        pushad
        mov Pcx_len,eax
        mov Pcx_start,esi
        mov _PcxDecoded,0    ; still have to decode it
        mov _PcxHasPalette,0 ; still have to read palette
        cmp dword ptr [esi],0801050Ah ; 8 bit/pix, RLE, Ver. 5, Pcx ???
        jne Pcx_err  ; no, get out!
        cmp byte ptr [esi+ 65],01     ; one plane ?
        jne Pcx_err  ; no, get out!
        
        movzx eax,word ptr [esi+66] ; bytes * scanline
        cmp eax,_ScrX
        ja Pcx_err ; image too big
        mov pcxx,eax
        
        movsx eax, word ptr [esi+10] ; ymax
        movsx ebx, word ptr [esi+6 ] ; ymin
        sub eax,ebx
        inc eax
        cmp eax,_ScrY
        ja Pcx_err
        mov pcxy,eax
        
        ; pcx image starting point at start of visible window
        mov eax,_VDispY
        mov edi,_VDispX
        add edi,_ScrBase
        add edi,[eax*4+_RowStart]
        mov scrpcx,edi  ; set displacement from screen buffer start
        
        xor ecx,ecx
        xor edx,edx
        xor ebx,ebx
        add esi,128  ; go to Pcx data block
@yPcx:  
        mov edi,[edx*4+_RowStart] ;
        mov eax,pcxx
        add edi,scrpcx
@xPcx:
        mov bl,[esi]
        inc esi
        mov cl,bl
        cmp bl,0C0h   ; last 64 colors ?
        jnb @Pcxburst ; then this is a RLE burst
        ; else it is a single byte
        mov [edi],cl
        inc edi
        dec eax
        jnz @xPcx
        jmp @linne
                
@Pcxburst:
        mov cl,[esi]
        and ebx,03Fh    ; get count value
        inc esi
        sub eax,ebx
buurst: mov [edi],cl
        inc edi
        dec ebx
        jnz buurst
        or eax,eax
        jnz @xPcx
@linne: ; new line of Pcx file
        inc edx
        cmp edx,pcxy
        jb @yPcx
        
        ; now look for palette data and extract it
        mov esi,Pcx_start
        add esi,Pcx_len
        sub esi,769
        cmp byte ptr [esi],12
        jne @paldone
        mov _PcxHasPalette,1
        inc esi
        mov edi,offset _PicPal
        mov ecx,256
tre2quattro:
        mov eax,[esi]
        add esi,3
        and eax,00FFFFFFh
        stosd
        dec ecx
        jne tre2quattro
        mov esi, offset _PicPal
        call _Set256Pal
@paldone:
        ; Pcx file fully decode
        mov _PcxDecoded,1      
Pcx_err:
        popad
        ret
                
_PcxLoad: ; DS:ESI == ASCIIZ name of Pcx file to load
          ; Load pcx image into _ScrBase at _DisplayStart position
          pushad
          mov _PcxDecoded,0
          call _FLoad
          jc loaderr
          mov esi,_HiMemBase
          call _Pcx2Scr
   loaderr:       
          popad
          ret
          
code32 ends

 END
